/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.DialogSelectSample;
import jsbugs.FrameJsbugs;
import model2.EnvScheme;
import model2.IGDIntervalEnv;
import model2.SBdb;
import model2.Sample;
import model2.Well;
import model2.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;

public class DialogEnv
extends JDialog {
    private final SBdb db;
    private final char units;
    private final Well well;
    private final WellInterp wellInterp;
    private IGDIntervalEnv zone;
    private Sample topSample;
    private Sample baseSample;
    private final DefaultComboBoxModel schemes = new DefaultComboBoxModel();
    private final DefaultComboBoxModel hierModel = new DefaultComboBoxModel();
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonSampleBase;
    private JButton jButtonSampleTop;
    private JComboBox jComboBoxLD;
    private JComboBox jComboBoxLP;
    private JComboBox jComboBoxQual;
    private JComboBox jComboBoxScheme;
    private JComboBox jComboBoxUD;
    private JComboBox jComboBoxUP;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JTextField jTextFieldDate;
    private JTextField jTextFieldLastModified;
    private JTextField jTextFieldSampleBase;
    private JTextField jTextFieldSampleTop;

    public DialogEnv(Frame parent, boolean modal, SBdb db, Well well, WellInterp wellInterp, char units, IGDIntervalEnv zone, Sample topSample, Sample baseSample) throws SQLException, SBException {
        super(parent, modal);
        this.db = db;
        this.units = units;
        this.zone = zone;
        this.well = well;
        this.wellInterp = wellInterp;
        if (zone == null) {
            this.topSample = topSample;
            this.baseSample = baseSample;
        }
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.fillSchemeCombo();
        this.getRootPane().setDefaultButton(this.jButtonOK);
        if (this.zone == null) {
            this.setTitle("Palaeoenvironment Interval : Add");
            if (this.wellInterp.getEnvs() != null && !this.wellInterp.getEnvs().isEmpty()) {
                this.setScheme(((IGDIntervalEnv)this.wellInterp.getEnvs().get(0)).getSchID());
            }
        } else {
            this.setTitle("Palaeoenvironment Interval : Edit");
            this.topSample = this.zone.getTopSample();
            this.baseSample = this.zone.getBaseSample();
            this.setScheme(this.zone.getSchID());
            this.jTextFieldLastModified.setText(this.db.getUser(this.zone.getModifier()).getAbr());
            if (this.zone.getModified() != null) {
                this.jTextFieldDate.setText(SB.df.format(this.zone.getModified()));
            }
        }
        if (this.topSample != null) {
            this.jTextFieldSampleTop.setText(this.topSample.toString(this.units));
        }
        if (this.baseSample != null) {
            this.jTextFieldSampleBase.setText(this.baseSample.toString(this.units));
        }
    }

    private void setScheme(int schID) throws SBException, SQLException {
        EnvScheme scheme = this.db.getEnvScheme(schID);
        if (scheme == null) {
            throw new SBException("Cann't find scheme, ID=" + this.zone.getSchID());
        }
        this.jComboBoxScheme.setSelectedItem(scheme);
        scheme.fillCombo(this.jComboBoxUP, this.zone != null ? this.zone.getUp() : 0, true);
        scheme.fillCombo(this.jComboBoxUD, this.zone != null ? this.zone.getUd() : 0, true);
        scheme.fillCombo(this.jComboBoxLP, this.zone != null ? this.zone.getLp() : 0, true);
        scheme.fillCombo(this.jComboBoxLD, this.zone != null ? this.zone.getLd() : 0, true);
        scheme.fillCombo(this.jComboBoxQual, this.zone != null ? this.zone.getQual() : 0, true);
        if (this.wellInterp.getEnvs() != null && (this.wellInterp.getEnvs().size() > 1 || this.wellInterp.getEnvs().size() == 1 && this.zone == null) && this.wellInterp.getEnvSchemes().size() == 1 && !this.db.allowMultipleEnvSchemes()) {
            this.jComboBoxScheme.setEnabled(false);
        }
    }

    private void fillSchemeCombo() throws SQLException, SBException {
        List coll = this.db.getEnvSchemes();
        for (EnvScheme scheme : coll) {
            this.schemes.addElement(scheme);
        }
        this.jComboBoxScheme.repaint();
    }

    private void initComponents() {
        this.jComboBoxScheme = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jTextFieldLastModified = new JTextField();
        this.jLabel14 = new JLabel();
        this.jTextFieldDate = new JTextField();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jTextFieldSampleTop = new JTextField();
        this.jTextFieldSampleBase = new JTextField();
        this.jButtonSampleBase = new JButton();
        this.jButtonSampleTop = new JButton();
        this.jLabel4 = new JLabel();
        this.jComboBoxUP = new JComboBox();
        this.jLabel5 = new JLabel();
        this.jComboBoxUD = new JComboBox();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jComboBoxLP = new JComboBox();
        this.jComboBoxLD = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.jLabel10 = new JLabel();
        this.jComboBoxQual = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setResizable(false);
        this.jComboBoxScheme.setModel(this.schemes);
        this.jComboBoxScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEnv.this.jComboBoxSchemeActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Scheme:");
        this.jLabel13.setText("Last modified by:");
        this.jTextFieldLastModified.setEditable(false);
        this.jLabel14.setText("On:");
        this.jTextFieldDate.setEditable(false);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEnv.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEnv.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEnv.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Sample", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jLabel2.setText("Base:");
        this.jLabel1.setText("Top:");
        this.jTextFieldSampleTop.setBackground(new Color(255, 255, 204));
        this.jTextFieldSampleTop.setEditable(false);
        this.jTextFieldSampleBase.setBackground(new Color(255, 255, 204));
        this.jTextFieldSampleBase.setEditable(false);
        this.jButtonSampleBase.setText("...");
        this.jButtonSampleBase.setToolTipText("Select base sample");
        this.jButtonSampleBase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEnv.this.jButtonSampleBaseActionPerformed(evt);
            }
        });
        this.jButtonSampleTop.setText("...");
        this.jButtonSampleTop.setToolTipText("Select top sample");
        this.jButtonSampleTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEnv.this.jButtonSampleTopActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((Component)this.jLabel2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jTextFieldSampleBase, -1, 146, Short.MAX_VALUE).add((Component)this.jTextFieldSampleTop, -1, 146, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((Component)this.jButtonSampleBase, -2, 32, Short.MAX_VALUE).add(1, (Component)this.jButtonSampleTop, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jTextFieldSampleTop, -2, -1, -2).add((Component)this.jLabel1).add((Component)this.jButtonSampleTop)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jTextFieldSampleBase, -2, -1, -2).add((Component)this.jLabel2).add((Component)this.jButtonSampleBase)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel4.setText("Upper proximal:");
        this.jComboBoxUP.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxUP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEnv.this.jComboBoxUPActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Upper distal:");
        this.jComboBoxUD.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxUD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEnv.this.jComboBoxUDActionPerformed(evt);
            }
        });
        this.jLabel8.setText("Lower proximal:");
        this.jLabel9.setText("Lower distal:");
        this.jComboBoxLP.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxLP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEnv.this.jComboBoxLPActionPerformed(evt);
            }
        });
        this.jComboBoxLD.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel10.setText("Qualifier:");
        this.jComboBoxQual.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel6).addPreferredGap(0).add((Component)this.jComboBoxScheme, 0, 202, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel13).addPreferredGap(0).add((Component)this.jTextFieldLastModified, -2, 61, -2).addPreferredGap(0).add((Component)this.jLabel14).addPreferredGap(0).add((Component)this.jTextFieldDate, -2, 74, -2)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jSeparator1, -1, 247, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.jComboBoxUP, 0, 167, Short.MAX_VALUE)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(15, 15, 15).add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.jComboBoxUD, 0, 167, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel8).add((Component)this.jLabel9)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jComboBoxLD, 0, 167, Short.MAX_VALUE).add((Component)this.jComboBoxLP, 0, 167, Short.MAX_VALUE))).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(32, 32, 32).add((Component)this.jLabel10).addPreferredGap(0).add((Component)this.jComboBoxQual, 0, 167, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.jComboBoxScheme, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jComboBoxUP, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel5).add((Component)this.jComboBoxUD, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel8).add((Component)this.jComboBoxLP, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jComboBoxLD, -2, -1, -2).add((Component)this.jLabel9)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel10).add((Component)this.jComboBoxQual, -2, -1, -2)).addPreferredGap(0, 22, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel13).add((Component)this.jTextFieldLastModified, -2, -1, -2).add((Component)this.jLabel14).add((Component)this.jTextFieldDate, -2, -1, -2)).add(14, 14, 14).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jComboBoxUDActionPerformed(ActionEvent evt) {
        if (this.zone == null) {
            this.jComboBoxLD.setSelectedItem(this.jComboBoxUD.getSelectedItem());
        }
    }

    private void jComboBoxLPActionPerformed(ActionEvent evt) {
        if (this.zone == null && this.jComboBoxLD.getSelectedIndex() < this.jComboBoxLP.getSelectedIndex()) {
            this.jComboBoxLD.setSelectedItem(this.jComboBoxLP.getSelectedItem());
        }
    }

    private void jComboBoxUPActionPerformed(ActionEvent evt) {
        if (this.zone == null) {
            this.jComboBoxUD.setSelectedItem(this.jComboBoxUP.getSelectedItem());
            this.jComboBoxLP.setSelectedItem(this.jComboBoxUP.getSelectedItem());
            this.jComboBoxLD.setSelectedItem(this.jComboBoxUP.getSelectedItem());
        }
    }

    private void jComboBoxSchemeActionPerformed(ActionEvent evt) {
        try {
            EnvScheme scheme = (EnvScheme)this.jComboBoxScheme.getSelectedItem();
            scheme.fillCombo(this.jComboBoxUP, 0, true);
            scheme.fillCombo(this.jComboBoxUD, 0, true);
            scheme.fillCombo(this.jComboBoxLP, 0, true);
            scheme.fillCombo(this.jComboBoxLD, 0, true);
            scheme.fillCombo(this.jComboBoxQual, 0, true);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error selecting scheme: " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
        }
    }

    private void jButtonSampleBaseActionPerformed(ActionEvent evt) {
        try {
            DialogSelectSample dialog = new DialogSelectSample(this, true, this.db, this.well, this.baseSample != null ? this.baseSample : this.topSample, this.units, false);
            dialog.setLocation(this.jButtonSampleBase.getLocationOnScreen());
            dialog.setVisible(true);
            if (dialog.isOK) {
                this.baseSample = dialog.selection;
                this.jTextFieldSampleBase.setText(this.baseSample.toString(this.units));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error opening dialog: " + ex.getMessage(), this.getTitle(), 0);
        }
    }

    private void jButtonSampleTopActionPerformed(ActionEvent evt) {
        try {
            DialogSelectSample dialog = new DialogSelectSample(this, true, this.db, this.well, this.topSample != null ? this.topSample : this.baseSample, this.units, false);
            dialog.setLocation(this.jButtonSampleTop.getLocationOnScreen());
            dialog.setVisible(true);
            if (dialog.isOK) {
                this.topSample = dialog.selection;
                this.jTextFieldSampleTop.setText(this.topSample.toString(this.units));
                if (this.baseSample == null) {
                    this.baseSample = this.topSample;
                    this.jTextFieldSampleBase.setText(this.baseSample.toString(this.units));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error opening dialog: " + ex.getMessage(), this.getTitle(), 0);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.topSample == null) {
            JOptionPane.showMessageDialog(this, "Top sample blank", this.getTitle(), 2);
            return;
        }
        if (this.baseSample == null) {
            JOptionPane.showMessageDialog(this, "Top sample blank", this.getTitle(), 2);
            return;
        }
        EnvScheme scheme = (EnvScheme)this.jComboBoxScheme.getSelectedItem();
        int up = this.jComboBoxUP.getSelectedIndex();
        if (up == 0) {
            JOptionPane.showMessageDialog(this, "No environment selected", this.getTitle(), 2);
            return;
        }
        int ud = this.jComboBoxUD.getSelectedIndex();
        if (ud < up) {
            JOptionPane.showMessageDialog(this, "Upper distal nearer than proximal", this.getTitle(), 2);
            return;
        }
        int lp = this.jComboBoxLP.getSelectedIndex();
        int ld = this.jComboBoxLD.getSelectedIndex();
        if (ld < lp) {
            JOptionPane.showMessageDialog(this, "Lower distal nearer than proximal", this.getTitle(), 2);
            return;
        }
        int qual = this.jComboBoxQual.getSelectedIndex();
        IGDIntervalEnv.Builder builder = new IGDIntervalEnv.Builder(this.db, this.topSample, this.baseSample, scheme.getID());
        builder.up(up).ud(ud).lp(lp).ld(ld).qual(qual);
        try {
            if (this.zone == null) {
                this.zone = this.wellInterp.addEnvInterval(builder, this.well.getWellID());
            } else {
                this.wellInterp.updateEnvInterval(this.zone, builder, this.well.getWellID());
            }
            this.db.commit();
        }
        catch (Exception e) {
            FrameJsbugs.showStackError("Error saving environment interval", e, this.db);
            this.db.doRollback();
        }
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogenv.html");
    }
}

