/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import jsbugs.EnvSchemeTableModel;
import jsbugs.FrameJsbugs;
import model2.EnvScheme;
import model2.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.ColorEditor;
import util.ColorRenderer;
import util.SB;

public class DialogEnvScheme
extends JDialog {
    EnvScheme original = null;
    EnvSchemeTableModel model = new EnvSchemeTableModel();
    SBdb db;
    boolean isOK = false;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonHelp;
    private JButton jButtonInsert;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JTable jTableScheme;
    private JTextField jTextFieldCreated;
    private JTextField jTextFieldModified;
    private JTextField jTextFieldName;

    public DialogEnvScheme(Frame parent, boolean modal, SBdb db, EnvScheme scheme) {
        super(parent, modal);
        this.original = scheme;
        this.db = db;
        this.model.scheme = scheme != null ? new EnvScheme(scheme) : new EnvScheme();
        this.initComponents();
        this.init();
    }

    public DialogEnvScheme(Dialog parent, boolean modal, SBdb db, EnvScheme scheme) {
        super(parent, modal);
        this.original = scheme;
        this.db = db;
        this.model.scheme = scheme != null ? new EnvScheme(scheme) : new EnvScheme();
        this.initComponents();
        this.init();
    }

    private void init() {
        if (this.original != null) {
            this.setTitle("Palaeoenvironment Scheme : " + this.model.scheme.getName());
        } else {
            this.setTitle("Palaeoenvironment Scheme : Add");
        }
        for (int i = 0; i < EnvSchemeTableModel.colTitles.length; ++i) {
            this.jTableScheme.getColumnModel().getColumn(i).setPreferredWidth(EnvSchemeTableModel.colWidths[i]);
            this.jTableScheme.getColumnModel().getColumn(i).setHeaderValue(EnvSchemeTableModel.colTitles[i]);
        }
        this.jTableScheme.setDefaultRenderer(Color.class, (TableCellRenderer)new ColorRenderer(true));
        if (this.model.scheme != null) {
            try {
                this.jTextFieldName.setText(this.model.scheme.getName());
                if (this.model.scheme.getCreated() != null) {
                    String created = SB.df.format(this.model.scheme.getCreated()) + "/" + this.db.getUser(this.model.scheme.getCreator());
                    this.jTextFieldCreated.setText(created);
                }
                if (this.model.scheme.getModified() != null) {
                    String modified = SB.df.format(this.model.scheme.getModified()) + "/" + this.db.getUser(this.model.scheme.getModifier());
                    this.jTextFieldModified.setText(modified);
                }
            }
            catch (Exception e) {
                System.out.println("Excption from setting env scheme date fields: " + e.getMessage());
                e.printStackTrace();
            }
        }
        ColorEditor.setUpColorEditor((JTable)this.jTableScheme);
        this.jTableScheme.getColumnModel().setColumnMargin(5);
        this.jTableScheme.getTableHeader().setReorderingAllowed(false);
        this.model.fireTableDataChanged();
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableScheme = new JTable();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldCreated = new JTextField();
        this.jLabel3 = new JLabel();
        this.jTextFieldModified = new JTextField();
        this.jButtonAdd = new JButton();
        this.jButtonInsert = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(375, 325));
        this.jTableScheme.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableScheme);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEnvScheme.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEnvScheme.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Name:");
        this.jTextFieldName.setText("jTextField1");
        this.jLabel2.setText("Created:");
        this.jTextFieldCreated.setEditable(false);
        this.jLabel3.setText("Modified:");
        this.jTextFieldModified.setEditable(false);
        this.jButtonAdd.setText("Add");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEnvScheme.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonInsert.setText("Insert");
        this.jButtonInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEnvScheme.this.jButtonInsertActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEnvScheme.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEnvScheme.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(10, 10, 10).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jTextFieldCreated, -1, 215, Short.MAX_VALUE).add(1, (Component)this.jTextFieldName, -1, 215, Short.MAX_VALUE).add(1, (Component)this.jTextFieldModified, -1, 215, Short.MAX_VALUE))).add((Component)this.jScrollPane1, -1, 262, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(1, false).add(2, (Component)this.jButtonOK, -1, 65, Short.MAX_VALUE).add(2, (Component)this.jButtonCancel, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonHelp, -2, 65, -2)).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jButtonDelete, -2, 65, -2).add(2, (Component)this.jButtonAdd, -1, 65, Short.MAX_VALUE).add((Component)this.jButtonInsert, -2, 65, -2)))).add((Component)this.jLabel3)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldName, -2, -1, -2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldCreated, -2, -1, -2).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldModified, -2, -1, -2).add((Component)this.jLabel3)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonInsert).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0, 29, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane1, -1, 191, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String name = this.jTextFieldName.getText();
        if (name.length() == 0) {
            JOptionPane.showMessageDialog(this, "Scheme name blank", this.getTitle(), 2);
            return;
        }
        for (int i = 0; i < this.model.scheme.getNClasses(); ++i) {
            if (this.model.scheme.getTerm(i + 1).length() != 0) continue;
            JOptionPane.showMessageDialog(this, "Scheme term blank", this.getTitle(), 2);
            return;
        }
        try {
            this.model.scheme.setName(name);
            if (this.original != null) {
                this.original.update(this.model.scheme);
            } else {
                this.db.addEnvScheme(this.model.scheme);
            }
            this.isOK = true;
            this.db.commit();
            this.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
            this.db.doRollback();
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            this.model.scheme.addRow();
            this.jTableScheme.updateUI();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
        }
    }

    private void jButtonInsertActionPerformed(ActionEvent evt) {
        if (this.jTableScheme.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "Select a row for insert point", this.getTitle(), 2);
            return;
        }
        try {
            this.model.scheme.insertRow(this.jTableScheme.getSelectedRow());
            this.model.fireTableDataChanged();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableScheme.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select a row to delete", this.getTitle(), 2);
            return;
        }
        try {
            this.model.scheme.deleteRow(this.jTableScheme.getSelectedRow());
            this.jTableScheme.clearSelection();
            this.model.fireTableDataChanged();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogenvscheme.html");
    }
}

