/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.DialogSelectTaxa;
import jsbugs.FrameJsbugs;
import jsbugs.SBDialog;
import model2.SBEvent;
import model2.SBdb;
import model2.TaxaMap;
import model2.Taxon;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;

public class DialogEvent
extends SBDialog {
    SBEvent original;
    Taxon taxon;
    SBEvent sbEvent;
    SBdb db;
    static final int DESCR_LEN = 240;
    static final int NAME_LEN = 100;
    private ButtonGroup buttonGroupType;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonTaxon;
    private JCheckBox jCheckBoxGenerate;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonPaired;
    private JRadioButton jRadioButtonSingle;
    private JSeparator jSeparator1;
    private JTextField jTextFieldDescription;
    private JTextField jTextFieldEvent;
    private JTextField jTextFieldTaxon;

    public DialogEvent(Frame parent, boolean modal, SBdb db, SBEvent event, Taxon taxon) {
        super(parent, modal);
        this.initComponents();
        this.db = db;
        this.original = event;
        this.taxon = taxon;
        this.init();
    }

    public DialogEvent(JDialog parent, boolean modal, SBdb db, SBEvent event, Taxon taxon) {
        super((Dialog)parent, modal);
        this.initComponents();
        this.db = db;
        this.original = event;
        this.taxon = taxon;
        this.init();
    }

    public DialogEvent(JDialog parent, boolean modal, SBdb db, SBEvent event) {
        super((Dialog)parent, modal);
        this.initComponents();
        this.db = db;
        this.original = event;
        this.init();
    }

    public void setEventName(String name) {
        this.jTextFieldEvent.setText(name);
    }

    private void init() {
        if (this.original == null || this.db != this.original.getDatabase()) {
            this.setTitle("Event : Add");
        } else {
            this.setTitle("Event : Edit");
        }
        if (this.original != null) {
            this.jTextFieldDescription.setText(this.original.getEvDesc());
            this.jTextFieldEvent.setText(this.original.getName());
            if (this.original.getTaxon() != null) {
                this.taxon = this.original.getTaxon().getLink() != null ? this.original.getTaxon().getLink() : this.original.getTaxon();
                this.jTextFieldTaxon.setText(this.taxon.toString());
            }
            if (this.original.isSingle()) {
                this.jRadioButtonSingle.setSelected(true);
                this.jCheckBoxGenerate.setEnabled(false);
            } else {
                this.jRadioButtonPaired.setSelected(true);
                this.jCheckBoxGenerate.setSelected(this.original.isGenerate());
            }
            this.jRadioButtonPaired.setEnabled(false);
            this.jRadioButtonSingle.setEnabled(false);
            try {
                if (this.original.getDatabase().isConnected() && this.original.getNoccs(true) == 0 && this.original.getNcmpStdOccs() == 0) {
                    this.jRadioButtonPaired.setEnabled(true);
                    this.jRadioButtonSingle.setEnabled(true);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if (!this.jRadioButtonPaired.isEnabled()) {
                this.jRadioButtonPaired.setToolTipText("You can't change the event type because it is recorded in wells and/or composite standards.");
                this.jRadioButtonSingle.setToolTipText("You can't change the event type because it is recorded in wells and/or composite standards.");
            }
        } else if (this.taxon != null) {
            this.jTextFieldTaxon.setText(this.taxon.toString());
            this.jTextFieldEvent.setText(this.taxon.toString(false, false));
        }
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.buttonGroupType = new ButtonGroup();
        this.jTextFieldTaxon = new JTextField();
        this.jTextFieldEvent = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonTaxon = new JButton();
        this.jPanel1 = new JPanel();
        this.jRadioButtonPaired = new JRadioButton();
        this.jRadioButtonSingle = new JRadioButton();
        this.jCheckBoxGenerate = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jTextFieldDescription = new JTextField();
        this.jLabel3 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jTextFieldTaxon.setEditable(false);
        this.jTextFieldTaxon.setBackground(new Color(255, 255, 204));
        this.jTextFieldEvent.setToolTipText("Type event name");
        this.jTextFieldEvent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogEvent.this.jTextFieldEventKeyTyped(evt);
            }
        });
        this.jLabel1.setText("Taxon name:");
        this.jLabel2.setText("Event name:");
        this.jButtonTaxon.setText("...");
        this.jButtonTaxon.setToolTipText("Select taxon");
        this.jButtonTaxon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEvent.this.jButtonTaxonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Type", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupType.add(this.jRadioButtonPaired);
        this.jRadioButtonPaired.setText("Paired");
        this.jRadioButtonPaired.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonPaired.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonPaired.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEvent.this.jRadioButtonPairedActionPerformed(evt);
            }
        });
        this.buttonGroupType.add(this.jRadioButtonSingle);
        this.jRadioButtonSingle.setText("Single");
        this.jRadioButtonSingle.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonSingle.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonSingle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEvent.this.jRadioButtonSingleActionPerformed(evt);
            }
        });
        this.jCheckBoxGenerate.setText("Use to generate top or base well events");
        this.jCheckBoxGenerate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxGenerate.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonPaired).addPreferredGap(0).add((Component)this.jRadioButtonSingle).add(18, 18, 18).add((Component)this.jCheckBoxGenerate).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jRadioButtonPaired).add((Component)this.jRadioButtonSingle).add((Component)this.jCheckBoxGenerate)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEvent.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEvent.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEvent.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jTextFieldDescription.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogEvent.this.jTextFieldDescriptionKeyTyped(evt);
            }
        });
        this.jLabel3.setText("Description:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((Component)this.jSeparator1, -1, 377, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTextFieldEvent, -1, 269, Short.MAX_VALUE).add((Component)this.jTextFieldTaxon, -1, 269, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jButtonTaxon, -2, 35, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add(6, 6, 6).add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.jTextFieldDescription, -1, 310, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jButtonTaxon).add((Component)this.jTextFieldTaxon, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldEvent, -2, -1, -2).add((Component)this.jLabel2)).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldDescription, -2, -1, -2).add((Component)this.jLabel3)).addPreferredGap(0).add((Component)this.jSeparator1, -2, 8, -2).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonTaxonActionPerformed(ActionEvent evt) {
        try {
            TaxaMap.BuilderPair lookupTaxon = null;
            if (this.jTextFieldEvent.getText().length() > 0) {
                lookupTaxon = TaxaMap.parse((String)this.jTextFieldEvent.getText().trim());
            }
            DialogSelectTaxa dialog = new DialogSelectTaxa((JDialog)this, true, this.db, true, lookupTaxon);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null && dialog.selection.size() > 0) {
                this.taxon = dialog.selection.get(0);
                this.jTextFieldTaxon.setText(this.taxon.toString());
                if (this.jTextFieldEvent.getText().trim().length() == 0) {
                    this.jTextFieldEvent.setText(this.taxon.toString(false, false));
                }
                if (this.buttonGroupType.getSelection() == null) {
                    this.jRadioButtonPaired.setSelected(true);
                }
                if (!this.jCheckBoxGenerate.isSelected()) {
                    this.jCheckBoxGenerate.setSelected(true);
                }
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String evName = this.jTextFieldEvent.getText().trim();
        if (evName.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Enter an event name", this.getTitle(), 2);
            this.jTextFieldEvent.requestFocusInWindow();
            return;
        }
        try {
            if ((this.original == null || evName.compareToIgnoreCase(this.original.getName()) != 0) && this.db.getSBEvent(evName) != null) {
                JOptionPane.showMessageDialog(this, "An event of that name already exists in the database.", this.getTitle(), 2);
                return;
            }
            SBEvent.Builder builder = new SBEvent.Builder().name(evName).taxon(this.taxon).desc(this.jTextFieldDescription.getText());
            builder.isSingle(this.jRadioButtonSingle.isSelected()).isGenerate(this.jCheckBoxGenerate.isSelected());
            if (this.original == null || this.db != this.original.getDatabase()) {
                this.sbEvent = this.db.addSBEvent(builder);
                if (this.sbEvent.isGenerate() != this.jCheckBoxGenerate.isSelected()) {
                    try {
                        this.sbEvent.setGenerate(this.jCheckBoxGenerate.isSelected());
                    }
                    catch (SBEvent.GenerateUniqueException e) {
                        JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
                    }
                }
            } else {
                this.db.updateSBEvent(this.original, builder);
                this.sbEvent = this.original;
                this.original.notifyObservers();
            }
            this.db.commit();
            this.db.notifyObservers((Object)this.sbEvent);
            this.setOK();
        }
        catch (SBEvent.GenerateUniqueException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            this.db.doRollback();
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogevent.html");
    }

    private void jTextFieldDescriptionKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldDescription, (int)240, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldEventKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldEvent, (int)100, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jRadioButtonSingleActionPerformed(ActionEvent evt) {
        this.jCheckBoxGenerate.setSelected(false);
        this.jCheckBoxGenerate.setEnabled(false);
    }

    private void jRadioButtonPairedActionPerformed(ActionEvent evt) {
        this.jCheckBoxGenerate.setEnabled(true);
    }

    void setTaxon(Taxon taxon) {
        this.taxon = taxon;
        this.jTextFieldTaxon.setText(taxon.toString());
        this.jTextFieldEvent.setText(taxon.toString(false, false));
        this.jCheckBoxGenerate.setSelected(true);
        this.jRadioButtonPaired.setSelected(true);
    }
}

