/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.DialogSelectAnalyst;
import jsbugs.FrameJsbugs;
import jsbugs.SBDialog;
import model2.Discipline;
import model2.SBdb;
import util.SB;

public class DialogEventComments
extends SBDialog {
    private final DefaultComboBoxModel comboModelDiscipline = new DefaultComboBoxModel<Discipline>(Discipline.values());
    private final SBdb db;
    Discipline discID;
    static boolean includeComments = true;
    static boolean includeQualifiers = true;
    static boolean includeSource = true;
    static boolean includeCompany = true;
    static boolean override = false;
    String analyst;
    private ButtonGroup buttonGroupDisc;
    private JButton jButtonAnalyst;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxComments;
    private JCheckBox jCheckBoxCompany;
    private JCheckBox jCheckBoxQualifiers;
    private JCheckBox jCheckBoxSource;
    private JComboBox jComboBoxDisc;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JRadioButton jRadioButton2;
    private JRadioButton jRadioButtonOverride;
    private JSeparator jSeparator1;
    private JTextField jTextFieldAnalyst;

    public DialogEventComments(Frame parent, boolean modal, SBdb db) {
        super(parent, modal);
        this.initComponents();
        this.db = db;
        this.init();
    }

    private void init() {
        this.setTitle("Generate Comments from Events");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jCheckBoxComments.setSelected(includeComments);
        this.jCheckBoxCompany.setSelected(includeCompany);
        this.jCheckBoxQualifiers.setSelected(includeQualifiers);
        this.jCheckBoxSource.setSelected(includeSource);
        this.jTextFieldAnalyst.setText(this.db.getUser().getAbr());
        this.jComboBoxDisc.setSelectedItem(this.db.getUser().getDiscipline());
    }

    private void initComponents() {
        this.buttonGroupDisc = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jButtonAnalyst = new JButton();
        this.jRadioButtonOverride = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.jTextFieldAnalyst = new JTextField();
        this.jLabel2 = new JLabel();
        this.jComboBoxDisc = new JComboBox();
        this.jCheckBoxComments = new JCheckBox();
        this.jCheckBoxQualifiers = new JCheckBox();
        this.jCheckBoxSource = new JCheckBox();
        this.jCheckBoxCompany = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Discipline and analyst", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jButtonAnalyst.setText("...");
        this.jButtonAnalyst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEventComments.this.jButtonAnalystActionPerformed(evt);
            }
        });
        this.buttonGroupDisc.add(this.jRadioButtonOverride);
        this.jRadioButtonOverride.setText("Overrides event fields");
        this.jRadioButtonOverride.setToolTipText("Use this discipline and analyst for all comments");
        this.buttonGroupDisc.add(this.jRadioButton2);
        this.jRadioButton2.setSelected(true);
        this.jRadioButton2.setText("Use where event has no discipline or analyst");
        this.jRadioButton2.setToolTipText("Preferentially use events' discipline and analyst");
        this.jLabel1.setText("Discipline:");
        this.jTextFieldAnalyst.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogEventComments.this.jTextFieldAnalystKeyTyped(evt);
            }
        });
        this.jLabel2.setText("Analyst:");
        this.jComboBoxDisc.setModel(this.comboModelDiscipline);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButton2).addComponent(this.jRadioButtonOverride).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldAnalyst).addComponent(this.jComboBoxDisc, -2, 137, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAnalyst, -2, 33, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBoxDisc, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldAnalyst, -2, -1, -2).addComponent(this.jButtonAnalyst)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonOverride).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jCheckBoxComments.setText("Include comments");
        this.jCheckBoxQualifiers.setText("Include qualifiers");
        this.jCheckBoxSource.setText("Include source");
        this.jCheckBoxCompany.setText("Include company");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEventComments.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEventComments.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEventComments.this.jButtonOKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxQualifiers).addComponent(this.jCheckBoxComments)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxSource).addComponent(this.jCheckBoxCompany))).addComponent(this.jSeparator1, -1, 267, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxComments).addComponent(this.jCheckBoxSource)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxQualifiers).addComponent(this.jCheckBoxCompany)).addGap(18, 18, 18).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonHelp).addComponent(this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jTextFieldAnalystKeyTyped(KeyEvent evt) {
        if (SB.uCaseField((JTextField)this.jTextFieldAnalyst, (int)5, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.analyst = this.jTextFieldAnalyst.getText().trim();
        try {
            if (this.analyst.isEmpty() || this.db.getUser(this.analyst) == null) {
                JOptionPane.showMessageDialog(this, "Analyst not recognised.", this.getTitle(), 0);
                return;
            }
        }
        catch (Exception e) {
            SB.showStackError((String)"Error: ", (Exception)e);
        }
        this.discID = (Discipline)this.jComboBoxDisc.getSelectedItem();
        includeComments = this.jCheckBoxComments.isSelected();
        includeQualifiers = this.jCheckBoxQualifiers.isSelected();
        includeSource = this.jCheckBoxSource.isSelected();
        includeCompany = this.jCheckBoxCompany.isSelected();
        override = this.jRadioButtonOverride.isSelected();
        this.setOK();
    }

    private void jButtonAnalystActionPerformed(ActionEvent evt) {
        try {
            DialogSelectAnalyst dialog = new DialogSelectAnalyst(this, true, this.db);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selectedUser != null) {
                this.jTextFieldAnalyst.setText(dialog.selectedUser.getAbr());
            }
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage() + "\n" + SB.sql, this.getTitle(), 0);
            ex.printStackTrace();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogeventcomments.html");
    }
}

