/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.TableModel;
import jsbugs.DialogCmpStd;
import jsbugs.EventStdOccTableModel;
import jsbugs.EventWellOccTableModel;
import jsbugs.FrameJsbugs;
import model2.CompositeStandard;
import model2.SBEvent;
import model2.SBdb;
import util.SB;
import util.SBException;
import util.TableSorter;

public class DialogEventOcc
extends JDialog {
    private final EventWellOccTableModel wellModel = new EventWellOccTableModel();
    private final TableSorter wellSorter = new TableSorter((TableModel)this.wellModel);
    private final EventStdOccTableModel cmpstdModel = new EventStdOccTableModel();
    private final TableSorter cmpstdSorter = new TableSorter((TableModel)this.cmpstdModel);
    private static int tab = 0;
    private final SBdb db;
    private final SBEvent event;
    private final Frame parent;
    SBEvent.WellEventQueryResult selectedWellResult = null;
    private JButton jButtonClose;
    private JButton jButtonGotoComposite;
    private JButton jButtonGotoWell;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanelCmpStd;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTabbedPane jTabbedPane1;
    private JTable jTableCmpstds;
    private JTable jTableWells;
    private JTextField jTextFieldEvent;

    public DialogEventOcc(Frame parent, boolean modal, SBEvent event, SBdb db) {
        super(parent, modal);
        this.parent = parent;
        this.event = event;
        this.db = db;
        this.initComponents();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        this.setTitle("Event Usage : " + this.event);
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.jTextFieldEvent.setText(this.event.getName());
        try {
            this.db.getInterps();
        }
        catch (SQLException sqle) {
            SB.showStackError((String)"Error loading interpHdrs: ", (SQLException)sqle);
        }
        this.wellModel.setupTable(this.jTableWells, this.wellSorter, this.db);
        this.cmpstdModel.setupTable(this.jTableCmpstds, this.cmpstdSorter);
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.wellModel.events = this.event.getWellOccs();
            for (SBEvent.WellEventQueryResult event : this.wellModel.events) {
                this.db.getAddWell(event.wellID).loadInterps();
                System.out.println("Loading version data for well: " + this.db.getProject(0).getWell(this.db, event.wellID));
                this.db.getAddWell(event.wellID).getInterp(event.interpID);
            }
            this.cmpstdModel.events = this.event.getCmpstdOccs();
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.wellModel.fireTableDataChanged();
        this.cmpstdModel.fireTableDataChanged();
        this.jTabbedPane1.setSelectedIndex(tab);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldEvent = new JTextField();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableWells = new JTable();
        this.jButtonGotoWell = new JButton();
        this.jPanelCmpStd = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTableCmpstds = new JTable();
        this.jButtonGotoComposite = new JButton();
        this.jButtonClose = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(450, 350));
        this.jLabel1.setText("Event:");
        this.jTextFieldEvent.setBackground(new Color(255, 255, 204));
        this.jTextFieldEvent.setEditable(false);
        this.jTableWells.setModel((TableModel)this.wellSorter);
        this.jTableWells.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.jTableWells);
        this.jButtonGotoWell.setText("Go to Well...");
        this.jButtonGotoWell.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEventOcc.this.jButtonGotoWellActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, -1, 497, Short.MAX_VALUE).addComponent(this.jButtonGotoWell)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 168, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonGotoWell).addContainerGap()));
        this.jTabbedPane1.addTab("Wells", this.jPanel1);
        this.jTableCmpstds.setModel((TableModel)this.cmpstdSorter);
        this.jTableCmpstds.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.jTableCmpstds);
        this.jButtonGotoComposite.setText("Go to Composite...");
        this.jButtonGotoComposite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEventOcc.this.jButtonGotoCompositeActionPerformed(evt);
            }
        });
        GroupLayout jPanelCmpStdLayout = new GroupLayout(this.jPanelCmpStd);
        this.jPanelCmpStd.setLayout(jPanelCmpStdLayout);
        jPanelCmpStdLayout.setHorizontalGroup(jPanelCmpStdLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelCmpStdLayout.createSequentialGroup().addContainerGap().addGroup(jPanelCmpStdLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2, -1, 497, Short.MAX_VALUE).addComponent(this.jButtonGotoComposite)).addContainerGap()));
        jPanelCmpStdLayout.setVerticalGroup(jPanelCmpStdLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelCmpStdLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 168, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonGotoComposite).addContainerGap()));
        this.jTabbedPane1.addTab("Composite Standards", this.jPanelCmpStd);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEventOcc.this.jButtonCloseActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, -1, 522, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldEvent, -1, 486, Short.MAX_VALUE)).addComponent(this.jButtonClose, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldEvent, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jTabbedPane1, -1, 252, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonClose).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        tab = this.jTabbedPane1.getSelectedIndex();
        this.dispose();
    }

    private void jButtonGotoWellActionPerformed(ActionEvent evt) {
        if (this.jTableWells.getSelectedRowCount() < 1) {
            JOptionPane.showMessageDialog(this, "Select a well event", this.getTitle(), 1);
            return;
        }
        this.selectedWellResult = this.wellModel.events.get(this.wellSorter.getIndexOf(this.jTableWells.getSelectedRow()));
        this.dispose();
    }

    private void jButtonGotoCompositeActionPerformed(ActionEvent evt) {
        if (this.jTableCmpstds.getSelectedRowCount() < 1) {
            JOptionPane.showMessageDialog(this, "Select a composite standard event", this.getTitle(), 1);
            return;
        }
        SBEvent.CmpstdEventQueryResult result = this.cmpstdModel.events.get(this.cmpstdSorter.getIndexOf(this.jTableCmpstds.getSelectedRow()));
        try {
            CompositeStandard cmpStd = this.db.getCompositeStandard(result.stdID);
            DialogCmpStd dialog = new DialogCmpStd(this.parent, true, this.db, cmpStd);
            dialog.setLocationRelativeTo(this.parent);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.cmpstdModel.events = this.event.getCmpstdOccs();
                this.cmpstdModel.fireTableDataChanged();
            }
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }
}

