/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import model2.CompositeStandardEvent;
import model2.SBdb;
import model2.WellEvent;
import util.SB;

public class DialogEventPrefix
extends JDialog {
    SBdb sbdb;
    static final int PREFIX_LEN = 8;
    static final String TOP_DEFAULT = "Top";
    static final String BASE_DEFAULT = "Base";
    private JButton jButtonCancel;
    private JButton jButtonDefaults;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JTextField jTextFieldCompositeBase;
    private JTextField jTextFieldCompositeTop;
    private JTextField jTextFieldWellBase;
    private JTextField jTextFieldWellTop;

    public DialogEventPrefix(Frame parent, boolean modal, SBdb sbdb) {
        super(parent, modal);
        this.sbdb = sbdb;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.jTextFieldWellTop.setText(WellEvent.getPrefixF());
        this.jTextFieldWellBase.setText(WellEvent.getPrefixL());
        this.jTextFieldCompositeTop.setText(CompositeStandardEvent.getPrefixF());
        this.jTextFieldCompositeBase.setText(CompositeStandardEvent.getPrefixL());
        this.setTitle("Event Prefixes");
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel3 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jButtonDefaults = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jTextFieldCompositeTop = new JTextField();
        this.jTextFieldCompositeBase = new JTextField();
        this.jPanel2 = new JPanel();
        this.jTextFieldWellBase = new JTextField();
        this.jLabel1 = new JLabel();
        this.jTextFieldWellTop = new JTextField();
        this.jLabel2 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEventPrefix.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEventPrefix.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel3.setText("<html>These prefixes are used when displaying<br>events throughout the system, including on<br>charts.</html>");
        this.jButtonDefaults.setText("Restore defaults");
        this.jButtonDefaults.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonDefaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEventPrefix.this.jButtonDefaultsActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Composite Standards", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jLabel4.setText(" Extinction / LAD:");
        this.jLabel5.setText("Inception / FAD:");
        this.jTextFieldCompositeTop.setText(TOP_DEFAULT);
        this.jTextFieldCompositeTop.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogEventPrefix.this.jTextFieldCompositeTopKeyTyped(evt);
            }
        });
        this.jTextFieldCompositeBase.setText(BASE_DEFAULT);
        this.jTextFieldCompositeBase.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogEventPrefix.this.jTextFieldCompositeBaseKeyTyped(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldCompositeBase).addComponent(this.jTextFieldCompositeTop)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldCompositeTop, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jTextFieldCompositeBase, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Wells and Outcrops", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jTextFieldWellBase.setText(BASE_DEFAULT);
        this.jTextFieldWellBase.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogEventPrefix.this.jTextFieldWellBaseKeyTyped(evt);
            }
        });
        this.jLabel1.setText("Top / FDO:");
        this.jTextFieldWellTop.setText(TOP_DEFAULT);
        this.jTextFieldWellTop.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogEventPrefix.this.jTextFieldWellTopKeyTyped(evt);
            }
        });
        this.jLabel2.setText("Base / LDO:");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldWellBase).addComponent(this.jTextFieldWellTop)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldWellTop, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldWellBase, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDefaults, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel, -2, 57, -2)).addComponent(this.jSeparator1).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK).addComponent(this.jButtonDefaults)).addContainerGap()));
        this.pack();
    }

    private void jButtonDefaultsActionPerformed(ActionEvent evt) {
        this.jTextFieldWellTop.setText(TOP_DEFAULT);
        this.jTextFieldWellBase.setText(BASE_DEFAULT);
        this.jTextFieldCompositeTop.setText(TOP_DEFAULT);
        this.jTextFieldCompositeBase.setText(BASE_DEFAULT);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String stdBase;
        String stdTop;
        String wellBase;
        String wellTop = this.jTextFieldWellTop.getText().trim();
        if (wellTop.isEmpty()) {
            wellTop = TOP_DEFAULT;
        }
        if ((wellBase = this.jTextFieldWellBase.getText().trim()).isEmpty()) {
            wellBase = BASE_DEFAULT;
        }
        if ((stdTop = this.jTextFieldCompositeTop.getText().trim()).isEmpty()) {
            stdTop = TOP_DEFAULT;
        }
        if ((stdBase = this.jTextFieldCompositeBase.getText().trim()).isEmpty()) {
            stdBase = BASE_DEFAULT;
        }
        if (wellTop.equals(wellBase)) {
            JOptionPane.showMessageDialog(this, "Well top and base prefxes must be different", this.getTitle(), 2);
            return;
        }
        if (stdTop.equals(stdBase)) {
            JOptionPane.showMessageDialog(this, "Composite top and base prefxes must be different", this.getTitle(), 2);
            return;
        }
        try {
            this.sbdb.putDatabasePref("EVENTPRXWT", wellTop);
            this.sbdb.putDatabasePref("EVENTPRXWB", wellBase);
            this.sbdb.putDatabasePref("EVENTPRXCT", stdTop);
            this.sbdb.putDatabasePref("EVENTPRXCB", stdBase);
            this.sbdb.commit();
            WellEvent.setPrefixes((String)wellTop, (String)wellBase);
            CompositeStandardEvent.setPrefixes((String)stdTop, (String)stdBase);
        }
        catch (SQLException sql) {
            SB.showStackError((String)"Error putting preferences", (SQLException)sql);
        }
        this.dispose();
    }

    private void jTextFieldWellTopKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldWellTop, (int)8, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldWellBaseKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldWellBase, (int)8, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldCompositeTopKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldCompositeTop, (int)8, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldCompositeBaseKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldCompositeBase, (int)8, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }
}

