/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import jsbugs.SBDialog;
import model2.EventXLSReader;
import model2.SBdb;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;

public class DialogEventXLSReader
extends SBDialog {
    private EventXLSReader reader;
    private final DefaultComboBoxModel topModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel baseModel = new DefaultComboBoxModel();
    private final SBdb db;
    private final SBdb ws;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JComboBox jComboBoxBase;
    private JComboBox jComboBoxTop;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;

    public DialogEventXLSReader(Frame parent, boolean modal, SBdb db, SBdb ws, File file) throws IOException, InvalidFormatException, IllegalStateException {
        super(parent, modal);
        this.db = db;
        this.ws = ws;
        this.initComponents();
        this.init(file);
    }

    private void init(File file) throws IOException, InvalidFormatException, IllegalStateException {
        this.setTitle("Event Reader");
        this.reader = new EventXLSReader(this.ws, file);
        this.topModel.addElement(null);
        this.baseModel.addElement(null);
        List prefixes = this.reader.scanPrefixes();
        for (String prefix : prefixes) {
            this.topModel.addElement(prefix);
            this.baseModel.addElement(prefix);
        }
        this.jComboBoxTop.repaint();
        this.jComboBoxBase.repaint();
    }

    private void initComponents() {
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jComboBoxBase = new JComboBox();
        this.jComboBoxTop = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEventXLSReader.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEventXLSReader.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Select file labels for top and base event types", 0, 0, null, new Color(51, 102, 204)));
        this.jLabel1.setText("Top:");
        this.jLabel2.setText("Base:");
        this.jComboBoxBase.setModel(this.baseModel);
        this.jComboBoxTop.setModel(this.topModel);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxTop, -2, 110, -2).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jComboBoxBase, -2, 91, -2).addContainerGap()));
        jPanel1Layout.linkSize(0, this.jComboBoxBase, this.jComboBoxTop);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBoxTop, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jComboBoxBase, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String top = (String)this.jComboBoxTop.getSelectedItem();
        String base = (String)this.jComboBoxBase.getSelectedItem();
        if (top == null && base == null) {
            JOptionPane.showMessageDialog(this, "No top/base tags found. Event names in the file should begin with Top/Base, FAD/LAD etc.", this.getTitle(), 2);
            return;
        }
        String msg = null;
        if (top == null) {
            msg = "No top tag selected. Only leave this blank if there are no tops in the file.";
        } else if (base == null) {
            msg = "No base tag selected. Only leave this blank if there are no bases in the file.";
        }
        if (msg != null) {
            int opt = JOptionPane.showConfirmDialog(this, msg = msg + "\nContinue?", this.getTitle(), 0);
            if (opt != 0) {
                return;
            }
        } else if (top.equals(base)) {
            JOptionPane.showMessageDialog(this, "Top and base event types are the same!", this.getTitle(), 2);
            return;
        }
        this.reader.setPrefixes(top, base);
        this.setOK();
    }

    public EventXLSReader getReader() {
        return this.reader;
    }
}

