/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import jsbugs.FrameJsbugs;
import model2.IGDIntervalZone;
import model2.IGDScheme;
import model2.InterpHdr;
import model2.Lastval;
import model2.Project;
import model2.SBdb;
import model2.SQPick;
import model2.Sample;
import model2.Well;
import model2.WellInterp;
import util.SB;
import util.SBException;
import util.SbugsFileFilter;

public class DialogExportText
extends JDialog {
    JFileChooser jFileChooser = null;
    SBdb db;
    List<Integer> dataTypes;
    Project project;
    InterpHdr interp;
    char units;
    private ButtonGroup buttonGroupFormat;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonSelectFile;
    private JComboBox jComboBoxDelimiter;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonFormat1;
    private JRadioButton jRadioButtonFormat2;
    private JRadioButton jRadioButtonFormat3;
    private JRadioButton jRadioButtonFormat4;
    private JRadioButton jRadioButtonFormat5;
    private JSeparator jSeparator1;
    private JTextField jTextFieldFile;

    public DialogExportText(Frame parent, boolean modal, SBdb db, List<Integer> dataTypes, Project project, InterpHdr interp, char units) {
        super(parent, modal);
        this.db = db;
        this.dataTypes = dataTypes;
        this.project = project;
        this.interp = interp;
        this.units = units;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Save Text File Options");
        if (this.jFileChooser == null) {
            this.jFileChooser = new JFileChooser();
            SbugsFileFilter filter = new SbugsFileFilter();
            filter.addExtension("csv");
            filter.setDescription("CSV files");
            filter.addExtension("txt");
            filter.setDescription("TXT files");
            this.jFileChooser.setFileFilter((FileFilter)filter);
            this.jFileChooser.setAcceptAllFileFilterUsed(false);
            File setDir = null;
            try {
                setDir = new File(Lastval.getString((SBdb)this.db, (String)"WINCSVFILE", (String)"UNXCSVFILE"));
            }
            catch (SQLException ex) {
                // empty catch block
            }
            if (setDir == null || setDir.getParent() == null || !setDir.getParentFile().exists()) {
                setDir = new File(".");
            }
            try {
                this.jFileChooser.setCurrentDirectory(setDir);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.jRadioButtonFormat1.setSelected(true);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.buttonGroupFormat = new ButtonGroup();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.jLabel1 = new JLabel();
        this.jTextFieldFile = new JTextField();
        this.jButtonSelectFile = new JButton();
        this.jLabel2 = new JLabel();
        this.jComboBoxDelimiter = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jRadioButtonFormat1 = new JRadioButton();
        this.jRadioButtonFormat2 = new JRadioButton();
        this.jRadioButtonFormat3 = new JRadioButton();
        this.jRadioButtonFormat4 = new JRadioButton();
        this.jRadioButtonFormat5 = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogExportText.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogExportText.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogExportText.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jLabel1.setText("File:");
        this.jTextFieldFile.setEditable(false);
        this.jTextFieldFile.setBackground(new Color(255, 255, 204));
        this.jButtonSelectFile.setText("...");
        this.jButtonSelectFile.setToolTipText("Select a file");
        this.jButtonSelectFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogExportText.this.jButtonSelectFileActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Field delimiter:");
        this.jComboBoxDelimiter.setModel(new DefaultComboBoxModel<String>(new String[]{",", ";", "<tab>", "<space>", " "}));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Format", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupFormat.add(this.jRadioButtonFormat1);
        this.jRadioButtonFormat1.setText("Top depth only (one column per data type / scheme / hierarchy level)");
        this.buttonGroupFormat.add(this.jRadioButtonFormat2);
        this.jRadioButtonFormat2.setText("Top and base depths (all other data in one column - flat list)");
        this.buttonGroupFormat.add(this.jRadioButtonFormat3);
        this.jRadioButtonFormat3.setText("Well name, zones top/base, depth, type, discipline - flat list, 2 lines per interval");
        this.buttonGroupFormat.add(this.jRadioButtonFormat4);
        this.jRadioButtonFormat4.setText("As above but including boundary types");
        this.buttonGroupFormat.add(this.jRadioButtonFormat5);
        this.jRadioButtonFormat5.setText("Top & base depth (one column per data type / scheme / hierarchy level)");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonFormat1).addComponent(this.jRadioButtonFormat2).addComponent(this.jRadioButtonFormat3).addComponent(this.jRadioButtonFormat4).addComponent(this.jRadioButtonFormat5)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(0, this.jRadioButtonFormat1, this.jRadioButtonFormat2, this.jRadioButtonFormat3, this.jRadioButtonFormat4, this.jRadioButtonFormat5);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButtonFormat1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonFormat5).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonFormat2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonFormat4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonFormat3)));
        jPanel1Layout.linkSize(1, this.jRadioButtonFormat1, this.jRadioButtonFormat2, this.jRadioButtonFormat3, this.jRadioButtonFormat4, this.jRadioButtonFormat5);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldFile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSelectFile, -2, 33, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxDelimiter, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldFile, -2, -1, -2).addComponent(this.jButtonSelectFile).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jComboBoxDelimiter, -2, -1, -2)).addGap(12, 12, 12).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK).addComponent(this.jButtonHelp)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogexporttext.html");
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        char delimChar;
        String fileName = this.jTextFieldFile.getText().trim();
        if (fileName.isEmpty()) {
            JOptionPane.showMessageDialog(this, "File name blank", this.getTitle(), 2);
            return;
        }
        File file = new File(fileName);
        if (file.exists() && JOptionPane.showConfirmDialog(this, "Overwrite file?", "Confirm File Overwrite", 0, 3) != 0) {
            return;
        }
        try {
            Lastval.putString((SBdb)this.db, (String)"WINCSVFILE", (String)"UNXCSVFILE", (String)fileName);
            this.db.commit();
        }
        catch (SQLException ex) {
            // empty catch block
        }
        String delim = (String)this.jComboBoxDelimiter.getSelectedItem();
        if (delim.equals(",")) {
            delimChar = ',';
        } else if (delim.equals(";")) {
            delimChar = ';';
        } else if (delim.equals("<tab>")) {
            delimChar = '\t';
        } else if (delim.equals("<space>")) {
            delimChar = ' ';
        } else {
            JOptionPane.showMessageDialog(this, "Unrecognised delimiter", this.getTitle(), 2);
            return;
        }
        try {
            if (this.jRadioButtonFormat1.isSelected()) {
                this.export(file, delimChar, false);
            } else if (this.jRadioButtonFormat5.isSelected()) {
                this.export(file, delimChar, true);
            } else if (this.jRadioButtonFormat2.isSelected()) {
                this.exportFlat(file, delimChar, false);
            } else if (this.jRadioButtonFormat4.isSelected()) {
                this.exportFlat(file, delimChar, true);
            } else {
                this.exportOW(file, delimChar);
            }
            JOptionPane.showMessageDialog(this, "File written", this.getTitle(), 1);
            this.dispose();
        }
        catch (Exception ex) {
            SB.showStackError((String)("Error writing file: " + ex.getMessage()), (Exception)ex);
            ex.printStackTrace();
        }
    }

    private void exportOW(File file, char delim) throws IOException, SBException, SQLException {
        String eol = "\r\n";
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        out.write("WELL NAME" + delim + "ZONES" + delim + "DEPTH" + delim + "TYPE" + delim + "DISCIPLINE" + eol);
        Iterator it = this.project.getWellIterator();
        while (it.hasNext()) {
            Well well = (Well)it.next();
            WellInterp wellInterp = well.getInterp(this.interp.getInterpID());
            for (Integer i : this.dataTypes) {
                List zones = new LinkedList();
                switch (i) {
                    case 10: 
                    case 11: 
                    case 12: {
                        zones = wellInterp.getIGDList(IGDIntervalZone.dType2IGDtype((int)i));
                        break;
                    }
                    case 13: 
                    case 14: {
                        List picks = wellInterp.getSQPicks();
                        for (SQPick pick : picks) {
                            out.write(well.getWellName() + delim);
                            out.write(pick.getName().replace(' ', '_') + delim);
                            out.write(pick.getSample().toString(well.getWellUnits(), false, false, false, false, null, null) + delim);
                            out.write(pick.getSample().getTypeString() + delim);
                            out.write(eol);
                        }
                        break;
                    }
                }
                if (zones == null || zones.isEmpty()) continue;
                for (IGDIntervalZone zone : zones) {
                    out.write(well.getWellName() + delim);
                    out.write(zone.toString() + (!zone.isSpotZone() ? "_Top" : "") + delim);
                    out.write(zone.getTopSample().toString(well.getWellUnits(), false, false, false, false, null, null) + delim);
                    out.write(zone.getTopSample().getTypeString() + delim);
                    IGDScheme scheme = this.db.getIGDScheme(zone.getSchID());
                    if (scheme.getDiscipline() != null) {
                        out.write(scheme.getDiscipline().getAbr(false) + eol);
                    } else {
                        out.write(eol);
                    }
                    if (zone.isSpotZone()) continue;
                    out.write(well.getWellName() + delim);
                    out.write(zone.toString() + "_Base" + delim);
                    out.write(zone.getBaseSample().toString(well.getWellUnits(), false, false, false, false, null, null) + delim);
                    out.write(zone.getBaseSample().getTypeString() + delim);
                    if (scheme.getDiscipline() != null) {
                        out.write(scheme.getDiscipline().getAbr(false) + eol);
                        continue;
                    }
                    out.write(eol);
                }
            }
        }
        out.close();
    }

    private void exportFlat(File file, char delim, boolean includeBnds) throws IOException, SBException, SQLException {
        String eol = "\r\n";
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        out.write("Well" + delim + "Top Sample Depth" + delim + "Type" + delim);
        if (includeBnds) {
            out.write("Boundary" + delim);
        }
        out.write("Base Sample Depth" + delim + "Type" + delim);
        if (includeBnds) {
            out.write("Boundary" + delim);
        }
        out.write("Legend" + eol);
        Iterator it = this.project.getWellIterator();
        char expUnits = this.units;
        while (it.hasNext()) {
            Well well = (Well)it.next();
            if (this.units == 'D') {
                expUnits = well.getWellUnits();
            }
            WellInterp wellInterp = well.getInterp(this.interp.getInterpID());
            for (Integer i : this.dataTypes) {
                List zones = new LinkedList();
                switch (i) {
                    case 10: 
                    case 11: 
                    case 12: {
                        zones = wellInterp.getIGDList(IGDIntervalZone.dType2IGDtype((int)i));
                    }
                }
                if (zones == null || zones.isEmpty()) continue;
                for (IGDIntervalZone zone : zones) {
                    out.write(well.getWellName() + delim);
                    out.write(zone.getTopSample().toString(expUnits, false, false, false, false, null, null) + delim);
                    out.write(zone.getTopSample().getTypeString() + delim);
                    if (includeBnds) {
                        out.write(zone.getTopBnd() + delim);
                    }
                    out.write(zone.getBaseSample().toString(expUnits, false, false, false, false, null, null) + delim);
                    out.write(zone.getBaseSample().getTypeString() + delim);
                    if (includeBnds) {
                        out.write(zone.getBaseBnd() + delim);
                    }
                    out.write(zone.toString() + eol);
                }
            }
        }
        out.close();
    }

    private void export(File file, char delim, boolean includeBase) throws IOException, SQLException, SBException {
        String eol = "\r\n";
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        LinkedList<String> headers = new LinkedList<String>();
        LinkedList rows = new LinkedList();
        Iterator<Integer> it = this.dataTypes.iterator();
        String suppMsg = "";
        block6: while (it.hasNext()) {
            int dType = it.next();
            LinkedList<Integer> schemeIDs = new LinkedList<Integer>();
            switch (dType) {
                case 1: {
                    continue block6;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    suppMsg = "\n(Use Save As... from the Analyses tab in Samples & Interpretations for CSV file options)";
                }
                default: {
                    String msg = "Sorry, data type " + SBdb.dTypeNames[dType] + " is not currently supported";
                    JOptionPane.showMessageDialog(this, msg + suppMsg, "Data type not supported", 2);
                    continue block6;
                }
                case 11: {
                    Iterator iterator = this.project.getWellIterator();
                    while (iterator.hasNext()) {
                        Well well = (Well)iterator.next();
                        WellInterp wellInterp = well.getInterp(this.interp.getInterpID());
                        List schemes = wellInterp.getIGDSchemes(4);
                        for (IGDScheme scheme : schemes) {
                            if (schemeIDs.contains(scheme.getID())) continue;
                            schemeIDs.add(scheme.getID());
                        }
                    }
                    break;
                }
                case 10: 
                case 12: 
            }
            if (schemeIDs.isEmpty()) {
                schemeIDs.add(0);
            }
            int igdType = IGDIntervalZone.dType2IGDtype((int)dType);
            Iterator i$ = schemeIDs.iterator();
            while (i$.hasNext()) {
                int schID = (Integer)i$.next();
                for (int hier = 1; hier <= IGDIntervalZone.getNHier((int)igdType, (boolean)true); ++hier) {
                    System.out.println("Processing level: " + hier);
                    Iterator wellIt = this.project.getWellIterator();
                    boolean hierUsed = false;
                    while (wellIt.hasNext()) {
                        Well well = (Well)wellIt.next();
                        WellInterp wellInterp = well.getInterp(this.interp.getInterpID());
                        List list = wellInterp.getIGDList(igdType, schID);
                        System.out.println("Found: " + list.size() + " at this level.");
                        for (IGDIntervalZone zone : list) {
                            if (zone.getHier() != hier) continue;
                            hierUsed = true;
                            boolean sampleFound = false;
                            for (List list2 : rows) {
                                Well rowWell = (Well)list2.get(0);
                                if (well != rowWell) continue;
                                Sample rowSample = (Sample)list2.get(1);
                                Sample rowBaseSample = null;
                                if (includeBase) {
                                    rowBaseSample = (Sample)list2.get(2);
                                }
                                if (zone.getTopSample() != rowSample || includeBase && rowBaseSample != zone.getBaseSample()) continue;
                                list2.add(zone.toString());
                                sampleFound = true;
                                break;
                            }
                            if (sampleFound) continue;
                            LinkedList<Object> linkedList = new LinkedList<Object>();
                            linkedList.add(well);
                            linkedList.add(zone.getTopSample());
                            if (includeBase) {
                                linkedList.add(zone.getBaseSample());
                            }
                            for (int i = 0; i < headers.size(); ++i) {
                                linkedList.add(null);
                            }
                            linkedList.add(zone.toString());
                            Iterator rowIt = rows.iterator();
                            int rowCount = 0;
                            boolean insert = false;
                            boolean wellFound = false;
                            while (rowIt.hasNext()) {
                                List row = (List)rowIt.next();
                                Well rowWell = (Well)row.get(0);
                                if (well == rowWell) {
                                    wellFound = true;
                                    Sample rowSample = (Sample)row.get(1);
                                    if (zone.getTopSample().getDepth() < rowSample.getDepth()) {
                                        insert = true;
                                        break;
                                    }
                                } else if (wellFound) {
                                    insert = true;
                                    break;
                                }
                                ++rowCount;
                            }
                            System.out.println("Inserting sample: " + zone.getTopSample() + " at row: " + rowCount);
                            if (insert) {
                                rows.add(rowCount, linkedList);
                                continue;
                            }
                            rows.add(linkedList);
                        }
                    }
                    if (!hierUsed) continue;
                    String header = SBdb.dTypeNames[dType] + " - " + IGDIntervalZone.getHierName((int)IGDIntervalZone.dType2IGDtype((int)dType), (int)hier, (boolean)true);
                    if (igdType == 4) {
                        header = header + "(" + this.db.getIGDScheme(schID).toString() + ")";
                    }
                    headers.add(header);
                    for (List list : rows) {
                        while (list.size() < headers.size() + 2) {
                            list.add(null);
                        }
                    }
                }
            }
        }
        out.write("Well" + delim + (includeBase ? "Top " : "") + "Depth" + delim + "Sample Type");
        if (includeBase) {
            out.write("Well" + delim + "Base Depth" + delim + "Sample Type");
        }
        Iterator ith = headers.iterator();
        while (ith.hasNext()) {
            out.write(delim + (String)ith.next());
        }
        out.write(eol);
        char expUnits = this.units;
        for (List list : rows) {
            for (Object obj : list) {
                if (obj instanceof Well) {
                    Well well = (Well)obj;
                    out.write(well.getWellName() + delim);
                    if (this.units != 'D') continue;
                    expUnits = well.getWellUnits();
                    continue;
                }
                if (obj instanceof Sample) {
                    Sample sample = (Sample)obj;
                    out.write("" + sample.getDepth(expUnits) + delim + sample.getTypeString() + delim);
                    continue;
                }
                if (obj != null) {
                    out.write("" + obj);
                }
                out.write(delim);
            }
            out.write(eol);
        }
        out.close();
    }

    private void jButtonSelectFileActionPerformed(ActionEvent evt) {
        if (0 == this.jFileChooser.showSaveDialog(this)) {
            String path = this.jFileChooser.getSelectedFile().getPath();
            if (!path.toLowerCase().endsWith(".csv") && !path.toLowerCase().endsWith(".txt")) {
                path = this.jComboBoxDelimiter.getSelectedItem().toString().equals(",") ? path + ".csv" : path + ".txt";
            }
            this.jTextFieldFile.setText(path);
        }
    }
}

