/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.DialogSelectSample;
import jsbugs.FrameJsbugs;
import jsbugs.SBDialog;
import model2.Fault;
import model2.SBdb;
import model2.Sample;
import model2.Well;
import model2.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SB;
import util.SBException;

public class DialogFault
extends SBDialog {
    private Fault original;
    private final char units;
    private final Well well;
    private final SBdb db;
    private final WellInterp wellInterp;
    private Sample sample = null;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonSelectSample;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabelUnits;
    private JSeparator jSeparator1;
    private JTextField jTextFieldLabel;
    private JTextField jTextFieldSample;
    private JTextField jTextFieldThrow;

    public DialogFault(JDialog parent, boolean modal, Fault fault, Well well, char units, WellInterp wellInterp, SBdb db) {
        super((Dialog)parent, modal);
        this.original = fault;
        this.units = units;
        this.wellInterp = wellInterp;
        this.db = db;
        this.well = well;
        this.initComponents();
        this.init();
    }

    public DialogFault(JFrame parent, boolean modal, Fault fault, Well well, char units, WellInterp wellInterp, SBdb db, Sample sample) {
        super((Frame)parent, modal);
        this.original = fault;
        this.units = units;
        this.well = well;
        this.wellInterp = wellInterp;
        this.db = db;
        this.sample = sample;
        this.initComponents();
        this.init();
    }

    private void init() {
        if (this.original == null) {
            this.setTitle("Fault : Add");
            if (this.sample != null) {
                this.jTextFieldSample.setText("" + this.sample);
            }
        } else {
            this.setTitle("Fault : Edit");
            this.jTextFieldSample.setText("" + this.original.getSample());
            this.sample = this.original.getSample();
            this.jTextFieldThrow.setText("" + this.original.getThrow());
            this.jTextFieldLabel.setText("" + this.original.getLabel());
        }
        SB.setUnitLabel((JLabel)this.jLabelUnits, (char)this.units);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldSample = new JTextField();
        this.jButtonSelectSample = new JButton();
        this.jLabel2 = new JLabel();
        this.jTextFieldThrow = new JTextField();
        this.jLabel3 = new JLabel();
        this.jTextFieldLabel = new JTextField();
        this.jLabelUnits = new JLabel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setText("Depth/Sample:");
        this.jTextFieldSample.setBackground(new Color(255, 255, 204));
        this.jTextFieldSample.setEditable(false);
        this.jButtonSelectSample.setText("...");
        this.jButtonSelectSample.setToolTipText("Select sample");
        this.jButtonSelectSample.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogFault.this.jButtonSelectSampleActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Throw:");
        this.jTextFieldThrow.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogFault.this.jTextFieldThrowKeyTyped(evt);
            }
        });
        this.jLabel3.setText("Label:");
        this.jTextFieldLabel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogFault.this.jTextFieldLabelKeyTyped(evt);
            }
        });
        this.jLabelUnits.setText("m");
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogFault.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogFault.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogFault.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.jSeparator1).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel2).add((Component)this.jLabel3).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.jTextFieldThrow).add((Component)this.jTextFieldSample, -1, 87, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(6, 6, 6).add((Component)this.jButtonSelectSample, -2, 30, -2)).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((Component)this.jLabelUnits, -2, 17, -2)))).add(2, (Component)this.jTextFieldLabel, -2, 123, -2))).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp, -2, 61, -2).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldSample, -2, -1, -2).add((Component)this.jLabel1).add((Component)this.jButtonSelectSample)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldThrow, -2, -1, -2).add((Component)this.jLabel2).add((Component)this.jLabelUnits)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jTextFieldLabel, -2, -1, -2)).add(18, 18, 18).add((Component)this.jSeparator1, -1, 4, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonOK).add((Component)this.jButtonHelp).add((Component)this.jButtonCancel)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonSelectSampleActionPerformed(ActionEvent evt) {
        DialogSelectSample dialog;
        try {
            dialog = new DialogSelectSample(this, true, this.db, this.well, this.sample, this.units, true);
        }
        catch (SBException ex) {
            SB.showStackError((String)"Error opening dialog", (Exception)((Object)ex));
            return;
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("Error opening dialog", ex, this.db);
            return;
        }
        dialog.setLocation(this.jButtonSelectSample.getLocationOnScreen());
        dialog.setVisible(true);
        if (dialog.isOK) {
            this.sample = dialog.selection;
            this.jTextFieldSample.setText(this.sample.toString(this.units));
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.sample == null) {
            JOptionPane.showMessageDialog(this, "Select a sample", this.getTitle(), 2);
            return;
        }
        if (this.jTextFieldThrow.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, "Enter fault throw", this.getTitle(), 2);
            this.jTextFieldThrow.requestFocusInWindow();
            return;
        }
        double faultThrow = Double.parseDouble(this.jTextFieldThrow.getText());
        String label = this.jTextFieldLabel.getText();
        try {
            this.original = this.original == null ? this.wellInterp.addFault(this.well, this.sample, faultThrow, label) : this.wellInterp.updateFault(this.well, this.original, this.sample, faultThrow, label);
            this.db.commit();
            this.wellInterp.notifyObservers((Object)this.original);
            this.setOK();
        }
        catch (InvalidFieldException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Cannot save fault", 2);
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("Error storing fault", ex, this.db);
            this.db.doRollback();
        }
    }

    private void jTextFieldThrowKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldThrow, (int)8, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldLabelKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldLabel, (int)80, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogfault.html");
    }
}

