/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.FrameJsbugs;
import model2.IGDIntervalZone;
import model2.IGDScheme;
import model2.IGDUnit;
import model2.SBdb;
import model2.Sample;
import model2.Well;
import model2.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SB;
import util.SBException;

public class DialogFillHierarchy
extends JDialog {
    WellInterp wellInterp;
    IGDScheme scheme;
    Well well;
    SBdb db;
    boolean isOK = false;
    List<IGDIntervalZone> list = null;
    List<IGDIntervalZone> toAdd = new LinkedList<IGDIntervalZone>();
    private ButtonGroup buttonGroupSamples;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBox3;
    private JCheckBox jCheckBox4;
    private JCheckBox jCheckBox5;
    private JCheckBox jCheckBox6;
    private JCheckBox jCheckBox7;
    private JCheckBox jCheckBox8;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonCreate;
    private JRadioButton jRadioButtonSpan;
    private JSeparator jSeparator1;
    private JTextField jTextFieldScheme;
    private JTextField jTextFieldVersion;

    public DialogFillHierarchy(Frame parent, boolean modal, Well well, WellInterp wellInterp, IGDScheme scheme, List<IGDIntervalZone> list) throws SBException {
        super(parent, modal);
        this.well = well;
        this.db = well.getDataModel();
        this.wellInterp = wellInterp;
        this.scheme = scheme;
        this.list = list;
        this.initComponents();
        this.init();
    }

    private void init() throws SBException {
        this.setTitle("Intervals : Fill Hierarchy");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jTextFieldVersion.setText(this.wellInterp.toString());
        if (this.scheme == null) {
            throw new SBException("Fill Hierarchy: no scheme specified");
        }
        this.jTextFieldScheme.setText(this.scheme.toString());
        this.setSchemeLevels(this.scheme);
    }

    private void setSchemeLevels(IGDScheme scheme) {
        if (scheme == null) {
            this.unsetCheck(this.jCheckBox1);
            this.unsetCheck(this.jCheckBox2);
            this.unsetCheck(this.jCheckBox3);
            this.unsetCheck(this.jCheckBox4);
            this.unsetCheck(this.jCheckBox5);
            this.unsetCheck(this.jCheckBox6);
            this.unsetCheck(this.jCheckBox7);
            this.unsetCheck(this.jCheckBox8);
        } else {
            this.setCheck(this.jCheckBox1, IGDIntervalZone.getHierName((int)scheme.getIGDType(), (int)1, (boolean)true));
            if (IGDIntervalZone.getNHier((int)scheme.getIGDType(), (boolean)true) > 1) {
                this.setCheck(this.jCheckBox2, IGDIntervalZone.getHierName((int)scheme.getIGDType(), (int)2, (boolean)true));
            } else {
                this.unsetCheck(this.jCheckBox2);
            }
            if (IGDIntervalZone.getNHier((int)scheme.getIGDType(), (boolean)true) > 2) {
                this.setCheck(this.jCheckBox3, IGDIntervalZone.getHierName((int)scheme.getIGDType(), (int)3, (boolean)true));
            } else {
                this.unsetCheck(this.jCheckBox3);
            }
            if (IGDIntervalZone.getNHier((int)scheme.getIGDType(), (boolean)true) > 3) {
                this.setCheck(this.jCheckBox4, IGDIntervalZone.getHierName((int)scheme.getIGDType(), (int)4, (boolean)true));
            } else {
                this.unsetCheck(this.jCheckBox4);
            }
            if (IGDIntervalZone.getNHier((int)scheme.getIGDType(), (boolean)true) > 4) {
                this.setCheck(this.jCheckBox5, IGDIntervalZone.getHierName((int)scheme.getIGDType(), (int)5, (boolean)true));
            } else {
                this.unsetCheck(this.jCheckBox5);
            }
            if (IGDIntervalZone.getNHier((int)scheme.getIGDType(), (boolean)true) > 5) {
                this.setCheck(this.jCheckBox6, IGDIntervalZone.getHierName((int)scheme.getIGDType(), (int)6, (boolean)true));
            } else {
                this.unsetCheck(this.jCheckBox6);
            }
            if (IGDIntervalZone.getNHier((int)scheme.getIGDType(), (boolean)true) > 6) {
                this.setCheck(this.jCheckBox7, IGDIntervalZone.getHierName((int)scheme.getIGDType(), (int)7, (boolean)true));
            } else {
                this.unsetCheck(this.jCheckBox7);
            }
            if (IGDIntervalZone.getNHier((int)scheme.getIGDType(), (boolean)true) > 7) {
                this.setCheck(this.jCheckBox8, IGDIntervalZone.getHierName((int)scheme.getIGDType(), (int)8, (boolean)true));
            } else {
                this.unsetCheck(this.jCheckBox8);
            }
        }
    }

    private void unsetCheck(JCheckBox checkBox) {
        checkBox.setText(null);
        checkBox.setEnabled(false);
        checkBox.setSelected(false);
    }

    private void setCheck(JCheckBox checkBox, String label) {
        checkBox.setText(label);
        checkBox.setEnabled(true);
        checkBox.setSelected(true);
    }

    private void initComponents() {
        this.buttonGroupSamples = new ButtonGroup();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabel1 = new JLabel();
        this.jTextFieldVersion = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldScheme = new JTextField();
        this.jLabel3 = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.jCheckBox2 = new JCheckBox();
        this.jCheckBox3 = new JCheckBox();
        this.jCheckBox4 = new JCheckBox();
        this.jCheckBox5 = new JCheckBox();
        this.jCheckBox6 = new JCheckBox();
        this.jCheckBox7 = new JCheckBox();
        this.jCheckBox8 = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jRadioButtonSpan = new JRadioButton();
        this.jRadioButtonCreate = new JRadioButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(441, 315));
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogFillHierarchy.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogFillHierarchy.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Version:");
        this.jTextFieldVersion.setEditable(false);
        this.jLabel2.setText("Scheme:");
        this.jTextFieldScheme.setEditable(false);
        this.jLabel3.setText("Levels:");
        this.jCheckBox1.setText("jCheckBox1");
        this.jCheckBox2.setText("jCheckBox2");
        this.jCheckBox3.setText("jCheckBox3");
        this.jCheckBox4.setText("jCheckBox4");
        this.jCheckBox5.setText("jCheckBox5");
        this.jCheckBox6.setText("jCheckBox6");
        this.jCheckBox7.setText("jCheckBox7");
        this.jCheckBox8.setText("jCheckBox8");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Sample gap options", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupSamples.add(this.jRadioButtonSpan);
        this.jRadioButtonSpan.setText("Higher levels span across sample gaps at lower levels");
        this.buttonGroupSamples.add(this.jRadioButtonCreate);
        this.jRadioButtonCreate.setText("Higher levels retain sample gaps ");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jRadioButtonSpan).add((Component)this.jRadioButtonCreate)).addContainerGap(122, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(new Component[]{this.jRadioButtonCreate, this.jRadioButtonSpan}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonSpan).addPreferredGap(1).add((Component)this.jRadioButtonCreate).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogFillHierarchy.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSeparator1, -1, 421, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).add(5, 5, 5).add((Component)this.jButtonCancel)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2)).add(4, 4, 4)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(1))).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jCheckBox1).addPreferredGap(0).add((Component)this.jCheckBox2).addPreferredGap(0).add((Component)this.jCheckBox3).addPreferredGap(1).add((Component)this.jCheckBox4)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jCheckBox5).addPreferredGap(0).add((Component)this.jCheckBox6).addPreferredGap(1).add((Component)this.jCheckBox7).addPreferredGap(0).add((Component)this.jCheckBox8)).add((Component)this.jTextFieldVersion, -1, 376, Short.MAX_VALUE).add((Component)this.jTextFieldScheme, -1, 376, Short.MAX_VALUE))).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldVersion, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jTextFieldScheme, -2, -1, -2)).add(10, 10, 10).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jCheckBox1).add((Component)this.jCheckBox2).add((Component)this.jCheckBox3).add((Component)this.jCheckBox4).add((Component)this.jLabel3)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jCheckBox5).add((Component)this.jCheckBox6).add((Component)this.jCheckBox7).add((Component)this.jCheckBox8)).add(13, 13, 13).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(1).add((Component)this.jSeparator1, -2, 10, -2).add(4, 4, 4).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK).add((Component)this.jButtonHelp)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.buttonGroupSamples.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "Select sample gap option", this.getTitle(), 1);
            return;
        }
        int igdType = this.scheme.getIGDType();
        try {
            int hier = IGDIntervalZone.getNHier((int)igdType, (boolean)true);
            while (true) {
                block35: {
                    LinkedList<IGDIntervalZone> hierZones;
                    block36: {
                        block34: {
                            if (hier <= 1) break block34;
                            hierZones = new LinkedList<IGDIntervalZone>();
                            for (IGDIntervalZone zone : this.list) {
                                if (zone.getHier() != hier) continue;
                                hierZones.add(zone);
                            }
                            if (hierZones.isEmpty()) break block35;
                            break block36;
                        }
                        System.out.println("\n\n" + this.toAdd.size() + " Intervals to be added before removal: ");
                        for (IGDIntervalZone z : this.toAdd) {
                            System.out.println("" + z.getTopSample() + "\t" + z.getBaseSample() + "\t" + z.getUppInf() + "\t" + z.getHier());
                        }
                        break;
                    }
                    block19: for (int genHier = hier - 1; genHier > 0; --genHier) {
                        switch (genHier) {
                            case 1: {
                                if (this.jCheckBox1.isSelected()) break;
                                continue block19;
                            }
                            case 2: {
                                if (this.jCheckBox2.isSelected()) break;
                                continue block19;
                            }
                            case 3: {
                                if (this.jCheckBox3.isSelected()) break;
                                continue block19;
                            }
                            case 4: {
                                if (this.jCheckBox4.isSelected()) break;
                                continue block19;
                            }
                            case 5: {
                                if (this.jCheckBox5.isSelected()) break;
                                continue block19;
                            }
                            case 6: {
                                if (this.jCheckBox6.isSelected()) break;
                                continue block19;
                            }
                            case 7: {
                                if (this.jCheckBox7.isSelected()) break;
                                continue block19;
                            }
                            case 8: {
                                if (!this.jCheckBox8.isSelected()) continue block19;
                            }
                        }
                        for (IGDIntervalZone zone : hierZones) {
                            IGDUnit unit;
                            IGDUnit higherUnit;
                            if (zone.getUppZone() == 0 || (higherUnit = this.scheme.getHigherUnit(unit = this.scheme.findUnit(zone.getUppZone()), genHier)) == null) continue;
                            boolean genZone = true;
                            if (zone.getLowZone() != 0) {
                                IGDUnit lowUnit = this.scheme.findUnit(zone.getLowZone());
                                IGDUnit highterLowUnit = this.scheme.getHigherUnit(lowUnit, genHier);
                                if (higherUnit.getUnitID() != highterLowUnit.getUnitID()) {
                                    genZone = false;
                                }
                            }
                            for (IGDIntervalZone checkZone : this.list) {
                                if (checkZone.getTopSample() != zone.getTopSample() || checkZone.getHier() != genHier) continue;
                                genZone = false;
                                break;
                            }
                            for (IGDIntervalZone checkZone : this.toAdd) {
                                if (checkZone.getHier() != genHier || checkZone.getTopSample() != zone.getTopSample()) continue;
                                genZone = false;
                                break;
                            }
                            if (!genZone) continue;
                            IGDIntervalZone.Builder addZone = new IGDIntervalZone.Builder(this.db, igdType, zone.getTopSample(), zone.getBaseSample(), higherUnit.getHier(), this.scheme.getID()).topBnd(zone.getTopBndInt()).baseBnd(zone.getBaseBndInt());
                            addZone.uppZone(higherUnit.getUnitID()).uppInf(higherUnit.getName());
                            try {
                                IGDIntervalZone okZone = WellInterp.checkOverlap(this.toAdd, (IGDIntervalZone.Builder)addZone, null, (boolean)false);
                                this.wellInterp.checkOverlap(addZone, null, false);
                                this.toAdd.add(okZone);
                            }
                            catch (SBException ex) {}
                        }
                    }
                }
                --hier;
            }
            boolean sorted = false;
            block23: while (true) {
                if (sorted) {
                    this.removeOverlappingIntervals();
                    System.out.println("\n\n" + this.toAdd.size() + " Intervals to be added AFTER removal: ");
                    for (IGDIntervalZone z : this.toAdd) {
                        System.out.println("" + z.getTopSample() + "\t" + z.getBaseSample() + "\t" + z.getUppInf() + "\t" + z.getHier());
                    }
                    IGDIntervalZone zone = null;
                    int zonesAdded = 0;
                    Iterator<Object> i$ = this.toAdd.iterator();
                    while (true) {
                        if (!i$.hasNext()) {
                            this.well.getDataModel().commit();
                            this.wellInterp.notifyObservers(zone);
                            JOptionPane.showMessageDialog(this, "Number of intervals added: " + zonesAdded, this.getTitle(), 1);
                            this.isOK = true;
                            this.dispose();
                            return;
                        }
                        IGDIntervalZone z = (IGDIntervalZone)i$.next();
                        zone = this.wellInterp.addZone(IGDIntervalZone.Builder.copyOf((IGDIntervalZone)z), this.well);
                        ++zonesAdded;
                    }
                }
                sorted = true;
                int i = 1;
                while (true) {
                    if (i >= this.toAdd.size()) continue block23;
                    IGDIntervalZone z1 = this.toAdd.get(i - 1);
                    IGDIntervalZone z2 = this.toAdd.get(i);
                    if (z1.getHier() > z2.getHier()) {
                        sorted = false;
                        this.toAdd.remove(i);
                        this.toAdd.add(i - 1, z2);
                        continue block23;
                    }
                    ++i;
                }
                break;
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
            ex.printStackTrace();
            this.well.getDataModel().doRollback();
            try {
                this.wellInterp.loadZones(igdType, this.well);
                if (!this.wellInterp.getIGDList(igdType).isEmpty()) {
                    this.wellInterp.notifyObservers(this.wellInterp.getIGDList(igdType).get(0));
                    return;
                }
                this.wellInterp.notifyObservers();
                return;
            }
            catch (Exception ex1) {
                SB.showStackError((String)ex.getMessage(), (Exception)ex1);
            }
        }
    }

    private void removeOverlappingIntervals() throws SBException, SQLException, InvalidFieldException {
        boolean intervalRemoved;
        block0: do {
            intervalRemoved = false;
            for (int i = 0; i < this.toAdd.size() - 1; ++i) {
                IGDIntervalZone zone = this.toAdd.get(i);
                IGDIntervalZone nextZone = this.toAdd.get(i + 1);
                if (zone.getHier() != nextZone.getHier() || zone.getUppZone() != nextZone.getUppZone() || !this.jRadioButtonSpan.isSelected() && !(zone.getBaseSample().getDepth() >= nextZone.getTopSample().getDepth())) continue;
                this.toAdd.remove(nextZone);
                if (nextZone.getBaseSample().getDepth() > zone.getBaseSample().getDepth()) {
                    int index = this.toAdd.indexOf(zone);
                    this.toAdd.remove(zone);
                    this.toAdd.add(index, WellInterp.checkOverlap(this.toAdd, (IGDIntervalZone.Builder)IGDIntervalZone.Builder.copyOf((IGDIntervalZone)zone, (Sample)zone.getTopSample(), (Sample)nextZone.getBaseSample()).baseBnd(nextZone.getBaseBndInt()), (IGDIntervalZone)zone, (boolean)false));
                }
                intervalRemoved = true;
                continue block0;
            }
        } while (intervalRemoved);
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogfillhierarchy.html");
    }
}

