/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import jsbugs.DialogList;
import jsbugs.FrameJsbugs;
import model2.AnalystHeader;
import model2.CompositeStandard;
import model2.SBEvent;
import model2.SBdb;
import model2.SynonymScheme;
import model2.Well;
import model2.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;

public class DialogGenerateEvent
extends JDialog {
    SBdb db;
    Well well;
    WellInterp interp;
    List<AnalystHeader> suites = null;
    private ButtonGroup buttonGroupSuite;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonSelectAnalysisSuites;
    private JCheckBox jCheckBoxCO;
    private JCheckBox jCheckBoxCU;
    private JCheckBox jCheckBoxFDO;
    private JCheckBox jCheckBoxIgnoreCv;
    private JCheckBox jCheckBoxIgnoreQuestionable;
    private JCheckBox jCheckBoxIgnoreRw;
    private JCheckBox jCheckBoxJuniorSynonyms;
    private JCheckBox jCheckBoxLDO;
    private JCheckBox jCheckBoxMacro;
    private JCheckBox jCheckBoxMicro;
    private JCheckBox jCheckBoxNanno;
    private JCheckBox jCheckBoxOC;
    private JCheckBox jCheckBoxPaly;
    private JCheckBox jCheckBoxSC;
    private JComboBox jComboBoxCompositeStandard;
    private JComboBox jComboBoxSynScheme;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JRadioButton jRadioButtonAllAnalyses;
    private JRadioButton jRadioButtonRestrictAnalyses;
    private JSeparator jSeparator1;

    public DialogGenerateEvent(Frame parent, boolean modal, SBdb db, Well well, WellInterp interp) throws SQLException, SBException {
        super(parent, modal);
        this.db = db;
        this.well = well;
        this.interp = interp;
        this.setTitle("Events : Generate");
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.getRootPane().setDefaultButton(this.jButtonOK);
        Collection c = this.db.getCompositeStandards();
        this.jComboBoxCompositeStandard.removeAllItems();
        this.jComboBoxCompositeStandard.addItem("<none>");
        for (CompositeStandard std : c) {
            this.jComboBoxCompositeStandard.addItem(std);
        }
        this.jComboBoxSynScheme.removeAllItems();
        try {
            for (SynonymScheme s : this.db.getSynSchemes()) {
                this.jComboBoxSynScheme.addItem(s);
            }
        }
        catch (Exception e) {
            this.jComboBoxSynScheme.setEnabled(false);
            e.printStackTrace();
        }
        this.jButtonSelectAnalysisSuites.setEnabled(false);
    }

    private void initComponents() {
        this.buttonGroupSuite = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jCheckBoxMicro = new JCheckBox();
        this.jCheckBoxNanno = new JCheckBox();
        this.jCheckBoxPaly = new JCheckBox();
        this.jCheckBoxMacro = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jCheckBoxFDO = new JCheckBox();
        this.jCheckBoxLDO = new JCheckBox();
        this.jCheckBoxIgnoreRw = new JCheckBox();
        this.jCheckBoxIgnoreCv = new JCheckBox();
        this.jCheckBoxIgnoreQuestionable = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.jCheckBoxCU = new JCheckBox();
        this.jCheckBoxCO = new JCheckBox();
        this.jCheckBoxSC = new JCheckBox();
        this.jCheckBoxOC = new JCheckBox();
        this.jComboBoxCompositeStandard = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jCheckBoxJuniorSynonyms = new JCheckBox();
        this.jComboBoxSynScheme = new JComboBox();
        this.jRadioButtonAllAnalyses = new JRadioButton();
        this.jRadioButtonRestrictAnalyses = new JRadioButton();
        this.jButtonSelectAnalysisSuites = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Disciplines", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 102, 204)));
        this.jCheckBoxMicro.setText("Micropalaeontology");
        this.jCheckBoxMicro.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxMicro.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxNanno.setText("Nannopalaeontology");
        this.jCheckBoxNanno.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxNanno.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxPaly.setText("Palynology");
        this.jCheckBoxPaly.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxPaly.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxMacro.setText("Macropalaeontology");
        this.jCheckBoxMacro.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxMacro.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jCheckBoxMicro).add((Component)this.jCheckBoxNanno).add((Component)this.jCheckBoxPaly).add((Component)this.jCheckBoxMacro)).addContainerGap(86, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jCheckBoxMicro).addPreferredGap(0).add((Component)this.jCheckBoxNanno).addPreferredGap(0).add((Component)this.jCheckBoxPaly).addPreferredGap(0).add((Component)this.jCheckBoxMacro)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Event Types", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jCheckBoxFDO.setSelected(true);
        this.jCheckBoxFDO.setText("First downhole occurrences");
        this.jCheckBoxFDO.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxFDO.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxLDO.setSelected(true);
        this.jCheckBoxLDO.setText("Last downhole occurrences");
        this.jCheckBoxLDO.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxLDO.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxIgnoreRw.setSelected(true);
        this.jCheckBoxIgnoreRw.setText("Ignore reworking");
        this.jCheckBoxIgnoreRw.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxIgnoreRw.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxIgnoreCv.setSelected(true);
        this.jCheckBoxIgnoreCv.setText("Ignore caving");
        this.jCheckBoxIgnoreCv.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxIgnoreCv.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxIgnoreQuestionable.setSelected(true);
        this.jCheckBoxIgnoreQuestionable.setText("Ignore questionable occurrences");
        this.jCheckBoxIgnoreQuestionable.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxIgnoreQuestionable.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jCheckBoxFDO).add((Component)this.jCheckBoxLDO).add((Component)this.jCheckBoxIgnoreRw).add((Component)this.jCheckBoxIgnoreCv).add((Component)this.jCheckBoxIgnoreQuestionable)).addContainerGap(28, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jCheckBoxFDO).addPreferredGap(0).add((Component)this.jCheckBoxLDO).addPreferredGap(0).add((Component)this.jCheckBoxIgnoreRw).addPreferredGap(0).add((Component)this.jCheckBoxIgnoreCv).addPreferredGap(0).add((Component)this.jCheckBoxIgnoreQuestionable).addContainerGap(3, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Sample Types", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jCheckBoxCU.setSelected(true);
        this.jCheckBoxCU.setText("Cuttings");
        this.jCheckBoxCU.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxCU.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxCO.setSelected(true);
        this.jCheckBoxCO.setText("Cores");
        this.jCheckBoxCO.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxCO.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxSC.setSelected(true);
        this.jCheckBoxSC.setText("Sidewall cores");
        this.jCheckBoxSC.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxSC.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxOC.setSelected(true);
        this.jCheckBoxOC.setText("Outcrops");
        this.jCheckBoxOC.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxOC.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jCheckBoxCU).add((Component)this.jCheckBoxCO).add((Component)this.jCheckBoxSC).add((Component)this.jCheckBoxOC)).addContainerGap(118, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jCheckBoxCU).addPreferredGap(0).add((Component)this.jCheckBoxCO).addPreferredGap(0).add((Component)this.jCheckBoxSC).addPreferredGap(0).add((Component)this.jCheckBoxOC)));
        this.jComboBoxCompositeStandard.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel1.setText("Restrict search to taxa/events in composite:");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogGenerateEvent.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogGenerateEvent.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogGenerateEvent.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jCheckBoxJuniorSynonyms.setSelected(true);
        this.jCheckBoxJuniorSynonyms.setText("Use junior synonyms from scheme:");
        this.jCheckBoxJuniorSynonyms.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxJuniorSynonyms.setMargin(new Insets(0, 0, 0, 0));
        this.jComboBoxSynScheme.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.buttonGroupSuite.add(this.jRadioButtonAllAnalyses);
        this.jRadioButtonAllAnalyses.setSelected(true);
        this.jRadioButtonAllAnalyses.setText("All analyses");
        this.jRadioButtonAllAnalyses.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogGenerateEvent.this.jRadioButtonAllAnalysesActionPerformed(evt);
            }
        });
        this.buttonGroupSuite.add(this.jRadioButtonRestrictAnalyses);
        this.jRadioButtonRestrictAnalyses.setText("Restrict to...");
        this.jRadioButtonRestrictAnalyses.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogGenerateEvent.this.jRadioButtonRestrictAnalysesActionPerformed(evt);
            }
        });
        this.jButtonSelectAnalysisSuites.setText("...");
        this.jButtonSelectAnalysisSuites.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogGenerateEvent.this.jButtonSelectAnalysisSuitesActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jRadioButtonAllAnalyses).addPreferredGap(0).add((Component)this.jRadioButtonRestrictAnalyses).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonSelectAnalysisSuites)).add((Component)this.jLabel1).add((Component)this.jComboBoxCompositeStandard, 0, 215, Short.MAX_VALUE).add((Component)this.jCheckBoxJuniorSynonyms).add((Component)this.jComboBoxSynScheme, 0, 215, Short.MAX_VALUE).add(2, (Component)this.jSeparator1, -1, 215, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel2, -2, 129, -2).addPreferredGap(0).add((Component)this.jPanel3, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jComboBoxCompositeStandard, -2, -1, -2).addPreferredGap(0).add((Component)this.jCheckBoxJuniorSynonyms).addPreferredGap(0).add((Component)this.jComboBoxSynScheme, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jRadioButtonAllAnalyses).add((Component)this.jRadioButtonRestrictAnalyses).add((Component)this.jButtonSelectAnalysisSuites)).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonHelp).add((Component)this.jButtonCancel).add((Component)this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonOKActionPerformed(ActionEvent evt) {
        String discs = "";
        if (this.jCheckBoxMacro.isSelected()) {
            discs = discs + "A";
        }
        if (this.jCheckBoxMicro.isSelected()) {
            discs = discs + "M";
        }
        if (this.jCheckBoxNanno.isSelected()) {
            discs = discs + "N";
        }
        if (this.jCheckBoxPaly.isSelected()) {
            discs = discs + "P";
        }
        if (discs.length() == 0) {
            JOptionPane.showMessageDialog(this, "No data discipline selected", this.getTitle(), 2);
            return;
        }
        if (this.jRadioButtonRestrictAnalyses.isSelected() && (this.suites == null || this.suites.isEmpty())) {
            JOptionPane.showMessageDialog(this, "No analysis suite(s) selected", this.getTitle(), 1);
            return;
        }
        if (!this.jCheckBoxFDO.isSelected() && !this.jCheckBoxLDO.isSelected()) {
            JOptionPane.showMessageDialog(this, "You must select either ", this.getTitle(), 2);
            return;
        }
        int synonymScheme = 1;
        if (this.jComboBoxSynScheme.getSelectedItem() != null) {
            synonymScheme = ((SynonymScheme)this.jComboBoxSynScheme.getSelectedItem()).getSchID();
        }
        CompositeStandard std = null;
        if (this.jComboBoxCompositeStandard.getSelectedItem() instanceof CompositeStandard) {
            std = (CompositeStandard)this.jComboBoxCompositeStandard.getSelectedItem();
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            LinkedList nonInserts = new LinkedList();
            int nAdded = this.interp.generateEvents(this.well, this.suites, this.jCheckBoxFDO.isSelected(), this.jCheckBoxLDO.isSelected(), this.jCheckBoxCU.isSelected(), this.jCheckBoxCO.isSelected(), this.jCheckBoxSC.isSelected(), this.jCheckBoxOC.isSelected(), discs, !this.jCheckBoxIgnoreRw.isSelected(), !this.jCheckBoxIgnoreCv.isSelected(), !this.jCheckBoxIgnoreQuestionable.isSelected(), std, this.jCheckBoxJuniorSynonyms.isSelected(), synonymScheme, nonInserts);
            this.db.commit();
            String msg = "" + nAdded + " events were generated.";
            if (!nonInserts.isEmpty()) {
                msg = msg + "\n\nThe following event(s) were not added because there are existing events of the same name, either based on different taxa, or not set to 'use as top or base':\n";
                int i = 0;
                for (SBEvent.Builder b : nonInserts) {
                    msg = msg + "\n" + b.getName();
                    if (++i <= 25) continue;
                    msg = msg + "\n (...more)";
                    break;
                }
            }
            JOptionPane.showMessageDialog(this, msg, this.getTitle(), 1);
            if (nAdded > 0) {
                this.interp.notifyObservers(this.interp.getEvents().get(0));
                this.dispose();
            }
        }
        catch (SBException ex) {
            SB.showStackError((String)"Error generating events", (Exception)((Object)ex));
            this.db.doRollback();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("Error generating events", sql, this.db);
            this.db.doRollback();
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"Error generating events", (Exception)re);
            this.db.doRollback();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialoggenerateevent.html");
    }

    private void jButtonSelectAnalysisSuitesActionPerformed(ActionEvent evt) {
        try {
            DialogList dialog = new DialogList(this, true, "Select Analyses", this.db, this.well.getAnalystHeaders(), true, true);
            dialog.setLocationRelativeTo(this);
            if (this.suites != null) {
                dialog.setSelectedItems(this.suites);
            }
            dialog.setVisible(true);
            if (dialog.selected != null && !dialog.selected.isEmpty()) {
                if (this.suites == null) {
                    this.suites = new LinkedList<AnalystHeader>();
                }
                this.suites.clear();
                for (Object o : dialog.selected) {
                    this.suites.add((AnalystHeader)o);
                }
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
            ex.printStackTrace();
        }
    }

    private void jRadioButtonRestrictAnalysesActionPerformed(ActionEvent evt) {
        this.jButtonSelectAnalysisSuites.setEnabled(true);
    }

    private void jRadioButtonAllAnalysesActionPerformed(ActionEvent evt) {
        this.jButtonSelectAnalysisSuites.setEnabled(false);
        this.suites = null;
    }
}

