/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelGrainSize;
import model2.GrainSizeDepth;
import model2.GrainSizeList;
import model2.LithBase;
import model2.LithInterval;
import model2.SBdb;
import model2.Well;
import util.SB;
import util.SBException;
import util.SbugsFileFilter;
import util.SbugsTable;
import util.TableSorter;

public class DialogGrainSize
extends JDialog {
    Well well;
    SBdb db;
    TableModelGrainSize model = new TableModelGrainSize();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonGenerate;
    private JButton jButtonHelp;
    private JButton jButtonInsert;
    private JButton jButtonOK;
    private JButton jButtonSaveAs;
    private JButton jButtonSelectAll;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTable jTableGrainSize;

    public DialogGrainSize(JDialog parent, boolean modal, SBdb db, Well well, char units) throws SQLException, SBException {
        super((Dialog)parent, modal);
        this.well = well;
        this.db = db;
        this.model.units = units;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Lithology Grain Size : " + this.well.getWellName());
        this.well.loadGrainSize();
        this.model.grainSize = new GrainSizeList(this.well.getGrainSize());
        this.model.setupTable(this.jTableGrainSize);
        this.sorter.reallocateIndexes();
        this.sorter.addMouseListenerToHeaderInTable(this.jTableGrainSize);
        this.sorter.fireTableDataChanged();
    }

    private void initComponents() {
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonCancel = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableGrainSize = new SbugsTable(this.sorter);
        this.jButtonGenerate = new JButton();
        this.jButtonInsert = new JButton();
        this.jButtonAdd = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonSaveAs = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.jButtonSelectAll = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(300, 400));
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogGrainSize.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogGrainSize.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogGrainSize.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jTableGrainSize.setModel((TableModel)this.sorter);
        this.jScrollPane1.setViewportView(this.jTableGrainSize);
        this.jButtonGenerate.setText("Generate");
        this.jButtonGenerate.setToolTipText("Create grain size profile from lithology intervals");
        this.jButtonGenerate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogGrainSize.this.jButtonGenerateActionPerformed(evt);
            }
        });
        this.jButtonInsert.setText("Insert");
        this.jButtonInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogGrainSize.this.jButtonInsertActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogGrainSize.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setToolTipText("Delete selected rows from the table");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogGrainSize.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonSaveAs.setText("Save as...");
        this.jButtonSaveAs.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogGrainSize.this.jButtonSaveAsActionPerformed(evt);
            }
        });
        this.jButtonSelectAll.setText("Select all");
        this.jButtonSelectAll.setToolTipText("Delete selected rows from the table");
        this.jButtonSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogGrainSize.this.jButtonSelectAllActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 241, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jSeparator1, -1, 77, Short.MAX_VALUE).addComponent(this.jButtonGenerate, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDelete, -1, 77, Short.MAX_VALUE).addComponent(this.jButtonInsert, -1, 77, Short.MAX_VALUE).addComponent(this.jButtonAdd, -1, 77, Short.MAX_VALUE).addComponent(this.jSeparator2, -1, 77, Short.MAX_VALUE).addComponent(this.jButtonSelectAll, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonSaveAs, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonCancel, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonHelp, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonOK, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 537, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButtonGenerate).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonInsert).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSelectAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSaveAs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 246, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            this.well.storeGrainSize(this.model.grainSize);
            this.db.commit();
            this.dispose();
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
            this.db.doRollback();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialoggrainsize.html");
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonGenerateActionPerformed(ActionEvent evt) {
        try {
            if (this.well.getLithIntervals().isEmpty()) {
                JOptionPane.showMessageDialog(this, "There are no lithology intervals to use. Load intervals into workspace first.", this.getTitle(), 2);
                return;
            }
            if (this.model.grainSize.size() > 0) {
                if (JOptionPane.showConfirmDialog(this, "Clear current entries?", this.getTitle(), 0, 3) != 0) {
                    return;
                }
                this.model.grainSize.clear();
            }
            Iterator it = this.well.getLithIntervals().iterator();
            float lastEntry = 0.0f;
            while (it.hasNext()) {
                LithBase base = (LithBase)it.next();
                if (!(base instanceof LithInterval)) continue;
                LithInterval zone = (LithInterval)base;
                try {
                    if (zone.getLithology().getGrainSize() == lastEntry) continue;
                    GrainSizeDepth gs = new GrainSizeDepth(zone.getTopDepth(), zone.getLithology().getGrainSize());
                    this.model.grainSize.add(gs);
                    if (zone.getBaseDepth() > zone.getTopDepth() + 0.01) {
                        gs = new GrainSizeDepth(zone.getBaseDepth() - 0.01, zone.getLithology().getGrainSize());
                        this.model.grainSize.add(gs);
                    }
                    lastEntry = gs.getGrainSize();
                }
                catch (SBException ex) {
                    System.out.println("Error generating: " + ex.getMessage());
                }
            }
            this.sorter.reallocateIndexes();
            this.jTableGrainSize.clearSelection();
            this.model.grainSize.setDirty();
            this.sorter.fireTableDataChanged();
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.toString(), (Exception)ex);
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            String number = JOptionPane.showInputDialog(this, "Number of rows:", this.getTitle(), 3);
            if (number == null || number.length() == 0) {
                return;
            }
            int nRows = Integer.parseInt(number);
            for (int i = 0; i < nRows; ++i) {
                this.model.grainSize.add(this.model.grainSize.size(), (Object)new GrainSizeDepth(0.0, 0.0f));
            }
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
            this.jTableGrainSize.clearSelection();
        }
        catch (Exception se) {
            JOptionPane.showMessageDialog(this, se.toString(), this.getTitle(), 0);
            se.printStackTrace();
        }
    }

    private void jButtonInsertActionPerformed(ActionEvent evt) {
        int selection = this.jTableGrainSize.getSelectedRow();
        if (selection < 0) {
            JOptionPane.showMessageDialog(this, "No insertion point selected.", this.getTitle(), 2);
            return;
        }
        try {
            String number = JOptionPane.showInputDialog(this, "Number of rows:", this.getTitle(), 3);
            if (number == null || number.length() == 0) {
                return;
            }
            int nRows = Integer.parseInt(number);
            for (int i = 0; i < nRows; ++i) {
                this.model.grainSize.add(this.sorter.getIndexOf(selection), (Object)new GrainSizeDepth(0.0, 0.0f));
            }
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
            this.jTableGrainSize.clearSelection();
        }
        catch (Exception se) {
            JOptionPane.showMessageDialog(this, se.toString(), this.getTitle(), 0);
            se.printStackTrace();
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        int[] selection = this.jTableGrainSize.getSelectedRows();
        if (selection.length == 0) {
            JOptionPane.showMessageDialog(this, "No rows selected.", this.getTitle(), 2);
            return;
        }
        LinkedList<Object> removals = new LinkedList<Object>();
        for (int i = 0; i < selection.length; ++i) {
            removals.add(this.model.grainSize.get(this.sorter.getIndexOf(selection[i])));
        }
        Iterator it = removals.iterator();
        while (it.hasNext()) {
            this.model.grainSize.remove(it.next());
        }
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
        this.jTableGrainSize.clearSelection();
        this.model.grainSize.setDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSaveAsActionPerformed(ActionEvent evt) {
        JFileChooser jFileChooser1 = new JFileChooser();
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("csv");
        filter.setDescription("CSV files");
        jFileChooser1.setFileFilter((FileFilter)filter);
        if (0 == jFileChooser1.showSaveDialog(this)) {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                String fileName = jFileChooser1.getSelectedFile().getPath();
                if (fileName.toLowerCase().indexOf(".csv") < 0) {
                    fileName = fileName + ".csv";
                }
                FileWriter out = new FileWriter(fileName);
                Iterator it = this.model.grainSize.iterator();
                String eol = "\r\n";
                out.write("Depth (" + SB.unitString((char)this.model.units) + "), Grain Size" + eol);
                while (it.hasNext()) {
                    GrainSizeDepth gs = (GrainSizeDepth)it.next();
                    if (!(gs.getDepth() > 0.0)) continue;
                    out.write(SB.convFromM((double)gs.getDepth(), (char)this.model.units) + "," + gs.getGrainSize() + eol);
                }
                out.close();
                JOptionPane.showMessageDialog(this, "File written ");
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "File error: " + ex.getMessage());
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private void jButtonSelectAllActionPerformed(ActionEvent evt) {
        this.jTableGrainSize.selectAll();
    }
}

