/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import jsbugs.FrameJsbugs;
import jsbugs.IGDColmapJPanel;
import jsbugs.TableModelIGDColmap;
import model2.IGDColMap;
import model2.IGDInterval;
import model2.IGDIntervalZone;
import model2.SBdb;
import model2.Well;
import model2.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.SB;

public class DialogIGDColmap
extends JDialog {
    SBdb db;
    Well well;
    WellInterp wellInterp;
    int igdType;
    TableModelIGDColmap model = new TableModelIGDColmap();
    DefaultComboBoxModel modelLevels = new DefaultComboBoxModel();
    JComboBox levelCombo = new JComboBox(this.modelLevels);
    IGDColmapJPanel panel;
    static final int MARGIN = 30;
    boolean isOK = false;
    private JButton jButtonAddColumn;
    private JButton jButtonCancel;
    private JButton jButtonDeleteColumn;
    private JButton jButtonEditColumn;
    private JButton jButtonHelp;
    private JButton jButtonInsert;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTable jTableLevels;

    public DialogIGDColmap(Frame parent, boolean modal, SBdb db, Well well, WellInterp wellInterp, int igdType) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.well = well;
        this.wellInterp = wellInterp;
        this.igdType = igdType;
        this.initComponents();
        this.init();
    }

    public DialogIGDColmap(Dialog parent, boolean modal, SBdb db, Well well, WellInterp wellInterp, int igdType) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.well = well;
        this.wellInterp = wellInterp;
        this.igdType = igdType;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.setTitle("Column Mapping : " + this.well.getWellName() + " : " + this.wellInterp.getHeader().getDescription() + " : " + IGDInterval.getIGDName((int)this.igdType));
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.modelLevels.removeAllElements();
        for (int i = 0; i < IGDIntervalZone.getNHier((int)this.igdType, (boolean)true); ++i) {
            this.modelLevels.addElement(IGDIntervalZone.getHierName((int)this.igdType, (int)(i + 1), (boolean)true));
        }
        this.model.setupTable(this.jTableLevels);
        this.model.colmap = new IGDColMap(this.wellInterp.getColMap(this.well.getWellID(), this.igdType));
        this.jTableLevels.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(this.levelCombo));
        this.jTableLevels.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(this.levelCombo));
        this.model.igdType = this.igdType;
        this.model.fireTableDataChanged();
        this.model.panel = this.panel = new IGDColmapJPanel(this.model.colmap, this.igdType);
        this.jPanel1.add(this.panel);
        this.panel.setSize(this.jPanel1.getWidth() - 30, this.jPanel1.getHeight() - 30);
        this.panel.repaint();
        this.drawHier();
    }

    void drawHier() {
    }

    private void initComponents() {
        this.jProgressBar1 = new JProgressBar();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableLevels = new JTable();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonAddColumn = new JButton();
        this.jButtonEditColumn = new JButton();
        this.jButtonDeleteColumn = new JButton();
        this.jButtonInsert = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(600, 570));
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setForeground(new Color(51, 102, 204));
        this.jLabel1.setText("Click the \"From\" and \"To\" cells to specify hierachy level range for selected column:");
        this.jTableLevels.setModel(this.model);
        this.jTableLevels.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogIGDColmap.this.jTableLevelsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableLevels);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIGDColmap.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIGDColmap.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIGDColmap.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonAddColumn.setText("New column...");
        this.jButtonAddColumn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIGDColmap.this.jButtonAddColumnActionPerformed(evt);
            }
        });
        this.jButtonEditColumn.setText("Edit name...");
        this.jButtonEditColumn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIGDColmap.this.jButtonEditColumnActionPerformed(evt);
            }
        });
        this.jButtonDeleteColumn.setText("Delete column");
        this.jButtonDeleteColumn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIGDColmap.this.jButtonDeleteColumnActionPerformed(evt);
            }
        });
        this.jButtonInsert.setText("Insert column");
        this.jButtonInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIGDColmap.this.jButtonInsertActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Preview", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jPanel1.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                DialogIGDColmap.this.jPanel1ComponentResized(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(0, 566, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(0, 296, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 469, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jButtonAddColumn, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonInsert, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonEditColumn, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDeleteColumn)).add(2, 2, 2)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jSeparator1, -1, 578, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.linkSize(new Component[]{this.jButtonAddColumn, this.jButtonDeleteColumn, this.jButtonEditColumn, this.jButtonInsert}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonInsert).addPreferredGap(0).add((Component)this.jButtonAddColumn).addPreferredGap(0).add((Component)this.jButtonEditColumn).addPreferredGap(0).add((Component)this.jButtonDeleteColumn)).add((Component)this.jScrollPane1, 0, 0, Short.MAX_VALUE)).addPreferredGap(1).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(1).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            if (!this.model.colmap.check()) {
                JOptionPane.showMessageDialog(this, "Cannot save - check duplicate entries.", this.getTitle(), 2);
                return;
            }
            this.wellInterp.setColMap(this.well.getWellID(), this.igdType, this.model.colmap);
            this.wellInterp.notifyObservers((Object)this.model.colmap);
            this.well.getDataModel().commit();
            this.isOK = true;
            this.dispose();
        }
        catch (Exception e) {
            SB.showStackError((String)e.getMessage(), (Exception)e);
            this.well.getDataModel().doRollback();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogigdcolmap.html");
    }

    private void jButtonAddColumnActionPerformed(ActionEvent evt) {
        if (this.model.getRowCount() == this.modelLevels.getSize()) {
            JOptionPane.showMessageDialog(this, "Cannot add any more columns.", this.getTitle(), 2);
            return;
        }
        try {
            String columnTitle = JOptionPane.showInputDialog(this, (Object)"Column name");
            if (columnTitle != null) {
                this.model.colmap.addEntry(this.modelLevels.getSize(), columnTitle);
                this.model.fireTableDataChanged();
                this.jPanel1.repaint();
                this.panel.repaint();
            }
        }
        catch (Exception e) {
            SB.showStackError((String)e.getMessage(), (Exception)e);
        }
    }

    private void jButtonEditColumnActionPerformed(ActionEvent evt) {
        try {
            if (this.jTableLevels.getSelectedRow() < 0) {
                JOptionPane.showMessageDialog(this, "No column selected.", this.getTitle(), 2);
                return;
            }
            int selection = this.jTableLevels.getSelectedRow() + 1;
            String columnTitle = JOptionPane.showInputDialog(this, "Column name", this.model.colmap.getColTitle(selection));
            if (columnTitle != null) {
                this.model.colmap.setTitle(selection, columnTitle);
                this.model.fireTableDataChanged();
                this.jPanel1.repaint();
                this.panel.repaint();
            }
        }
        catch (Exception e) {
            SB.showStackError((String)e.getMessage(), (Exception)e);
        }
    }

    private void jButtonDeleteColumnActionPerformed(ActionEvent evt) {
        try {
            if (this.model.colmap.getSize() <= 1) {
                JOptionPane.showMessageDialog(this, "You must have at least 1 column.", this.getTitle(), 2);
                return;
            }
            if (this.jTableLevels.getSelectedRow() < 0) {
                JOptionPane.showMessageDialog(this, "No column selected.", this.getTitle(), 2);
                return;
            }
            int selection = this.jTableLevels.getSelectedRow() + 1;
            this.model.colmap.deleteColumn(selection);
            this.model.fireTableDataChanged();
            this.jPanel1.repaint();
            this.panel.repaint();
        }
        catch (Exception e) {
            SB.showStackError((String)e.getMessage(), (Exception)e);
        }
    }

    private void jButtonInsertActionPerformed(ActionEvent evt) {
        try {
            if (this.model.colmap.getSize() == this.modelLevels.getSize()) {
                JOptionPane.showMessageDialog(this, "Cannot add any more columns.", this.getTitle(), 2);
                return;
            }
            int insertPoint = this.jTableLevels.getSelectedRow();
            if (insertPoint < 0) {
                JOptionPane.showMessageDialog(this, "Select an entry in the list of columns below new entry to be inserted.", this.getTitle(), 2);
                return;
            }
            String columnTitle = JOptionPane.showInputDialog(this, (Object)"Column name");
            if (columnTitle != null) {
                this.model.colmap.insertEntry(this.modelLevels.getSize(), insertPoint + 1, columnTitle);
                this.model.fireTableDataChanged();
            }
        }
        catch (Exception e) {
            SB.showStackError((String)e.getMessage(), (Exception)e);
        }
    }

    private void jPanel1ComponentResized(ComponentEvent evt) {
        this.panel.setSize(this.jPanel1.getWidth() - 30, this.jPanel1.getHeight() - 30);
        this.jPanel1.repaint();
        this.panel.repaint();
    }

    private void jTableLevelsMouseClicked(MouseEvent evt) {
        int col;
        if (evt.getClickCount() > 1 && (col = this.jTableLevels.getSelectedColumn()) == 0) {
            this.jButtonEditColumnActionPerformed(null);
        }
    }
}

