/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.SBDialog;
import model2.IGDHdr;
import model2.IGDScheme;
import model2.SBdb;
import model2.Well;
import model2.WellInterp;
import util.SB;

public class DialogIGDHdr
extends SBDialog {
    Well well;
    WellInterp wellInterp;
    IGDHdr hdr;
    final int SOURCE_LEN = 25;
    final int AUTH_LEN = 25;
    final int COMM_LEN = 240;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JComboBox jComboBoxIGDSchemes;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JTextArea jTextAreaComment;
    private JTextField jTextFieldAuthorised;
    private JTextField jTextFieldSource;

    public DialogIGDHdr(JDialog parent, boolean modal, Well well, WellInterp wellInterp, IGDHdr hdr) throws SQLException {
        super((Dialog)parent, modal);
        this.well = well;
        this.wellInterp = wellInterp;
        this.hdr = hdr;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.jComboBoxIGDSchemes.removeAllItems();
        if (this.hdr != null) {
            this.setTitle("Notes : Edit");
            this.jTextAreaComment.setText(this.hdr.getComments());
            this.jTextFieldSource.setText(this.hdr.getSource());
            this.jTextFieldAuthorised.setText(this.hdr.getAuthorised());
            this.jComboBoxIGDSchemes.addItem(this.wellInterp.getDatabase().getIGDScheme(this.hdr.getSchID()));
            this.jComboBoxIGDSchemes.setEnabled(false);
        } else {
            this.setTitle("Notes : Add");
            LinkedList<IGDScheme> list = new LinkedList<IGDScheme>();
            SBdb db = this.wellInterp.getDatabase();
            Collection coll = db.getIGDSchemes(3);
            if (coll != null) {
                for (IGDScheme o : coll) {
                    list.add(o);
                }
            }
            if ((coll = db.getIGDSchemes(2)) != null) {
                for (IGDScheme o : coll) {
                    list.add(o);
                }
            }
            if ((coll = db.getIGDSchemes(4)) != null) {
                for (IGDScheme o : coll) {
                    list.add(o);
                }
            }
            if ((coll = db.getIGDSchemes(10)) != null) {
                for (IGDScheme o : coll) {
                    list.add(o);
                }
            }
            Iterator it = list.iterator();
            while (it.hasNext()) {
                this.jComboBoxIGDSchemes.addItem(it.next());
            }
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jComboBoxIGDSchemes = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaComment = new JTextArea();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jTextFieldSource = new JTextField();
        this.jTextFieldAuthorised = new JTextField();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setHorizontalAlignment(11);
        this.jLabel1.setText("Scheme: ");
        this.jComboBoxIGDSchemes.setMaximumRowCount(50);
        this.jLabel2.setHorizontalAlignment(11);
        this.jLabel2.setText("Comment:");
        this.jTextAreaComment.setColumns(20);
        this.jTextAreaComment.setRows(5);
        this.jTextAreaComment.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogIGDHdr.this.jTextAreaCommentKeyTyped(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTextAreaComment);
        this.jLabel3.setHorizontalAlignment(11);
        this.jLabel3.setText("Source:");
        this.jLabel4.setHorizontalAlignment(11);
        this.jLabel4.setText("Authorised:");
        this.jTextFieldSource.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogIGDHdr.this.jTextFieldSourceKeyTyped(evt);
            }
        });
        this.jTextFieldAuthorised.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogIGDHdr.this.jTextFieldAuthorisedKeyTyped(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIGDHdr.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIGDHdr.this.jButtonOKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 318, Short.MAX_VALUE).addComponent(this.jComboBoxIGDSchemes, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.jTextFieldSource).addComponent(this.jTextFieldAuthorised, GroupLayout.Alignment.TRAILING)).addGap(17, 17, 17)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonCancel).addGap(10, 10, 10)));
        layout.linkSize(0, this.jButtonCancel, this.jButtonOK);
        layout.linkSize(0, this.jLabel1, this.jLabel2, this.jLabel3, this.jLabel4);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBoxIGDSchemes, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jScrollPane1)).addGap(7, 7, 7).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldSource, -2, -1, -2)).addGap(7, 7, 7).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldAuthorised, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTextAreaComment.getText().trim().isEmpty() && this.jTextFieldAuthorised.getText().trim().isEmpty() && this.jTextFieldSource.getText().trim().isEmpty()) {
            JOptionPane.showMessageDialog(this, "No data entered", this.getTitle(), 1);
            return;
        }
        try {
            if (this.hdr == null) {
                int schID = ((IGDScheme)this.jComboBoxIGDSchemes.getSelectedItem()).getID();
                List hdrs = this.wellInterp.getHeaders();
                for (IGDHdr h : hdrs) {
                    if (h.getSchID() != schID) continue;
                    JOptionPane.showMessageDialog(this, "Comments for the selected scheme already exist.", this.getTitle(), 1);
                    return;
                }
                this.wellInterp.addIGDHdr(this.well.getWellID(), schID, this.jTextAreaComment.getText().trim(), this.jTextFieldSource.getText().trim(), this.jTextFieldAuthorised.getText().trim());
            } else {
                this.wellInterp.updateIGDHdr(this.well.getWellID(), this.hdr, this.jTextAreaComment.getText().trim(), this.jTextFieldSource.getText().trim(), this.jTextFieldAuthorised.getText().trim());
            }
            this.wellInterp.getDatabase().commit();
            this.setOK();
            this.dispose();
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.toString(), (Exception)ex);
        }
    }

    private void jTextAreaCommentKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextArea)this.jTextAreaComment, (int)240, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldSourceKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldSource, (int)25, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldAuthorisedKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldAuthorised, (int)25, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }
}

