/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import jsbugs.SBDialog;
import model2.IGDHdr;
import model2.IGDScheme;
import model2.SBdb;
import model2.Well;
import model2.WellInterp;
import util.SB;
import util.TableSorter;

public class DialogIGDHdrOccs
extends SBDialog {
    TableModelIGDHdrOccs model = new TableModelIGDHdrOccs();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    SBdb db;
    Well selectedWell;
    IGDScheme scheme;
    private JButton jButtonCancel;
    private JButton jButtonGoToWell;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTable jTableIGDHdrOccs;

    public DialogIGDHdrOccs(Frame parent, boolean modal, SBdb db, IGDScheme scheme) throws SQLException {
        super(parent, modal);
        this.initComponents();
        this.db = db;
        this.scheme = scheme;
        this.model.setupTable(this.jTableIGDHdrOccs);
        this.sorter.addMouseListenerToHeaderInTable(this.jTableIGDHdrOccs);
        this.model.initData(db, scheme.getID());
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
    }

    private void initComponents() {
        this.jButtonCancel = new JButton();
        this.jLabel1 = new JLabel();
        this.jButtonOK = new JButton();
        this.jButtonGoToWell = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableIGDHdrOccs = new JTable();
        this.setDefaultCloseOperation(2);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIGDHdrOccs.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jLabel1.setText("The selected scheme is linked to notes in the following wells:");
        this.jButtonOK.setText("Delete Scheme");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIGDHdrOccs.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonGoToWell.setText("Go to well");
        this.jButtonGoToWell.setToolTipText("Use the Notes button next to the Version selector in the Interpretations tab");
        this.jButtonGoToWell.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIGDHdrOccs.this.jButtonGoToWellActionPerformed(evt);
            }
        });
        this.jTableIGDHdrOccs.setModel((TableModel)this.sorter);
        this.jScrollPane1.setViewportView(this.jTableIGDHdrOccs);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonGoToWell).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonCancel)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 92, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 224, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK).addComponent(this.jButtonGoToWell)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            for (IGDHdr.IGDHdrOcc row : this.model.rows) {
                Iterator it = this.db.getProject(0).getWellIterator();
                while (it.hasNext()) {
                    Well well = (Well)it.next();
                    if (well.getWellID() != row.getWellID()) continue;
                    Iterator wit = well.getInterpIterator();
                    while (wit.hasNext()) {
                        WellInterp interp = (WellInterp)wit.next();
                        if (!interp.getHeader().getDescription().equalsIgnoreCase(row.getInterp())) continue;
                        interp.removeIGDHdr(this.scheme.getID());
                    }
                }
            }
            this.setOK();
            this.dispose();
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.toString(), (Exception)ex);
        }
    }

    private void jButtonGoToWellActionPerformed(ActionEvent evt) {
        if (this.jTableIGDHdrOccs.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "No item selected", this.getTitle(), 2);
            return;
        }
        try {
            IGDHdr.IGDHdrOcc occ = this.model.rows.get(this.sorter.getIndexOf(this.jTableIGDHdrOccs.getSelectedRow()));
            this.selectedWell = this.db.getAddWell(occ.getWellID());
            this.dispose();
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.toString(), (Exception)ex);
        }
    }

    class TableModelIGDHdrOccs
    extends AbstractTableModel {
        final int COL_WELL = 0;
        final int COL_CODE = 1;
        final int COL_INTERP = 2;
        final int COL_COMMENTS = 3;
        final String[] colTitles = new String[]{"Well Name", "Well Code", "Version", "Notes"};
        final int[] colWidths = new int[]{40, 40, 30, 80};
        List<IGDHdr.IGDHdrOcc> rows;
        SBdb db;

        TableModelIGDHdrOccs() {
        }

        @Override
        public int getRowCount() {
            if (this.rows == null) {
                return 0;
            }
            return this.rows.size();
        }

        @Override
        public int getColumnCount() {
            return this.colTitles.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.rows == null) {
                return "";
            }
            try {
                IGDHdr.IGDHdrOcc row = this.rows.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return row.getWellName();
                    }
                    case 1: {
                        return row.getWellCode();
                    }
                    case 3: {
                        return row.getComments();
                    }
                    case 2: {
                        return row.getInterp();
                    }
                }
                return "";
            }
            catch (Exception e) {
                e.printStackTrace();
                return e.getMessage();
            }
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
        }

        public Class getColumnClass(int c) {
            switch (c) {
                default: 
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        void setupTable(JTable jTable) {
            SB.setTableHeaderBold((JTable)jTable);
            for (int i = 0; i < this.getColumnCount(); ++i) {
                jTable.getColumnModel().getColumn(i).setHeaderValue(this.colTitles[i]);
                jTable.getColumnModel().getColumn(i).setPreferredWidth(this.colWidths[i]);
            }
        }

        void initData(SBdb db, int schID) throws SQLException {
            this.rows = IGDHdr.getOccs((SBdb)db, (int)schID);
        }
    }
}

