/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import jsbugs.DialogIGDHdr;
import jsbugs.TableModelIGDHdrs;
import model2.IGDHdr;
import model2.Well;
import model2.WellInterp;
import util.SB;
import util.SBException;

public class DialogIGDHdrs
extends JDialog {
    TableModelIGDHdrs model = new TableModelIGDHdrs();
    WellInterp wellInterp;
    Well well;
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTable jTableIGDHdrs;

    public DialogIGDHdrs(Frame parent, boolean modal, Well well, WellInterp wellInterp) throws SBException {
        super(parent, modal);
        this.initComponents();
        this.wellInterp = wellInterp;
        this.well = well;
        this.init();
    }

    private void init() throws SBException {
        this.setTitle("Interpretation Notes: " + this.well.getWellName() + " : " + this.wellInterp.toString());
        this.model.setupTable(this.jTableIGDHdrs);
        this.model.db = this.wellInterp.getDatabase();
        this.model.hdrs = this.wellInterp.getHeaders();
        this.model.fireTableDataChanged();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jButtonClose = new JButton();
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jScrollPane1 = new JScrollPane();
        this.jTableIGDHdrs = new JTable();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Enter optional notes describing use of schemes within current version");
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIGDHdrs.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIGDHdrs.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIGDHdrs.this.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIGDHdrs.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jTableIGDHdrs.setModel(this.model);
        this.jTableIGDHdrs.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogIGDHdrs.this.jTableIGDHdrsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableIGDHdrs);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 773, Short.MAX_VALUE).addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonAdd, GroupLayout.Alignment.TRAILING).addComponent(this.jButtonEdit, GroupLayout.Alignment.TRAILING).addComponent(this.jButtonDelete, GroupLayout.Alignment.TRAILING).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING, -2, 63, -2).addComponent(this.jButtonClose)))).addContainerGap()));
        layout.linkSize(0, this.jButtonAdd, this.jButtonClose, this.jButtonDelete, this.jButtonEdit, this.jSeparator1);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(13, 13, 13).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButtonAdd).addGap(8, 8, 8).addComponent(this.jButtonEdit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 9, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 61, Short.MAX_VALUE).addComponent(this.jButtonClose))).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            DialogIGDHdr dialog = new DialogIGDHdr(this, true, this.well, this.wellInterp, null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.model.fireTableDataChanged();
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.toString(), (Exception)ex);
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jTableIGDHdrs.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "No item selected in table", this.getTitle(), 1);
            return;
        }
        IGDHdr hdr = this.model.hdrs.get(this.jTableIGDHdrs.getSelectedRow());
        try {
            DialogIGDHdr dialog = new DialogIGDHdr(this, true, this.well, this.wellInterp, hdr);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.model.fireTableDataChanged();
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.toString(), (Exception)ex);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableIGDHdrs.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "No item selected in table", this.getTitle(), 1);
            return;
        }
        IGDHdr hdr = this.model.hdrs.get(this.jTableIGDHdrs.getSelectedRow());
        if (JOptionPane.showConfirmDialog(this, "Delete selected item?", this.getTitle(), 0, 3) == 1) {
            return;
        }
        try {
            this.wellInterp.deleteIGDHdr(this.well.getWellID(), hdr);
            this.model.fireTableDataChanged();
            this.wellInterp.getDatabase().commit();
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.toString(), (Exception)ex);
        }
    }

    private void jTableIGDHdrsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditActionPerformed(null);
        }
    }
}

