/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableModel;
import jsbugs.DialogList;
import jsbugs.DialogSurfaceOption;
import jsbugs.DialogSurfaceOption2;
import jsbugs.DialogUnitUsage;
import jsbugs.DialogUnlinked;
import jsbugs.FrameJsbugs;
import jsbugs.IGDSchTableModel;
import jsbugs.SBDialog;
import jsbugs.SurfaceTableModel;
import model2.Discipline;
import model2.IGDInterval;
import model2.IGDIntervalZone;
import model2.IGDScheme;
import model2.IGDSchemeXLSReader;
import model2.IGDUnit;
import model2.Lastval;
import model2.SBdb;
import model2.Surface;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SbugsTable;
import util.TableSorter;

public class DialogIGDScheme
extends SBDialog {
    private final SBdb db;
    private final IGDSchTableModel modelUnits;
    private final TableSorter sorterUnits;
    private final JComboBox hierComboBox = new JComboBox();
    private final SurfaceTableModel modelSurfaces;
    private final TableSorter sorterSurfaces;
    private final JComboBox typeCombo = new JComboBox<Surface.SurfaceType>(Surface.SurfaceType.values());
    private final IGDScheme scheme;
    IGDScheme schemeAdded = null;
    private static final int NAME_LEN = 80;
    private Color copyColour = null;
    Frame frameParent = null;
    private ButtonGroup buttonGroupDisc;
    private ButtonGroup buttonGroupSeq;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonCopyColour;
    private JButton jButtonCreate;
    private JButton jButtonDelete;
    private JButton jButtonHelp;
    private JButton jButtonInsert;
    private JButton jButtonOK;
    private JButton jButtonPasteColour;
    private JButton jButtonRead;
    private JButton jButtonShowUnlinked;
    private JButton jButtonWells;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanelDisc;
    private JPanel jPanelSequence;
    private JRadioButton jRadioButtonMacro;
    private JRadioButton jRadioButtonMicro;
    private JRadioButton jRadioButtonNanno;
    private JRadioButton jRadioButtonPaly;
    private JRadioButton jRadioButtonSeqD;
    private JRadioButton jRadioButtonSeqG;
    private JScrollPane jScrollPaneSurfaces;
    private JScrollPane jScrollPaneUnits;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTabbedPane jTabbedPane1;
    private JTable jTableScheme;
    private JTable jTableSurfaces;
    private JTextField jTextFieldColour;
    private JTextField jTextFieldCreated;
    private JTextField jTextFieldCreator;
    private JTextField jTextFieldName;

    public DialogIGDScheme(Frame parent, boolean modal, SBdb db, IGDScheme scheme, int igdType) throws SQLException, SBException {
        super(parent, modal);
        if (db == null) {
            throw new IllegalArgumentException("Null data model in DialogIGDScheme");
        }
        this.db = db;
        this.scheme = scheme;
        this.modelUnits = new IGDSchTableModel(scheme != null ? scheme.getIGDType() : igdType);
        this.sorterUnits = new TableSorter((TableModel)this.modelUnits);
        this.modelSurfaces = new SurfaceTableModel(this.modelUnits.scheme);
        this.sorterSurfaces = new TableSorter((TableModel)this.modelSurfaces);
        this.frameParent = parent;
        this.initComponents();
        this.init();
    }

    public DialogIGDScheme(JDialog parent, boolean modal, SBdb db, IGDScheme scheme, int igdType) throws SQLException, SBException {
        super((Dialog)parent, modal);
        if (db == null) {
            throw new IllegalArgumentException("Null data model in DialogIGDScheme");
        }
        this.db = db;
        this.scheme = scheme;
        this.modelUnits = new IGDSchTableModel(scheme != null ? scheme.getIGDType() : igdType);
        this.sorterUnits = new TableSorter((TableModel)this.modelUnits);
        this.modelSurfaces = new SurfaceTableModel(this.modelUnits.scheme);
        this.sorterSurfaces = new TableSorter((TableModel)this.modelSurfaces);
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Stratigraphic Scheme");
        int igdType = this.modelUnits.igdType;
        if (igdType != 10) {
            this.jScrollPaneSurfaces.setEnabled(false);
            this.jTabbedPane1.remove(this.jScrollPaneSurfaces);
        } else {
            this.jTabbedPane1.setSelectedComponent(this.jScrollPaneSurfaces);
            this.modelSurfaces.setupTable(this.jTableSurfaces, this.typeCombo);
        }
        if (this.scheme != null) {
            IGDUnit.Builder builder;
            this.scheme.loadUnits();
            for (IGDUnit unit : this.scheme.getUnitsX()) {
                builder = IGDUnit.Builder.copyOf((IGDUnit)unit, (SBdb)this.db);
                builder.setNOccs(unit.getNoccs(true));
                this.modelUnits.scheme.add(builder);
            }
            if (this.scheme.isSequence()) {
                this.scheme.loadSurfaces();
                for (Surface surface : this.scheme.getSurfacesX()) {
                    builder = Surface.Builder.copyOf((SBdb)this.db, (Surface)surface);
                    builder.setNOccs(surface.getNoccs(true));
                    this.modelSurfaces.scheme.add((Surface.Builder)builder);
                }
            }
            this.setTitle(this.getTitle() + " : " + this.scheme.toString());
            if (this.scheme.getDatabase() == null || !this.scheme.getDatabase().isConnected()) {
                this.jButtonWells.setEnabled(false);
                this.jButtonShowUnlinked.setEnabled(false);
            }
            this.jTextFieldName.setText(this.scheme.toString());
            if (this.scheme.getCreated() != null) {
                this.jTextFieldCreated.setText(SB.df.format(this.scheme.getCreated()));
            } else {
                this.jTextFieldCreated.setText("<unknown>");
            }
            if (this.scheme.getCreator() > 0 && this.scheme.getDatabase() != null) {
                this.jTextFieldCreator.setText(this.scheme.getDatabase().getUser(this.scheme.getCreator()).getAbr());
            } else {
                this.jTextFieldCreator.setText("");
            }
            if (this.scheme.getIGDType() == 10) {
                switch (this.scheme.getSqType()) {
                    default: {
                        this.jRadioButtonSeqD.setSelected(true);
                        break;
                    }
                    case GENETIC: {
                        this.jRadioButtonSeqG.setSelected(true);
                        break;
                    }
                }
            } else if (this.scheme.getIGDType() == 4) {
                switch (this.scheme.getDiscID()) {
                    case 'M': {
                        this.jRadioButtonMicro.setSelected(true);
                        break;
                    }
                    case 'N': {
                        this.jRadioButtonNanno.setSelected(true);
                        break;
                    }
                    case 'P': {
                        this.jRadioButtonPaly.setSelected(true);
                        break;
                    }
                    case 'A': {
                        this.jRadioButtonMacro.setSelected(true);
                    }
                }
            }
            this.sorterUnits.reallocateIndexes();
            this.sorterUnits.fireTableDataChanged();
        } else {
            this.setTitle(this.getTitle() + " : Add " + IGDInterval.getIGDName((int)igdType));
            this.jButtonWells.setEnabled(false);
            this.jButtonShowUnlinked.setEnabled(false);
        }
        this.modelUnits.setupTable(this.jTableScheme, this.hierComboBox);
        this.sorterUnits.addMouseListenerToHeaderInTable(this.jTableScheme);
        if (igdType != 10) {
            this.jButtonCreate.setEnabled(false);
            this.jPanelSequence.setEnabled(false);
            this.jRadioButtonSeqD.setEnabled(false);
            this.jRadioButtonSeqG.setEnabled(false);
        } else {
            this.sorterSurfaces.addMouseListenerToHeaderInTable(this.jTableSurfaces);
            this.sorterSurfaces.reallocateIndexes();
        }
        if (igdType != 4) {
            this.jRadioButtonMicro.setEnabled(false);
            this.jRadioButtonMacro.setEnabled(false);
            this.jRadioButtonNanno.setEnabled(false);
            this.jRadioButtonPaly.setEnabled(false);
        }
    }

    private void initComponents() {
        this.buttonGroupDisc = new ButtonGroup();
        this.buttonGroupSeq = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldCreator = new JTextField();
        this.jLabel3 = new JLabel();
        this.jTextFieldCreated = new JTextField();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonInsert = new JButton();
        this.jButtonAdd = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonShowUnlinked = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonWells = new JButton();
        this.jButtonCreate = new JButton();
        this.jPanelDisc = new JPanel();
        this.jRadioButtonMicro = new JRadioButton();
        this.jRadioButtonNanno = new JRadioButton();
        this.jRadioButtonPaly = new JRadioButton();
        this.jRadioButtonMacro = new JRadioButton();
        this.jPanelSequence = new JPanel();
        this.jRadioButtonSeqD = new JRadioButton();
        this.jRadioButtonSeqG = new JRadioButton();
        this.jButtonHelp = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jScrollPaneUnits = new JScrollPane();
        this.jTableScheme = new SbugsTable(this.sorterUnits);
        this.jScrollPaneSurfaces = new JScrollPane();
        this.jTableSurfaces = new SbugsTable(this.sorterUnits);
        this.jButtonCopyColour = new JButton();
        this.jTextFieldColour = new JTextField();
        this.jButtonPasteColour = new JButton();
        this.jSeparator2 = new JSeparator();
        this.jButtonRead = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(600, 580));
        this.jLabel1.setText("Name:");
        this.jTextFieldName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogIGDScheme.this.jTextFieldNameKeyTyped(evt);
            }
        });
        this.jLabel2.setText("Created by:");
        this.jTextFieldCreator.setEditable(false);
        this.jLabel3.setText("On:");
        this.jTextFieldCreated.setEditable(false);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setToolTipText("");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIGDScheme.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.setToolTipText("");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIGDScheme.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonInsert.setText("Insert");
        this.jButtonInsert.setToolTipText("");
        this.jButtonInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIGDScheme.this.jButtonInsertActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add");
        this.jButtonAdd.setToolTipText("");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIGDScheme.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Remove");
        this.jButtonDelete.setToolTipText("");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIGDScheme.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonShowUnlinked.setText("Show unlinked...");
        this.jButtonShowUnlinked.setToolTipText("Show unlinked intervals in this scheme");
        this.jButtonShowUnlinked.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonShowUnlinked.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIGDScheme.this.jButtonShowUnlinkedActionPerformed(evt);
            }
        });
        this.jButtonWells.setText("Show wells...");
        this.jButtonWells.setToolTipText("");
        this.jButtonWells.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIGDScheme.this.jButtonWellsActionPerformed(evt);
            }
        });
        this.jButtonCreate.setText("Create...");
        this.jButtonCreate.setMargin(new Insets(2, 7, 2, 7));
        this.jButtonCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIGDScheme.this.jButtonCreateActionPerformed(evt);
            }
        });
        this.jPanelDisc.setBorder(BorderFactory.createTitledBorder(null, "Discipline", 0, 0, null, new Color(51, 102, 204)));
        this.buttonGroupDisc.add(this.jRadioButtonMicro);
        this.jRadioButtonMicro.setText("Micro");
        this.buttonGroupDisc.add(this.jRadioButtonNanno);
        this.jRadioButtonNanno.setText("Nanno");
        this.buttonGroupDisc.add(this.jRadioButtonPaly);
        this.jRadioButtonPaly.setText("Paly");
        this.buttonGroupDisc.add(this.jRadioButtonMacro);
        this.jRadioButtonMacro.setText("Macro");
        GroupLayout jPanelDiscLayout = new GroupLayout((Container)this.jPanelDisc);
        this.jPanelDisc.setLayout((LayoutManager)jPanelDiscLayout);
        jPanelDiscLayout.setHorizontalGroup((GroupLayout.Group)jPanelDiscLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelDiscLayout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonMicro).addPreferredGap(0).add((Component)this.jRadioButtonNanno).addPreferredGap(1).add((Component)this.jRadioButtonPaly).addPreferredGap(1).add((Component)this.jRadioButtonMacro).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelDiscLayout.setVerticalGroup((GroupLayout.Group)jPanelDiscLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelDiscLayout.createSequentialGroup().add((GroupLayout.Group)jPanelDiscLayout.createParallelGroup(3).add((Component)this.jRadioButtonMicro).add((Component)this.jRadioButtonNanno).add((Component)this.jRadioButtonPaly).add((Component)this.jRadioButtonMacro)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanelSequence.setBorder(BorderFactory.createTitledBorder(null, "Sequence Type", 0, 0, null, new Color(51, 102, 204)));
        this.jPanelSequence.setMinimumSize(new Dimension(580, 600));
        this.buttonGroupSeq.add(this.jRadioButtonSeqD);
        this.jRadioButtonSeqD.setText("Depositional (Vail)");
        this.buttonGroupSeq.add(this.jRadioButtonSeqG);
        this.jRadioButtonSeqG.setText("Genetic (Galloway)");
        GroupLayout jPanelSequenceLayout = new GroupLayout((Container)this.jPanelSequence);
        this.jPanelSequence.setLayout((LayoutManager)jPanelSequenceLayout);
        jPanelSequenceLayout.setHorizontalGroup((GroupLayout.Group)jPanelSequenceLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelSequenceLayout.createSequentialGroup().add((Component)this.jRadioButtonSeqD).addPreferredGap(1).add((Component)this.jRadioButtonSeqG).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelSequenceLayout.setVerticalGroup((GroupLayout.Group)jPanelSequenceLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelSequenceLayout.createParallelGroup(3).add((Component)this.jRadioButtonSeqD).add((Component)this.jRadioButtonSeqG)));
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIGDScheme.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DialogIGDScheme.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.jTableScheme.setModel((TableModel)this.sorterUnits);
        this.jScrollPaneUnits.setViewportView(this.jTableScheme);
        this.jTabbedPane1.addTab("Units", this.jScrollPaneUnits);
        this.jTableSurfaces.setModel((TableModel)this.sorterSurfaces);
        this.jScrollPaneSurfaces.setViewportView(this.jTableSurfaces);
        this.jTabbedPane1.addTab("Surfaces", this.jScrollPaneSurfaces);
        this.jButtonCopyColour.setText("Copy colour");
        this.jButtonCopyColour.setToolTipText("Copy colour of selected unit");
        this.jButtonCopyColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIGDScheme.this.jButtonCopyColourActionPerformed(evt);
            }
        });
        this.jTextFieldColour.setEditable(false);
        this.jTextFieldColour.setToolTipText("Selected colour");
        this.jButtonPasteColour.setText("Paste colour");
        this.jButtonPasteColour.setToolTipText("Paste selected colour to selected unit");
        this.jButtonPasteColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIGDScheme.this.jButtonPasteColourActionPerformed(evt);
            }
        });
        this.jButtonRead.setText("Read...");
        this.jButtonRead.setToolTipText("Read the contents of an XLS file into scheme units");
        this.jButtonRead.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIGDScheme.this.jButtonReadActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTabbedPane1, -1, 603, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.jButtonShowUnlinked, -1, 107, Short.MAX_VALUE).add(1, (Component)this.jButtonWells, -1, 107, Short.MAX_VALUE).add(1, (Component)this.jSeparator1, -1, 107, Short.MAX_VALUE).add((Component)this.jButtonDelete, -1, 107, Short.MAX_VALUE).add((Component)this.jButtonInsert, -1, 107, Short.MAX_VALUE).add((Component)this.jButtonAdd, -1, 107, Short.MAX_VALUE).add((Component)this.jButtonCancel, -1, 107, Short.MAX_VALUE).add((Component)this.jButtonHelp, -1, 107, Short.MAX_VALUE).add((Component)this.jButtonOK, -1, 107, Short.MAX_VALUE).add((Component)this.jButtonCreate, -1, 107, Short.MAX_VALUE).add(1, (Component)this.jButtonCopyColour, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jTextFieldColour).add(1, (Component)this.jButtonPasteColour, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jSeparator2).add(1, (Component)this.jButtonRead, -1, -1, Short.MAX_VALUE))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jPanelDisc, -1, -1, Short.MAX_VALUE).add((Component)this.jTextFieldName, -1, 266, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jTextFieldCreator, -2, 60, -2).addPreferredGap(0).add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.jTextFieldCreated, -2, 92, -2)).add((Component)this.jPanelSequence, -2, -1, -2)))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldName, -2, -1, -2).add((Component)this.jLabel2).add((Component)this.jTextFieldCreator, -2, -1, -2).add((Component)this.jLabel3).add((Component)this.jTextFieldCreated, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jPanelSequence, -2, 57, Short.MAX_VALUE).add((Component)this.jPanelDisc, -2, -1, -2)).add(18, 18, 18).add((Component)this.jTabbedPane1, -1, 471, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add(134, 134, 134).add((Component)this.jButtonInsert).add(5, 5, 5).add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(1).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonWells).addPreferredGap(0).add((Component)this.jButtonShowUnlinked).addPreferredGap(0).add((Component)this.jButtonCreate).addPreferredGap(1).add((Component)this.jSeparator2, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonCopyColour).addPreferredGap(0).add((Component)this.jTextFieldColour, -2, -1, -2).addPreferredGap(0).add((Component)this.jButtonPasteColour).addPreferredGap(1).add((Component)this.jButtonRead).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTableScheme.isEditing()) {
            this.jTableScheme.getCellEditor().stopCellEditing();
        }
        if (this.jTableSurfaces.isEditing()) {
            this.jTableSurfaces.getCellEditor().stopCellEditing();
        }
        if ((name = this.jTextFieldName.getText().trim()).length() == 0) {
            JOptionPane.showMessageDialog(this, "You must choose a scheme name.", this.getTitle(), 2);
            return;
        }
        disc = null;
        sqType = null;
        if (this.modelUnits.igdType != 4) ** GOTO lbl27
        if (this.jRadioButtonMacro.isSelected()) {
            disc = Discipline.MACRO;
        } else if (this.jRadioButtonMicro.isSelected()) {
            disc = Discipline.MICRO;
        } else if (this.jRadioButtonNanno.isSelected()) {
            disc = Discipline.NANNO;
        } else if (this.jRadioButtonPaly.isSelected()) {
            disc = Discipline.PALY;
        } else {
            JOptionPane.showMessageDialog(this, "You must select a discipline.", this.getTitle(), 2);
            return;
lbl27:
            // 1 sources

            if (this.modelUnits.igdType == 10) {
                if (this.jRadioButtonSeqD.isSelected()) {
                    sqType = IGDScheme.SequenceType.DEPOSITIONAL;
                } else if (this.jRadioButtonSeqG.isSelected()) {
                    sqType = IGDScheme.SequenceType.GENETIC;
                } else {
                    JOptionPane.showMessageDialog(this, "You must select a sequence scheme type.", this.getTitle(), 2);
                    return;
                }
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            IGDScheme.checkSchemeUnits(this.modelUnits.scheme);
            if (this.modelUnits.igdType == 10) {
                IGDScheme.checkSchemeSurfaces(this.modelSurfaces.scheme);
            }
        }
        catch (InvalidFieldException ife) {
            JOptionPane.showMessageDialog(this, ife.getMessage(), this.getTitle(), 2);
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        try {
            if (this.scheme == null) {
                this.schemeAdded = new IGDScheme(this.db, this.modelUnits.igdType, name, disc, sqType);
                this.schemeAdded.storeDetails();
                if (!this.modelUnits.scheme.isEmpty() || !this.modelSurfaces.scheme.isEmpty()) {
                    this.schemeAdded.update(this.modelUnits.scheme, this.modelSurfaces.scheme, name, disc, sqType);
                }
            } else if (this.scheme.getDatabase().isConnected()) {
                if (!this.scheme.checkDeletedUnits(this.modelUnits.scheme) && JOptionPane.showConfirmDialog(this, msg = "Deleted units are linked to intervals in wells.\nDo you want to continue, and unlink these intervals?", this.getTitle(), 0, 3) != 0) {
                    return;
                }
                this.scheme.update(this.modelUnits.scheme, this.modelSurfaces.scheme, name, disc, sqType);
                list = this.scheme.getUnlinkedIntervals();
                if (list.size() > 0) {
                    nUnlinked = 0;
                    occs = 0;
                    for (IGDScheme.UnlinkedInterval interval : list) {
                        if (!interval.linked) continue;
                        ++nUnlinked;
                        occs += interval.occs;
                    }
                    if (nUnlinked > 0 && JOptionPane.showConfirmDialog(this, "Do you want to link " + nUnlinked + " units to " + occs + " occurrence(s) of informal terms in the well database?", this.getTitle(), 0) == 0) {
                        for (IGDScheme.UnlinkedInterval interval : list) {
                            if (!interval.linked) continue;
                            this.scheme.linkInformal(interval);
                        }
                    }
                }
            } else {
                if (this.db.getIGDScheme(name, this.modelUnits.igdType) != null) {
                    JOptionPane.showMessageDialog(this, "A Scheme of this name already exists in database.", this.getTitle(), 2);
                    return;
                }
                this.schemeAdded = new IGDScheme(this.db, this.modelUnits.igdType, name, disc, sqType);
                this.schemeAdded.storeDetails();
                try {
                    for (IGDUnit.Builder unit : this.modelUnits.scheme) {
                        this.schemeAdded.addUnit(unit);
                    }
                    if (!this.schemeAdded.isSequence()) ** GOTO lbl97
                    for (Surface.Builder surface : this.modelSurfaces.scheme) {
                        this.schemeAdded.addSurface(surface);
                    }
                }
                catch (InvalidFieldException e) {
                    SB.showStackError((String)"Error", (Exception)e);
                    e.printStackTrace();
                    return;
                }
            }
lbl97:
            // 4 sources

            this.db.commit();
            if (this.scheme != null) {
                this.scheme.notifyObservers();
            }
            if (this.schemeAdded != null) {
                this.db.addIGDScheme(this.schemeAdded);
            }
            this.setOK();
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)sbe);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        try {
            if (this.jTabbedPane1.getSelectedComponent() == this.jScrollPaneUnits) {
                this.jTableScheme.editingCanceled(null);
                int[] indices = this.jTableScheme.getSelectedRows();
                if (indices.length == 0) {
                    JOptionPane.showMessageDialog(this, "Select one or more rows to remove", this.getTitle(), 2);
                    return;
                }
                LinkedList<IGDUnit.Builder> toDie = new LinkedList<IGDUnit.Builder>();
                for (int i = 0; i < indices.length; ++i) {
                    toDie.add(this.modelUnits.scheme.get(this.sorterUnits.getIndexOf(indices[i])));
                }
                Iterator it = toDie.iterator();
                while (it.hasNext()) {
                    this.modelUnits.scheme.remove(it.next());
                }
                if (indices.length > 1) {
                    this.jTableScheme.clearSelection();
                }
                this.sorterUnits.reallocateIndexes();
                this.sorterUnits.fireTableDataChanged();
            } else {
                int[] indices = this.jTableSurfaces.getSelectedRows();
                this.jTableSurfaces.editingCanceled(null);
                if (indices.length == 0) {
                    JOptionPane.showMessageDialog(this, "Select one or more rows to remove", this.getTitle(), 2);
                    return;
                }
                LinkedList<Surface.Builder> toDie = new LinkedList<Surface.Builder>();
                for (int i = 0; i < indices.length; ++i) {
                    toDie.add(this.modelSurfaces.scheme.get(this.sorterSurfaces.getIndexOf(indices[i])));
                }
                for (Surface.Builder surface : toDie) {
                    if (surface.getNOccs() <= 0) continue;
                    JOptionPane.showMessageDialog(this, "You can't delete surfaces that are picked in wells. You must delete the well data first.", this.getTitle(), 2);
                    return;
                }
                Iterator it = toDie.iterator();
                while (it.hasNext()) {
                    this.modelSurfaces.scheme.remove(it.next());
                }
                if (indices.length > 1) {
                    this.jTableSurfaces.clearSelection();
                }
                this.sorterSurfaces.reallocateIndexes();
                this.sorterSurfaces.fireTableDataChanged();
            }
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonInsertActionPerformed(ActionEvent evt) {
        if (this.jTabbedPane1.getSelectedComponent() == this.jScrollPaneUnits) {
            if (this.jTableScheme.getSelectedRow() < 0) {
                JOptionPane.showMessageDialog(this, "No row selected", this.getTitle(), 2);
                return;
            }
            IGDUnit.Builder unit = new IGDUnit.Builder(this.db);
            IGDUnit.Builder selected = this.modelUnits.scheme.get(this.sorterUnits.getIndexOf(this.jTableScheme.getSelectedRow()));
            double age = selected.getUage();
            unit.age(age, age).hier(selected.getHier());
            this.modelUnits.scheme.add(this.modelUnits.scheme.indexOf(selected) + 1, unit);
            this.sorterUnits.reallocateIndexes();
            this.sorterUnits.fireTableDataChanged();
        } else {
            if (this.jTableSurfaces.getSelectedRow() < 0) {
                JOptionPane.showMessageDialog(this, "No row selected", this.getTitle(), 2);
                return;
            }
            Surface.Builder surface = new Surface.Builder(this.db);
            Surface.Builder selected = this.modelSurfaces.scheme.get(this.sorterSurfaces.getIndexOf(this.jTableSurfaces.getSelectedRow()));
            double age = selected.getAge();
            surface.age(age);
            this.modelSurfaces.scheme.add(this.sorterSurfaces.getIndexOf(this.jTableSurfaces.getSelectedRow()), surface);
            this.sorterSurfaces.reallocateIndexes();
            this.sorterSurfaces.fireTableDataChanged();
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            if (this.jTabbedPane1.getSelectedComponent() == this.jScrollPaneUnits) {
                int hier = this.modelUnits.scheme.size() > 0 ? this.modelUnits.scheme.get(this.modelUnits.scheme.size() - 1).getHier() : IGDIntervalZone.getDefaultHier((int)this.modelUnits.igdType);
                IGDUnit.Builder builder = new IGDUnit.Builder(this.db);
                builder.hier(hier);
                this.modelUnits.scheme.add(builder);
                this.sorterUnits.reallocateIndexes();
                this.sorterUnits.fireTableDataChanged();
                int index = this.modelUnits.scheme.size() - 1;
                this.jTableScheme.scrollRectToVisible(this.jTableScheme.getCellRect(index, 0, false));
                this.jTableScheme.setRowSelectionInterval(index, index);
            } else {
                Surface.Builder surface = new Surface.Builder(this.db);
                this.modelSurfaces.scheme.add(surface);
                this.sorterSurfaces.reallocateIndexes();
                this.sorterSurfaces.fireTableDataChanged();
                int index = this.modelSurfaces.scheme.size() - 1;
                this.jTableSurfaces.scrollRectToVisible(this.jTableSurfaces.getCellRect(index, 0, false));
                this.jTableSurfaces.setRowSelectionInterval(index, index);
            }
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonShowUnlinkedActionPerformed(ActionEvent evt) {
        if (this.scheme == null) {
            JOptionPane.showMessageDialog(this, "Scheme is not stored", this.getTitle(), 2);
            return;
        }
        try {
            List list = this.scheme.getUnlinkedIntervals();
            if (list.isEmpty()) {
                JOptionPane.showMessageDialog(this, "There are no unlinked informal terms for this scheme", this.getTitle(), 1);
                return;
            }
            DialogUnlinked dialog = new DialogUnlinked(this, true, this.scheme, list);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                int startIndex;
                int endIndex = startIndex = -1;
                for (IGDScheme.UnlinkedInterval interval : dialog.selection) {
                    if (this.scheme.findUnit(interval.name) != null) continue;
                    IGDUnit.Builder b = new IGDUnit.Builder(this.scheme.getDatabase()).name(interval.name);
                    this.modelUnits.scheme.add(b);
                    endIndex = this.modelUnits.scheme.size() - 1;
                    if (startIndex >= 0) continue;
                    startIndex = endIndex;
                }
                this.sorterUnits.reallocateIndexes();
                this.sorterUnits.fireTableDataChanged();
                if (startIndex >= 0) {
                    this.jTableScheme.scrollRectToVisible(this.jTableScheme.getCellRect(endIndex, 0, false));
                    this.jTableScheme.setRowSelectionInterval(startIndex, endIndex);
                }
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonWellsActionPerformed(ActionEvent evt) {
        try {
            if (this.jTabbedPane1.getSelectedComponent() == this.jScrollPaneUnits) {
                int[] indices = this.jTableScheme.getSelectedRows();
                if (indices.length != 1) {
                    JOptionPane.showMessageDialog(this, "Select one unit to display", this.getTitle(), 2);
                    return;
                }
                IGDUnit.Builder unit = this.modelUnits.scheme.get(this.sorterUnits.getIndexOf(indices[0]));
                if (unit.getOriginalID() <= 0) {
                    JOptionPane.showMessageDialog(this, "No original unit", this.getTitle(), 2);
                    return;
                }
                IGDUnit origUnit = this.scheme.findUnit(unit.getOriginalID());
                if (origUnit == null || origUnit.getUnitID() == 0) {
                    JOptionPane.showMessageDialog(this, "Unit is not stored in scheme.", this.getTitle(), 2);
                    return;
                }
                List list = origUnit.getOccs();
                if (list.size() > 0) {
                    DialogUnitUsage dialog = new DialogUnitUsage(this.frameParent, false, origUnit, this.db);
                    dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
                    dialog.setLocationRelativeTo(this);
                    dialog.setVisible(true);
                } else {
                    JOptionPane.showMessageDialog(this, "Unit: " + unit.getName() + " does not occur in any wells.", this.getTitle(), 1);
                }
            } else {
                int[] indices = this.jTableSurfaces.getSelectedRows();
                if (indices.length != 1) {
                    JOptionPane.showMessageDialog(this, "Select one surface to display", this.getTitle(), 2);
                    return;
                }
                Surface.Builder surface = this.modelSurfaces.scheme.get(this.sorterSurfaces.getIndexOf(indices[0]));
                Surface origSurface = this.scheme.getSurface(surface.getOriginalID());
                if (origSurface == null || origSurface.getSurfaceID() == 0) {
                    JOptionPane.showMessageDialog(this, "Surface is not stored in scheme.", this.getTitle(), 2);
                    return;
                }
                List list = origSurface.getOccs(this.db);
                if (list.size() > 0) {
                    DialogList dialog = new DialogList(this, true, surface.getName(), this.db, list, true, false);
                    dialog.setLocationRelativeTo(this);
                    dialog.setVisible(true);
                } else {
                    JOptionPane.showMessageDialog(this, "'" + surface.getName() + "' is not picked in any wells.", this.getTitle(), 1);
                }
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonCreateActionPerformed(ActionEvent evt) {
        if (this.jTabbedPane1.getSelectedComponent() == this.jScrollPaneUnits) {
            try {
                if (this.modelSurfaces.scheme.size() > 0) {
                    int opt;
                    boolean canClear = true;
                    for (Surface.Builder b : this.modelSurfaces.scheme) {
                        if (b.getNOccs() <= 0) continue;
                        canClear = false;
                    }
                    if (canClear) {
                        opt = JOptionPane.showConfirmDialog(this, "Clear all existing surfaces?", this.getTitle(), 1, 3);
                        if (opt == 2 || opt == -1) {
                            return;
                        }
                        if (opt == 0) {
                            this.modelUnits.scheme.clear();
                        }
                    } else {
                        opt = JOptionPane.showConfirmDialog(this, "Cannot clear existing surfaces because some have been picked in wells.\nContinue to create non-conflicting surfaces?", this.getTitle(), 0, 3);
                        if (opt != 0) {
                            return;
                        }
                    }
                }
                DialogSurfaceOption2 dialog = new DialogSurfaceOption2(this, true, this.jRadioButtonSeqD.isSelected());
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.selection == null) {
                    return;
                }
                int created = 0;
                for (IGDUnit.Builder unitB : this.modelUnits.scheme) {
                    if (!(unitB.getLage() > 0.0) || DialogIGDScheme.findSurface(this.modelSurfaces.scheme, unitB.getLage()) != null) continue;
                    ++created;
                    Surface.Builder surface = new Surface.Builder(this.db).age(unitB.getLage()).name(unitB.getName());
                    if (dialog.selection == DialogSurfaceOption2.SURFACEGEN.SB) {
                        surface.type(Surface.SurfaceType.SB);
                    } else if (dialog.selection == DialogSurfaceOption2.SURFACEGEN.MFS) {
                        surface.type(Surface.SurfaceType.MFS);
                    }
                    this.modelSurfaces.scheme.add(surface);
                }
                String msg = created > 0 ? "" + created + " surfaces were created. Press Surfaces tab to view." : "No surfaces were created. There are no ages on the unit boundaries, or there are existing surfaces at boundary ages.";
                JOptionPane.showMessageDialog(this, msg, this.getTitle(), 1);
                this.sorterSurfaces.reallocateIndexes();
                this.sorterSurfaces.fireTableDataChanged();
            }
            catch (RuntimeException re) {
                SB.showStackError((String)"", (Exception)re);
            }
        } else {
            try {
                if (this.modelUnits.scheme.size() > 0) {
                    int opt;
                    boolean canClear = true;
                    for (IGDUnit.Builder b : this.modelUnits.scheme) {
                        if (b.getNOccs() <= 0) continue;
                        canClear = false;
                    }
                    if (canClear) {
                        opt = JOptionPane.showConfirmDialog(this, "Clear all existing units?", this.getTitle(), 1, 3);
                        if (opt == 2 || opt == -1) {
                            return;
                        }
                        if (opt == 0) {
                            this.modelUnits.scheme.clear();
                        }
                    } else {
                        opt = JOptionPane.showConfirmDialog(this, "Cannot clear existing units because some have been picked in wells.\nContinue to create non-conflicting units?", this.getTitle(), 0, 3);
                        if (opt != 0) {
                            return;
                        }
                    }
                }
                DialogSurfaceOption dialog = new DialogSurfaceOption(this, true, this.jRadioButtonSeqD.isSelected());
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.selection == null) {
                    return;
                }
                IGDUnit.Builder unit = null;
                int created = 0;
                for (Surface.Builder surface : this.modelSurfaces.scheme) {
                    if ((surface.getType() == Surface.SurfaceType.SB || surface.getType() == Surface.SurfaceType.CC) && dialog.selection == DialogSurfaceOption.SURFACEGEN.TOPSB) {
                        if (unit != null) {
                            unit.lAge(surface.getAge());
                            if (this.addUnitToScheme(unit)) {
                                ++created;
                            }
                        }
                        unit = new IGDUnit.Builder(this.db).uAge(surface.getAge()).hier(1);
                        unit.name(this.filterSurfaceName(surface.getName()));
                        continue;
                    }
                    if ((surface.getType() == Surface.SurfaceType.SB || surface.getType() == Surface.SurfaceType.CC) && dialog.selection == DialogSurfaceOption.SURFACEGEN.BASESB) {
                        if (unit == null) {
                            unit = new IGDUnit.Builder(this.db).uAge(0.0).hier(1);
                        }
                        unit.name(this.filterSurfaceName(surface.getName()));
                        unit.lAge(surface.getAge());
                        if (this.addUnitToScheme(unit)) {
                            ++created;
                        }
                        unit = new IGDUnit.Builder(this.db);
                        unit.uAge(surface.getAge()).hier(1);
                        continue;
                    }
                    if (surface.getType() == Surface.SurfaceType.MFS && dialog.selection == DialogSurfaceOption.SURFACEGEN.TOPMFS) {
                        if (unit != null) {
                            unit.lAge(surface.getAge());
                            if (this.addUnitToScheme(unit)) {
                                ++created;
                            }
                        }
                        unit = new IGDUnit.Builder(this.db);
                        unit.uAge(surface.getAge()).hier(1);
                        unit.name(this.filterSurfaceName(surface.getName()));
                        continue;
                    }
                    if (surface.getType() != Surface.SurfaceType.MFS || dialog.selection != DialogSurfaceOption.SURFACEGEN.BASEMFS) continue;
                    if (unit == null) {
                        unit = new IGDUnit.Builder(this.db).uAge(0.0).hier(1);
                    }
                    unit.name(this.filterSurfaceName(surface.getName()));
                    unit.lAge(surface.getAge());
                    if (this.addUnitToScheme(unit)) {
                        ++created;
                    }
                    unit = new IGDUnit.Builder(this.db).uAge(surface.getAge()).hier(1);
                }
                if (unit != null && (dialog.selection == DialogSurfaceOption.SURFACEGEN.TOPMFS || dialog.selection == DialogSurfaceOption.SURFACEGEN.TOPSB)) {
                    unit.lAge(unit.getUage());
                    if (this.addUnitToScheme(unit)) {
                        ++created;
                    }
                }
                String msg = created > 0 ? "" + created + " units were created. Select Units tab to view." : "No units were created.";
                JOptionPane.showMessageDialog(this, msg, this.getTitle(), 1);
                this.sorterSurfaces.reallocateIndexes();
                this.sorterSurfaces.fireTableDataChanged();
                this.sorterUnits.reallocateIndexes();
                this.sorterUnits.fireTableDataChanged();
            }
            catch (RuntimeException re) {
                SB.showStackError((String)"", (Exception)re);
            }
        }
    }

    private String filterSurfaceName(String surfaceName) {
        for (Surface.SurfaceType type : Surface.SurfaceType.values()) {
            if (!surfaceName.endsWith(type.name())) continue;
            surfaceName = surfaceName.substring(0, surfaceName.length() - type.name().length()).trim();
            break;
        }
        return surfaceName;
    }

    private boolean addUnitToScheme(IGDUnit.Builder unit) {
        if (this.findUnit(unit.getName()) == null && !IGDScheme.isOverlap(this.modelUnits.scheme, (IGDUnit.Builder)unit)) {
            boolean inserted = false;
            int i = 0;
            for (IGDUnit.Builder b : this.modelUnits.scheme) {
                if (b.getSortEntry().compareTo(unit.getSortEntry()) > 0) {
                    this.modelUnits.scheme.add(i, unit);
                    inserted = true;
                    break;
                }
                ++i;
            }
            if (!inserted) {
                this.modelUnits.scheme.add(unit);
            }
            return true;
        }
        return false;
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogigdscheme.html");
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        if (this.jTabbedPane1.getSelectedComponent() == this.jScrollPaneSurfaces) {
            this.jButtonCreate.setText("Create units...");
        } else {
            this.jButtonCreate.setText("Create surfaces...");
        }
    }

    private void jTextFieldNameKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldName, (int)80, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonCopyColourActionPerformed(ActionEvent evt) {
        try {
            if (this.jTabbedPane1.getSelectedComponent() == this.jScrollPaneUnits) {
                int[] indices = this.jTableScheme.getSelectedRows();
                if (indices.length != 1) {
                    JOptionPane.showMessageDialog(this, "Select one unit to copy", this.getTitle(), 2);
                    return;
                }
                IGDUnit.Builder unit = this.modelUnits.scheme.get(this.sorterUnits.getIndexOf(indices[0]));
                this.copyColour = unit.getColour();
                this.jTextFieldColour.setBackground(this.copyColour);
            }
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonPasteColourActionPerformed(ActionEvent evt) {
        try {
            if (this.copyColour == null) {
                JOptionPane.showMessageDialog(this, "No colour selected - copy first");
                return;
            }
            if (this.jTabbedPane1.getSelectedComponent() == this.jScrollPaneUnits) {
                int[] indices = this.jTableScheme.getSelectedRows();
                if (indices.length == 0) {
                    return;
                }
                if (this.jTableScheme.isEditing()) {
                    this.jTableScheme.getCellEditor().stopCellEditing();
                }
                for (int i = 0; i < indices.length; ++i) {
                    this.modelUnits.scheme.get(this.sorterUnits.getIndexOf(indices[i])).colour(this.copyColour);
                }
            }
            this.sorterUnits.fireTableDataChanged();
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonReadActionPerformed(ActionEvent evt) {
        JFileChooser jFileChooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Excel files (xls)", "xls", "xlsx");
        jFileChooser.setFileFilter(filter);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        File setDir = null;
        try {
            setDir = new File(Lastval.getString((SBdb)this.db, (String)"JXLSFILE"));
        }
        catch (SQLException SQL) {
            // empty catch block
        }
        try {
            jFileChooser.setCurrentDirectory(setDir);
        }
        catch (Exception ex1) {
            // empty catch block
        }
        if (0 == jFileChooser.showOpenDialog(this)) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                File file = jFileChooser.getSelectedFile();
                String fileName = file.getPath();
                try {
                    Lastval.putString((SBdb)this.db, (String)"JXLSFILE", (String)fileName);
                    this.db.commit();
                }
                catch (SQLException sql) {
                    FrameJsbugs.showStackError("SQL Error", sql, this.db);
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                List units = IGDSchemeXLSReader.read((SBdb)this.db, (File)file, (int)this.modelUnits.igdType);
                for (IGDUnit.Builder b : units) {
                    this.modelUnits.scheme.add(b);
                }
                this.sorterUnits.fireTableDataChanged();
                this.sorterUnits.reallocateIndexes();
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.db);
            }
            catch (Exception re) {
                SB.showStackError((String)"", (Exception)re);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    void setUpdateUnits(LinkedList<IGDUnit> toUpdate) throws SBException, SQLException {
        for (IGDUnit unit : toUpdate) {
            IGDUnit.Builder b = this.findUnit(unit.getName());
            if (b == null) continue;
            if (!b.getName().equals(unit.getName())) {
                b.name(unit.getName());
            }
            if (!b.getAbr().endsWith(unit.getAbr())) {
                b.abr(unit.getAbr());
            }
            if (Math.abs(b.getUage() - unit.getUage()) > 1.0E-5) {
                b.uAge(unit.getUage());
            }
            if (Math.abs(b.getLage() - unit.getLage()) > 1.0E-5) {
                b.lAge(unit.getLage());
            }
            if (b.getColour().equals(unit.getColour())) continue;
            b.colour(unit.getColour());
        }
    }

    void setUpdateSurfaces(LinkedList<Surface> toUpdate) throws SBException, SQLException {
        for (Surface surface : toUpdate) {
            Surface.Builder b = this.findSurface(surface.getName(), surface.getType());
            if (b == null || !(Math.abs(b.getAge() - surface.getAge()) > 1.0E-5)) continue;
            b.age(surface.getAge());
        }
    }

    private static Surface.Builder findSurface(List<Surface.Builder> list, double age) {
        for (Surface.Builder surface : list) {
            if (!(Math.abs(age - surface.getAge()) < 1.0E-5)) continue;
            return surface;
        }
        return null;
    }

    private Surface.Builder findSurface(String surfaceName, Surface.SurfaceType type) {
        for (Surface.Builder b : this.modelSurfaces.scheme) {
            if (b.getName().compareToIgnoreCase(surfaceName) != 0 || b.getType() != type) continue;
            return b;
        }
        return null;
    }

    private IGDUnit.Builder findUnit(String unitName) {
        for (IGDUnit.Builder b : this.modelUnits.scheme) {
            if (b.getName().compareToIgnoreCase(unitName) != 0) continue;
            return b;
        }
        return null;
    }
}

