/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import model2.ImageSet;
import model2.Lastval;
import model2.SBImage;
import model2.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.SbugsFileFilter;

public class DialogImageSet
extends JDialog {
    SBImage image = null;
    SBdb db;
    ImageSet imageSet;
    boolean isOK = false;
    boolean isWorkspace = false;
    boolean imagesDeleted = false;
    static final int CAPTION_LEN = 255;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButtonCancel;
    private JButton jButtonDeleteImage;
    private JButton jButtonOK;
    private JButton jButtonSelectImage;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabelImage;
    private JLabel jLabelNimages;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSpinner jSpinnerImage;
    private JTextArea jTextAreaCaption;

    public DialogImageSet(JDialog parent, boolean modal, SBdb db, ImageSet imageSet) throws SQLException, SBException {
        super((Dialog)parent, modal);
        this.db = db;
        if (!db.isConnected()) {
            this.isWorkspace = true;
        }
        this.imageSet = imageSet;
        this.initComponents();
        int dialogWidth = Lastval.getInt((SBdb)db, (String)"DIS-W");
        int dialogHeight = Lastval.getInt((SBdb)db, (String)"DIS-H");
        if (dialogWidth > this.getMinimumSize().width || dialogHeight > this.getMinimumSize().height) {
            this.setSize(dialogWidth, dialogHeight);
        }
        if (imageSet != null) {
            if (imageSet.getSize() > 0) {
                this.setImage(0);
            } else {
                this.jSpinnerImage.setEnabled(false);
            }
            this.jLabelNimages.setText("of " + imageSet.getSize());
            if (imageSet.isUnreferenced()) {
                this.jButtonSelectImage.setEnabled(false);
                this.jButtonDeleteImage.setEnabled(false);
                this.jTextAreaCaption.setEditable(false);
            }
        } else {
            this.jLabelNimages.setText("");
            this.jSpinnerImage.setEnabled(false);
        }
        if (imageSet != null) {
            this.setTitle("Image Set : Edit");
        } else {
            this.setTitle("Image Set : Add");
        }
        if (this.isWorkspace) {
            this.jButtonSelectImage.setEnabled(false);
            this.jButtonDeleteImage.setEnabled(false);
            this.jTextAreaCaption.setEnabled(false);
            this.jButtonOK.setEnabled(false);
        }
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    final void setImage(int index) throws SQLException, SBException {
        if (index >= this.imageSet.getSize()) {
            if (this.imageSet.isUnreferenced() || this.isWorkspace) {
                return;
            }
            index = this.imageSet.getSize();
        }
        if (this.imageSet != null) {
            this.jSpinnerImage.setValue(index + 1);
            this.jSpinnerImageStateChanged(null);
        }
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonSelectImage = new JButton();
        this.jLabelImage = new JLabel();
        this.jButtonDeleteImage = new JButton();
        this.jSpinnerImage = new JSpinner();
        this.jLabelNimages = new JLabel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaCaption = new JTextArea();
        this.jLabel2 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jButton1.setText("jButton1");
        this.jButton2.setText("jButton2");
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(350, 480));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DialogImageSet.this.formWindowClosing(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                DialogImageSet.this.formComponentResized(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogImageSet.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogImageSet.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonSelectImage.setText("Select...");
        this.jButtonSelectImage.setToolTipText("Select an image from file");
        this.jButtonSelectImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogImageSet.this.jButtonSelectImageActionPerformed(evt);
            }
        });
        this.jLabelImage.setBackground(new Color(255, 255, 255));
        this.jLabelImage.setText("jLabel9");
        this.jLabelImage.setBorder(new MatteBorder(null));
        this.jLabelImage.setPreferredSize(new Dimension(360, 160));
        this.jButtonDeleteImage.setText("Remove");
        this.jButtonDeleteImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogImageSet.this.jButtonDeleteImageActionPerformed(evt);
            }
        });
        this.jSpinnerImage.setModel(new SpinnerNumberModel(1, 1, 50, 1));
        this.jSpinnerImage.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DialogImageSet.this.jSpinnerImageStateChanged(evt);
            }
        });
        this.jLabelNimages.setFont(new Font("Tahoma", 1, 11));
        this.jLabelNimages.setText("of n");
        this.jLabel1.setText("Caption:");
        this.jTextAreaCaption.setColumns(20);
        this.jTextAreaCaption.setFont(new Font("Tahoma", 0, 13));
        this.jTextAreaCaption.setLineWrap(true);
        this.jTextAreaCaption.setWrapStyleWord(true);
        this.jTextAreaCaption.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogImageSet.this.jTextAreaCaptionKeyTyped(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTextAreaCaption);
        this.jLabel2.setText("Image");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jScrollPane1, -1, 305, Short.MAX_VALUE).add(1, (Component)this.jSeparator1, -1, 305, Short.MAX_VALUE).add(1, (Component)this.jLabelImage, -1, 305, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK, -2, 65, -2).addPreferredGap(0).add((Component)this.jButtonCancel)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jSpinnerImage, -2, 53, -2).addPreferredGap(0).add((Component)this.jLabelNimages).addPreferredGap(0, 43, Short.MAX_VALUE).add((Component)this.jButtonDeleteImage).addPreferredGap(0).add((Component)this.jButtonSelectImage)).add(1, (Component)this.jLabel1)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabelImage, -1, 255, Short.MAX_VALUE).add(7, 7, 7).add((Component)this.jSeparator1, -2, 10, -2).add(1, 1, 1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonSelectImage).add((Component)this.jButtonDeleteImage).add((Component)this.jLabel2).add((Component)this.jSpinnerImage, -2, -1, -2).add((Component)this.jLabelNimages)).addPreferredGap(1).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jScrollPane1, -2, 76, -2).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonSelectImageActionPerformed(ActionEvent evt) {
        File setDir;
        JFileChooser jFileChooser = new JFileChooser();
        try {
            setDir = new File(Lastval.getString((SBdb)this.db, (String)"WINIMG", (String)"UNXIMG"));
            System.out.println("Image file name selected: " + setDir.getAbsolutePath());
            System.out.println("File parent: " + setDir.getParent());
            if (setDir == null || setDir.getParent() == null || !setDir.getParentFile().exists()) {
                setDir = new File(".");
            } else {
                setDir = new File(setDir.getParent());
                System.out.println("Image file exists: " + setDir.exists());
            }
        }
        catch (SQLException ex) {
            System.out.println("Error getting last image file name");
            ex.printStackTrace();
            setDir = new File(".");
        }
        jFileChooser.setCurrentDirectory(setDir);
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("jpg");
        filter.addExtension("tif");
        jFileChooser.setFileFilter((FileFilter)filter);
        if (jFileChooser.showOpenDialog(this) == 0) {
            String fileName = jFileChooser.getSelectedFile().getPath();
            try {
                int i;
                this.getImageCaption();
                int imageNumber = Integer.parseInt(this.jSpinnerImage.getValue().toString());
                this.image = new SBImage(this.db, new File(fileName), false, false);
                Lastval.putString((SBdb)this.db, (String)"WINIMG", (String)"UNXIMG", (String)fileName);
                System.out.println("Put image string back to database: " + fileName);
                this.setImage();
                if (this.imageSet == null) {
                    this.imageSet = new ImageSet(this.db);
                }
                if ((i = this.imageSet.insert(imageNumber, this.image) + 1) != imageNumber) {
                    this.jSpinnerImage.setValue(i);
                }
                this.jLabelNimages.setText("of " + this.imageSet.getSize());
                this.db.commit();
                this.jSpinnerImage.setEnabled(true);
            }
            catch (SQLException sqle) {
                JOptionPane.showMessageDialog(this, sqle.getMessage() + "\n" + SB.sql, this.getTitle(), 2);
                sqle.printStackTrace();
                this.db.doRollback();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
                e.printStackTrace();
                this.db.doRollback();
            }
        }
    }

    private void jButtonDeleteImageActionPerformed(ActionEvent evt) {
        if (this.image == null) {
            JOptionPane.showMessageDialog(this, "No image to delete", this.getTitle(), 2);
            return;
        }
        try {
            int imageNumber = Integer.parseInt(this.jSpinnerImage.getValue().toString());
            this.imageSet.removeImage(imageNumber - 1);
            this.image = this.imageSet.getImage(imageNumber);
            this.jLabelNimages.setText("of " + this.imageSet.getSize());
            if (this.imageSet.getSize() == 0) {
                this.jSpinnerImage.setEnabled(false);
            }
            this.setImage();
        }
        catch (SQLException sqle) {
            JOptionPane.showMessageDialog(this, sqle.getMessage() + "\n" + SB.sql, this.getTitle(), 2);
            sqle.printStackTrace();
            this.db.doRollback();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
            e.printStackTrace();
            this.db.doRollback();
        }
    }

    private void jSpinnerImageStateChanged(ChangeEvent evt) {
        System.out.println("spinner state changed");
        int imageNumber = Integer.parseInt(this.jSpinnerImage.getValue().toString());
        try {
            this.getImageCaption();
            this.image = this.imageSet.getImage(imageNumber - 1);
            this.setImage();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
            e.printStackTrace();
        }
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.jLabelImage.getWidth() > this.getWidth()) {
            int width = this.getWidth() - 30;
            int height = this.getHeight() - 200;
            this.jLabelImage.setIcon(null);
            this.jLabelImage.setSize(width, height);
        }
        try {
            this.getImageCaption();
            this.setImage();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
            e.printStackTrace();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        if (this.imageSet != null) {
            if (this.imageSet.hasDeletedImages()) {
                this.imageSet.restoreDeletedImages();
            }
            this.imageSet.clearImages();
        }
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.imageSet.isUnreferenced()) {
            this.dispose();
        }
        if (this.imageSet.hasDeletedImages()) {
            if (JOptionPane.showConfirmDialog(this, "Permanently delete removed images?", "Delete images", 0) != 0) {
                return;
            }
            this.imagesDeleted = true;
        }
        try {
            this.getImageCaption();
            this.imageSet.store();
            if (this.imageSet.getSize() == 0) {
                this.imageSet = null;
            } else {
                this.imageSet.clearImages();
            }
            int width = this.getWidth();
            int height = this.getHeight();
            if (width > this.getMinimumSize().width || height > this.getMinimumSize().height) {
                Lastval.putInt((SBdb)this.db, (String)"DIS-W", (int)width);
                Lastval.putInt((SBdb)this.db, (String)"DIS-H", (int)height);
            }
            this.db.commit();
            this.isOK = true;
            this.dispose();
        }
        catch (SQLException sqle) {
            SB.showStackError((String)"SQL Error saving image set", (SQLException)sqle);
            this.db.doRollback();
        }
        catch (Exception e) {
            SB.showStackError((String)"Error saving image set", (Exception)e);
            this.db.doRollback();
        }
    }

    private void jTextAreaCaptionKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextArea)this.jTextAreaCaption, (int)255, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.jButtonCancelActionPerformed(null);
    }

    private void setImage() throws SQLException, SBException, IOException {
        if (this.image != null) {
            this.jLabelImage.setText(null);
            Rectangle bounds = this.jLabelImage.getBounds();
            ImageIcon icon = this.image.getImage(bounds.width, bounds.height, false);
            this.jLabelImage.setIcon(icon);
            this.jTextAreaCaption.setText(this.image.getCaption());
        } else {
            this.jLabelImage.setIcon(null);
            this.jLabelImage.setText("Press Select... to add an image here");
            this.jLabelImage.setHorizontalAlignment(0);
            this.jLabelImage.setVerticalAlignment(0);
            this.jTextAreaCaption.setText(null);
        }
    }

    private void getImageCaption() throws SQLException, SBException {
        if (this.image != null && !this.jTextAreaCaption.getText().equals(this.image.getCaption())) {
            try {
                this.image.setCaption(this.jTextAreaCaption.getText());
                if (!this.isWorkspace) {
                    this.db.commit();
                }
            }
            catch (SQLException sqle) {
                JOptionPane.showMessageDialog(this, sqle.getMessage() + "\n" + SB.sql, this.getTitle(), 2);
                sqle.printStackTrace();
                this.db.doRollback();
            }
        }
    }
}

