/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import jsbugs.DialogImageSet;
import jsbugs.TableModelImageSet;
import model2.ImageSet;
import model2.SBdb;
import util.SB;
import util.SBException;

public class DialogImageSetOverview
extends JDialog {
    TableModelImageSet model = new TableModelImageSet();
    SBdb sbdb;
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonHelp;
    private JScrollPane jScrollPane1;
    private JTable jTableImageSet;

    public DialogImageSetOverview(Dialog parent, boolean modal, ImageSet imageSet, SBdb sbdb) {
        super(parent, modal);
        this.sbdb = sbdb;
        this.initComponents();
        this.init(imageSet);
    }

    private void init(ImageSet imageSet) {
        this.setTitle("Image Set : Overview");
        this.model.set = imageSet;
        this.model.setupTable(this.jTableImageSet);
        this.getRootPane().setDefaultButton(this.jButtonClose);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableImageSet = new JTable();
        this.jButtonClose = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonAdd = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(450, 450));
        this.jTableImageSet.setModel(this.model);
        this.jTableImageSet.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogImageSetOverview.this.jTableImageSetMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableImageSet);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogImageSetOverview.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogImageSetOverview.this.jButtonAddActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose))).addContainerGap()));
        layout.linkSize(0, this.jButtonAdd, this.jButtonClose, this.jButtonHelp);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 373, Short.MAX_VALUE).addGap(14, 14, 14).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonClose).addComponent(this.jButtonHelp).addComponent(this.jButtonAdd)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            this.selectImage(this.model.set.getSize());
        }
        catch (Exception e) {
            SB.showStackError((String)"Error", (Exception)e);
        }
    }

    private void selectImage(int index) {
        try {
            DialogImageSet dialog = new DialogImageSet(this, true, this.sbdb, this.model.set);
            dialog.setImage(index);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK) {
                this.model.fireTableDataChanged();
            }
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
    }

    private void jTableImageSetMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            int index = this.jTableImageSet.getSelectedRow();
            this.selectImage(index);
        }
    }
}

