/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jsbugs.DialogSelectAnalyst;
import jsbugs.FrameJsbugs;
import model2.SBdb;
import model2.Userdef;
import org.jdesktop.layout.GroupLayout;
import util.SB;

public class DialogImportAnalyses
extends JDialog {
    SBdb db;
    SBdb ws;
    boolean isOK = false;
    char discID = '\u0000';
    boolean isWell = true;
    char units = '\u0000';
    boolean setEmptyAsBarren = false;
    Userdef analyst = null;
    static final String nullAnalyst = "<Select>";
    String sampleType = "CU";
    private ButtonGroup buttonGroupBarren;
    private ButtonGroup buttonGroupDisc;
    private ButtonGroup buttonGroupSectionType;
    private ButtonGroup buttonGroupUnits;
    private JButton jButtonAnalyst;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JComboBox jComboBoxAnalyst;
    private JComboBox jComboBoxSampleType;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JRadioButton jRadioButtonBarren;
    private JRadioButton jRadioButtonFeet;
    private JRadioButton jRadioButtonMacro;
    private JRadioButton jRadioButtonMetres;
    private JRadioButton jRadioButtonMicro;
    private JRadioButton jRadioButtonNanno;
    private JRadioButton jRadioButtonOutcrop;
    private JRadioButton jRadioButtonPaly;
    private JRadioButton jRadioButtonPrepared;
    private JRadioButton jRadioButtonWell;

    public DialogImportAnalyses(Frame parent, boolean modal, SBdb db, SBdb ws) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.ws = ws;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.setTitle("File Import Parameters");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.initCombo();
    }

    private void initCombo() throws SQLException {
        this.jComboBoxAnalyst.removeAllItems();
        this.jComboBoxAnalyst.addItem(nullAnalyst);
        Collection users = this.db.getUsers();
        LinkedList list = new LinkedList(users);
        Collections.sort(list);
        for (Userdef user : list) {
            this.jComboBoxAnalyst.addItem(user);
        }
    }

    private void initComponents() {
        this.buttonGroupDisc = new ButtonGroup();
        this.buttonGroupUnits = new ButtonGroup();
        this.buttonGroupSectionType = new ButtonGroup();
        this.buttonGroupBarren = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jRadioButtonMicro = new JRadioButton();
        this.jRadioButtonNanno = new JRadioButton();
        this.jRadioButtonPaly = new JRadioButton();
        this.jRadioButtonMacro = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.jRadioButtonMetres = new JRadioButton();
        this.jRadioButtonFeet = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.jRadioButtonWell = new JRadioButton();
        this.jRadioButtonOutcrop = new JRadioButton();
        this.jPanel4 = new JPanel();
        this.jComboBoxAnalyst = new JComboBox();
        this.jButtonAnalyst = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jPanel5 = new JPanel();
        this.jRadioButtonBarren = new JRadioButton();
        this.jRadioButtonPrepared = new JRadioButton();
        this.jPanel6 = new JPanel();
        this.jComboBoxSampleType = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Discipline", 0, 0, null, new Color(51, 102, 204)));
        this.buttonGroupDisc.add(this.jRadioButtonMicro);
        this.jRadioButtonMicro.setText("Micropalaeontology");
        this.buttonGroupDisc.add(this.jRadioButtonNanno);
        this.jRadioButtonNanno.setText("Nannopalaeontology");
        this.buttonGroupDisc.add(this.jRadioButtonPaly);
        this.jRadioButtonPaly.setText("Palynology");
        this.buttonGroupDisc.add(this.jRadioButtonMacro);
        this.jRadioButtonMacro.setText("Macropalaeontology");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jRadioButtonMicro).add((Component)this.jRadioButtonNanno).add((Component)this.jRadioButtonPaly).add((Component)this.jRadioButtonMacro)).addContainerGap(41, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(new Component[]{this.jRadioButtonMacro, this.jRadioButtonMicro, this.jRadioButtonNanno, this.jRadioButtonPaly}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jRadioButtonMicro).addPreferredGap(1).add((Component)this.jRadioButtonNanno).addPreferredGap(1).add((Component)this.jRadioButtonPaly).addPreferredGap(1).add((Component)this.jRadioButtonMacro).addContainerGap(9, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Depth Units", 0, 0, null, new Color(51, 102, 204)));
        this.buttonGroupUnits.add(this.jRadioButtonMetres);
        this.jRadioButtonMetres.setText("Metres");
        this.buttonGroupUnits.add(this.jRadioButtonFeet);
        this.jRadioButtonFeet.setText("Feet");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jRadioButtonMetres).add((Component)this.jRadioButtonFeet)).addContainerGap(107, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(new Component[]{this.jRadioButtonFeet, this.jRadioButtonMetres}, 1);
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jRadioButtonMetres).addPreferredGap(0, 3, Short.MAX_VALUE).add((Component)this.jRadioButtonFeet)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Section Type", 0, 0, null, new Color(51, 102, 204)));
        this.buttonGroupSectionType.add(this.jRadioButtonWell);
        this.jRadioButtonWell.setSelected(true);
        this.jRadioButtonWell.setText("Well");
        this.jRadioButtonWell.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogImportAnalyses.this.jRadioButtonWellActionPerformed(evt);
            }
        });
        this.buttonGroupSectionType.add(this.jRadioButtonOutcrop);
        this.jRadioButtonOutcrop.setText("Outcrop");
        this.jRadioButtonOutcrop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogImportAnalyses.this.jRadioButtonOutcropActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jRadioButtonWell).add((Component)this.jRadioButtonOutcrop)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.linkSize(new Component[]{this.jRadioButtonOutcrop, this.jRadioButtonWell}, 1);
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jRadioButtonWell).addPreferredGap(1).add((Component)this.jRadioButtonOutcrop).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(null, "Analyst", 0, 0, null, new Color(51, 102, 204)));
        this.jComboBoxAnalyst.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jButtonAnalyst.setText("...");
        this.jButtonAnalyst.setToolTipText("Select an analyst");
        this.jButtonAnalyst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogImportAnalyses.this.jButtonAnalystActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((Component)this.jComboBoxAnalyst, 0, 114, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButtonAnalyst, -2, 32, -2).addContainerGap()));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.jComboBoxAnalyst, -2, -1, -2).add((Component)this.jButtonAnalyst)).addContainerGap(14, Short.MAX_VALUE)));
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogImportAnalyses.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogImportAnalyses.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogImportAnalyses.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(null, "Barren flags", 0, 0, null, new Color(51, 102, 204)));
        this.buttonGroupBarren.add(this.jRadioButtonBarren);
        this.jRadioButtonBarren.setText("Empty samples are \"Barren\"");
        this.buttonGroupBarren.add(this.jRadioButtonPrepared);
        this.jRadioButtonPrepared.setText("Empty samples are \"Prepared\"");
        GroupLayout jPanel5Layout = new GroupLayout((Container)this.jPanel5);
        this.jPanel5.setLayout((LayoutManager)jPanel5Layout);
        jPanel5Layout.setHorizontalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().add((Component)this.jRadioButtonPrepared).add(0, 0, Short.MAX_VALUE)).add((Component)this.jRadioButtonBarren, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel5Layout.setVerticalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().add((Component)this.jRadioButtonBarren).addPreferredGap(1).add((Component)this.jRadioButtonPrepared).addContainerGap(12, Short.MAX_VALUE)));
        this.jPanel6.setBorder(BorderFactory.createTitledBorder(null, "Sample type", 0, 0, null, new Color(51, 102, 204)));
        this.jComboBoxSampleType.setModel(new DefaultComboBoxModel<String>(new String[]{"CU", "CO", "SC", "LOG", "OC"}));
        GroupLayout jPanel6Layout = new GroupLayout((Container)this.jPanel6);
        this.jPanel6.setLayout((LayoutManager)jPanel6Layout);
        jPanel6Layout.setHorizontalGroup((GroupLayout.Group)jPanel6Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel6Layout.createSequentialGroup().add((Component)this.jComboBoxSampleType, 0, 71, Short.MAX_VALUE).addContainerGap()));
        jPanel6Layout.setVerticalGroup((GroupLayout.Group)jPanel6Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel6Layout.createSequentialGroup().addContainerGap().add((Component)this.jComboBoxSampleType, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK, -2, 55, -2).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel, -1, -1, Short.MAX_VALUE)).add((Component)this.jPanel3, -2, -1, -2).add((Component)this.jPanel2, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jPanel1, -2, -1, -2).add((Component)this.jPanel6, -2, -1, -2)).add((Component)this.jPanel4, -2, -1, -2).add((Component)this.jPanel5, -2, 183, -2)).add(0, 0, Short.MAX_VALUE)))));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, -1, -2).add(11, 11, 11).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel6, -1, -1, Short.MAX_VALUE)).add(1, 1, 1).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel4, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel5, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonOK).add((Component)this.jButtonHelp).add((Component)this.jButtonCancel)).addContainerGap()));
        this.pack();
    }

    private void jButtonAnalystActionPerformed(ActionEvent evt) {
        try {
            DialogSelectAnalyst dialog = new DialogSelectAnalyst(this, true, this.db);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selectedUser != null) {
                this.initCombo();
                this.jComboBoxAnalyst.setSelectedItem(dialog.selectedUser);
            }
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage() + "\nSQL: " + SB.sql, "SQL Error", 0);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.buttonGroupUnits.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "Must select depth units", this.getTitle(), 2);
            return;
        }
        this.units = this.jRadioButtonFeet.isSelected() ? (char)70 : (char)77;
        if (this.buttonGroupBarren.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "Must select barren flag", this.getTitle(), 2);
            return;
        }
        if (this.jRadioButtonBarren.isSelected()) {
            this.setEmptyAsBarren = true;
        }
        if (this.jRadioButtonOutcrop.isSelected()) {
            this.isWell = false;
        }
        if (this.jRadioButtonMicro.isSelected()) {
            this.discID = (char)77;
        } else if (this.jRadioButtonNanno.isSelected()) {
            this.discID = (char)78;
        } else if (this.jRadioButtonPaly.isSelected()) {
            this.discID = (char)80;
        } else if (this.jRadioButtonMacro.isSelected()) {
            this.discID = (char)65;
        } else {
            JOptionPane.showMessageDialog(this, "Must select discipline", this.getTitle(), 2);
            return;
        }
        if (this.jComboBoxAnalyst.getSelectedItem() instanceof String) {
            JOptionPane.showMessageDialog(this, "Must select an analyst", this.getTitle(), 2);
            return;
        }
        try {
            this.analyst = Userdef.copyToWorkspace((SBdb)this.ws, (Userdef)((Userdef)this.jComboBoxAnalyst.getSelectedItem()));
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.toString(), (Exception)ex);
            return;
        }
        this.sampleType = this.jComboBoxSampleType.getSelectedItem().toString();
        this.isOK = true;
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogimportanalyses.html");
    }

    private void jRadioButtonWellActionPerformed(ActionEvent evt) {
        this.jComboBoxSampleType.setSelectedItem("CU");
    }

    private void jRadioButtonOutcropActionPerformed(ActionEvent evt) {
        this.jComboBoxSampleType.setSelectedItem("OC");
    }
}

