/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.TableModel;
import jsbugs.DialogGrainSize;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelIntLith;
import model2.LithBase;
import model2.LithInterval;
import model2.LithQualifier;
import model2.SBdb;
import model2.Well;
import util.SB;
import util.SBException;
import util.SbugsTable;
import util.TableSorter;

public class DialogIntLith
extends JDialog
implements Observer {
    TableModelIntLith model = new TableModelIntLith();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    Well well;
    SBdb db;
    private JButton jButtonAddInterval;
    private JButton jButtonAddQual;
    private JButton jButtonCancel;
    private JButton jButtonGrainSize;
    private JButton jButtonHelp;
    private JButton jButtonInsertInterval;
    private JButton jButtonInsertQual;
    private JButton jButtonOK;
    private JButton jButtonRemove;
    private JScrollPane jScrollPane1;
    private JTable jTableLith;

    public DialogIntLith(Frame parent, boolean modal, SBdb db, Well well) throws SQLException, SBException {
        super(parent, modal);
        this.well = well;
        this.db = db;
        this.model.units = well.getWellUnits();
        this.model.type = well.getType();
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Interval Lithlogy : " + this.well.getWellName());
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.initList(false);
        this.model.lithdesc = this.db.getLithdesc();
        this.model.intervalComboBox = this.db.getLithologyCombo(true);
        this.model.alignmentComboBox = new JComboBox<String>(new String[]{"Left", "Right", "Centre"});
        this.model.setupTable(this.jTableLith);
        this.sorter.addMouseListenerToHeaderInTable(this.jTableLith);
        this.sorter.reallocateIndexes();
        this.well.addObserver((Observer)this);
    }

    Well getWell() {
        return this.well;
    }

    void initList(boolean forceReload) throws SQLException, SBException {
        this.model.list = new LinkedList<LithBase>();
        if (forceReload) {
            this.well.loadLithology();
        }
        for (LithBase interval : this.well.getLithIntervals()) {
            if (interval instanceof LithInterval) {
                this.model.list.add((LithBase)new LithInterval(null, (LithInterval)interval));
                continue;
            }
            this.model.list.add((LithBase)new LithQualifier(null, (LithQualifier)interval));
        }
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableLith = new SbugsTable(this.sorter);
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonInsertInterval = new JButton();
        this.jButtonAddInterval = new JButton();
        this.jButtonRemove = new JButton();
        this.jButtonAddQual = new JButton();
        this.jButtonInsertQual = new JButton();
        this.jButtonGrainSize = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(500, 400));
        this.jTableLith.setModel((TableModel)this.sorter);
        this.jScrollPane1.setViewportView(this.jTableLith);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIntLith.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIntLith.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIntLith.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonInsertInterval.setText("Insert interval");
        this.jButtonInsertInterval.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonInsertInterval.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIntLith.this.jButtonInsertIntervalActionPerformed(evt);
            }
        });
        this.jButtonAddInterval.setText("Add Interval");
        this.jButtonAddInterval.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonAddInterval.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIntLith.this.jButtonAddIntervalActionPerformed(evt);
            }
        });
        this.jButtonRemove.setText("Delete");
        this.jButtonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIntLith.this.jButtonRemoveActionPerformed(evt);
            }
        });
        this.jButtonAddQual.setText("Add qualifier");
        this.jButtonAddQual.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonAddQual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIntLith.this.jButtonAddQualActionPerformed(evt);
            }
        });
        this.jButtonInsertQual.setText("Insert qualifier");
        this.jButtonInsertQual.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonInsertQual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIntLith.this.jButtonInsertQualActionPerformed(evt);
            }
        });
        this.jButtonGrainSize.setText("Grain size...");
        this.jButtonGrainSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIntLith.this.jButtonGrainSizeActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 661, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonCancel).addComponent(this.jButtonHelp).addComponent(this.jButtonOK).addComponent(this.jButtonAddInterval)).addComponent(this.jButtonInsertInterval)).addComponent(this.jButtonAddQual).addComponent(this.jButtonInsertQual)).addComponent(this.jButtonRemove)).addComponent(this.jButtonGrainSize)).addContainerGap()));
        layout.linkSize(0, this.jButtonAddInterval, this.jButtonAddQual, this.jButtonCancel, this.jButtonHelp, this.jButtonInsertInterval, this.jButtonInsertQual, this.jButtonOK, this.jButtonRemove);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonAddInterval).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonInsertInterval).addGap(18, 18, 18).addComponent(this.jButtonAddQual).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonInsertQual).addGap(18, 18, 18).addComponent(this.jButtonRemove).addGap(37, 37, 37).addComponent(this.jButtonGrainSize).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 238, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 542, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonInsertIntervalActionPerformed(ActionEvent evt) {
        if (this.jTableLith.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "No row selected", this.getTitle(), 2);
            return;
        }
        int row = this.jTableLith.getSelectedRow();
        this.model.list.add(row, (LithBase)new LithInterval(null));
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
        this.jTableLith.scrollRectToVisible(this.jTableLith.getCellRect(row, 0, true));
        this.jTableLith.setRowSelectionInterval(row, row);
    }

    private void jButtonAddIntervalActionPerformed(ActionEvent evt) {
        this.model.list.add((LithBase)new LithInterval(null));
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
        int addedRow = this.model.list.size() - 1;
        this.jTableLith.scrollRectToVisible(this.jTableLith.getCellRect(addedRow, 0, true));
        this.jTableLith.setRowSelectionInterval(addedRow, addedRow);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        try {
            this.initList(false);
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            Collections.sort(this.model.list);
            LithBase.check(this.model.list, (char)this.model.units);
            this.well.storeLithology(this.model.list);
            this.well.notifyObservers(LithBase.class);
            this.db.commit();
            this.initList(false);
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
            this.dispose();
        }
        catch (SBException ex) {
            JOptionPane.showMessageDialog(this, "Check overlapping intervals: " + ex.getMessage(), this.getTitle(), 2);
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
            this.db.doRollback();
        }
    }

    private void jButtonAddQualActionPerformed(ActionEvent evt) {
        this.model.list.add((LithBase)new LithQualifier(null));
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
        this.jTableLith.scrollRectToVisible(this.jTableLith.getCellRect(this.model.getRowCount(), 0, true));
    }

    private void jButtonInsertQualActionPerformed(ActionEvent evt) {
        if (this.jTableLith.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "No row selected", this.getTitle(), 2);
            return;
        }
        int row = this.jTableLith.getSelectedRow();
        this.model.list.add(row, (LithBase)new LithQualifier(null));
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
        this.jTableLith.scrollRectToVisible(this.jTableLith.getCellRect(row, 0, true));
    }

    private void jButtonRemoveActionPerformed(ActionEvent evt) {
        if (this.jTableLith.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No rows selected", this.getTitle(), 2);
            return;
        }
        int[] selection = this.jTableLith.getSelectedRows();
        String msg = "Really delete " + (selection.length == 1 ? "this row?" : "these " + selection.length + " rows?");
        if (JOptionPane.showConfirmDialog(this, msg = msg + "\nData are not deleted from the database until you press OK.", this.getTitle(), 0, 3) != 0) {
            return;
        }
        LinkedList<LithBase> toRemove = new LinkedList<LithBase>();
        for (int i = 0; i < selection.length; ++i) {
            toRemove.add(this.model.list.get(this.sorter.getIndexOf(selection[i])));
        }
        for (LithBase lith : toRemove) {
            this.model.list.remove(lith);
        }
        this.jTableLith.clearSelection();
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogintlith.html");
    }

    private void jButtonGrainSizeActionPerformed(ActionEvent evt) {
        try {
            DialogGrainSize dialog = new DialogGrainSize(this, true, this.db, this.well, this.model.units);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.toString(), (Exception)ex);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof Well && this.well.getWellID() == this.well.getWellID() && (arg instanceof LithBase || arg == LithBase.class)) {
            try {
                this.initList(false);
                this.sorter.reallocateIndexes();
                this.sorter.fireTableDataChanged();
                this.jTableLith.repaint();
            }
            catch (SQLException sql) {
                sql.printStackTrace();
            }
            catch (SBException sbe) {
                sbe.printStackTrace();
            }
        }
    }
}

