/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jsbugs.FrameJsbugs;
import model2.Intcom;
import model2.SBdb;
import model2.Well;
import model2.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SB;

public class DialogIntervalComment
extends JDialog {
    private final SBdb db;
    private final Well well;
    private final WellInterp wellInterp;
    private final char units;
    private Intcom intcom;
    private static final int LENDEPTH = 8;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabelDepthUnitsBase;
    private JLabel jLabelDepthUnitsTop;
    private JScrollPane jScrollPaneComment;
    private JTextArea jTextAreaComment;
    private JTextField jTextFieldBase;
    private JTextField jTextFieldTop;

    public DialogIntervalComment(Frame parent, boolean modal, SBdb db, Well well, WellInterp wellInterp, Intcom intcom, char units) {
        super(parent, modal);
        this.db = db;
        this.intcom = intcom;
        this.well = well;
        this.wellInterp = wellInterp;
        this.units = units;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.getRootPane().setDefaultButton(this.jButtonOK);
        if (this.intcom != null) {
            this.jTextFieldTop.setText(SB.floatString((double)SB.convFromM((double)this.intcom.getTopDepth(), (char)this.units, (char)this.well.getType()), (int)2));
            this.jTextFieldBase.setText(SB.floatString((double)SB.convFromM((double)this.intcom.getBaseDepth(), (char)this.units, (char)this.well.getType()), (int)2));
            this.jTextAreaComment.setText(this.intcom.getComments());
            this.setTitle("Interval Comment : Edit");
        } else {
            this.setTitle("Interval Comment : Add");
        }
        if (this.well.getWellUnits() == 'F') {
            this.jLabelDepthUnitsTop.setText("ft");
            this.jLabelDepthUnitsBase.setText("ft");
        }
    }

    private void initComponents() {
        this.jScrollPaneComment = new JScrollPane();
        this.jTextAreaComment = new JTextArea();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextFieldTop = new JTextField();
        this.jTextFieldBase = new JTextField();
        this.jLabelDepthUnitsTop = new JLabel();
        this.jLabelDepthUnitsBase = new JLabel();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(300, 300));
        this.jTextAreaComment.setColumns(20);
        this.jTextAreaComment.setFont(new Font("Tahoma", 0, 13));
        this.jTextAreaComment.setLineWrap(true);
        this.jTextAreaComment.setRows(5);
        this.jTextAreaComment.setWrapStyleWord(true);
        this.jScrollPaneComment.setViewportView(this.jTextAreaComment);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIntervalComment.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIntervalComment.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Top:");
        this.jLabel2.setText("Base:");
        this.jTextFieldTop.setToolTipText("Enter a depth for the top of this interval");
        this.jTextFieldTop.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogIntervalComment.this.jTextFieldTopKeyTyped(evt);
            }
        });
        this.jTextFieldBase.setToolTipText("Enter a depth for the base of this interval");
        this.jTextFieldBase.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogIntervalComment.this.jTextFieldBaseKeyTyped(evt);
            }
        });
        this.jLabelDepthUnitsTop.setText("m");
        this.jLabelDepthUnitsBase.setText("m");
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogIntervalComment.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(11, 11, 11).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jTextFieldBase).add((Component)this.jTextFieldTop, -1, 118, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabelDepthUnitsTop).add((Component)this.jLabelDepthUnitsBase))).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPaneComment, -1, 346, Short.MAX_VALUE)).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(149, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldTop, -2, -1, -2).add((Component)this.jLabel1).add((Component)this.jLabelDepthUnitsTop)).add(3, 3, 3).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldBase, -2, -1, -2).add((Component)this.jLabel2).add((Component)this.jLabelDepthUnitsBase)).addPreferredGap(1).add((Component)this.jScrollPaneComment, -1, 183, Short.MAX_VALUE).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK).add((Component)this.jButtonHelp)).addContainerGap()));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTextFieldTop.getText().trim().isEmpty()) {
            JOptionPane.showMessageDialog(this, "Enter a top depth", this.getTitle(), 2);
            return;
        }
        if (this.jTextFieldBase.getText().trim().isEmpty()) {
            JOptionPane.showMessageDialog(this, "Enter a base depth", this.getTitle(), 2);
            return;
        }
        double topDepth = SB.convToM((double)Double.parseDouble(this.jTextFieldTop.getText()), (char)this.units, (char)this.well.getType());
        double baseDepth = SB.convToM((double)Double.parseDouble(this.jTextFieldBase.getText()), (char)this.units, (char)this.well.getType());
        String comment = this.jTextAreaComment.getText();
        if (comment.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "Enter a comment", this.getTitle(), 2);
            return;
        }
        if (topDepth > baseDepth) {
            JOptionPane.showMessageDialog(this, "Top depth must be above base depth", this.getTitle(), 2);
            return;
        }
        try {
            this.intcom = this.intcom == null ? this.wellInterp.addIntcom(this.well, new Intcom.Builder(this.db, topDepth).baseDepth(baseDepth).comments(comment)) : this.wellInterp.updateIntcom(this.intcom, this.well.getWellID(), topDepth, baseDepth, comment);
            this.db.commit();
            this.wellInterp.notifyObservers((Object)this.intcom);
            this.dispose();
        }
        catch (InvalidFieldException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("Error saving interval comment", ex, this.db);
            this.db.doRollback();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jTextFieldTopKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldTop, (int)8, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldBaseKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldBase, (int)8, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogintervalcomments.html");
    }
}

