/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.DialogSelectIGDType;
import jsbugs.DialogSelectScheme;
import jsbugs.FrameJsbugs;
import jsbugs.SBDialog;
import model2.IGDIntervalZone;
import model2.IGDScheme;
import model2.IGDUnit;
import model2.LOC;
import model2.SBdb;
import model2.Sample;
import model2.Well;
import model2.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;

public class DialogLOCIntervals
extends SBDialog {
    private final WellInterp wellInterp;
    IGDScheme scheme;
    private final Well well;
    private final SBdb db;
    private JCheckBox[] checkBoxes;
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JButton jButtonSelectScheme;
    private JCheckBox jCheckBox0;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBox3;
    private JCheckBox jCheckBox4;
    private JCheckBox jCheckBox5;
    private JCheckBox jCheckBox6;
    private JCheckBox jCheckBox7;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonCreate;
    private JRadioButton jRadioButtonSnap;
    private JSeparator jSeparator1;
    private JTextField jTextFieldScheme;
    private JTextField jTextFieldVersion;

    public DialogLOCIntervals(Frame parent, boolean modal, Well well, int interpID, IGDScheme scheme) throws SBException {
        super(parent, modal);
        this.well = well;
        this.db = well.getDataModel();
        this.wellInterp = well.getInterp(interpID);
        this.scheme = scheme;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Intervals : Create");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jTextFieldVersion.setText(this.wellInterp.toString());
        this.checkBoxes = new JCheckBox[8];
        this.checkBoxes[0] = this.jCheckBox0;
        this.checkBoxes[1] = this.jCheckBox1;
        this.checkBoxes[2] = this.jCheckBox2;
        this.checkBoxes[3] = this.jCheckBox3;
        this.checkBoxes[4] = this.jCheckBox4;
        this.checkBoxes[5] = this.jCheckBox5;
        this.checkBoxes[6] = this.jCheckBox6;
        this.checkBoxes[7] = this.jCheckBox7;
        if (this.scheme != null) {
            this.jTextFieldScheme.setText(this.scheme.toString());
            this.setSchemeLevels(this.scheme);
        } else {
            this.setSchemeLevels(null);
        }
    }

    private void setSchemeLevels(IGDScheme scheme) {
        if (scheme == null) {
            for (JCheckBox b : this.checkBoxes) {
                this.unsetCheck(b);
            }
        } else {
            this.setCheck(this.jCheckBox0, IGDIntervalZone.getHierName((int)scheme.getIGDType(), (int)1, (boolean)true));
            for (int hier = 1; hier < 8; ++hier) {
                if (IGDIntervalZone.getNHier((int)scheme.getIGDType(), (boolean)true) > hier) {
                    this.setCheck(this.checkBoxes[hier], IGDIntervalZone.getHierName((int)scheme.getIGDType(), (int)(hier + 1), (boolean)true));
                    continue;
                }
                this.unsetCheck(this.checkBoxes[hier]);
            }
        }
    }

    private void unsetCheck(JCheckBox checkBox) {
        checkBox.setText(null);
        checkBox.setEnabled(false);
        checkBox.setSelected(false);
    }

    private void setCheck(JCheckBox checkBox, String label) {
        checkBox.setText(label);
        checkBox.setEnabled(true);
        checkBox.setSelected(true);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabel1 = new JLabel();
        this.jTextFieldVersion = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldScheme = new JTextField();
        this.jButtonSelectScheme = new JButton();
        this.jLabel3 = new JLabel();
        this.jCheckBox0 = new JCheckBox();
        this.jCheckBox1 = new JCheckBox();
        this.jCheckBox2 = new JCheckBox();
        this.jCheckBox3 = new JCheckBox();
        this.jCheckBox4 = new JCheckBox();
        this.jCheckBox5 = new JCheckBox();
        this.jCheckBox6 = new JCheckBox();
        this.jCheckBox7 = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jRadioButtonSnap = new JRadioButton();
        this.jRadioButtonCreate = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogLOCIntervals.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogLOCIntervals.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Version:");
        this.jTextFieldVersion.setEditable(false);
        this.jLabel2.setText("Scheme:");
        this.jTextFieldScheme.setEditable(false);
        this.jTextFieldScheme.setBackground(new Color(255, 255, 204));
        this.jButtonSelectScheme.setText("...");
        this.jButtonSelectScheme.setToolTipText("Select a scheme");
        this.jButtonSelectScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogLOCIntervals.this.jButtonSelectSchemeActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Levels:");
        this.jCheckBox0.setText("jCheckBox0");
        this.jCheckBox1.setText("jCheckBox1");
        this.jCheckBox2.setText("jCheckBox2");
        this.jCheckBox3.setText("jCheckBox3");
        this.jCheckBox4.setText("jCheckBox4");
        this.jCheckBox5.setText("jCheckBox5");
        this.jCheckBox6.setText("jCheckBox6");
        this.jCheckBox7.setText("jCheckBox7");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Sample options", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroup1.add(this.jRadioButtonSnap);
        this.jRadioButtonSnap.setText("<html>Snap boundaries to nearest samples (<strong>note</strong>: always creates sample at unconformities)</html>");
        this.buttonGroup1.add(this.jRadioButtonCreate);
        this.jRadioButtonCreate.setText("Always create LOG (pick) samples at interpolated depths");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jRadioButtonSnap, -2, -1, -2).add((Component)this.jRadioButtonCreate)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(new Component[]{this.jRadioButtonCreate, this.jRadioButtonSnap}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonSnap, -2, -1, -2).addPreferredGap(1).add((Component)this.jRadioButtonCreate).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSeparator1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonCancel)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2)).add(4, 4, 4)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(1))).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jCheckBox0).addPreferredGap(0).add((Component)this.jCheckBox1).addPreferredGap(0).add((Component)this.jCheckBox2).addPreferredGap(1).add((Component)this.jCheckBox3)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jCheckBox4).addPreferredGap(0).add((Component)this.jCheckBox5).addPreferredGap(1).add((Component)this.jCheckBox6).addPreferredGap(0).add((Component)this.jCheckBox7)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldScheme).addPreferredGap(0).add((Component)this.jButtonSelectScheme, -2, 30, -2)).add((Component)this.jTextFieldVersion))).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldVersion, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jTextFieldScheme, -2, -1, -2).add((Component)this.jButtonSelectScheme)).add(10, 10, 10).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jCheckBox0).add((Component)this.jCheckBox1).add((Component)this.jCheckBox2).add((Component)this.jCheckBox3).add((Component)this.jLabel3)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jCheckBox4).add((Component)this.jCheckBox5).add((Component)this.jCheckBox6).add((Component)this.jCheckBox7)).add(13, 13, 13).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(1).add((Component)this.jSeparator1, -2, 10, -2).add(4, 4, 4).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK)).addContainerGap(14, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonSelectSchemeActionPerformed(ActionEvent evt) {
        DialogSelectIGDType dialog = new DialogSelectIGDType(this, true, false, false, false, false);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            if (dialog.igdType == 20) {
                JOptionPane.showMessageDialog(this, "You can't select a composite Standard here", this.getTitle(), 2);
                return;
            }
            if (dialog.igdType == 10) {
                JOptionPane.showMessageDialog(this, "You can't select a sequence scheme here - this generates intervals, not picks.", this.getTitle(), 2);
                return;
            }
            try {
                DialogSelectScheme dialogScheme = new DialogSelectScheme(this, true, this.db, dialog.igdType, null);
                dialogScheme.setLocationRelativeTo(this);
                dialogScheme.setVisible(true);
                if (dialogScheme.selection != null && dialogScheme.selection != this.scheme) {
                    this.scheme = dialogScheme.selection;
                    this.jTextFieldScheme.setText(this.scheme.toString());
                    this.scheme.loadUnits();
                    this.setSchemeLevels(this.scheme);
                }
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.db);
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error", (Exception)((Object)sbe));
            }
            catch (RuntimeException re) {
                SB.showStackError((String)"", (Exception)re);
            }
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        int opt;
        if (this.buttonGroup1.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "Select sample boundary option", this.getTitle(), 1);
            return;
        }
        if (this.scheme == null) {
            JOptionPane.showMessageDialog(this, "No scheme selected", this.getTitle(), 1);
            return;
        }
        int igdType = this.scheme.getIGDType();
        LOC loc = this.wellInterp.getLOC();
        if (loc == null || loc.getSize() < 2) {
            JOptionPane.showMessageDialog(this, "There is no line of correlation defined.", this.getTitle(), 1);
            return;
        }
        List zones = igdType == 4 ? this.wellInterp.getIGDList(igdType, this.scheme.getID()) : this.wellInterp.getIGDList(igdType);
        if (!zones.isEmpty() && (opt = JOptionPane.showConfirmDialog(this, "Do you want to clear all existing intervals?", this.getTitle(), 0, 3)) == 0) {
            try {
                if (igdType == 4) {
                    this.wellInterp.deleteZones(igdType, this.well.getWellID(), this.scheme.getID());
                } else {
                    this.wellInterp.deleteZones(igdType, this.well.getWellID());
                }
            }
            catch (SQLException sql) {
                this.db.doRollback();
                FrameJsbugs.showStackError("SQL Error", sql, this.db);
                return;
            }
        }
        try {
            class AgeDepth {
                double age;
                double depth;
                int bnd = -1;

                AgeDepth(double age) {
                    this.age = age;
                }
            }
            HashMap<Long, AgeDepth> ageDepths = new HashMap<Long, AgeDepth>();
            for (IGDUnit unit : this.scheme.getUnits()) {
                long age = (long)(unit.getUage() * 1.0E7);
                System.out.println("unit: " + unit + " age: " + age);
                if (ageDepths.get(age) == null) {
                    ageDepths.put(age, new AgeDepth(unit.getUage()));
                }
                if (ageDepths.get(age = (long)((int)(unit.getLage() * 1.0E7))) != null) continue;
                ageDepths.put(age, new AgeDepth(unit.getLage()));
            }
            Iterator itAD = ageDepths.values().iterator();
            while (itAD.hasNext()) {
                AgeDepth ad = (AgeDepth)itAD.next();
                double depth = loc.getDepth(ad.age, null, null, true);
                if (depth < 0.0) {
                    itAD.remove();
                    continue;
                }
                ad.depth = depth;
            }
            LOC.LOCNode endNode = loc.getNode(0);
            AgeDepth ageDepth = new AgeDepth(endNode.getAge());
            ageDepth.depth = endNode.getDepth();
            ageDepth.bnd = endNode.getBnd();
            double youngest = ageDepth.age;
            ageDepths.put((long)(youngest * 1.0E7), ageDepth);
            endNode = loc.getNode(loc.getSize() - 1);
            ageDepth = new AgeDepth(endNode.getAge());
            ageDepth.depth = endNode.getDepth();
            ageDepth.bnd = endNode.getBnd();
            double oldest = ageDepth.age;
            ageDepths.put((long)(oldest * 1.0E7), ageDepth);
            for (AgeDepth a : ageDepths.values()) {
                a.bnd = loc.getBoundary(a.depth);
            }
            for (AgeDepth ageDepthX : ageDepths.values()) {
                System.out.println("ageDepth : " + ageDepthX.age + ",\t" + ageDepthX.depth + "\tBnd=" + ageDepthX.bnd);
            }
            int zonesAdded = 0;
            Sample lastSampleAdded = null;
            LinkedList<IGDIntervalZone.Builder> toAdd = new LinkedList<IGDIntervalZone.Builder>();
            for (IGDUnit unit : this.scheme.getUnits()) {
                Sample baseSample;
                Sample topSample;
                if (!this.checkBoxes[unit.getHier() - 1].isSelected()) continue;
                long topAge = (long)(unit.getUage() * 1.0E7);
                ageDepth = unit.getUage() < youngest ? (AgeDepth)ageDepths.get((long)(youngest * 1.0E7)) : (AgeDepth)ageDepths.get(topAge);
                if (ageDepth == null) continue;
                double topDepth = ageDepth.depth;
                int topBnd = ageDepth.bnd;
                long baseAge = (long)(unit.getLage() * 1.0E7);
                ageDepth = unit.getLage() > oldest ? (AgeDepth)ageDepths.get((long)(oldest * 1.0E7)) : (AgeDepth)ageDepths.get(baseAge);
                if (ageDepth == null) continue;
                double baseDepth = ageDepth.depth;
                int baseBnd = ageDepth.bnd;
                if (this.jRadioButtonSnap.isSelected()) {
                    double depthBase;
                    double ageBase;
                    double depthTop;
                    double ageTop;
                    Double bd;
                    Double td;
                    if (topBnd == 4 || topBnd == 5) {
                        topSample = this.well.getSample(topDepth, null, true);
                        if (topSample == null) {
                            td = this.db.useSampleTops() ? Double.valueOf(topDepth) : null;
                            bd = this.db.useSampleTops() ? null : Double.valueOf(topDepth);
                            lastSampleAdded = topSample = this.well.addSample(td, bd, "LOG", "from loc (top)");
                        }
                    } else {
                        topSample = this.well.getSampleNearestBelow(topDepth);
                    }
                    if (baseBnd == 4 || baseBnd == 5) {
                        baseSample = this.well.getSample(baseDepth, null, true);
                        if (baseSample == null) {
                            td = this.db.useSampleTops() ? Double.valueOf(baseDepth) : null;
                            bd = this.db.useSampleTops() ? null : Double.valueOf(baseDepth);
                            lastSampleAdded = baseSample = this.well.addSample(td, bd, "LOG", "from loc(base)");
                        }
                    } else {
                        baseSample = this.well.getSampleNearestAbove(baseDepth, false, false);
                    }
                    if (topSample == null || baseSample == null || (ageTop = loc.getAge(depthTop = topSample.getDepth(), false)) > unit.getLage() || (ageBase = loc.getAge(depthBase = baseSample.getDepth(), false)) < unit.getUage() || (topBnd == 4 || topBnd == 5) && (baseBnd == 4 || baseBnd == 5) && topSample == baseSample) {
                        continue;
                    }
                } else {
                    topSample = this.well.getSample(topDepth, null, true);
                    if (topSample == null) {
                        lastSampleAdded = topSample = this.well.addSample(null, Double.valueOf(topDepth), "LOG", "from LOC(top)");
                    }
                    if ((baseSample = this.well.getSample(baseDepth, null, true)) == null) {
                        lastSampleAdded = baseSample = this.well.addSample(null, Double.valueOf(baseDepth), "LOG", "from LOC(base)");
                    }
                }
                System.out.println("Creating temporary zone: " + topSample.getDepth() + "," + baseSample.getDepth() + ",Hier=" + unit.getHier() + ",Unit=" + unit.getName() + ", bnd=" + topBnd + "/" + baseBnd);
                IGDIntervalZone.Builder builder = new IGDIntervalZone.Builder(this.db, igdType, topSample, baseSample, unit.getHier(), this.scheme.getID());
                builder.topBnd(topBnd).baseBnd(baseBnd).uppZone(unit.getUnitID()).uppInf(unit.getName());
                boolean addZone = true;
                for (IGDIntervalZone.Builder z : toAdd) {
                    if (builder.getHier() != z.getHier()) continue;
                    if (builder.getTopSample() == z.getTopSample()) {
                        toAdd.remove(z);
                        break;
                    }
                    if (builder.getBaseSample() != z.getBaseSample()) continue;
                    addZone = false;
                    break;
                }
                if (!addZone) continue;
                try {
                    this.wellInterp.checkOverlap(builder, null, false);
                }
                catch (SBException e) {
                    System.out.println("Did not add zone: " + e.getMessage());
                }
                toAdd.add(builder);
            }
            IGDIntervalZone zone = null;
            for (IGDIntervalZone.Builder z : toAdd) {
                zone = this.wellInterp.addZone(z, this.well);
                ++zonesAdded;
            }
            this.well.getDataModel().commit();
            if (zone != null) {
                this.wellInterp.notifyObservers(zone);
            }
            if (lastSampleAdded != null) {
                this.well.notifyObservers(lastSampleAdded);
            }
            JOptionPane.showMessageDialog(this, "Number of intervals added: " + zonesAdded, this.getTitle(), 1);
            this.setOK();
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error", (Exception)ex);
            ex.printStackTrace();
            this.well.getDataModel().doRollback();
            try {
                this.wellInterp.loadZones(igdType, this.well);
            }
            catch (Exception ex1) {
                SB.showStackError((String)ex.getMessage(), (Exception)ex1);
            }
        }
    }
}

