/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import model2.LOC;
import model2.Well;
import model2.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.AgeFormat;
import util.InvalidFieldException;
import util.SB;

public class DialogLOCnode
extends JDialog {
    private char units;
    private Well well;
    private WellInterp interp;
    private final AgeFormat af;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabelAgeFormat;
    private JLabel jLabelUnits;
    private JSeparator jSeparator1;
    private JTextField jTextFieldCSU;
    private JTextField jTextFieldDepth;

    public DialogLOCnode(Frame parent, boolean modal, char units, Well well, WellInterp interp, AgeFormat af) {
        super(parent, modal);
        this.initComponents();
        this.setTitle("LOC Node : Add");
        if (units == 'F') {
            this.jLabelUnits.setText("ft");
        } else {
            this.jLabelUnits.setText("m");
        }
        this.units = units;
        this.well = well;
        if (interp == null) {
            throw new IllegalArgumentException("Attempt to open dialog with null WellInterp");
        }
        this.interp = interp;
        this.af = af;
        this.jLabelAgeFormat.setText(af.getDescr());
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldDepth = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldCSU = new JTextField();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabelUnits = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabelAgeFormat = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setText("Depth:");
        this.jTextFieldDepth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogLOCnode.this.jTextFieldDepthKeyTyped(evt);
            }
        });
        this.jLabel2.setText("Age:");
        this.jTextFieldCSU.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogLOCnode.this.jTextFieldCSUKeyTyped(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogLOCnode.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogLOCnode.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabelUnits.setText("m");
        this.jLabelAgeFormat.setText("Ma");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jSeparator1).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jTextFieldCSU, -2, 89, -2)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jTextFieldDepth, -2, 89, -2))).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabelUnits, -2, 38, -2).add((Component)this.jLabelAgeFormat)).add(0, 0, Short.MAX_VALUE)))).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonCancel).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelUnits).add((Component)this.jTextFieldDepth, -2, -1, -2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jTextFieldCSU, -2, -1, -2).add((Component)this.jLabelAgeFormat)).addPreferredGap(1).add((Component)this.jSeparator1, -2, 2, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTextFieldDepth.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, "No depth entered");
        }
        if (this.jTextFieldCSU.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, "No value entered");
        }
        double depth = SB.convToM((double)Double.parseDouble(this.jTextFieldDepth.getText()), (char)this.units, (char)this.well.getType());
        double CSU = Double.parseDouble(this.jTextFieldCSU.getText());
        CSU /= this.af.getMultiplyer();
        Iterator it = this.interp.getLOC().getNodeIterator();
        while (it.hasNext()) {
            LOC.LOCNode node = (LOC.LOCNode)it.next();
            if (node.getDepth() != depth || node.getAge() != CSU) continue;
            JOptionPane.showMessageDialog(this, "Node already exists");
            return;
        }
        try {
            this.interp.addLOCNode(3, depth, CSU, this.well.getWellID());
            this.interp.getLOC().notifyObservers();
            this.dispose();
        }
        catch (InvalidFieldException ife) {
            JOptionPane.showMessageDialog(this, ife.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
    }

    private void jTextFieldDepthKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldDepth, (int)8, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldCSUKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldCSU, (int)10, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }
}

