/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;
import model2.Lastval;
import model2.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SbugsFileFilter;

public class DialogList
extends JDialog {
    SBdb db;
    List list;
    Object selection = null;
    List<Object> selected = null;
    boolean multipleSelect;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JButton jButtonSaveAs;
    private JList jList1;
    private JScrollPane jScrollPane1;

    public DialogList(Frame parent, boolean modal, String title, SBdb db, List list, boolean toSelect, boolean multipleSelect) {
        super(parent, modal);
        this.initComponents();
        this.list = list;
        this.db = db;
        this.multipleSelect = multipleSelect;
        this.init(toSelect);
        this.setTitle(title);
    }

    public DialogList(JDialog parent, boolean modal, String title, SBdb db, List list, boolean toSelect, boolean multipleSelect) {
        super((Dialog)parent, modal);
        this.initComponents();
        this.setTitle(title);
        this.list = list;
        this.db = db;
        this.multipleSelect = multipleSelect;
        this.init(toSelect);
    }

    private void init(boolean toSelect) {
        this.jList1.setListData(this.list.toArray());
        if (!toSelect) {
            this.jButtonOK.setVisible(false);
            this.jButtonCancel.setText("Close");
        }
    }

    private void initComponents() {
        this.jButtonSaveAs = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(275, 250));
        this.setModal(true);
        this.jButtonSaveAs.setText("Save as...");
        this.jButtonSaveAs.setToolTipText("Save the current list as a text file");
        this.jButtonSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogList.this.jButtonSaveAsActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogList.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogList.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jList1.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jList1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogList.this.jList1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jScrollPane1, -1, 310, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonSaveAs).addPreferredGap(0, 91, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 344, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonSaveAs).add((Component)this.jButtonCancel).add((Component)this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jList1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOKActionPerformed(null);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jList1.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, "No row selected", this.getTitle(), 2);
            return;
        }
        if (!this.multipleSelect) {
            this.selection = this.jList1.getSelectedValue();
        } else {
            this.selected = new LinkedList<Object>();
            this.selected.addAll(Arrays.asList(this.jList1.getSelectedValues()));
        }
        this.dispose();
    }

    private void jButtonSaveAsActionPerformed(ActionEvent evt) {
        File setDir = null;
        try {
            setDir = new File(Lastval.getString((SBdb)this.db, (String)"JLISTFILE"));
        }
        catch (SQLException ex) {
            // empty catch block
        }
        JFileChooser jFileChooser1 = new JFileChooser();
        jFileChooser1.setCurrentDirectory(setDir);
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("txt");
        filter.setDescription("Text files");
        jFileChooser1.addChoosableFileFilter((FileFilter)filter);
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
        Date date = new Date();
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (0 == jFileChooser1.showSaveDialog(this)) {
            try {
                String fileName = jFileChooser1.getSelectedFile().getPath();
                if (!fileName.toLowerCase().endsWith(".txt")) {
                    fileName = fileName + ".txt";
                }
                FileWriter out = new FileWriter(fileName);
                String eol = "\r\n";
                out.write("StrataBugs output: " + df.format(date) + eol);
                out.write(this.getTitle() + eol + eol);
                Iterator it = this.list.iterator();
                while (it.hasNext()) {
                    String text = it.next().toString();
                    out.write(text + eol);
                }
                out.close();
                if (JOptionPane.showConfirmDialog(this, "File '" + fileName + "' written", "File Saved", 2) == 0) {
                    Lastval.putString((SBdb)this.db, (String)"JLISTFILE", (String)fileName);
                    this.db.commit();
                }
            }
            catch (SQLException se) {
                JOptionPane.showMessageDialog(null, "Error: " + se.getMessage() + "\nSQL: " + SB.sql, "SQL Error", 0);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "File error: " + ex.getMessage());
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    void setSelectedItems(List items) {
        int[] indices = new int[items.size()];
        int n = 0;
        block0: for (int index = 0; index < this.list.size(); ++index) {
            for (Object o : items) {
                if (this.list.get(index) != o) continue;
                indices[n++] = index;
                continue block0;
            }
        }
        this.jList1.setSelectedIndices(indices);
    }
}

