/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import jsbugs.DialogLithTrnScheme;
import jsbugs.FrameJsbugs;
import model2.Lastval;
import model2.LithTrnEntry;
import model2.LithTrnScheme;
import model2.SBdb;
import util.SB;
import util.SBException;
import util.SbugsFileFilter;

public class DialogLithTrnSchManager
extends JDialog {
    SBdb sbdb;
    LithTrnScheme selected = null;
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonRead;
    private JList jListSchemes;
    private JScrollPane jScrollPane1;

    public DialogLithTrnSchManager(Dialog parent, boolean modal, SBdb sbdb) {
        super(parent, modal);
        this.initComponents();
        this.sbdb = sbdb;
        this.init();
    }

    private void init() {
        this.setTitle("Manage Lithology Match Schemes");
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.initList();
    }

    private void initList() {
        try {
            this.jListSchemes.setListData(this.sbdb.getLithTrnSchemes().toArray());
        }
        catch (Exception e) {
            SB.showStackError((String)"Error", (Exception)e);
        }
        this.jListSchemes.repaint();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jListSchemes = new JList();
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonRead = new JButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(250, 250));
        this.jListSchemes.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        this.jListSchemes.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.jListSchemes);
        this.jButtonAdd.setText("Add");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogLithTrnSchManager.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit");
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogLithTrnSchManager.this.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogLithTrnSchManager.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogLithTrnSchManager.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonRead.setText("Read...");
        this.jButtonRead.setToolTipText("Import a litholgoy match scheme from file");
        this.jButtonRead.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonRead.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogLithTrnSchManager.this.jButtonReadActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogLithTrnSchManager.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 214, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonHelp, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonRead, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonClose, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonAdd, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonEdit, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDelete, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 217, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonEdit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonRead).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 55, Short.MAX_VALUE).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose))).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        if (this.jListSchemes.getSelectedIndex() > 0) {
            this.selected = (LithTrnScheme)this.jListSchemes.getSelectedValue();
        }
        this.dispose();
    }

    private void jButtonReadActionPerformed(ActionEvent evt) {
        this.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jListSchemes.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, "Select a scheme to edit", this.getTitle(), 2);
            return;
        }
        LithTrnScheme scheme = (LithTrnScheme)this.jListSchemes.getSelectedValue();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            scheme.loadEntries();
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
            this.setCursor(Cursor.getDefaultCursor());
        }
        DialogLithTrnScheme dialog = new DialogLithTrnScheme((Dialog)this, true, this.sbdb, scheme);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        LithTrnScheme newScheme = new LithTrnScheme(this.sbdb, new LinkedList());
        DialogLithTrnScheme dialog = new DialogLithTrnScheme((Dialog)this, true, this.sbdb, newScheme);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK) {
            try {
                this.sbdb.addLithTrnScheme(newScheme);
                Collections.sort(this.sbdb.getLithTrnSchemes());
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error: ", (Exception)((Object)sbe));
            }
            catch (SQLException sql) {
                SB.showStackError((String)"SQL Error: ", (SQLException)sql);
            }
        }
        this.initList();
        if (dialog.isOK) {
            this.jListSchemes.setSelectedValue(newScheme, true);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jListSchemes.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, "Select a scheme", this.getTitle(), 2);
            return;
        }
        LithTrnScheme scheme = (LithTrnScheme)this.jListSchemes.getSelectedValue();
        if (JOptionPane.showConfirmDialog(this, "Really delete scheme '" + scheme + "'?", this.getTitle(), 0) != 0) {
            return;
        }
        try {
            this.sbdb.deleteLithTrnScheme(scheme.getID());
        }
        catch (Exception e) {
            SB.showStackError((String)"Error deleting scheme", (Exception)e);
        }
        this.initList();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("organiser_lithimport.html");
    }

    void read() {
        File setDir = null;
        try {
            setDir = new File(Lastval.getString((SBdb)this.sbdb, (String)"LTHSCHFILE"));
        }
        catch (SQLException ex) {
            // empty catch block
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(setDir);
        SbugsFileFilter filter = new SbugsFileFilter("txt", "Openworks lithology index files");
        jFileChooser.setFileFilter((FileFilter)filter);
        SbugsFileFilter filter2 = new SbugsFileFilter("csv", "CSV lithology index files");
        jFileChooser.setFileFilter((FileFilter)filter2);
        if (jFileChooser.showOpenDialog(this) == 0) {
            try {
                Lastval.putString((SBdb)this.sbdb, (String)"LTHSCHFILE", (String)jFileChooser.getSelectedFile().getPath());
            }
            catch (SQLException sql) {
                // empty catch block
            }
            LinkedList<LithTrnEntry> liths = new LinkedList<LithTrnEntry>();
            try {
                String fileName = jFileChooser.getSelectedFile().getPath();
                boolean isOWfile = false;
                if (fileName.endsWith("txt") || fileName.endsWith("TXT")) {
                    isOWfile = true;
                }
                BufferedReader in = new BufferedReader(new FileReader(fileName));
                String buff = in.readLine();
                buff = in.readLine();
                while (buff != null) {
                    LithTrnEntry lith = isOWfile ? this.readOWline(buff) : this.readCSVline(buff);
                    if (lith != null) {
                        liths.add(lith);
                    }
                    buff = in.readLine();
                }
                in.close();
            }
            catch (Exception eio) {
                JOptionPane.showMessageDialog(null, "Problem reading file: " + eio.getMessage(), this.getTitle(), 2);
                eio.printStackTrace();
            }
            if (liths.isEmpty()) {
                return;
            }
            LithTrnScheme newScheme = new LithTrnScheme(this.sbdb, liths);
            DialogLithTrnScheme dialog = new DialogLithTrnScheme((Dialog)this, true, this.sbdb, newScheme);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK) {
                try {
                    this.sbdb.getLithTrnSchemes().add(newScheme);
                }
                catch (Exception e) {
                    SB.showStackError((String)"Error adding translation scheme", (Exception)e);
                }
                this.initList();
            }
        }
    }

    LithTrnEntry readOWline(String buff) {
        LithTrnEntry lith = null;
        if (buff.indexOf(9) > 0) {
            String descr = buff.substring(0, buff.indexOf(9)).trim();
            String intString = buff.substring(buff.indexOf(9) + 1).trim();
            int trnID = intString.length() > 0 ? Integer.parseInt(intString) : 0;
            if (descr.length() > 0 && trnID != 0) {
                lith = new LithTrnEntry(trnID, descr, -1);
            }
        }
        return lith;
    }

    LithTrnEntry readCSVline(String buff) {
        LithTrnEntry lith = null;
        if (buff.indexOf(44) > 0) {
            String intString = buff.substring(0, buff.indexOf(44)).trim();
            int lithID = intString.length() > 0 ? Integer.parseInt(intString) : 0;
            buff = buff.substring(buff.indexOf(44) + 1);
            String descr = buff.substring(0, buff.indexOf(44));
            descr = descr.replaceAll("\"", "");
            buff = buff.substring(buff.indexOf(44) + 1);
            intString = buff.substring(0, buff.indexOf(44)).trim();
            int trnID = intString.length() > 0 ? Integer.parseInt(intString) : 0;
            String trnDescr = buff = buff.substring(buff.indexOf(44) + 1);
            trnDescr = trnDescr.replaceAll("\"", "");
            if (lithID != 0) {
                lith = new LithTrnEntry(trnID, trnDescr, lithID);
            }
        }
        return lith;
    }
}

