/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.LinkedList;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jsbugs.FloatRenderer;
import jsbugs.FrameJsbugs;
import model2.LithTrnEntry;
import model2.LithTrnScheme;
import model2.Lithdesc;
import model2.Lithology;
import model2.SBdb;
import util.ArrowCellRenderer;
import util.SB;
import util.SBException;
import util.TableSorter;

public class DialogLithTrnScheme
extends JDialog {
    TableModelLithTrnScheme model = new TableModelLithTrnScheme();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    SBdb sbdb;
    boolean isOK = false;
    private ButtonGroup buttonGroup1;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JRadioButton jRadioButtonCodes;
    private JRadioButton jRadioButtonDescr;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JTextField jTextFieldName;

    public DialogLithTrnScheme(Dialog parent, boolean modal, SBdb sbdb, LithTrnScheme scheme) {
        super(parent, modal);
        this.initComponents();
        this.sbdb = sbdb;
        this.init(scheme);
    }

    private void init(LithTrnScheme scheme) {
        if (scheme.toString() == null || scheme.toString().isEmpty()) {
            this.setTitle("Lithology Match Scheme : Add");
        } else {
            this.setTitle("Lithology Match Scheme : Edit : " + scheme.toString());
            this.jTextFieldName.setText(scheme.getName());
        }
        if (scheme.isUseCodes()) {
            this.jRadioButtonCodes.setSelected(true);
        } else {
            this.jRadioButtonDescr.setSelected(true);
        }
        this.getRootPane().setDefaultButton(this.jButtonOK);
        try {
            this.model.scheme = scheme;
            this.model.lithdesc = this.sbdb.getLithdesc();
            JComboBox combo = this.sbdb.getLithologyCombo(true);
            this.model.setupTable(this.jTable1, combo);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error: ", (Exception)((Object)sbe));
            sbe.printStackTrace();
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error: ", (SQLException)sql);
            sql.printStackTrace();
        }
        this.sorter.addMouseListenerToHeaderInTable(this.jTable1);
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jButtonAdd = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jRadioButtonCodes = new JRadioButton();
        this.jRadioButtonDescr = new JRadioButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(450, 400));
        this.jTable1.setModel((TableModel)this.sorter);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jLabel1.setText("Scheme name:");
        this.jTextFieldName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogLithTrnScheme.this.jTextFieldNameKeyTyped(evt);
            }
        });
        this.jButtonAdd.setText("Add");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogLithTrnScheme.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogLithTrnScheme.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogLithTrnScheme.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogLithTrnScheme.this.jButtonOKActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonCodes);
        this.jRadioButtonCodes.setText("Use numerical codes");
        this.jRadioButtonCodes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogLithTrnScheme.this.jRadioButtonCodesActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonDescr);
        this.jRadioButtonDescr.setText("Use descriptions");
        this.jRadioButtonDescr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogLithTrnScheme.this.jRadioButtonDescrActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogLithTrnScheme.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jRadioButtonCodes).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonDescr)).addComponent(this.jTextFieldName, -1, 302, Short.MAX_VALUE))).addComponent(this.jScrollPane1, -1, 376, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonCancel, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDelete, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonAdd, -1, -1, Short.MAX_VALUE)).addComponent(this.jButtonHelp, 0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK, -1, 65, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.jButtonAdd, this.jButtonCancel, this.jButtonDelete, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonCodes).addComponent(this.jRadioButtonDescr)).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonAdd).addGap(8, 8, 8).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 215, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jScrollPane1, -1, 350, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        this.model.scheme.addEntry(new LithTrnEntry(-1, "", -1), false);
        this.model.fireTableDataChanged();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String title = this.jTextFieldName.getText().trim();
        if (title.isEmpty()) {
            JOptionPane.showMessageDialog(this, "You must enter a name", this.getTitle(), 2);
            return;
        }
        this.model.scheme.setUseCodes(this.jRadioButtonCodes.isSelected());
        LinkedList<LithTrnEntry> empties = new LinkedList<LithTrnEntry>();
        for (LithTrnEntry entry : this.model.scheme.getEntries()) {
            if ((!this.model.scheme.isUseCodes() || entry.getCode() > 0) && (this.model.scheme.isUseCodes() || entry.getDescr() != null && !entry.getDescr().isEmpty())) continue;
            empties.add(entry);
        }
        for (LithTrnEntry empty : empties) {
            this.model.scheme.getEntries().remove(empty);
        }
        for (LithTrnEntry entry : this.model.scheme.getEntries()) {
            for (LithTrnEntry entry2 : this.model.scheme.getEntries()) {
                if (entry.equals(entry2) || (!this.model.scheme.isUseCodes() || entry.getCode() != entry2.getCode()) && (this.model.scheme.isUseCodes() || !entry.getDescr().equalsIgnoreCase(entry2.getDescr()))) continue;
                JOptionPane.showMessageDialog(this, "The scheme cannot contain duplicate entries", this.getTitle(), 2);
                this.sorter.fireTableDataChanged();
                return;
            }
        }
        for (LithTrnEntry entry : this.model.scheme.getEntries()) {
            if (entry.getSbugsCode() > 0) continue;
            JOptionPane.showMessageDialog(this, "All entries must be linked to a StrataBugs lithology", this.getTitle(), 2);
            return;
        }
        this.model.scheme.setName(title);
        this.model.scheme.setUseCodes(this.jRadioButtonCodes.isSelected());
        try {
            this.model.scheme.storeAll();
            this.sbdb.commit();
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error storing scheme: ", (SQLException)sql);
            sql.printStackTrace();
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error storing scheme: ", (Exception)((Object)sbe));
            sbe.printStackTrace();
        }
        this.isOK = true;
        this.dispose();
    }

    private void jTextFieldNameKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldName, (int)80, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jRadioButtonCodesActionPerformed(ActionEvent evt) {
        this.setUseCodes(true);
    }

    private void jRadioButtonDescrActionPerformed(ActionEvent evt) {
        this.setUseCodes(false);
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        int[] selection;
        if (this.jTable1.getSelectedRowCount() < 1) {
            JOptionPane.showMessageDialog(this, "Select one or more rows", this.getTitle(), 2);
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "Really delete these rows?", this.getTitle(), 2) != 0) {
            return;
        }
        for (int i : selection = this.jTable1.getSelectedRows()) {
            LithTrnEntry entry = (LithTrnEntry)this.model.scheme.getEntries().get(this.sorter.getIndexOf(i));
            this.model.scheme.getEntries().remove(entry);
        }
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("organiser_lithimport.html");
    }

    private void setUseCodes(boolean useCodes) {
        if (this.model.scheme.isUseCodes() == useCodes) {
            return;
        }
        this.model.scheme.setUseCodes(useCodes);
        this.jTable1.getColumnModel().getColumn(0).setHeaderValue(useCodes ? "Code" : "Description");
        this.sorter.fireTableDataChanged();
    }

    class TableModelLithTrnScheme
    extends AbstractTableModel {
        static final int COL_DONOR = 0;
        static final int COL_ARROW = 1;
        static final int COL_HOST_ID = 2;
        static final int COL_HOST_DESC = 3;
        final int[] colWidths = new int[]{50, 16, 20, 80};
        final String[] colTitles = new String[]{"Description", "", "StrataBugs ID", "StrataBugs Description"};
        boolean modelDirty = false;
        LithTrnScheme scheme = null;
        Lithdesc lithdesc;

        TableModelLithTrnScheme() {
        }

        @Override
        public int getColumnCount() {
            return this.colTitles.length;
        }

        @Override
        public int getRowCount() {
            if (this.scheme != null) {
                return this.scheme.getEntries().size();
            }
            return 0;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.scheme == null) {
                return null;
            }
            LithTrnEntry lith = (LithTrnEntry)this.scheme.getEntries().get(row);
            switch (col) {
                case 0: {
                    if (this.scheme.isUseCodes()) {
                        if (lith.getCode() > 0) {
                            return "" + lith.getCode();
                        }
                    } else {
                        return lith.getDescr();
                    }
                    return null;
                }
                case 1: {
                    return lith.getSbugsCode() > 0;
                }
                case 2: {
                    if (lith.getSbugsCode() > 0) {
                        return "" + lith.getSbugsCode();
                    }
                    return "";
                }
                case 3: {
                    if (lith.getSbugsCode() > 0 && this.lithdesc != null) {
                        return this.lithdesc.getLithology(lith.getSbugsCode()).toString();
                    }
                    return null;
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            this.modelDirty = true;
            LithTrnEntry lith = (LithTrnEntry)this.scheme.getEntries().get(row);
            switch (col) {
                case 3: {
                    Lithology lithology = this.lithdesc.getLithologyFromDescription(obj.toString());
                    if (lith == null) break;
                    lith.setSbugsCode(lithology.getLithID());
                    break;
                }
                case 0: {
                    if (this.scheme.isUseCodes()) {
                        int code = -1;
                        code = obj == null || obj.toString().length() == 0 ? -1 : Integer.parseInt(obj.toString());
                        lith.setCode(code);
                        break;
                    }
                    String descr = obj.toString();
                    lith.setDescr(obj.toString());
                    break;
                }
            }
        }

        public Class getColumnClass(int col) {
            switch (col) {
                case 0: {
                    if (this.scheme.isUseCodes()) {
                        return Integer.class;
                    }
                    return String.class;
                }
                case 2: 
                case 3: {
                    return String.class;
                }
                case 1: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 0: 
                case 3: {
                    return true;
                }
            }
            return false;
        }

        public void setupTable(JTable table, JComboBox combo) {
            SB.setTableHeaderBold((JTable)table);
            TableColumnModel columnModel = table.getTableHeader().getColumnModel();
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (i == 0) {
                    columnModel.getColumn(i).setHeaderValue(this.scheme.isUseCodes() ? "Code" : "Description");
                } else {
                    columnModel.getColumn(i).setHeaderValue(this.colTitles[i]);
                }
                columnModel.getColumn(i).setPreferredWidth(this.colWidths[i]);
            }
            columnModel.getColumn(1).setMaxWidth(this.colWidths[1]);
            columnModel.getColumn(3).setCellEditor(new DefaultCellEditor(combo));
            table.setDefaultRenderer(Integer.class, new FloatRenderer(Color.WHITE));
            table.setDefaultRenderer(Boolean.class, (TableCellRenderer)new ArrowCellRenderer());
            table.getTableHeader().setReorderingAllowed(false);
        }
    }
}

