/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelLithdesc;
import model2.Lithology;
import model2.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.SbugsTable;
import util.TableSorter;

public class DialogLithdesc
extends JDialog {
    TableModelLithdesc model = new TableModelLithdesc();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    SBdb db;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    public DialogLithdesc(Frame parent, boolean modal, SBdb db) throws SQLException, SBException {
        super(parent, modal);
        this.initComponents();
        this.db = db;
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Lithologies");
        this.model.setupTable(this.jTable1);
        this.model.lithdesc = this.db.getLithdesc();
        this.model.list = this.db.getLithdesc().getBase();
        this.sorter.addMouseListenerToHeaderInTable(this.jTable1);
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new SbugsTable(this.sorter);
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 400));
        this.jTable1.setModel((TableModel)this.sorter);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogLithdesc.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogLithdesc.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogLithdesc.this.jButtonOKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 478, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane1, -1, 594, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialoglithdesc.html");
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            HashSet<Integer> sorts = new HashSet<Integer>();
            for (Lithology lith : this.model.list) {
                if (lith.getSortOrder() <= 0 || sorts.add(lith.getSortOrder())) continue;
                JOptionPane.showMessageDialog(this, "List contains duplicate sort order entries", this.getTitle(), 1);
                return;
            }
            for (Lithology lith : this.model.list) {
                Lithology dbLith = this.db.getLithdesc().getLithology(lith.getLithID());
                if ((dbLith == null || !((double)Math.abs(lith.getGrainSize() - dbLith.getGrainSize()) > 1.0E-4) && lith.getSortOrder() == dbLith.getSortOrder() && lith.getDescr().equals(dbLith.getDescr())) && (lith.getAbr() == null || lith.getAbr().equals(dbLith.getAbr()))) continue;
                dbLith.update(lith);
            }
            this.db.getDatabase().commit();
            this.dispose();
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
            this.db.doRollback();
        }
    }
}

