/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import jsbugs.FrameJsbugs;
import jsbugs.LogSymbolRenderer;
import jsbugs.PanelWirelineLog;
import jsbugs.SBDialog;
import jsbugs.SBGraphics;
import model2.LogDef;
import model2.SBdb;
import util.SB;
import util.SBException;

public class DialogLogDef
extends SBDialog {
    private final SBdb db;
    private final DefaultComboBoxModel penModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel traceModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel symbolModel = new DefaultComboBoxModel();
    boolean inStartup = true;
    LogDef def;
    private ButtonGroup buttonGroupScale;
    private JButton jButtonCancel;
    private JButton jButtonFillCol;
    private JButton jButtonHelp;
    private JButton jButtonLineCol;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxWrap;
    private JComboBox jComboBoxPenStyle;
    private JComboBox jComboBoxSymbol;
    private JComboBox jComboBoxTraceStyle;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JRadioButton jRadioButtonLinear;
    private JRadioButton jRadioButtonLog;
    private JSpinner jSpinnerPenWidth;
    private JTextField jTextFieldAbr;
    private JTextField jTextFieldFillCol;
    private JTextField jTextFieldLineCol;
    private JTextField jTextFieldMaxVal;
    private JTextField jTextFieldMinVal;
    private JTextField jTextFieldTitle;
    private JTextField jTextFieldUnits;

    public DialogLogDef(Dialog parent, boolean modal, LogDef def, SBdb db) {
        super(parent, modal);
        this.def = def;
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.initPenStyleCombo();
        this.initTraceStyleCombo();
        this.initSymbolCombo();
        this.getRootPane().setDefaultButton(this.jButtonOK);
        if (this.def == null) {
            this.jTextFieldAbr.setEditable(true);
            this.setTitle("Add Log Header");
            return;
        }
        this.setTitle((this.db == null ? "Trace Properties : " : "Edit Log Header : ") + this.def.getAbr());
        this.jTextFieldAbr.setText(this.def.getAbr());
        this.jTextFieldAbr.setEditable(false);
        this.jTextFieldTitle.setText(this.def.getTitle());
        this.jTextFieldUnits.setText(this.def.getUnits());
        this.jTextFieldMinVal.setText("" + this.def.getMinval());
        this.jTextFieldMaxVal.setText("" + this.def.getMaxval());
        this.jRadioButtonLog.setSelected(this.def.isAsLog());
        this.jRadioButtonLinear.setSelected(!this.def.isAsLog());
        this.jTextFieldLineCol.setBackground(this.def.getLineColour());
        this.jTextFieldFillCol.setBackground(this.def.getBackColour());
        this.jSpinnerPenWidth.setValue(Float.valueOf(this.def.getPenWidth()));
        this.jCheckBoxWrap.setSelected(this.def.getWrapTrace());
        this.enableSymbols();
        this.inStartup = false;
    }

    private void initPenStyleCombo() {
        this.penModel.removeAllElements();
        for (String strg : LogDef.penStyles) {
            this.penModel.addElement(strg);
        }
        if (this.def != null) {
            this.jComboBoxPenStyle.setSelectedIndex(this.def.getPenStyle());
        }
    }

    private void initTraceStyleCombo() {
        this.traceModel.removeAllElements();
        for (String strg : LogDef.traceStyles) {
            this.traceModel.addElement(strg);
        }
        if (this.def != null) {
            this.jComboBoxTraceStyle.setSelectedIndex(this.def.getTraceStyle());
        }
    }

    private void initSymbolCombo() {
        ImageIcon[] images = new ImageIcon[LogDef.symbols.length];
        float symbolSize = 5.0f;
        int width = (int)(symbolSize * 2.0f);
        int height = (int)((double)this.jComboBoxSymbol.getHeight() * 0.85);
        for (int i = 0; i < LogDef.symbols.length; ++i) {
            ImageIcon icon;
            BufferedImage bufferedImage = new BufferedImage(width, height, 1);
            Graphics2D g = bufferedImage.createGraphics();
            AffineTransform tnf = new AffineTransform();
            tnf.scale(0.01f, 0.01f);
            g.transform(tnf);
            SBGraphics sbg = new SBGraphics(g, null, true, true);
            sbg.setStroke(1.0f);
            sbg.setColor(Color.WHITE);
            sbg.fillRect(0.0f, 0.0f, width, height);
            sbg.setColor(Color.BLACK);
            PanelWirelineLog.drawSymbol(sbg, width / 2, height / 2, i, symbolSize);
            images[i] = icon = new ImageIcon(bufferedImage);
            if (images[i] == null) continue;
            images[i].setDescription(LogDef.symbols[i]);
        }
        LogSymbolRenderer renderer = new LogSymbolRenderer(images);
        this.jComboBoxSymbol.setRenderer(renderer);
        this.symbolModel.removeAllElements();
        for (int i = 0; i < LogDef.symbols.length; ++i) {
            this.symbolModel.addElement(i);
        }
        if (this.def != null) {
            this.jComboBoxSymbol.setSelectedIndex(this.def.getSymbol());
        }
    }

    private void initComponents() {
        this.buttonGroupScale = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jTextFieldLineCol = new JTextField();
        this.jButtonLineCol = new JButton();
        this.jLabel7 = new JLabel();
        this.jComboBoxPenStyle = new JComboBox();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jComboBoxTraceStyle = new JComboBox();
        this.jCheckBoxWrap = new JCheckBox();
        this.jTextFieldFillCol = new JTextField();
        this.jButtonFillCol = new JButton();
        this.jLabel10 = new JLabel();
        this.jSpinnerPenWidth = new JSpinner();
        this.jComboBoxSymbol = new JComboBox();
        this.jPanel2 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jTextFieldMinVal = new JTextField();
        this.jTextFieldMaxVal = new JTextField();
        this.jRadioButtonLinear = new JRadioButton();
        this.jRadioButtonLog = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.jTextFieldTitle = new JTextField();
        this.jTextFieldUnits = new JTextField();
        this.jTextFieldAbr = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Style", 0, 0, null, new Color(51, 102, 204)));
        this.jLabel6.setText("Line colour:");
        this.jTextFieldLineCol.setEditable(false);
        this.jButtonLineCol.setText("...");
        this.jButtonLineCol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogLogDef.this.jButtonLineColActionPerformed(evt);
            }
        });
        this.jLabel7.setText("Pen style:");
        this.jComboBoxPenStyle.setModel(this.penModel);
        this.jLabel8.setText("Pen width:");
        this.jLabel9.setText("Trace style:");
        this.jComboBoxTraceStyle.setModel(this.traceModel);
        this.jComboBoxTraceStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogLogDef.this.jComboBoxTraceStyleActionPerformed(evt);
            }
        });
        this.jCheckBoxWrap.setText("Wrap trace");
        this.jTextFieldFillCol.setEditable(false);
        this.jButtonFillCol.setText("...");
        this.jButtonFillCol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogLogDef.this.jButtonFillColActionPerformed(evt);
            }
        });
        this.jLabel10.setText("Fill colour:");
        this.jSpinnerPenWidth.setModel(new SpinnerNumberModel(Float.valueOf(0.1f), Float.valueOf(0.1f), Float.valueOf(1.0f), Float.valueOf(0.1f)));
        this.jComboBoxSymbol.setModel(this.symbolModel);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel8).addComponent(this.jLabel9).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxPenStyle, 0, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxWrap).addComponent(this.jSpinnerPenWidth, GroupLayout.Alignment.TRAILING).addComponent(this.jComboBoxTraceStyle, -2, 89, -2)).addGap(8, 8, 8).addComponent(this.jComboBoxSymbol, -2, 44, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel6).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldLineCol, -2, 48, -2).addComponent(this.jTextFieldFillCol, GroupLayout.Alignment.TRAILING, -2, 48, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonLineCol, 0, 1, Short.MAX_VALUE).addComponent(this.jButtonFillCol, -2, 27, Short.MAX_VALUE)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldLineCol, -2, -1, -2).addComponent(this.jLabel6).addComponent(this.jButtonLineCol)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldFillCol, -2, -1, -2).addComponent(this.jButtonFillCol).addComponent(this.jLabel10)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxPenStyle, -2, -1, -2).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.jSpinnerPenWidth, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.jComboBoxTraceStyle, -2, -1, -2).addComponent(this.jComboBoxSymbol, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxWrap).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Scaling", 0, 0, null, new Color(51, 102, 204)));
        this.jLabel4.setText("Minimum:");
        this.jLabel5.setText("Maximum:");
        this.jTextFieldMinVal.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogLogDef.this.jTextFieldMinValKeyTyped(evt);
            }
        });
        this.jTextFieldMaxVal.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogLogDef.this.jTextFieldMaxValKeyTyped(evt);
            }
        });
        this.buttonGroupScale.add(this.jRadioButtonLinear);
        this.jRadioButtonLinear.setText("Linear");
        this.buttonGroupScale.add(this.jRadioButtonLog);
        this.jRadioButtonLog.setText("Logarithmic");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldMinVal, -2, 64, -2).addComponent(this.jTextFieldMaxVal, -2, 64, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonLinear).addComponent(this.jRadioButtonLog))));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(5, 5, 5).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jTextFieldMinVal, -2, -1, -2).addComponent(this.jRadioButtonLinear)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jTextFieldMaxVal, -2, -1, -2).addComponent(this.jRadioButtonLog)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Caption", 0, 0, null, new Color(51, 102, 204)));
        this.jTextFieldTitle.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogLogDef.this.jTextFieldTitleKeyTyped(evt);
            }
        });
        this.jTextFieldUnits.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogLogDef.this.jTextFieldUnitsKeyTyped(evt);
            }
        });
        this.jTextFieldAbr.setEditable(false);
        this.jTextFieldAbr.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogLogDef.this.jTextFieldAbrKeyTyped(evt);
            }
        });
        this.jLabel1.setText("Abr:");
        this.jLabel2.setText("Title:");
        this.jLabel3.setText("Units:");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldAbr, -2, 82, -2).addComponent(this.jTextFieldUnits, -2, 68, -2).addComponent(this.jTextFieldTitle, -1, 168, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldAbr, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldTitle, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldUnits, -2, -1, -2).addComponent(this.jLabel3)).addContainerGap(13, Short.MAX_VALUE)));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogLogDef.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogLogDef.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogLogDef.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, 0, 232, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonHelp).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonLineColActionPerformed(ActionEvent evt) {
        Color colour = this.jTextFieldLineCol.getBackground();
        if ((colour = JColorChooser.showDialog(this, "Line Colour", colour)) != null) {
            this.jTextFieldLineCol.setBackground(colour);
        }
    }

    private void jButtonFillColActionPerformed(ActionEvent evt) {
        Color colour = this.jTextFieldFillCol.getBackground();
        if ((colour = JColorChooser.showDialog(this, "Fill Colour", colour)) != null) {
            this.jTextFieldFillCol.setBackground(colour);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.buttonGroupScale.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "No scale selection made", this.getTitle(), 2);
            return;
        }
        String abr = this.jTextFieldAbr.getText().trim().toUpperCase();
        if (abr.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Enter an abbreviation", this.getTitle(), 2);
            this.jTextFieldAbr.requestFocusInWindow();
            return;
        }
        String title = this.jTextFieldTitle.getText().trim();
        if (title.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Enter a title", this.getTitle(), 2);
            this.jTextFieldTitle.requestFocusInWindow();
            return;
        }
        String units = this.jTextFieldUnits.getText().trim();
        if (units.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Enter units", this.getTitle(), 2);
            this.jTextFieldUnits.requestFocusInWindow();
            return;
        }
        String minValText = this.jTextFieldMinVal.getText().trim();
        if (minValText.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Enter a minimum value", this.getTitle(), 2);
            this.jTextFieldMinVal.requestFocusInWindow();
            return;
        }
        float minval = Float.parseFloat(this.jTextFieldMinVal.getText().trim());
        String maxValText = this.jTextFieldMaxVal.getText().trim();
        if (maxValText.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Enter a maximum value", this.getTitle(), 2);
            this.jTextFieldMaxVal.requestFocusInWindow();
            return;
        }
        float maxval = Float.parseFloat(this.jTextFieldMaxVal.getText().trim());
        boolean asLog = this.jRadioButtonLog.isSelected();
        Color backColour = this.jTextFieldFillCol.getBackground();
        Color lineColour = this.jTextFieldLineCol.getBackground();
        if (asLog && minval == 0.0f) {
            JOptionPane.showMessageDialog(this, "The scale minimum cannot be 0 in logarithmic scaling", this.getTitle(), 2);
            this.jTextFieldMinVal.requestFocusInWindow();
            return;
        }
        if (asLog && minval > maxval) {
            JOptionPane.showMessageDialog(this, "<html>The scale minimum must be smaller than the scale<br> maximum in logarithmic scaling</html>", this.getTitle(), 2);
            this.jTextFieldMinVal.requestFocusInWindow();
            return;
        }
        int penStyle = this.jComboBoxPenStyle.getSelectedIndex();
        int traceStyle = this.jComboBoxTraceStyle.getSelectedIndex();
        int symbol = this.jComboBoxSymbol.getSelectedIndex();
        float penWidth = ((Float)this.jSpinnerPenWidth.getValue()).floatValue();
        boolean wrapTrace = this.jCheckBoxWrap.isSelected();
        try {
            if (this.def != null) {
                if (this.db != null) {
                    this.db.updateLogDef(this.def, abr, title, units, minval, maxval, asLog, backColour, lineColour, penStyle, traceStyle, penWidth, wrapTrace, symbol);
                } else {
                    this.def.update(title, units, minval, maxval, asLog, backColour, lineColour, penStyle, traceStyle, penWidth, wrapTrace, symbol);
                }
            } else {
                this.def = this.db.addLogDef(abr, title, units, minval, maxval, asLog, backColour, lineColour, penStyle, traceStyle, penWidth, wrapTrace, symbol);
            }
            if (this.db != null) {
                this.db.commit();
            }
            this.setOK();
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            this.db.doRollback();
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jTextFieldTitleKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldTitle, (int)30, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldUnitsKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldUnits, (int)10, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldMinValKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldMinVal, (int)10, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldMaxValKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldMaxVal, (int)10, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialoglogdef.html");
    }

    private void jComboBoxTraceStyleActionPerformed(ActionEvent evt) {
        if (this.inStartup) {
            return;
        }
        this.enableSymbols();
    }

    private void jTextFieldAbrKeyTyped(KeyEvent evt) {
        if (SB.uCaseField((JTextField)this.jTextFieldAbr, (int)10, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void enableSymbols() {
        int traceStyle = this.jComboBoxTraceStyle.getSelectedIndex();
        if (traceStyle == 3 || traceStyle == 4) {
            this.jComboBoxSymbol.setEnabled(true);
        } else {
            this.jComboBoxSymbol.setEnabled(false);
        }
    }
}

