/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.sql.SQLException;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsbugs.LoggingSheetCodes;
import model2.Lastval;
import model2.SBdb;
import util.SB;
import util.SBException;

public class DialogLoggingSheetCodesProperties
extends JDialog {
    LoggingSheetCodes logSheet;
    SBdb sbdb;
    PageFormat pf;
    private ButtonGroup buttonGroupSort;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxCat;
    private JCheckBox jCheckBoxGenAbr;
    private JCheckBox jCheckBoxSubHeadings;
    private JCheckBox jCheckBoxTotalsCol;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabelNPages;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonSortCategory;
    private JRadioButton jRadioButtonSortCode;
    private JRadioButton jRadioButtonSortGenus;
    private JRadioButton jRadioButtonSortSpecies;
    private JSeparator jSeparator1;
    private JSpinner jSpinnerCols;
    private JSpinner jSpinnerFont;

    public DialogLoggingSheetCodesProperties(Dialog parent, boolean modal, LoggingSheetCodes logSheet, SBdb sbdb, PageFormat pf) {
        super(parent, modal);
        this.initComponents();
        this.sbdb = sbdb;
        this.logSheet = logSheet;
        this.pf = pf;
        this.init();
    }

    private void init() {
        this.setTitle("Properties");
        this.jCheckBoxGenAbr.setSelected(this.logSheet.abbreviateGenus);
        this.jCheckBoxCat.setSelected(this.logSheet.includeCat);
        this.jCheckBoxSubHeadings.setSelected(this.logSheet.subHeadings);
        this.jCheckBoxTotalsCol.setSelected(this.logSheet.totalsCol);
        switch (this.logSheet.sortOrder) {
            case 2: {
                this.jRadioButtonSortGenus.setSelected(true);
                break;
            }
            case 3: {
                this.jRadioButtonSortSpecies.setSelected(true);
                break;
            }
            case 0: {
                this.jRadioButtonSortCode.setSelected(true);
                break;
            }
            default: {
                this.jRadioButtonSortCategory.setSelected(true);
            }
        }
        this.jSpinnerFont.setValue(this.logSheet.getFontSize());
        this.jSpinnerCols.setValue(this.logSheet.nColumns);
        this.setPagesLabel(new LinkedList<LinkedList<Object>>());
    }

    private void initComponents() {
        this.buttonGroupSort = new ButtonGroup();
        this.jCheckBoxGenAbr = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jRadioButtonSortCategory = new JRadioButton();
        this.jRadioButtonSortCode = new JRadioButton();
        this.jRadioButtonSortGenus = new JRadioButton();
        this.jRadioButtonSortSpecies = new JRadioButton();
        this.jCheckBoxCat = new JCheckBox();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jLabel1 = new JLabel();
        this.jSpinnerFont = new JSpinner();
        this.jLabel2 = new JLabel();
        this.jSpinnerCols = new JSpinner();
        this.jLabelNPages = new JLabel();
        this.jCheckBoxSubHeadings = new JCheckBox();
        this.jCheckBoxTotalsCol = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jCheckBoxGenAbr.setText("Abbreviate genus");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Sort by", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupSort.add(this.jRadioButtonSortCategory);
        this.jRadioButtonSortCategory.setText("Category");
        this.buttonGroupSort.add(this.jRadioButtonSortCode);
        this.jRadioButtonSortCode.setText("Code");
        this.buttonGroupSort.add(this.jRadioButtonSortGenus);
        this.jRadioButtonSortGenus.setText("Genus");
        this.buttonGroupSort.add(this.jRadioButtonSortSpecies);
        this.jRadioButtonSortSpecies.setText("Species");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonSortCategory).addComponent(this.jRadioButtonSortGenus).addComponent(this.jRadioButtonSortSpecies).addComponent(this.jRadioButtonSortCode)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButtonSortCode).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonSortCategory).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonSortGenus).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonSortSpecies).addContainerGap(-1, Short.MAX_VALUE)));
        this.jCheckBoxCat.setText("Include category");
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogLoggingSheetCodesProperties.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogLoggingSheetCodesProperties.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Font size:");
        this.jSpinnerFont.setModel(new SpinnerNumberModel(10, 6, 24, 1));
        this.jSpinnerFont.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DialogLoggingSheetCodesProperties.this.jSpinnerFontStateChanged(evt);
            }
        });
        this.jLabel2.setText("Columns:");
        this.jSpinnerCols.setModel(new SpinnerNumberModel(3, 1, 4, 1));
        this.jSpinnerCols.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DialogLoggingSheetCodesProperties.this.jSpinnerColsStateChanged(evt);
            }
        });
        this.jLabelNPages.setText("Number of pages:");
        this.jCheckBoxSubHeadings.setText("Sub-headings");
        this.jCheckBoxSubHeadings.setToolTipText("Group names if printing a set; category name if sorted by category");
        this.jCheckBoxTotalsCol.setText("Totals column");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxTotalsCol).addComponent(this.jCheckBoxSubHeadings).addComponent(this.jLabelNPages).addComponent(this.jCheckBoxGenAbr).addComponent(this.jCheckBoxCat).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSpinnerFont, -1, 48, Short.MAX_VALUE).addComponent(this.jSpinnerCols)))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxGenAbr).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxCat).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jSpinnerFont, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinnerCols, -2, -1, -2).addComponent(this.jLabel2)).addGap(18, 18, 18).addComponent(this.jLabelNPages).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxSubHeadings).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxTotalsCol).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOK).addComponent(this.jButtonCancel)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.logSheet.abbreviateGenus = this.jCheckBoxGenAbr.isSelected();
        this.logSheet.includeCat = this.jCheckBoxCat.isSelected();
        this.logSheet.setFontSize((Integer)this.jSpinnerFont.getValue());
        this.logSheet.nColumns = (Integer)this.jSpinnerCols.getValue();
        this.logSheet.sortOrder = this.getSort();
        this.logSheet.subHeadings = this.jCheckBoxSubHeadings.isSelected();
        this.logSheet.totalsCol = this.jCheckBoxTotalsCol.isSelected();
        try {
            this.logSheet.initMaster(this.sbdb);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
        this.logSheet.pages = new LinkedList();
        this.setPagesLabel(this.logSheet.pages);
        this.encode();
        this.dispose();
    }

    private int getSort() {
        if (this.jRadioButtonSortCategory.isSelected()) {
            return 1;
        }
        if (this.jRadioButtonSortGenus.isSelected()) {
            return 2;
        }
        if (this.jRadioButtonSortCode.isSelected()) {
            return 0;
        }
        return 3;
    }

    private void jSpinnerFontStateChanged(ChangeEvent evt) {
        this.setPagesLabel(new LinkedList<LinkedList<Object>>());
    }

    private void jSpinnerColsStateChanged(ChangeEvent evt) {
        this.setPagesLabel(new LinkedList<LinkedList<Object>>());
    }

    private void encode() {
        String string = new String();
        String[] props = new String[]{"" + (this.jCheckBoxGenAbr.isSelected() ? 1 : 0), "" + (this.jCheckBoxCat.isSelected() ? 1 : 0), "" + this.getSort(), "" + (Integer)this.jSpinnerFont.getValue(), "" + (Integer)this.jSpinnerCols.getValue(), "" + (this.jCheckBoxSubHeadings.isSelected() ? 1 : 0), "" + (this.jCheckBoxTotalsCol.isSelected() ? 1 : 0)};
        for (String prop : props) {
            string = string + prop + "|";
        }
        try {
            Lastval.putString((SBdb)this.sbdb, (String)"LOGSHTCODE", (String)string);
            this.sbdb.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setPagesLabel(LinkedList<LinkedList<Object>> pages) {
        int nCols = (Integer)this.jSpinnerCols.getValue();
        int fontSize = (Integer)this.jSpinnerFont.getValue();
        int pageHeight = (int)(this.pf.getImageableHeight() / this.logSheet.scale);
        int pageWidth = (int)(this.pf.getImageableWidth() / this.logSheet.scale);
        int nPages = this.logSheet.getnPages(pageHeight, pageWidth, fontSize, nCols, pages);
        this.jLabelNPages.setText("Number of pages: " + nPages);
    }
}

