/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.FrameJsbugs;
import model2.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;

public class DialogManageImages
extends JDialog {
    SBdb db;
    int nFile = 0;
    int nDatabase = 0;
    private ButtonGroup buttonGroup1;
    private JButton jButtonClearExternal;
    private JButton jButtonClose;
    private JButton jButtonHelp;
    private JButton jButtonSelectExternal;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JProgressBar jProgressBar1;
    private JRadioButton jRadioButtonDatabase;
    private JRadioButton jRadioButtonFiles;
    private JSeparator jSeparator1;
    private JTextField jTextFieldExternal;
    private JTextField jTextFieldFiles;
    private JTextField jTextFieldStored;

    public DialogManageImages(Frame parent, boolean modal, SBdb db) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.setTitle("Image Storage Options");
        this.setCounts();
        if (this.db.storeImage()) {
            this.jRadioButtonDatabase.setSelected(true);
        } else {
            this.jRadioButtonFiles.setSelected(true);
        }
        this.getRootPane().setDefaultButton(this.jButtonClose);
        if (this.db.getImageFolder() != null) {
            this.jTextFieldExternal.setText(this.db.getImageFolder());
        }
    }

    private void setCounts() throws SQLException {
        this.nFile = this.db.getImageCount(false);
        this.nDatabase = this.db.getImageCount(true);
        this.jTextFieldFiles.setText("" + this.nFile);
        this.jTextFieldStored.setText("" + this.nDatabase);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jTextFieldStored = new JTextField();
        this.jLabel1 = new JLabel();
        this.jTextFieldFiles = new JTextField();
        this.jPanel2 = new JPanel();
        this.jRadioButtonFiles = new JRadioButton();
        this.jRadioButtonDatabase = new JRadioButton();
        this.jProgressBar1 = new JProgressBar();
        this.jButtonClose = new JButton();
        this.jLabel3 = new JLabel();
        this.jButtonHelp = new JButton();
        this.jPanel3 = new JPanel();
        this.jTextFieldExternal = new JTextField();
        this.jButtonSelectExternal = new JButton();
        this.jButtonClearExternal = new JButton();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Number of images", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jLabel2.setHorizontalAlignment(11);
        this.jLabel2.setText("Stored in database:");
        this.jTextFieldStored.setEditable(false);
        this.jTextFieldStored.setText("jTextField1");
        this.jLabel1.setHorizontalAlignment(11);
        this.jLabel1.setText("Linked to files:");
        this.jTextFieldFiles.setEditable(false);
        this.jTextFieldFiles.setText("jTextField1");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((Component)this.jLabel2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jTextFieldFiles).add((Component)this.jTextFieldStored)).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldFiles, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jTextFieldStored, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Storage option", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroup1.add(this.jRadioButtonFiles);
        this.jRadioButtonFiles.setText("Link images to source files but do not store");
        this.jRadioButtonFiles.setToolTipText("Reduces database file size");
        this.jRadioButtonFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogManageImages.this.jRadioButtonFilesActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonDatabase);
        this.jRadioButtonDatabase.setText("Store images in database");
        this.jRadioButtonDatabase.setToolTipText("Reduces dependencies but increases database size");
        this.jRadioButtonDatabase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogManageImages.this.jRadioButtonDatabaseActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jRadioButtonFiles).add((Component)this.jRadioButtonDatabase)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jRadioButtonFiles).addPreferredGap(0).add((Component)this.jRadioButtonDatabase)));
        this.jProgressBar1.setEnabled(false);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogManageImages.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jLabel3.setText("<html>Warning: changes to these preferences are system-wide, <br> affecting other users - but only once they have <br>\nrestarted the session, not if they are currently logged on.");
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogManageImages.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "External folder", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jTextFieldExternal.setBackground(new Color(255, 255, 204));
        this.jTextFieldExternal.setEditable(false);
        this.jTextFieldExternal.setToolTipText("Folder containing \"type\" images, where the filename is prefixed with the species name followed by an underscore");
        this.jButtonSelectExternal.setText("...");
        this.jButtonSelectExternal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogManageImages.this.jButtonSelectExternalActionPerformed(evt);
            }
        });
        this.jButtonClearExternal.setText("Clear");
        this.jButtonClearExternal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogManageImages.this.jButtonClearExternalActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jTextFieldExternal).add(2, (GroupLayout.Group)jPanel3Layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jButtonClearExternal).addPreferredGap(0).add((Component)this.jButtonSelectExternal, -2, 30, -2))).addContainerGap()));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.jTextFieldExternal, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jButtonSelectExternal).add((Component)this.jButtonClearExternal)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jProgressBar1, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonClose)).add((Component)this.jLabel3, -1, 280, Short.MAX_VALUE).add(2, (Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add((Component)this.jSeparator1)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonClose, this.jButtonHelp}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, 81, -2).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel3, -2, 53, -2).addPreferredGap(0).add((Component)this.jProgressBar1, -2, 21, -2).add(27, 27, 27).add((Component)this.jPanel3, -2, -1, -2).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonClose).add((Component)this.jButtonHelp)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jRadioButtonFilesActionPerformed(ActionEvent evt) {
        if (this.nDatabase > 0) {
            if (JOptionPane.showConfirmDialog(this, "Export all images to files?", this.getTitle(), 0, 3) != 0) {
                return;
            }
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(1);
            if (fileChooser.showOpenDialog(this) == 0) {
                File folder = fileChooser.getSelectedFile();
                try {
                    if (!folder.exists()) {
                        int opt = JOptionPane.showConfirmDialog(this, "Folder doesn't exist. Create it?", this.getTitle(), 0, 3);
                        if (opt != 0) {
                            return;
                        }
                        if (!folder.mkdir()) {
                            throw new SBException("Cannot make folder: " + folder);
                        }
                    }
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.db.exportImages(folder);
                    this.db.commit();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, e.toString(), this.getTitle(), 0);
                    e.printStackTrace();
                    this.db.doRollback();
                }
                finally {
                    this.setCursor(Cursor.getDefaultCursor());
                }
            }
            try {
                this.setCounts();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.db.setStoreImage(false);
            this.db.commit();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jRadioButtonDatabaseActionPerformed(ActionEvent evt) {
        if (this.nDatabase < this.nDatabase + this.nFile) {
            if (JOptionPane.showConfirmDialog(this, "Import all images from file references?", this.getTitle(), 0, 3) != 0) {
                return;
            }
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.db.importImages();
                this.db.commit();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 0);
                e.printStackTrace();
                this.db.doRollback();
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
            try {
                this.setCounts();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            this.db.setStoreImage(true);
            this.db.commit();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("control_panel.html#imagestorage");
    }

    private void jButtonSelectExternalActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        if (fileChooser.showOpenDialog(this) == 0) {
            File folder = fileChooser.getSelectedFile();
            try {
                if (!folder.exists()) {
                    int opt = JOptionPane.showConfirmDialog(this, "Folder doesn't exist. Create it?", this.getTitle(), 0, 3);
                    if (opt != 0) {
                        return;
                    }
                    if (!folder.mkdir()) {
                        throw new SBException("Cannot make folder: " + folder);
                    }
                }
                this.db.putDatabasePref("imagefolder", folder.getPath());
                this.db.setImageFolder(folder.getPath());
                this.db.commit();
                this.jTextFieldExternal.setText(folder.getPath());
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error", (Exception)((Object)sbe));
            }
            catch (SQLException sql) {
                SB.showStackError((String)"SQL Error", (SQLException)sql);
            }
        }
    }

    private void jButtonClearExternalActionPerformed(ActionEvent evt) {
        try {
            this.db.putDatabasePref("imagefolder", "");
            this.db.setImageFolder(null);
            this.db.commit();
            this.jTextFieldExternal.setText("");
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
    }
}

