/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import jsbugs.DialogSeismicMarker;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelMarkers;
import model2.SeismicMarker;
import model2.Well;
import org.jdesktop.layout.GroupLayout;
import util.ColorRenderer;
import util.SB;
import util.SBException;

public class DialogMarkers
extends JDialog
implements Observer {
    Well well;
    TableModelMarkers model = new TableModelMarkers();
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonHelp;
    private JScrollPane jScrollPane1;
    private JTable jTableMarkers;

    public DialogMarkers(Frame parent, boolean modal, Well well) throws SQLException {
        super(parent, modal);
        this.well = well;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        Font font = this.jTableMarkers.getTableHeader().getFont();
        font = new Font(font.getName(), 1, font.getSize());
        this.jTableMarkers.getTableHeader().setFont(font);
        TableColumnModel columnModel = this.jTableMarkers.getTableHeader().getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelMarkers.titles[i]);
            columnModel.getColumn(i).setWidth(TableModelMarkers.widths[i]);
        }
        this.jTableMarkers.setDefaultRenderer(Color.class, (TableCellRenderer)new ColorRenderer(true));
        this.setTitle("Seismic Markers : " + this.well.getWellName());
        this.model.markers = this.well.getMarkers();
        this.model.units = this.well.getWellUnits();
        this.model.type = this.well.getType();
        this.jTableMarkers.updateUI();
        this.model.markers.addObserver((Observer)this);
        this.getRootPane().setDefaultButton(this.jButtonClose);
    }

    @Override
    public void update(Observable obs, Object obj) {
        try {
            if (obs == this.well.getMarkers()) {
                this.model.fireTableDataChanged();
            }
        }
        catch (Exception e) {
            System.out.println("Exception in update method: " + e);
        }
    }

    Well getWell() {
        return this.well;
    }

    private void initComponents() {
        this.jButtonClose = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonAdd = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableMarkers = new JTable();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(237, 285));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DialogMarkers.this.formWindowClosing(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMarkers.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMarkers.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.setMaximumSize(new Dimension(59, 23));
        this.jButtonHelp.setMinimumSize(new Dimension(59, 23));
        this.jButtonHelp.setPreferredSize(new Dimension(59, 23));
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMarkers.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add..");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMarkers.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jTableMarkers.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableMarkers);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 148, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButtonAdd, -2, 63, -2).add((Component)this.jButtonDelete).add((Component)this.jButtonHelp, -2, 63, -2).add((Component)this.jButtonClose, -2, 63, -2)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 263, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0, 159, Short.MAX_VALUE).add((Component)this.jButtonHelp, -2, -1, -2).addPreferredGap(0).add((Component)this.jButtonClose).add(11, 11, 11)))));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.model.markers.deleteObserver((Observer)this);
        this.dispose();
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableMarkers.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "No row selected", this.getTitle(), 1);
            return;
        }
        try {
            for (int row : this.jTableMarkers.getSelectedRows()) {
                SeismicMarker marker = this.model.markers.get(row);
                int option = JOptionPane.showConfirmDialog(this, "Really delete: " + SB.convFromM((double)marker.getDepth(), (char)this.model.units, (char)this.model.type) + " " + marker, this.getTitle(), 0, 3);
                if (option != 0) continue;
                this.model.markers.delete(this.well.getWellID(), marker);
                this.well.getDataModel().commit();
                this.well.setDataChanged();
                this.well.notifyObservers((Object)marker);
                this.model.fireTableDataChanged();
            }
            this.jTableMarkers.clearSelection();
            this.model.markers.notifyObservers();
        }
        catch (SQLException sql) {
            this.getWell().getDataModel().doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.getWell().getDataModel());
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            DialogSeismicMarker dialog = new DialogSeismicMarker(this, true, this.well, this.model.units);
            dialog.setLocation(this.getLocation().x + 25, this.getLocation().y + 25);
            dialog.setVisible(true);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Error starting seismic marker dialog: " + ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogmarkers.html");
    }

    private void formWindowClosing(WindowEvent evt) {
        this.jButtonCloseActionPerformed(null);
    }
}

