/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.TableModel;
import jsbugs.DialogAbnScheme;
import jsbugs.DialogAbnSchemes;
import jsbugs.FrameJsbugs;
import jsbugs.MatchAbnItem;
import jsbugs.SBDialog;
import jsbugs.TableModelMatchAbundance;
import model2.AbnScheme;
import model2.AnalystHeader;
import model2.SBdb;
import model2.Sample;
import model2.Smpdtl;
import model2.TaxonOcc;
import model2.Well;
import util.SB;
import util.TableSorter;

public class DialogMatchAbundance
extends SBDialog {
    private final TableModelMatchAbundance model = new TableModelMatchAbundance();
    private final TableSorter sorter = new TableSorter((TableModel)this.model);
    private final SBdb ws;
    private final SBdb db;
    private final AbnScheme wsScheme;
    private final JComboBox comboAbn = new JComboBox();
    private final Image backgroundImage;
    private boolean inStartup = true;
    private JButton jButtonAddScheme;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonSchemes;
    private JComboBox jComboBoxDBScheme;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTableMatchAbundance;
    private JTextField jTextFieldWSScheme;

    public DialogMatchAbundance(Frame parent, boolean modal, SBdb ws, SBdb db, AbnScheme wsScheme) throws SQLException {
        super(parent, modal);
        this.ws = ws;
        this.db = db;
        if (wsScheme == null) {
            throw new IllegalArgumentException("Abundance Scheme passed to MatchAbundance Scheme is null");
        }
        this.wsScheme = wsScheme;
        this.backgroundImage = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/MatchBG.png"));
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.setTitle("Match Abundance");
        this.jTextFieldWSScheme.setText(this.wsScheme.toString());
        this.refreshDBCombo();
        this.inStartup = false;
        this.setScheme();
        this.model.setupTable(this.jTableMatchAbundance, this.comboAbn);
        this.jTableMatchAbundance.getTableHeader().setReorderingAllowed(false);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(DialogMatchAbundance.this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane1 = new JScrollPane();
        this.jTableMatchAbundance = new JTable();
        this.jLabel1 = new JLabel();
        this.jButtonAddScheme = new JButton();
        this.jLabel2 = new JLabel();
        this.jComboBoxDBScheme = new JComboBox();
        this.jButtonSchemes = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jTextFieldWSScheme = new JTextField();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(750, 250));
        this.setModal(true);
        this.jScrollPane1.setViewportBorder(BorderFactory.createLineBorder(new Color(255, 255, 255)));
        this.jTableMatchAbundance.setModel((TableModel)this.sorter);
        this.jScrollPane1.setViewportView(this.jTableMatchAbundance);
        this.jLabel1.setFont(new Font("Tahoma", 1, 13));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace:");
        this.jButtonAddScheme.setText("Add...");
        this.jButtonAddScheme.setToolTipText("Add workspace scheme into database");
        this.jButtonAddScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchAbundance.this.jButtonAddSchemeActionPerformed(evt);
            }
        });
        this.jLabel2.setFont(new Font("Tahoma", 1, 13));
        this.jLabel2.setText("Database:");
        this.jComboBoxDBScheme.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxDBScheme.setToolTipText("Select abundance sheme to match against imported data. Best fit scheme is pre-selected");
        this.jComboBoxDBScheme.setBorder(null);
        this.jComboBoxDBScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchAbundance.this.jComboBoxDBSchemeActionPerformed(evt);
            }
        });
        this.jButtonSchemes.setText("...");
        this.jButtonSchemes.setToolTipText("Modify or show database abundance schemes");
        this.jButtonSchemes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchAbundance.this.jButtonSchemesActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchAbundance.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchAbundance.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jTextFieldWSScheme.setBackground(new Color(255, 255, 204));
        this.jTextFieldWSScheme.setEditable(false);
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchAbundance.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldWSScheme, -2, 174, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAddScheme).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 19, Short.MAX_VALUE).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxDBScheme, -2, 186, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSchemes, -2, 35, -2)).addComponent(this.jScrollPane1, -1, 641, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonCancel, GroupLayout.Alignment.TRAILING, -2, 71, -2).addComponent(this.jButtonOK, -2, 71, -2).addComponent(this.jButtonHelp, GroupLayout.Alignment.TRAILING, -2, 71, -2)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jButtonAddScheme, -2, 22, -2).addComponent(this.jTextFieldWSScheme, -2, -1, -2).addComponent(this.jButtonSchemes).addComponent(this.jComboBoxDBScheme, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jScrollPane1, -1, 185, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            if (!this.saveMatches()) {
                return;
            }
            this.setOK();
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jComboBoxDBSchemeActionPerformed(ActionEvent evt) {
        if (this.inStartup) {
            return;
        }
        this.model.dbScheme = (AbnScheme)this.jComboBoxDBScheme.getSelectedItem();
        try {
            for (MatchAbnItem item : this.model.data) {
                if (!item.additional) {
                    item.dbDesc = null;
                    item.rw = false;
                    item.cv = false;
                    item.questionable = false;
                }
                if (this.model.dbScheme.getIndex(item.abr) < 0) continue;
                String dbDesc = this.model.dbScheme.getClassName(item.abr);
                int dbMin = this.model.dbScheme.getLowBound(this.model.dbScheme.getIndex(item.abr));
                if (item.desc != null && !item.desc.equalsIgnoreCase(dbDesc) || item.min != 0 && item.min != dbMin) continue;
                item.dbDesc = dbDesc;
                item.dbMin = dbMin;
            }
            this.comboAbn.removeAllItems();
            this.model.dbScheme.fillCombo(this.comboAbn, true);
            this.model.fireTableDataChanged();
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error: ", (Exception)ex);
        }
    }

    private void jButtonAddSchemeActionPerformed(ActionEvent evt) {
        try {
            DialogAbnScheme dialog = new DialogAbnScheme(this, true, this.db, this.wsScheme);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.inStartup = true;
                this.refreshDBCombo();
                this.inStartup = false;
                this.jComboBoxDBScheme.setSelectedItem(dialog.origScheme);
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error: ", (Exception)ex);
        }
    }

    private void jButtonSchemesActionPerformed(ActionEvent evt) {
        try {
            Object selectedScheme = this.jComboBoxDBScheme.getSelectedItem();
            DialogAbnSchemes dialog = new DialogAbnSchemes(this, true, this.db);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            this.inStartup = true;
            this.refreshDBCombo();
            this.inStartup = false;
            this.jComboBoxDBScheme.setSelectedItem(selectedScheme);
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error: ", (Exception)ex);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogmatchabundance.html");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setScheme() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.model.data.clear();
            boolean subjFound = false;
            Iterator wit = this.ws.getProject(0).getWellIterator();
            while (wit.hasNext()) {
                Well well = (Well)wit.next();
                LinkedList<AnalystHeader> selectedAnalystHeaders = null;
                Iterator ait = well.getAnalystHeaderIterator();
                while (ait.hasNext()) {
                    AnalystHeader header = (AnalystHeader)ait.next();
                    if (header.getAbnSchID() <= 0 || header.getAbnSchID() != this.wsScheme.getID()) continue;
                    if (selectedAnalystHeaders == null) {
                        selectedAnalystHeaders = new LinkedList<AnalystHeader>();
                    }
                    selectedAnalystHeaders.add(header);
                }
                for (Sample sample : well.getSamples()) {
                    for (Smpdtl smpdtl : sample.getAnalyses()) {
                        boolean process = false;
                        if (selectedAnalystHeaders != null) {
                            for (AnalystHeader header : selectedAnalystHeaders) {
                                if (header != smpdtl.getHeader()) continue;
                                process = true;
                                break;
                            }
                        }
                        if (!process) continue;
                        for (TaxonOcc occ : smpdtl.getOccur()) {
                            MatchAbnItem item;
                            if (occ.getSubAbund() == null || occ.getSubAbund().length() <= 0) continue;
                            subjFound = true;
                            Iterator<MatchAbnItem> mit = this.model.data.iterator();
                            boolean found = false;
                            while (mit.hasNext()) {
                                item = mit.next();
                                if (!item.abr.equals(occ.getSubAbund())) continue;
                                found = true;
                                ++item.occs;
                                break;
                            }
                            if (found) continue;
                            item = new MatchAbnItem();
                            item.abr = occ.getSubAbund();
                            if (item.abr.equals("+")) {
                                item.additional = true;
                                item.dbDesc = this.model.ADDITONAL_STRING;
                            }
                            item.occs = 1;
                            if (this.wsScheme != null) {
                                int index = this.wsScheme.getIndex(item.abr);
                                if (index >= 0) {
                                    item.desc = this.wsScheme.getClassName(index);
                                    item.min = this.wsScheme.getLowBound(index);
                                    item.output = this.wsScheme.getOutputValue(index);
                                } else {
                                    System.out.println("Abn abr value not in selected donor Scheme: " + item.abr + ". Selected Scheme: " + this.wsScheme);
                                }
                            }
                            this.model.data.add(item);
                        }
                    }
                }
            }
            if (this.wsScheme.getLink() != null) {
                this.jComboBoxDBScheme.setSelectedItem(this.wsScheme.getLink());
            } else {
                boolean sorted = false;
                block12: while (!sorted) {
                    sorted = true;
                    for (int i = 1; i < this.model.data.size(); ++i) {
                        MatchAbnItem prev = this.model.data.get(i - 1);
                        MatchAbnItem current = this.model.data.get(i);
                        if (current.min >= prev.min) continue;
                        this.model.data.remove(i);
                        this.model.data.add(i - 1, current);
                        sorted = false;
                        continue block12;
                    }
                }
                AbnScheme maxScheme = this.suggestScheme();
                if (maxScheme != null) {
                    this.jComboBoxDBScheme.setSelectedItem(maxScheme);
                }
            }
            this.model.fireTableDataChanged();
            if (!subjFound) {
                JOptionPane.showMessageDialog(this, "There are no semi-quantitative abundance items to be matched in this scheme", this.getTitle(), 2);
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error: ", (Exception)ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private AbnScheme suggestScheme() throws SQLException {
        int maxHits = 0;
        int maxDescHits = 0;
        AbnScheme maxScheme = null;
        for (AbnScheme scheme : this.db.getAbnSchemes()) {
            int hits = 0;
            int descHits = 0;
            for (MatchAbnItem item : this.model.data) {
                if (scheme.getIndex(item.abr) > 0) {
                    ++hits;
                }
                if (item.desc == null || scheme.getAbr(item.desc).length() <= 0) continue;
                ++descHits;
            }
            if (descHits > maxDescHits) {
                maxDescHits = descHits;
                maxHits = hits;
                maxScheme = scheme;
                continue;
            }
            if (hits <= maxHits && !this.wsScheme.getName().equalsIgnoreCase(scheme.getName())) continue;
            maxHits = hits;
            maxScheme = scheme;
        }
        return maxScheme;
    }

    private void refreshDBCombo() throws SQLException {
        this.jComboBoxDBScheme.removeAllItems();
        Iterator list = this.db.getAbnSchemes().iterator();
        while (list.hasNext()) {
            this.jComboBoxDBScheme.addItem(list.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveMatches() {
        for (MatchAbnItem item : this.model.data) {
            if (item.dbDesc != null && item.dbDesc.length() != 0) continue;
            JOptionPane.showMessageDialog(this, "Not all items matched - all need to be matched", this.getTitle(), 2);
            return false;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            Iterator wit = this.ws.getProject(0).getWellIterator();
            AbnScheme selectedDbScheme = (AbnScheme)this.jComboBoxDBScheme.getSelectedItem();
            boolean forceScheme = false;
            this.wsScheme.copy(false, selectedDbScheme);
            while (wit.hasNext()) {
                Well well = (Well)wit.next();
                LinkedList<AnalystHeader> selectedAnalystHeaders = null;
                Iterator ait = well.getAnalystHeaderIterator();
                while (ait.hasNext()) {
                    AnalystHeader header = (AnalystHeader)ait.next();
                    if (header.getAbnSchID() <= 0 || header.getAbnSchID() != this.wsScheme.getID()) continue;
                    if (selectedAnalystHeaders == null) {
                        selectedAnalystHeaders = new LinkedList<AnalystHeader>();
                    }
                    selectedAnalystHeaders.add(header);
                }
                for (Sample sample : well.getSamples()) {
                    for (Smpdtl smpdtl : sample.getAnalyses()) {
                        boolean process = false;
                        if (this.wsScheme != null) {
                            if (selectedAnalystHeaders != null) {
                                for (AnalystHeader header : selectedAnalystHeaders) {
                                    if (header != smpdtl.getHeader()) continue;
                                    process = true;
                                    break;
                                }
                            }
                        } else {
                            process = true;
                        }
                        if (!process) continue;
                        block11: for (TaxonOcc occ : smpdtl.getOccur()) {
                            if (occ.getSubAbund() == null || occ.getSubAbund().length() <= 0) continue;
                            if (forceScheme) {
                                smpdtl.getHeader().setAbnScheme(this.wsScheme.getID());
                            }
                            for (MatchAbnItem item : this.model.data) {
                                if (!item.abr.equals(occ.getSubAbund())) continue;
                                if (item.additional || item.dbDesc.equals(AbnScheme.OTC_STRG)) {
                                    occ.setSubjAbund("", false, false, false);
                                    continue block11;
                                }
                                String abr = selectedDbScheme.getAbr(item.dbDesc);
                                occ.setSubjAbund(abr, item.rw, item.cv, item.questionable);
                                continue block11;
                            }
                        }
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error: ", (Exception)ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        return false;
    }
}

