/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jsbugs.DialogMatchAnalystHeaders;
import jsbugs.DialogMatchTaxonOcc;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelMatchAnalyses;
import model2.AbnScheme;
import model2.AnalystHeader;
import model2.SBdb;
import model2.Sample;
import model2.Smpdtl;
import model2.TaxonOcc;
import model2.Userdef;
import model2.WsWell;
import org.jdesktop.layout.GroupLayout;
import util.ArrowCellRenderer;
import util.MatchData;
import util.SB;
import util.SBException;
import util.SbugsStatus;
import util.SbugsStatusRenderer;
import util.StringStatus;
import util.TableSorter;

public class DialogMatchAnalyses
extends JDialog {
    private final TableModelMatchAnalyses model = new TableModelMatchAnalyses();
    private final TableSorter sorter = new TableSorter((TableModel)this.model);
    WsWell wsWell;
    char discID = '\u0000';
    Image backgroundImage;
    private final Frame parent;
    SBdb db;
    private JButton jButton1;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonExclude;
    private JButton jButtonHeaders;
    private JButton jButtonHelp;
    private JButton jButtonOccurrences;
    private JButton jButtonSave;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane2;
    private JTable jTableMatchAnalyses;

    public DialogMatchAnalyses(Frame parent, boolean modal, SBdb ws, SBdb db, WsWell well, char units, char discID) throws SQLException, SBException {
        super(parent, modal);
        this.wsWell = well;
        this.discID = discID;
        this.model.units = units;
        this.model.workspace = ws;
        this.db = db;
        this.parent = parent;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Match Analyses");
        this.checkLinks();
        if (this.wsWell.getLink() != null) {
            this.wsWell.updateAnalystHeadersStatus();
        }
        this.model.data.init(this.wsWell.getAnalyses(this.discID, null, 0), this.wsWell.getLink() != null ? this.wsWell.getLink().getAnalyses(this.discID, null, 0) : (List)null);
        SB.setTableHeaderBold((JTable)this.jTableMatchAnalyses);
        TableColumnModel columnModel = this.jTableMatchAnalyses.getTableHeader().getColumnModel();
        columnModel.getColumn(15).setMaxWidth(TableModelMatchAnalyses.colWidths[15]);
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelMatchAnalyses.colTitles[i]);
            columnModel.getColumn(i).setPreferredWidth(TableModelMatchAnalyses.colWidths[i]);
        }
        this.jTableMatchAnalyses.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        this.jTableMatchAnalyses.setDefaultRenderer(Boolean.class, (TableCellRenderer)new ArrowCellRenderer());
        this.sorter.addMouseListenerToHeaderInTable(this.jTableMatchAnalyses);
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
        this.jTableMatchAnalyses.getTableHeader().setReorderingAllowed(false);
        this.backgroundImage = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/MatchBG.png"));
    }

    private void checkLinks() throws SQLException, SBException {
        if (this.wsWell.getLink() != null && !this.wsWell.getAnalyses(this.discID, null, 0).isEmpty()) {
            for (Userdef u : this.model.workspace.getUsers()) {
                if (u.getLink() != null) continue;
                throw new SBException("Cannot open dialog; analysts not matched");
            }
            for (Smpdtl dtl : this.wsWell.getAnalyses(this.discID, null, 0)) {
                for (TaxonOcc occ : dtl.getOccurUnsorted()) {
                    if (occ.getTaxon() == null) {
                        throw new SBException("Corrupt file - missing species dictionary");
                    }
                    if (occ.getTaxon().getLink() != null) continue;
                    throw new SBException("Cannot open dialog; taxa not matched");
                }
            }
            for (AnalystHeader hdr : this.wsWell.getAnalystHeaders()) {
                if (hdr.getDiscID() != this.discID) continue;
                if (hdr.getAbnSchID() > 0 && this.model.workspace.getAbnScheme(hdr.getAbnSchID(), false).getLink() == null) {
                    throw new SBException("Cannot open dialog; abundance scheme '" + this.model.workspace.getAbnScheme(hdr.getAbnSchID(), false) + "' not matched");
                }
                if (hdr.getEnvSchID() <= 0 || this.model.workspace.getEnvScheme(hdr.getEnvSchID()) == null || this.model.workspace.getEnvScheme(hdr.getEnvSchID()).getLink() != null) continue;
                throw new SBException("Cannot open dialog; paleoenvironment scheme '" + this.model.workspace.getEnvScheme(hdr.getEnvSchID()) + "' not matched");
            }
        }
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jPanel1 = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(DialogMatchAnalyses.this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane2 = new JScrollPane();
        this.jTableMatchAnalyses = new JTable();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonCancel = new JButton();
        this.jButtonOccurrences = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonExclude = new JButton();
        this.jButtonHeaders = new JButton();
        this.jButtonHelp = new JButton();
        this.jButton1.setText("jButton1");
        this.setDefaultCloseOperation(2);
        this.setBackground(Color.lightGray);
        this.setMinimumSize(new Dimension(600, 300));
        this.setModal(true);
        this.jScrollPane2.setViewportBorder(BorderFactory.createLineBorder(new Color(255, 255, 255)));
        this.jTableMatchAnalyses.setModel((TableModel)this.sorter);
        this.jTableMatchAnalyses.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogMatchAnalyses.this.jTableMatchAnalysesMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTableMatchAnalyses);
        this.jLabel1.setFont(new Font("Tahoma", 1, 13));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(new Font("Tahoma", 1, 13));
        this.jLabel2.setText("...Database");
        this.jButtonCancel.setText("Close");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchAnalyses.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOccurrences.setText("Occurrences...");
        this.jButtonOccurrences.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonOccurrences.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchAnalyses.this.jButtonOccurrencesActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.setToolTipText("Save ALL unsaved analyses from workspace into database");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchAnalyses.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setToolTipText("Delete selected analyses from database");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchAnalyses.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.setToolTipText("Exclude selected analyses from workspace");
        this.jButtonExclude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchAnalyses.this.jButtonExcludeActionPerformed(evt);
            }
        });
        this.jButtonHeaders.setText("Suites...");
        this.jButtonHeaders.setToolTipText("Match analysis suites");
        this.jButtonHeaders.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchAnalyses.this.jButtonHeadersActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchAnalyses.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0, 554, Short.MAX_VALUE).add((Component)this.jLabel2)).add(2, (Component)this.jScrollPane2, -1, 712, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2, false).add((Component)this.jButtonExclude, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDelete, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonSave, -1, 93, Short.MAX_VALUE).add((Component)this.jButtonOccurrences, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonHeaders, -1, 93, Short.MAX_VALUE).add((Component)this.jButtonCancel, -1, 93, Short.MAX_VALUE).add((Component)this.jButtonHelp, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jButtonExclude).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0).add((Component)this.jButtonSave).addPreferredGap(0).add((Component)this.jButtonOccurrences).addPreferredGap(0).add((Component)this.jButtonHeaders).addPreferredGap(0, 300, Short.MAX_VALUE).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane2, -1, 491, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        this.deleteAnalyses(false);
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.deleteAnalyses(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSaveActionPerformed(ActionEvent evt) {
        if (this.wsWell.getLink() == null) {
            JOptionPane.showMessageDialog(this, "No linked well - use Match | Wells from main menu.", this.getTitle(), 2);
            return;
        }
        for (int row = 0; row < this.model.data.size(); ++row) {
            MatchData.MatchPair pair = this.model.data.get(row);
            Smpdtl ws = (Smpdtl)pair.getWs();
            if (ws == null || ws.getStatus() != Smpdtl.CONFLICT) continue;
            JOptionPane.showMessageDialog(this, "Conflicting data in workspace at sample: " + ws.getSample(), this.getTitle(), 2);
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            Statement stmt = null;
            for (int row = 0; row < this.model.data.size(); ++row) {
                MatchData.MatchPair pair = this.model.data.get(row);
                Smpdtl ws = (Smpdtl)pair.getWs();
                Smpdtl db = (Smpdtl)pair.getDb();
                if (db == null) {
                    AnalystHeader hdr;
                    Sample wsSample = ws.getSample();
                    Sample dbSample = this.wsWell.getLink().getSample(wsSample.getTopDepth(), wsSample.getBaseDepth(), wsSample.getType(), false);
                    if (dbSample == null) {
                        dbSample = new Sample(this.wsWell.getLink().getDataModel(), wsSample, true);
                        if (stmt == null) {
                            stmt = this.wsWell.getLink().getDataModel().getDatabase().createStatement();
                        }
                        this.wsWell.getLink().addSample(stmt, dbSample);
                    }
                    if ((hdr = this.wsWell.getLink().getAnalystHeader(ws.getAnalyst(), ws.getDiscID(), ws.getAnalyNo(), false)) == null) {
                        AnalystHeader wsHdr = this.wsWell.getAnalystHeader(ws.getAnalyst(), ws.getDiscID(), ws.getAnalyNo(), false);
                        if (wsHdr == null) {
                            hdr = this.wsWell.getLink().getAnalystHeader(ws.getAnalyst(), ws.getDiscID(), ws.getAnalyNo(), true);
                        } else {
                            int envSchID = -1;
                            int abnSchID = -1;
                            if (wsHdr.getEnvSchID() > 0) {
                                envSchID = this.wsWell.getDataModel().getEnvScheme(wsHdr.getEnvSchID()).getLink().getID();
                            }
                            if (wsHdr.getAbnSchID() > 0) {
                                abnSchID = this.wsWell.getDataModel().getAbnScheme(wsHdr.getAbnSchID(), false).getLink().getID();
                            }
                            hdr = this.wsWell.getLink().addAnalystHeader(ws.getAnalyst(), ws.getDiscID(), ws.getAnalyNo(), wsHdr.getDepthFrom(), wsHdr.getDepthTo(), wsHdr.getDateFrom(), wsHdr.getDateTo(), wsHdr.getComments() != null ? wsHdr.getComments() : "", envSchID, abnSchID, Color.BLACK);
                        }
                    } else {
                        AbnScheme linkAbn;
                        if (this.wsWell.getAnalystHeader(ws.getAnalyst(), ws.getDiscID(), ws.getAnalyNo(), false).getStatus() == SbugsStatus.CONFLICT) {
                            String msg = "Cannot save: conflicting analyst suite header information. Press Suites... to reconcile.";
                            JOptionPane.showMessageDialog(this, msg, this.getTitle(), 2);
                            return;
                        }
                        if (ws.hasSemiQuantData() && hdr.getAbnSchID() <= 0 && (linkAbn = this.wsWell.getDataModel().getAbnScheme(this.wsWell.getAnalystHeader(ws.getAnalyst(), ws.getDiscID(), ws.getAnalyNo(), false).getAbnSchID(), false).getLink()) != null) {
                            hdr.setAbnScheme(linkAbn.getID());
                        }
                    }
                    db = new Smpdtl(stmt, this.wsWell.getLink().getDataModel(), this.wsWell.getDataModel(), ws, this.wsWell.getLink().getWellID(), dbSample.getSampID(), hdr);
                    dbSample.addDtl(db);
                    continue;
                }
                if (ws == null || ws.getStatus() != Sample.PARTSTORED) continue;
                db.update(this.wsWell.getLink().getWellID(), ws);
            }
            if (stmt != null) {
                stmt.close();
            }
            this.model.data.init(this.wsWell.getAnalyses(this.discID, null, 0), this.wsWell.getLink().getAnalyses(this.discID, null, 0));
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
            this.wsWell.getLink().getDataModel().commit();
            this.wsWell.getLink().setDataChanged();
            this.wsWell.getLink().notifyObservers(Smpdtl.class);
        }
        catch (Exception e) {
            SB.showStackError((String)"Error saving analyses", (Exception)e);
            this.wsWell.getLink().getDataModel().doRollback();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jTableMatchAnalysesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOccurrencesActionPerformed(null);
        }
    }

    private void jButtonOccurrencesActionPerformed(ActionEvent evt) {
        if (this.jTableMatchAnalyses.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one row", this.getTitle(), 2);
            return;
        }
        MatchData.MatchPair pair = this.model.data.get(this.sorter.getIndexOf(this.jTableMatchAnalyses.getSelectedRow()));
        Smpdtl ws = (Smpdtl)pair.getWs();
        Smpdtl db = (Smpdtl)pair.getDb();
        try {
            DialogMatchTaxonOcc dialog = new DialogMatchTaxonOcc(this, true, this.wsWell, ws, db);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (ws != null && db != null) {
                ws.updateStatus(db);
                this.sorter.fireTableDataChanged();
            }
        }
        catch (Exception e) {
            if (e.getMessage().startsWith("Cannot open dialog - taxa not Matched")) {
                JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 1);
                return;
            }
            e.printStackTrace();
            SB.showStackError((String)"Error opening TaxonOcc dialog", (Exception)e);
        }
    }

    private void jButtonHeadersActionPerformed(ActionEvent evt) {
        if (this.wsWell.getLink() == null) {
            JOptionPane.showMessageDialog(this, "Cannot show this dialog before well is matched.", this.getTitle(), 2);
            return;
        }
        DialogMatchAnalystHeaders dialog = new DialogMatchAnalystHeaders(this.parent, true, this.discID, this.wsWell, this.model.workspace, this.db);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.hasChanged) {
            try {
                this.wsWell.updateSampleStatus(true);
                this.model.data.init(this.wsWell.getAnalyses(this.discID, null, 0), this.wsWell.getLink().getAnalyses(this.discID, null, 0));
            }
            catch (Exception e) {
                e.printStackTrace();
                SB.showStackError((String)"Error: ", (Exception)e);
            }
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogmatchanalyses.html");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAnalyses(boolean fromDatabase) {
        if (fromDatabase && this.wsWell.getLink() == null) {
            JOptionPane.showMessageDialog(this, "No well data - use Exclude to remove from workspace", this.getTitle(), 2);
            return;
        }
        if (this.jTableMatchAnalyses.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No analyses selected", this.getTitle(), 2);
            return;
        }
        int[] selected = this.jTableMatchAnalyses.getSelectedRows();
        LinkedList<Smpdtl> toRemove = new LinkedList<Smpdtl>();
        for (int i : selected) {
            Smpdtl smpdtl = fromDatabase ? (Smpdtl)this.model.data.get(this.sorter.getIndexOf(i)).getDb() : (Smpdtl)this.model.data.get(this.sorter.getIndexOf(i)).getWs();
            if (smpdtl == null) continue;
            toRemove.add(smpdtl);
        }
        if (fromDatabase && toRemove.size() > 0) {
            String msg = "Really delete ";
            if (JOptionPane.showConfirmDialog(this, msg = msg + (toRemove.size() == 1 ? "this analysis?" : "these " + toRemove.size() + " analyses?"), this.getTitle(), 0, 3) != 0) {
                return;
            }
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            int nSamples = 0;
            WsWell deleteWell = fromDatabase ? this.wsWell.getLink() : this.wsWell;
            Smpdtl lastSmpdtl = null;
            for (Smpdtl smpdtl : toRemove) {
                Sample sample = smpdtl.getSample();
                sample.deleteDtl(deleteWell.getWellID(), smpdtl.getAnalyID(), smpdtl);
                deleteWell.setDataChanged();
                lastSmpdtl = smpdtl;
                ++nSamples;
            }
            String text = fromDatabase ? "deleted" : "excluded";
            JOptionPane.showMessageDialog(this, "Analyses " + text + ": " + nSamples, this.getTitle(), 1);
            this.wsWell.updateSampleStatus(true);
            this.model.data.init(this.wsWell.getAnalyses(this.discID, null, 0), this.wsWell.getLink() != null ? this.wsWell.getLink().getAnalyses(this.discID, null, 0) : null);
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
            if (fromDatabase) {
                deleteWell.getDataModel().commit();
                deleteWell.notifyObservers((Object)lastSmpdtl);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error " + (fromDatabase ? "deleting" : "excluding") + " : " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
            if (fromDatabase) {
                this.wsWell.getLink().getDataModel().doRollback();
            }
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }
}

