/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.TableModel;
import jsbugs.DialogUserdef;
import jsbugs.FrameJsbugs;
import jsbugs.SBDialog;
import jsbugs.TableModelMatchAnalysts;
import model2.SBdb;
import model2.Userdef;
import util.SB;
import util.SBException;
import util.TableSorter;

public class DialogMatchAnalysts
extends SBDialog {
    private final TableModelMatchAnalysts model = new TableModelMatchAnalysts();
    private final TableSorter sorter = new TableSorter((TableModel)this.model);
    private Image backgroundImage;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonMatchAll;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTableAnalysts;

    public DialogMatchAnalysts(Frame parent, boolean modal, SBdb ws, SBdb db) throws SQLException {
        super(parent, modal);
        this.initComponents();
        this.init(ws, db);
    }

    private void init(SBdb ws, SBdb db) throws SQLException {
        this.model.setupTable(this.jTableAnalysts, ws, db);
        this.sorter.addMouseListenerToHeaderInTable(this.jTableAnalysts);
        this.sorter.reallocateIndexes();
        this.sorter.sortByColumn(0);
        this.sorter.sort((Object)this);
        this.sorter.fireTableDataChanged();
        this.jTableAnalysts.getTableHeader().setReorderingAllowed(false);
        this.setTitle("Match Analysts/Personnel");
        this.backgroundImage = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/MatchBG.png"));
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(DialogMatchAnalysts.this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableAnalysts = new JTable();
        this.jButtonMatchAll = new JButton();
        this.jButtonAdd = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 250));
        this.jLabel1.setFont(new Font("Tahoma", 1, 13));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(new Font("Tahoma", 1, 13));
        this.jLabel2.setText("...Database");
        this.jScrollPane1.setToolTipText("Select the database abbreviation to match");
        this.jScrollPane1.setViewportBorder(BorderFactory.createLineBorder(new Color(255, 255, 255)));
        this.jTableAnalysts.setModel((TableModel)this.sorter);
        this.jScrollPane1.setViewportView(this.jTableAnalysts);
        this.jButtonMatchAll.setText("Match all");
        this.jButtonMatchAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchAnalysts.this.jButtonMatchAllActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchAnalysts.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchAnalysts.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchAnalysts.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchAnalysts.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonCancel, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonMatchAll, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonAdd, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonOK, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonHelp, -2, 75, -2)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1, -2, 21, -2).addComponent(this.jLabel2, -2, 27, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonMatchAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 117, Short.MAX_VALUE).addComponent(this.jButtonOK).addGap(5, 5, 5).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 249, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonMatchAllActionPerformed(ActionEvent evt) {
        try {
            for (Userdef user : this.model.users) {
                Userdef dbUser;
                if (user.getLink() != null || (dbUser = this.model.db.getUser(user.getAbr())) == null) continue;
                user.setLink(dbUser);
            }
            this.sorter.fireTableDataChanged();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("Error getting personnel", sql, this.model.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        if (this.jTableAnalysts.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one row from the table to add.", this.getTitle(), 1);
            return;
        }
        Userdef user = (Userdef)this.model.getValueAt(this.sorter.getIndexOf(this.jTableAnalysts.getSelectedRow()), 0);
        if (user.getLink() != null) {
            JOptionPane.showMessageDialog(this, "Item to be added is already linked.", this.getTitle(), 1);
            return;
        }
        DialogUserdef dialog = new DialogUserdef(this, true, this.model.db, user.getAbr(), user.getName(), user.getDiscipline());
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            try {
                user.setLink(dialog.user);
                this.model.refreshUserCombo(this.model.db);
                this.jTableAnalysts.repaint();
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("Error getting personnel", sql, this.model.db);
            }
            catch (RuntimeException re) {
                SB.showStackError((String)"", (Exception)re);
            }
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            for (Userdef user : this.model.users) {
                if (user.getLink() == null) {
                    JOptionPane.showMessageDialog(this, "Not all personnel matched. Press Cancel to close without matching.", this.getTitle(), 2);
                    return;
                }
                for (Userdef user2 : this.model.users) {
                    if (user2.getLink() == null || user == user2 || user.getLink().getUsrID() != user2.getLink().getUsrID() || this.model.ws.checkAnalystConflicts(user.getUsrID(), user2.getUsrID())) continue;
                    JOptionPane.showMessageDialog(this, "You cannot match more than one analyst to the same database analyst because of conflicting analyses or comment data.", this.getTitle(), 2);
                    return;
                }
            }
            for (Userdef user : this.model.users) {
                user.setFromLink();
            }
            this.setOK();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.model.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogmatchanalysts.html");
    }
}

