/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelMatchBiocom;
import model2.Biocom;
import model2.InterpHdr;
import model2.SBdb;
import model2.Sample;
import model2.Userdef;
import model2.Well;
import model2.WellInterp;
import model2.WsWell;
import util.ArrowCellRenderer;
import util.MatchData;
import util.SB;
import util.SBException;
import util.SbugsStatusRenderer;
import util.StringStatus;
import util.TableSorter;

public class DialogMatchBiocoms
extends JDialog {
    WsWell wsWell = null;
    TableModelMatchBiocom model = new TableModelMatchBiocom();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    InterpHdr hdr;
    char discID;
    Image backgroundImage;
    WellInterp wsInterp = null;
    WellInterp dbInterp = null;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonExclude;
    private JButton jButtonSave;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTableMatchBioComs;

    public DialogMatchBiocoms(Frame parent, boolean modal, SBdb ws, SBdb db, WsWell well, char discID, char units, InterpHdr hdr) throws SBException, SQLException {
        super(parent, modal);
        this.wsWell = well;
        this.hdr = hdr;
        this.discID = discID;
        this.model.units = units;
        this.initComponents();
        this.init();
    }

    private void init() throws SBException, SQLException {
        this.backgroundImage = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/MatchBG.png"));
        this.setTitle("Match Biostratigraphic Comments");
        this.checkLinks();
        int interpID = this.hdr.getInterpID();
        if (this.wsWell.hasInterpLoaded(interpID)) {
            this.wsInterp = this.wsWell.getInterp(interpID);
        }
        if (this.wsWell.getLink() != null && this.hdr.getLink() != null) {
            this.wsWell.getLink().loadInterps();
            int dbInterpID = this.hdr.getLink().getInterpID();
            if (this.wsWell.getLink().hasInterpLoaded(dbInterpID)) {
                this.dbInterp = this.wsWell.getLink().getInterp(dbInterpID);
                this.wsWell.getLink().loadInterp(this.dbInterp);
            }
        }
        this.model.data.init(this.wsInterp != null ? this.wsInterp.getComments(this.discID) : null, this.dbInterp != null ? this.dbInterp.getComments(this.discID) : null);
        SB.setTableHeaderBold((JTable)this.jTableMatchBioComs);
        TableColumnModel columnModel = this.jTableMatchBioComs.getTableHeader().getColumnModel();
        columnModel.getColumn(4).setMaxWidth(TableModelMatchBiocom.colWidths[4]);
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelMatchBiocom.colTitles[i]);
            columnModel.getColumn(i).setPreferredWidth(TableModelMatchBiocom.colWidths[i]);
        }
        this.jTableMatchBioComs.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        this.jTableMatchBioComs.setDefaultRenderer(Boolean.class, (TableCellRenderer)new ArrowCellRenderer());
        this.sorter.addMouseListenerToHeaderInTable(this.jTableMatchBioComs);
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
        this.jTableMatchBioComs.getTableHeader().setReorderingAllowed(false);
    }

    private void checkLinks() throws SQLException, SBException {
        if (this.wsWell.getLink() != null) {
            SBdb ws = this.wsWell.getDataModel();
            if (!this.wsWell.getAnalyses(this.discID, null, 0).isEmpty()) {
                for (Userdef u : ws.getUsers()) {
                    if (u.getLink() != null) continue;
                    throw new SBException("Cannot open dialog, analysts not Matched");
                }
            }
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(DialogMatchBiocoms.this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane1 = new JScrollPane();
        this.jTableMatchBioComs = new JTable();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonExclude = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonSave = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(500, 500));
        this.setModal(true);
        this.jTableMatchBioComs.setModel((TableModel)this.sorter);
        this.jScrollPane1.setViewportView(this.jTableMatchBioComs);
        this.jLabel1.setFont(new Font("Tahoma", 1, 13));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(new Font("Tahoma", 1, 13));
        this.jLabel2.setText("...Database");
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.setToolTipText("Exclude selected data from workspace");
        this.jButtonExclude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchBiocoms.this.jButtonExcludeActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setToolTipText("Delete selected data from database");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchBiocoms.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchBiocoms.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.setToolTipText("Save all unsaved comments to the database");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchBiocoms.this.jButtonSaveActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 563, Short.MAX_VALUE).addComponent(this.jLabel2)).addComponent(this.jScrollPane1, -1, 721, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonClose, -2, 78, -2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonSave, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDelete, GroupLayout.Alignment.LEADING, -1, 75, Short.MAX_VALUE).addComponent(this.jButtonExclude, GroupLayout.Alignment.LEADING, -1, 75, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonExclude).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 355, Short.MAX_VALUE).addComponent(this.jButtonClose)).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 459, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        this.deleteBiocom(false);
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.deleteBiocom(true);
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        if (this.wsWell.getLink() == null) {
            JOptionPane.showMessageDialog(this, "No linked well - use Match | Wells from main menu.", this.getTitle(), 2);
            return;
        }
        if (this.dbInterp == null) {
            JOptionPane.showMessageDialog(this, "Version not linked - use Match | Versions from main menu.", this.getTitle(), 2);
            return;
        }
        try {
            Well dbWell = this.wsWell.getLink();
            SBdb wsDB = this.wsWell.getDataModel();
            boolean doStore = true;
            Sample sampleAdded = null;
            Statement stmt = null;
            for (int row = 0; row < this.model.data.size(); ++row) {
                Sample baseSample;
                MatchData.MatchPair pair = this.model.data.get(row);
                Biocom ws = (Biocom)pair.getWs();
                Biocom db = (Biocom)pair.getDb();
                if (ws == null || db != null) continue;
                Sample topSample = dbWell.getSample(ws.getTopSample().getTopDepth(), ws.getTopSample().getBaseDepth(), ws.getTopSample().getType());
                if (topSample == null) {
                    int opt = JOptionPane.showConfirmDialog(this, "Sample: " + ws.getTopSample() + " does not exist: create it?", this.getTitle(), 0, 3);
                    if (opt != 0) {
                        doStore = false;
                        break;
                    }
                    if (stmt == null) {
                        stmt = dbWell.getDataModel().getDatabase().createStatement();
                    }
                    sampleAdded = dbWell.addWsSample(stmt, ws.getTopSample());
                }
                if (ws.getBaseSample() != null && (baseSample = dbWell.getSample(ws.getBaseSample().getTopDepth(), ws.getBaseSample().getBaseDepth(), ws.getBaseSample().getType())) == null) {
                    int opt = JOptionPane.showConfirmDialog(this, "Sample: " + ws.getTopSample() + " does not exist: create it?", this.getTitle(), 0, 3);
                    if (opt != 0) {
                        doStore = false;
                        break;
                    }
                    if (stmt == null) {
                        stmt = dbWell.getDataModel().getDatabase().createStatement();
                    }
                    sampleAdded = dbWell.addWsSample(stmt, ws.getBaseSample());
                }
                int analystID = 0;
                if (ws.getAnalyst() <= 0) continue;
                Userdef wsUser = wsDB.getUser(ws.getAnalyst());
                if (wsUser == null) {
                    JOptionPane.showMessageDialog(this, "Cannot save: analyst used does not exist in workspace.");
                    doStore = false;
                    break;
                }
                if (wsUser.getLink() == null) {
                    JOptionPane.showMessageDialog(this, "Cannot save: analyst is not matched: " + wsUser.getAbr());
                    doStore = false;
                    break;
                }
                analystID = wsUser.getLink().getUsrID();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (doStore) {
                this.dbInterp.storeComments(this.wsInterp, this.wsWell.getLink().getWellID(), this.discID);
            }
            if (sampleAdded != null) {
                dbWell.notifyObservers(sampleAdded);
            }
            this.wsWell.updateAllBCMStatus(this.wsInterp, this.dbInterp != null ? this.dbInterp.getHeader() : null, this.model.units, true);
            this.model.data.init(this.wsInterp != null ? this.wsInterp.getComments(this.discID) : null, this.dbInterp != null ? this.dbInterp.getComments(this.discID) : null);
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
            this.wsWell.getLink().getDataModel().commit();
            this.dbInterp.notifyObservers((Object)19);
        }
        catch (Exception e) {
            this.wsWell.getLink().getDataModel().doRollback();
            SB.showStackError((String)"Error saving comment", (Exception)e);
            e.printStackTrace();
        }
    }

    private void deleteBiocom(boolean fromDatabase) {
        if (fromDatabase && this.wsWell.getLink() == null) {
            JOptionPane.showMessageDialog(this, "No well data - use Exclude to remove from workspace", this.getTitle(), 2);
            return;
        }
        if (this.jTableMatchBioComs.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No rows selected", this.getTitle(), 2);
            return;
        }
        int[] selected = this.jTableMatchBioComs.getSelectedRows();
        LinkedList<Biocom> toRemove = new LinkedList<Biocom>();
        for (int i : selected) {
            Biocom biocom = fromDatabase ? (Biocom)this.model.data.get(this.sorter.getIndexOf(i)).getDb() : (Biocom)this.model.data.get(this.sorter.getIndexOf(i)).getWs();
            if (biocom == null) continue;
            toRemove.add(biocom);
        }
        if (fromDatabase && toRemove.size() > 0) {
            String msg = "Really delete ";
            msg = msg + (toRemove.size() == 1 ? "this comment" : "these " + toRemove.size() + " comment");
            if (JOptionPane.showConfirmDialog(this, msg = msg + (toRemove.size() == 1 ? "?" : "s?"), this.getTitle(), 0, 3) != 0) {
                return;
            }
        }
        try {
            int nItems = 0;
            WsWell deleteFromWell = fromDatabase ? this.wsWell.getLink() : this.wsWell;
            int deleteFromInterpID = fromDatabase ? this.hdr.getLink().getInterpID() : this.hdr.getInterpID();
            WellInterp deleteFromWellInterp = deleteFromWell.getInterp(deleteFromInterpID);
            for (Biocom biocom : toRemove) {
                deleteFromWellInterp.deleteBiocom(deleteFromWell.getWellID(), biocom);
                ++nItems;
            }
            String text = fromDatabase ? "deleted" : "excluded";
            JOptionPane.showMessageDialog(this, "Comments " + text + ": " + nItems, this.getTitle(), 1);
            if (fromDatabase) {
                deleteFromWell.getDataModel().commit();
                deleteFromWellInterp.notifyObservers((Object)19);
            } else {
                this.wsWell.updateAllBCMStatus(this.wsInterp, this.dbInterp != null ? this.dbInterp.getHeader() : null, this.model.units, true);
            }
            this.model.data.init(this.wsInterp != null ? this.wsInterp.getComments(this.discID) : null, this.dbInterp != null ? this.dbInterp.getComments(this.discID) : null);
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
        }
        catch (SQLException sql) {
            if (fromDatabase) {
                this.wsWell.getLink().getDataModel().doRollback();
            }
            FrameJsbugs.showStackError("SQL Error " + (fromDatabase ? "deleting" : "excluding"), sql, this.wsWell.getLink().getDataModel());
        }
        catch (SBException sbe) {
            if (fromDatabase) {
                this.wsWell.getLink().getDataModel().doRollback();
            }
            SB.showStackError((String)("Error " + (fromDatabase ? "deleting" : "excluding")), (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }
}

