/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelMatchCasing;
import model2.CasingPoint;
import model2.WellInterp;
import model2.WsWell;
import org.jdesktop.layout.GroupLayout;
import util.ArrowCellRenderer;
import util.SB;
import util.SBException;
import util.SbugsStatusRenderer;
import util.StringStatus;
import util.TableSorter;

public class DialogMatchCasing
extends JDialog {
    WsWell well = null;
    TableModelMatchCasing model = new TableModelMatchCasing();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    Image backgroundImage;
    WellInterp interp = null;
    WellInterp dbInterp = null;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonExclude;
    private JButton jButtonSave;
    private JButton jButtonSelectView;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTableCasing;

    public DialogMatchCasing(Frame parent, boolean modal, WsWell well, char units) throws SQLException, SBException {
        super(parent, modal);
        this.well = well;
        this.model.units = units;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Match Casing");
        SB.setTableHeaderBold((JTable)this.jTableCasing);
        TableColumnModel columnModel = this.jTableCasing.getTableHeader().getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelMatchCasing.colTitles[i]);
            columnModel.getColumn(i).setWidth(TableModelMatchCasing.colWidths[i]);
        }
        columnModel.getColumn(2).setMaxWidth(TableModelMatchCasing.colWidths[2]);
        this.model.init(this.well.getCasing(), this.well.getLink() != null ? this.well.getLink().getCasing() : null);
        if (this.well.getLink() == null || !this.well.getLink().getDataModel().isConnected() || !this.well.getLink().getDataModel().hasCasingView()) {
            this.jButtonSelectView.setVisible(false);
        }
        if (this.well.getLink() == null) {
            this.jButtonSave.setEnabled(false);
        }
        this.jTableCasing.setDefaultRenderer(CasingPoint.class, (TableCellRenderer)new SbugsStatusRenderer());
        this.jTableCasing.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        this.jTableCasing.setDefaultRenderer(Boolean.class, (TableCellRenderer)new ArrowCellRenderer());
        this.sorter.addMouseListenerToHeaderInTable(this.jTableCasing);
        this.sorter.reallocateIndexes();
        this.backgroundImage = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/MatchBG.png"));
        this.jTableCasing.getTableHeader().setReorderingAllowed(false);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(DialogMatchCasing.this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane1 = new JScrollPane();
        this.jTableCasing = new JTable();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonExclude = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonSelectView = new JButton();
        this.jButtonSave = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(480, 320));
        this.setModal(true);
        this.jScrollPane1.setViewportBorder(BorderFactory.createLineBorder(new Color(255, 255, 255)));
        this.jTableCasing.setModel((TableModel)this.sorter);
        this.jScrollPane1.setViewportView(this.jTableCasing);
        this.jLabel1.setFont(new Font("Tahoma", 1, 13));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(new Font("Tahoma", 1, 13));
        this.jLabel2.setText("...Database");
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.setToolTipText("Exclude selected data from workspace");
        this.jButtonExclude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchCasing.this.jButtonExcludeActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setToolTipText("Delete selected data from database");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchCasing.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchCasing.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonSelectView.setText("Load");
        this.jButtonSelectView.setToolTipText("Load casing points for well from CDS");
        this.jButtonSelectView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchCasing.this.jButtonSelectViewActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.setToolTipText("Save unsaved casing points in database");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchCasing.this.jButtonSaveActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0, 227, Short.MAX_VALUE).add((Component)this.jLabel2)).add(2, (Component)this.jScrollPane1, -1, 385, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2, false).add((Component)this.jButtonClose, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonExclude, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jButtonDelete, -1, -1, Short.MAX_VALUE)).add((Component)this.jButtonSelectView).add((Component)this.jButtonSave)).addContainerGap()));
        jPanel1Layout.linkSize(new Component[]{this.jButtonDelete, this.jButtonExclude, this.jButtonSave, this.jButtonSelectView}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jButtonExclude).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(1).add((Component)this.jButtonSelectView).addPreferredGap(0).add((Component)this.jButtonSave).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonClose)).add((Component)this.jScrollPane1, -1, 271, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.deleteCasingPoint(true);
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        this.deleteCasingPoint(false);
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        try {
            if (this.well.getCasing().getSize() == 0) {
                return;
            }
            if (this.well.getLink() == null) {
                return;
            }
            LinkedList<Integer> dType = new LinkedList<Integer>();
            dType.add(new Integer(20));
            try {
                this.well.store(dType);
            }
            catch (Exception ex) {
                FrameJsbugs.showStackError(ex.toString(), ex, this.well.getLink() != null ? this.well.getLink().getDataModel() : null);
            }
            this.well.updateCasingStatus(true);
            this.model.init(this.well.getCasing(), this.well.getLink() != null ? this.well.getLink().getCasing() : null);
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
        }
        catch (Exception ex) {
            FrameJsbugs.showStackError(ex.toString(), ex, this.well.getLink() != null ? this.well.getLink().getDataModel() : null);
        }
    }

    private void jButtonSelectViewActionPerformed(ActionEvent evt) {
        try {
            if (this.well.getCasing().getSize() > 0 && JOptionPane.showConfirmDialog(this, "Clear workspace?", this.getTitle(), 0, 3) == 1) {
                return;
            }
            this.well.getCasing().loadFromView(this.well.getLink().getDataModel(), this.well.getLink().getWellCode());
            this.well.updateCasingStatus(true);
            this.model.init(this.well.getCasing(), this.well.getLink() != null ? this.well.getLink().getCasing() : null);
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
        }
        catch (Exception ex) {
            FrameJsbugs.showStackError(ex.toString(), ex, this.well.getLink() != null ? this.well.getLink().getDataModel() : null);
        }
    }

    private void deleteCasingPoint(boolean fromDatabase) {
        block8: {
            String msg;
            if (fromDatabase && this.well.getLink() == null) {
                JOptionPane.showMessageDialog(this, "No well data - use Exclude to remove from workspace", this.getTitle(), 2);
                return;
            }
            if (this.jTableCasing.getSelectedRowCount() == 0) {
                JOptionPane.showMessageDialog(this, "No rows selected", this.getTitle(), 2);
                return;
            }
            int[] selected = this.jTableCasing.getSelectedRows();
            LinkedList<CasingPoint> toRemove = new LinkedList<CasingPoint>();
            for (int i : selected) {
                CasingPoint casing = fromDatabase ? (CasingPoint)this.model.data.get(this.sorter.getIndexOf(i)).getDb() : (CasingPoint)this.model.data.get(this.sorter.getIndexOf(i)).getWs();
                if (casing == null) continue;
                toRemove.add(casing);
            }
            if (fromDatabase && toRemove.size() > 0 && JOptionPane.showConfirmDialog(this, msg = "Really delete " + (toRemove.size() == 1 ? "this casing point?" : "these " + toRemove.size() + " casing points?"), this.getTitle(), 0, 3) != 0) {
                return;
            }
            try {
                int nItems = 0;
                WsWell deleteFromWell = fromDatabase ? this.well.getLink() : this.well;
                for (CasingPoint casing : toRemove) {
                    deleteFromWell.getCasing().delete(deleteFromWell.getWellID(), casing);
                    ++nItems;
                }
                String text = fromDatabase ? "deleted" : "excluded";
                JOptionPane.showMessageDialog(this, "Casing Points " + text + ": " + nItems, this.getTitle(), 1);
                this.well.updateCasingStatus(true);
                this.model.init(this.well.getCasing(), this.well.getLink() != null ? this.well.getLink().getCasing() : null);
                this.sorter.reallocateIndexes();
                this.sorter.fireTableDataChanged();
                if (fromDatabase) {
                    deleteFromWell.getDataModel().commit();
                    deleteFromWell.notifyObservers();
                    deleteFromWell.getCasing().notifyObservers();
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Error " + (fromDatabase ? "deleting" : "excluding") + " : " + e.getMessage(), this.getTitle(), 0);
                e.printStackTrace();
                if (!fromDatabase) break block8;
                this.well.getLink().getDataModel().doRollback();
            }
        }
    }
}

