/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.TableModel;
import jsbugs.DialogCategory;
import jsbugs.FrameJsbugs;
import jsbugs.SBDialog;
import jsbugs.TableModelMatchCategories;
import model2.Category;
import model2.Discipline;
import model2.SBdb;
import model2.Taxon;
import util.SB;
import util.TableSorter;

public class DialogMatchCategories
extends SBDialog {
    private final TableModelMatchCategories model = new TableModelMatchCategories();
    private final TableSorter sorter = new TableSorter((TableModel)this.model);
    private final SBdb ws;
    List<Taxon> listTaxa = null;
    Discipline discID;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JScrollPane jScrollPane1;
    private JTable jTableCats;

    public DialogMatchCategories(JDialog parent, boolean modal, SBdb ws, SBdb db, List<Taxon> list, Discipline discID) throws SQLException {
        super((Dialog)parent, modal);
        this.ws = ws;
        this.model.db = db;
        this.discID = discID;
        this.setTitle("Match Catagories");
        this.initComponents();
        this.init(list);
    }

    private void init(List<Taxon> list) throws SQLException {
        this.setTitle("Match Categories");
        this.model.setupTable(this.jTableCats);
        ArrayList<String> donorIDs = new ArrayList<String>();
        ArrayList<Integer> donorOccs = new ArrayList<Integer>();
        for (Taxon donorTaxon : list) {
            if (!donorIDs.contains(donorTaxon.getCatMnem())) {
                donorIDs.add(donorTaxon.getCatMnem());
                donorOccs.add(new Integer(1));
                continue;
            }
            int index = donorIDs.indexOf(donorTaxon.getCatMnem());
            donorOccs.set(index, new Integer((Integer)donorOccs.get(index) + 1));
        }
        this.fillCombo();
        this.model.setSize(donorIDs.size());
        Iterator its = donorIDs.iterator();
        int row = 0;
        while (its.hasNext()) {
            String donorID = (String)its.next();
            this.model.donorCat[row] = this.ws.getCategory(donorID);
            this.model.occs[row] = (Integer)donorOccs.get(row);
            this.model.hostCat[row] = this.model.db.getCategory(donorID);
            ++row;
        }
        this.sorter.addMouseListenerToHeaderInTable(this.jTableCats);
        SB.setTableHeaderBold((JTable)this.jTableCats);
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
        this.listTaxa = list;
    }

    void fillCombo() throws SQLException {
        this.model.categoryComboBox.removeAllItems();
        this.model.db.fillCatCombo(this.model.categoryComboBox, true, this.discID);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableCats = new JTable();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonAdd = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(350, 250));
        this.jTableCats.setModel((TableModel)this.sorter);
        this.jScrollPane1.setViewportView(this.jTableCats);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchCategories.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchCategories.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchCategories.this.jButtonAddActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 372, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonCancel, -2, 67, -2).addComponent(this.jButtonOK, -2, 67, -2)).addContainerGap()).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jButtonAdd, -2, 67, -2).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 241, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 166, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        int i;
        boolean makeSwitches = false;
        boolean asked = false;
        for (i = 0; i < this.model.hostCat.length; ++i) {
            if (this.model.hostCat[i] == null) {
                if (asked) continue;
                if (JOptionPane.showConfirmDialog(this, "There are unmatched Categories. Do want to close?.", this.getTitle(), 0, 3) != 0) {
                    return;
                }
                asked = true;
                continue;
            }
            if (this.model.donorCat[i].getMnem().equals(this.model.hostCat[i].getMnem())) continue;
            makeSwitches = true;
        }
        if (makeSwitches) {
            try {
                for (i = 0; i < this.model.donorCat.length; ++i) {
                    Category donorCat = this.model.donorCat[i];
                    Category hostCat = this.model.hostCat[i];
                    if (hostCat == null) continue;
                    this.ws.updateCategory(donorCat, hostCat.getMnem(), this.discID != null ? this.discID : hostCat.getDisc(), hostCat.getName(), hostCat.getColour());
                }
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.model.db);
            }
        }
        this.setOK();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        if (this.jTableCats.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one row", this.getTitle(), 2);
            return;
        }
        int row = this.sorter.getIndexOf(this.jTableCats.getSelectedRow());
        Category donor = this.model.donorCat[row];
        try {
            DialogCategory dialog = new DialogCategory(this, true, this.model.db, donor.getMnem(), donor.getMnem(), this.discID);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.catAdded != null) {
                this.model.hostCat[row] = dialog.catAdded;
                this.model.hostDescription[row] = dialog.catAdded.getName();
                this.sorter.fireTableDataChanged();
                this.fillCombo();
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.model.db);
        }
    }
}

