/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import jsbugs.DialogCmpStd;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelSB;
import model2.Audit;
import model2.CompositeStandard;
import model2.CompositeStandardEvent;
import model2.SBdb;
import util.ArrowCellRenderer;
import util.ColorRenderer;
import util.InvalidFieldException;
import util.MatchData;
import util.SB;
import util.SBException;
import util.SbugsStatus;
import util.SbugsStatusRenderer;
import util.StringStatus;

public class DialogMatchCmpStd
extends JDialog {
    private final TableModelMatchCmpStd model = new TableModelMatchCmpStd();
    private final SBdb db;
    private final CompositeStandard wsStd;
    private boolean inStartup = true;
    private Image backgroundImage;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonExclude;
    private JButton jButtonOK;
    private JButton jButtonSave;
    private JComboBox jComboBoxHost;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTableMatch;
    private JTextField jTextField1;

    public DialogMatchCmpStd(Frame parent, boolean modal, CompositeStandard std, SBdb db) throws SBException, SQLException {
        super(parent, modal);
        this.db = db;
        this.wsStd = std;
        this.initComponents();
        this.init();
    }

    private void init() throws SBException, SQLException {
        this.model.data.init(this.wsStd.getEvents(), null);
        this.model.setUpTable(this.jTableMatch);
        this.initStdCombo();
        this.jTextField1.setText(this.wsStd.getName());
        this.backgroundImage = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/MatchBG.png"));
        this.setTitle("Match Composite Standard Events");
    }

    private void initStdCombo() throws SQLException, SBException {
        this.jComboBoxHost.removeAllItems();
        for (CompositeStandard std : this.db.getCompositeStandards()) {
            this.jComboBoxHost.addItem(std);
        }
        this.inStartup = false;
        this.jComboBoxHost.insertItemAt("<Select>", 0);
        if (this.wsStd.getLink() != null) {
            this.jComboBoxHost.setSelectedItem(this.wsStd.getLink());
        } else {
            Iterator it = this.db.getCompositeStandards().iterator();
            boolean found = false;
            while (it.hasNext()) {
                CompositeStandard selectedScheme = (CompositeStandard)it.next();
                if (!selectedScheme.getName().equalsIgnoreCase(this.wsStd.getName())) continue;
                this.jComboBoxHost.setSelectedItem(selectedScheme);
                found = true;
                break;
            }
            if (!found) {
                this.jComboBoxHost.setSelectedIndex(0);
            }
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(DialogMatchCmpStd.this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonExclude = new JButton();
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jLabel2 = new JLabel();
        this.jComboBoxHost = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.jTableMatch = new JTable();
        this.jButtonDelete = new JButton();
        this.jButtonAdd = new JButton();
        this.jButtonSave = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(700, 300));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchCmpStd.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchCmpStd.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchCmpStd.this.jButtonExcludeActionPerformed(evt);
            }
        });
        this.jLabel1.setFont(new Font("Tahoma", 1, 13));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace:");
        this.jTextField1.setBackground(new Color(255, 255, 204));
        this.jTextField1.setEditable(false);
        this.jLabel2.setFont(new Font("Tahoma", 1, 13));
        this.jLabel2.setText("Database:");
        this.jComboBoxHost.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchCmpStd.this.jComboBoxHostActionPerformed(evt);
            }
        });
        this.jTableMatch.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableMatch);
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchCmpStd.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add..");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchCmpStd.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchCmpStd.this.jButtonSaveActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1, -2, 178, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAdd, -2, 59, -2).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxHost, 0, 178, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 591, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonSave, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDelete, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonExclude, -1, 81, Short.MAX_VALUE).addComponent(this.jButtonCancel, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonOK, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jComboBoxHost, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jButtonAdd)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonExclude).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 229, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jScrollPane1, -1, 362, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jComboBoxHostActionPerformed(ActionEvent evt) {
        if (this.jComboBoxHost.getSelectedIndex() > 0) {
            CompositeStandard std = (CompositeStandard)this.jComboBoxHost.getSelectedItem();
            try {
                std.loadEvents();
                this.wsStd.setLink(std);
                this.model.data.init(this.wsStd.getEvents(), std.getEvents());
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error", (Exception)((Object)sbe));
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.db);
            }
        } else {
            try {
                this.wsStd.setLink(null);
                this.model.data.init(this.wsStd.getEvents(), null);
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error", (Exception)((Object)sbe));
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.db);
            }
        }
        this.model.fireTableDataChanged();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            DialogCmpStd dialog = new DialogCmpStd(this, true, this.db, this.wsStd);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.initStdCombo();
                this.jComboBoxHost.setSelectedItem(dialog.cmpStdAdded);
            }
        }
        catch (IllegalStateException ie) {
            JOptionPane.showMessageDialog(this, "You can't add this Composite Standard: " + ie.toString());
            ie.printStackTrace();
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error: ", (SQLException)sql);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.wsStd.getLink() == null) {
            JOptionPane.showMessageDialog(this, "Composite not matched", this.getTitle(), 2);
            return;
        }
        for (CompositeStandardEvent event : this.wsStd.getEvents()) {
            if (event.getStatus() == SbugsStatus.CONFLICT) {
                JOptionPane.showMessageDialog(this, "Conflicting data in workspace", this.getTitle(), 2);
                return;
            }
            if (event.getStatus() != SbugsStatus.NOTSTORED) continue;
            String msg = "Some events are not stored.\nPress 'save' to add new events to selected database composite.";
            JOptionPane.showMessageDialog(this, msg, this.getTitle(), 2);
            return;
        }
        this.dispose();
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        if (this.wsStd.getLink() == null) {
            JOptionPane.showMessageDialog(this, "Workspace composite must be matched or added before saving", this.getTitle(), 2);
            return;
        }
        try {
            LinkedList<CompositeStandardEvent.Builder> builders = new LinkedList<CompositeStandardEvent.Builder>();
            for (CompositeStandardEvent event : this.wsStd.getEvents()) {
                if (event.getStatus() == SbugsStatus.CONFLICT) {
                    JOptionPane.showMessageDialog(this, "Conflicting data in workspace", this.getTitle(), 2);
                    return;
                }
                if (event.getEvent().getLink() == null) {
                    JOptionPane.showMessageDialog(this, "Cannot save: unlinked event in workspace: " + event.getEvent(), this.getTitle(), 2);
                    return;
                }
                if (event.getStatus() != SbugsStatus.NOTSTORED) continue;
                CompositeStandardEvent.Builder copy = CompositeStandardEvent.Builder.copyOf((CompositeStandardEvent)event);
                copy.event(event.getEvent().getLink()).audit(new Audit(this.db, this.wsStd.getDatabase(), event.getAudit()));
                builders.add(copy);
            }
            this.wsStd.getLink().addEvents(builders);
            this.db.commit();
            this.wsStd.updateStatus();
            this.model.data.init(this.wsStd.getEvents(), this.wsStd.getLink().getEvents());
            this.model.fireTableDataChanged();
        }
        catch (IllegalStateException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
        }
        catch (InvalidFieldException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        this.deleteEvents(false);
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.wsStd.getLink() == null) {
            JOptionPane.showMessageDialog(this, "Select a database composite", this.getTitle(), 2);
            return;
        }
        this.deleteEvents(true);
    }

    private void deleteEvents(boolean fromDatabase) {
        if (this.jTableMatch.getSelectedRowCount() < 1) {
            JOptionPane.showMessageDialog(this, "Select events to " + (fromDatabase ? "delete" : "exclude"), this.getTitle(), 2);
            return;
        }
        LinkedList<CompositeStandardEvent> toRemove = new LinkedList<CompositeStandardEvent>();
        for (int i : this.jTableMatch.getSelectedRows()) {
            CompositeStandardEvent evt = fromDatabase ? (CompositeStandardEvent)this.model.data.get(i).getDb() : (CompositeStandardEvent)this.model.data.get(i).getWs();
            if (evt == null) continue;
            toRemove.add(evt);
        }
        CompositeStandard std = fromDatabase ? this.wsStd.getLink() : this.wsStd;
        try {
            std.deleteEvents(toRemove);
            this.wsStd.updateStatus();
            if (fromDatabase) {
                this.wsStd.getLink().notifyObservers();
                this.db.commit();
            }
            this.model.data.init(this.wsStd.getEvents(), this.wsStd.getLink() != null ? this.wsStd.getLink().getEvents() : null);
            this.model.fireTableDataChanged();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
    }

    class TableModelMatchCmpStd
    extends AbstractTableModel {
        static final int COL_WS_EVENT = 0;
        static final int COL_WS_TYPE = 1;
        static final int COL_WS_CSU = 2;
        static final int COL_ARROW = 3;
        static final int COL_DB_EVENT = 4;
        static final int COL_DB_TYPE = 5;
        static final int COL_DB_CSU = 6;
        final String[] colTitles = new String[]{"Event", "Type", "CSU", "", "Event", "Type", "CSU"};
        final int[] colWidths = new int[]{60, 15, 25, 16, 60, 15, 25};
        final MatchData data = new MatchData();

        TableModelMatchCmpStd() {
        }

        @Override
        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return this.colTitles.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            MatchData.MatchPair pair = this.data.get(rowIndex);
            if (pair == null) {
                return "";
            }
            CompositeStandardEvent ws = (CompositeStandardEvent)pair.getWs();
            CompositeStandardEvent db = (CompositeStandardEvent)pair.getDb();
            try {
                switch (columnIndex) {
                    case 0: {
                        return ws == null ? null : new StringStatus(ws.getEvent().toString(), ws.getStatus());
                    }
                    case 1: {
                        return ws == null ? null : new StringStatus(ws.getEvTypeString(), ws.getStatus());
                    }
                    case 2: {
                        return ws == null ? null : new StringStatus("" + ws.getCSU(), ws.getStatus());
                    }
                    case 3: {
                        return ws != null && db != null ? TableModelSB.linked : TableModelSB.unlinked;
                    }
                    case 4: {
                        return db == null ? null : db.getEvent().toString();
                    }
                    case 5: {
                        return db == null ? null : db.getEvTypeString();
                    }
                    case 6: {
                        return db == null ? null : Double.valueOf(db.getCSU());
                    }
                }
                return "";
            }
            catch (Exception e) {
                e.printStackTrace();
                return e.getMessage();
            }
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 3: {
                    return Boolean.class;
                }
                case 0: 
                case 1: 
                case 2: {
                    return StringStatus.class;
                }
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                default: 
            }
            return false;
        }

        void setUpTable(JTable table) {
            SB.setTableHeaderBold((JTable)table);
            TableColumnModel columnModel = table.getTableHeader().getColumnModel();
            for (int i = 0; i < columnModel.getColumnCount(); ++i) {
                columnModel.getColumn(i).setHeaderValue(this.colTitles[i]);
                columnModel.getColumn(i).setPreferredWidth(this.colWidths[i]);
            }
            columnModel.getColumn(3).setMaxWidth(this.colWidths[3]);
            table.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
            table.setDefaultRenderer(Color.class, (TableCellRenderer)new ColorRenderer(true));
            table.setDefaultRenderer(Boolean.class, (TableCellRenderer)new ArrowCellRenderer());
        }
    }
}

