/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.LinkedList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelMatchCores;
import model2.CoredInterval;
import model2.WsWell;
import util.ArrowCellRenderer;
import util.SB;
import util.SBException;
import util.SbugsStatusRenderer;
import util.StringStatus;
import util.TableSorter;

public class DialogMatchCores
extends JDialog {
    WsWell well = null;
    TableModelMatchCores model = new TableModelMatchCores();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    Image backgroundImage;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonExclude;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTableMatchCores;

    public DialogMatchCores(Frame parent, boolean modal, WsWell well, char units) throws SQLException, SBException {
        super(parent, modal);
        this.well = well;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Match Cores");
        SB.setTableHeaderBold((JTable)this.jTableMatchCores);
        TableColumnModel columnModel = this.jTableMatchCores.getTableHeader().getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelMatchCores.colTitles[i]);
            columnModel.getColumn(i).setWidth(TableModelMatchCores.colWidths[i]);
        }
        columnModel.getColumn(3).setMaxWidth(TableModelMatchCores.colWidths[3]);
        this.model.init(this.well.getCores(), this.well.getLink() != null ? this.well.getLink().getCores() : null);
        this.jTableMatchCores.setDefaultRenderer(CoredInterval.class, (TableCellRenderer)new SbugsStatusRenderer());
        this.jTableMatchCores.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        this.jTableMatchCores.setDefaultRenderer(Boolean.class, (TableCellRenderer)new ArrowCellRenderer());
        this.sorter.addMouseListenerToHeaderInTable(this.jTableMatchCores);
        this.sorter.reallocateIndexes();
        this.jTableMatchCores.getTableHeader().setReorderingAllowed(false);
        this.backgroundImage = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/MatchBG.png"));
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(DialogMatchCores.this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane1 = new JScrollPane();
        this.jTableMatchCores = new JTable();
        this.jButtonClose = new JButton();
        this.jButtonExclude = new JButton();
        this.jButtonDelete = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(480, 320));
        this.setModal(true);
        this.jTableMatchCores.setModel((TableModel)this.sorter);
        this.jScrollPane1.setViewportView(this.jTableMatchCores);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchCores.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.setToolTipText("Exclude selected data from workspace");
        this.jButtonExclude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchCores.this.jButtonExcludeActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setToolTipText("Delete selected data from database");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchCores.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jLabel1.setFont(new Font("Tahoma", 1, 13));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(new Font("Tahoma", 1, 13));
        this.jLabel2.setText("...Database");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 232, Short.MAX_VALUE).addComponent(this.jLabel2)).addComponent(this.jScrollPane1, -1, 390, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonClose, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonExclude, -1, -1, Short.MAX_VALUE)).addComponent(this.jButtonDelete, -2, 69, -2)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonExclude).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 196, Short.MAX_VALUE).addComponent(this.jButtonClose)).addComponent(this.jScrollPane1, -1, 271, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        this.deleteCore(false);
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.deleteCore(true);
    }

    private void deleteCore(boolean fromDatabase) {
        block8: {
            String msg;
            if (fromDatabase && this.well.getLink() == null) {
                JOptionPane.showMessageDialog(this, "No well data - use Exclude to remove from workspace", this.getTitle(), 2);
                return;
            }
            if (this.jTableMatchCores.getSelectedRowCount() == 0) {
                JOptionPane.showMessageDialog(this, "No intervals selected", this.getTitle(), 2);
                return;
            }
            int[] selected = this.jTableMatchCores.getSelectedRows();
            LinkedList<CoredInterval> toRemove = new LinkedList<CoredInterval>();
            for (int i : selected) {
                CoredInterval coredInterval = fromDatabase ? (CoredInterval)this.model.data.get(this.sorter.getIndexOf(i)).getDb() : (CoredInterval)this.model.data.get(this.sorter.getIndexOf(i)).getWs();
                if (coredInterval == null) continue;
                toRemove.add(coredInterval);
            }
            if (fromDatabase && toRemove.size() > 0 && JOptionPane.showConfirmDialog(this, msg = "Really delete " + (toRemove.size() == 1 ? "this core?" : "these " + toRemove.size() + " cores?"), this.getTitle(), 0, 3) != 0) {
                return;
            }
            try {
                int nSamples = 0;
                WsWell deleteWell = fromDatabase ? this.well.getLink() : this.well;
                for (CoredInterval envInterval : toRemove) {
                    deleteWell.deleteCoredInterval(envInterval);
                    ++nSamples;
                }
                String text = fromDatabase ? "deleted" : "excluded";
                JOptionPane.showMessageDialog(this, "Cored intervals " + text + ": " + nSamples, this.getTitle(), 1);
                this.well.updateCoreStatus(true);
                this.model.init(this.well.getCores(), this.well.getLink() != null ? this.well.getLink().getCores() : null);
                this.sorter.reallocateIndexes();
                this.sorter.fireTableDataChanged();
                if (fromDatabase) {
                    deleteWell.getDataModel().commit();
                    deleteWell.notifyObservers();
                    deleteWell.getCores().notifyObservers();
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Error " + (fromDatabase ? "deleting" : "excluding") + " : " + e.getMessage(), this.getTitle(), 0);
                e.printStackTrace();
                if (!fromDatabase) break block8;
                this.well.getLink().getDataModel().doRollback();
            }
        }
    }
}

