/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.DialogEnvScheme;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelMatchEnvScheme;
import model2.AnalystHeader;
import model2.EnvScheme;
import model2.IGDIntervalEnv;
import model2.SBdb;
import model2.Sample;
import model2.Smpdtl;
import model2.Well;
import model2.WellInterp;
import util.SB;
import util.SBException;

public class DialogMatchEnvScheme
extends JDialog {
    Image backgroundImage;
    TableModelMatchEnvScheme model = new TableModelMatchEnvScheme();
    SBdb ws;
    SBdb db;
    boolean isOK = false;
    EnvScheme origLink;
    boolean inStartup = true;
    private JButton jButtonAddScheme;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonSelectScheme;
    private JComboBox jComboBoxHost;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTableMatchEnvScheme;
    private JTextField jTextFieldDonorScheme;

    public DialogMatchEnvScheme(Frame parent, boolean modal, EnvScheme scheme, SBdb ws, SBdb db) throws SBException, SQLException {
        super(parent, modal);
        this.ws = ws;
        this.db = db;
        this.model.scheme = scheme;
        this.origLink = scheme.getLink();
        this.initComponents();
        this.init();
    }

    private void init() throws SBException, SQLException {
        this.setTitle("Match Palaeoenvironment Scheme");
        this.model.setUpTable(this.jTableMatchEnvScheme);
        this.backgroundImage = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/MatchBG.png"));
        this.jTextFieldDonorScheme.setText(this.model.scheme.getName());
        this.getDonorOccs(this.model.scheme);
        this.setHostSchemes();
    }

    private void setHostSchemes() throws SQLException, SBException {
        this.jComboBoxHost.removeAllItems();
        for (EnvScheme scheme : this.db.getEnvSchemes()) {
            this.jComboBoxHost.addItem(scheme);
        }
        this.jComboBoxHost.insertItemAt("<Select>", 0);
        this.inStartup = false;
        if (this.model.scheme.getLink() != null) {
            this.jComboBoxHost.setSelectedItem(this.model.scheme.getLink());
        } else {
            Iterator it = this.db.getEnvSchemes().iterator();
            boolean found = false;
            while (it.hasNext()) {
                EnvScheme selectedScheme = (EnvScheme)it.next();
                if (!selectedScheme.getName().equalsIgnoreCase(this.model.scheme.getName())) continue;
                this.jComboBoxHost.setSelectedItem(selectedScheme);
                found = true;
                break;
            }
            if (!found) {
                this.jComboBoxHost.setSelectedIndex(0);
            }
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(DialogMatchEnvScheme.this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane1 = new JScrollPane();
        this.jTableMatchEnvScheme = new JTable();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonAddScheme = new JButton();
        this.jComboBoxHost = new JComboBox();
        this.jButtonSelectScheme = new JButton();
        this.jTextFieldDonorScheme = new JTextField();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(710, 250));
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DialogMatchEnvScheme.this.formWindowClosing(evt);
            }
        });
        this.jPanel1.setMinimumSize(new Dimension(300, 175));
        this.jTableMatchEnvScheme.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableMatchEnvScheme);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchEnvScheme.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchEnvScheme.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel1.setFont(new Font("Tahoma", 1, 13));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace:");
        this.jLabel2.setFont(new Font("Tahoma", 1, 13));
        this.jLabel2.setText("Database:");
        this.jButtonAddScheme.setText("Add...");
        this.jButtonAddScheme.setToolTipText("Add workspace scheme to database");
        this.jButtonAddScheme.setActionCommand("Add");
        this.jButtonAddScheme.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonAddScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchEnvScheme.this.jButtonAddSchemeActionPerformed(evt);
            }
        });
        this.jComboBoxHost.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxHost.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchEnvScheme.this.jComboBoxHostActionPerformed(evt);
            }
        });
        this.jButtonSelectScheme.setText("...");
        this.jButtonSelectScheme.setToolTipText("View selected database scheme");
        this.jButtonSelectScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchEnvScheme.this.jButtonSelectSchemeActionPerformed(evt);
            }
        });
        this.jTextFieldDonorScheme.setEditable(false);
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchEnvScheme.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldDonorScheme, -2, 173, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAddScheme, -2, 49, -2).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxHost, 0, 171, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSelectScheme, -2, 33, -2)).addComponent(this.jScrollPane1, -1, 608, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addComponent(this.jButtonHelp, -2, 61, -2)).addContainerGap()));
        jPanel1Layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jButtonAddScheme).addComponent(this.jLabel2).addComponent(this.jComboBoxHost, -2, -1, -2).addComponent(this.jButtonSelectScheme).addComponent(this.jTextFieldDonorScheme, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 275, Short.MAX_VALUE))).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        try {
            this.model.scheme.setLink(this.origLink);
        }
        catch (Exception e) {
            SB.showStackError((String)"Error resetting link", (Exception)e);
        }
        this.dispose();
    }

    private void getDonorOccs(EnvScheme scheme) throws SQLException, SBException {
        scheme.resetNoccs();
        Iterator it = this.ws.getProject(0).getWellIterator();
        while (it.hasNext()) {
            Well well = (Well)it.next();
            Iterator iti = well.getInterpIterator();
            while (iti.hasNext()) {
                WellInterp wellInterp = (WellInterp)iti.next();
                for (IGDIntervalEnv zone : wellInterp.getEnvs()) {
                    if (zone.getSchID() != scheme.getID()) continue;
                    HashSet<Integer> set = new HashSet<Integer>();
                    this.setSchemeNocc(scheme, set, zone.getUp());
                    this.setSchemeNocc(scheme, set, zone.getUd());
                    this.setSchemeNocc(scheme, set, zone.getLp());
                    this.setSchemeNocc(scheme, set, zone.getLd());
                    this.setSchemeNocc(scheme, set, zone.getQual());
                }
            }
        }
    }

    private void jComboBoxHostActionPerformed(ActionEvent evt) {
        if (this.inStartup) {
            return;
        }
        try {
            if (this.jComboBoxHost.getSelectedItem() instanceof EnvScheme) {
                this.model.scheme.setLink((EnvScheme)this.jComboBoxHost.getSelectedItem());
                this.model.envComboBox.removeAllItems();
                this.model.scheme.getLink().fillCombo(this.model.envComboBox, 0, false);
            } else {
                this.model.scheme.setLink(null);
                this.model.envComboBox.removeAllItems();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.model.fireTableDataChanged();
    }

    private void jButtonAddSchemeActionPerformed(ActionEvent evt) {
        try {
            if (JOptionPane.showConfirmDialog(this, "Add " + this.model.scheme.getName() + " scheme to database?", this.getTitle(), 0) == 0) {
                String schemeName = this.model.scheme.getName();
                while (this.db.getEnvScheme(schemeName) != null) {
                    schemeName = (String)JOptionPane.showInputDialog(this, "A scheme of the name " + this.model.scheme.getName() + "already exists in the database. /nAdd new scheme with different name?", this.getTitle(), 1, null, null, this.model.scheme.getName());
                    if (schemeName == null) {
                        return;
                    }
                    this.model.scheme.setName(schemeName);
                    this.jTextFieldDonorScheme.setText(schemeName);
                }
                EnvScheme scheme = new EnvScheme(this.model.scheme);
                scheme.resetID();
                this.db.addEnvScheme(scheme);
                this.db.commit();
                this.model.scheme.setLink(scheme);
                this.jComboBoxHost.addItem(scheme);
                this.jComboBoxHost.setSelectedItem(scheme);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonSelectSchemeActionPerformed(ActionEvent evt) {
        if (!(this.jComboBoxHost.getSelectedItem() instanceof EnvScheme)) {
            JOptionPane.showMessageDialog(this, "Select a scheme", this.getTitle(), 0);
            return;
        }
        DialogEnvScheme dialog = new DialogEnvScheme((Dialog)this, true, this.db, (EnvScheme)this.jComboBoxHost.getSelectedItem());
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        try {
            if (dialog.isOK) {
                this.setHostSchemes();
                this.model.fireTableDataChanged();
            }
        }
        catch (Exception e) {
            SB.showStackError((String)"Error", (Exception)e);
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        try {
            this.model.scheme.setLink(this.origLink);
        }
        catch (Exception e) {
            SB.showStackError((String)"Error", (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.model.scheme.getLink() == null) {
            JOptionPane.showMessageDialog(this, "No scheme selected", this.getTitle(), 2);
            return;
        }
        for (int i = 0; i < this.model.scheme.getNClasses(); ++i) {
            if (this.model.scheme.getLinkTerm(i + 1) != null || this.model.scheme.getNoccs(i + 1) <= 0) continue;
            JOptionPane.showMessageDialog(this, "Not all terms matched", this.getTitle(), 2);
            return;
        }
        try {
            this.model.scheme.updateSchemeFromLink();
            this.setCursor(Cursor.getPredefinedCursor(3));
            Iterator wit = this.ws.getProject(0).getWellIterator();
            while (wit.hasNext()) {
                Well well = (Well)wit.next();
                LinkedList<AnalystHeader> selectedAnalystHeaders = null;
                Iterator ait = well.getAnalystHeaderIterator();
                while (ait.hasNext()) {
                    AnalystHeader header = (AnalystHeader)ait.next();
                    if (header.getEnvSchID() <= 0 || header.getEnvSchID() != this.model.scheme.getID()) continue;
                    if (selectedAnalystHeaders == null) {
                        selectedAnalystHeaders = new LinkedList<AnalystHeader>();
                    }
                    selectedAnalystHeaders.add(header);
                }
                for (Sample sample : well.getSamples()) {
                    block9: for (Smpdtl smpdtl : sample.getAnalyses()) {
                        if (selectedAnalystHeaders == null) continue;
                        for (AnalystHeader header : selectedAnalystHeaders) {
                            if (header != smpdtl.getHeader()) continue;
                            if (smpdtl.getProximal() > 0) {
                                smpdtl.setProximal(this.model.scheme.getLinkTermIndex(smpdtl.getProximal()).intValue());
                            }
                            if (smpdtl.getDistal() <= 0) continue block9;
                            smpdtl.setDistal(this.model.scheme.getLinkTermIndex(smpdtl.getDistal()).intValue());
                            continue block9;
                        }
                    }
                }
            }
            this.isOK = true;
            this.dispose();
        }
        catch (Exception e) {
            SB.showStackError((String)"Error", (Exception)e);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogmatchenvscheme.html");
    }

    private void setSchemeNocc(EnvScheme scheme, HashSet<Integer> set, int env) {
        if (set.add(env)) {
            if (env > 0 && env <= scheme.getNClasses()) {
                scheme.setNoccs(env, scheme.getNoccs(env) + 1);
            } else if (env != 0) {
                System.out.println("Env zone scheme reference invalid: " + env);
            }
        }
    }
}

