/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableModel;
import jsbugs.DialogEvent;
import jsbugs.DialogSelectEvent;
import jsbugs.FrameJsbugs;
import jsbugs.SBDialog;
import jsbugs.TableModelMatchEvents;
import model2.SBEvent;
import model2.SBdb;
import util.SB;
import util.SBException;
import util.TableSorter;

public class DialogMatchEvents
extends SBDialog {
    private final TableModelMatchEvents model = new TableModelMatchEvents();
    private final TableSorter sorter = new TableSorter((TableModel)this.model);
    private Image backgroundImage;
    private final SBdb ws;
    private final SBdb db;
    private File matchFile = null;
    private JButton jButtonAdd;
    private JButton jButtonAddAll;
    private JButton jButtonAddSelected;
    private JButton jButtonCancel;
    private JButton jButtonExclude;
    private JButton jButtonHelp;
    private JButton jButtonLoad;
    private JButton jButtonMatchAll;
    private JButton jButtonOK;
    private JButton jButtonSelectEvent;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTableMatchEvents;

    public DialogMatchEvents(Frame parent, boolean modal, SBdb ws, SBdb db) throws SQLException, SBException {
        super(parent, modal);
        this.db = db;
        this.ws = ws;
        this.initComponents();
        this.init();
    }

    public DialogMatchEvents(Dialog parent, boolean modal, SBdb ws, SBdb db) throws SQLException, SBException {
        super(parent, modal);
        this.db = db;
        this.ws = ws;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Match Events ");
        this.model.setUpTable(this.jTableMatchEvents);
        this.sorter.addMouseListenerToHeaderInTable(this.jTableMatchEvents);
        this.model.data = new LinkedList<SBEvent>(this.ws.getSBEvents(false));
        for (SBEvent event : this.model.data) {
            if (event.getLink() == null) continue;
            event.getLink().getNoccs(true);
        }
        this.sorter.fireTableDataChanged();
        this.sorter.reallocateIndexes();
        this.backgroundImage = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/MatchBG.png"));
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(DialogMatchEvents.this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane1 = new JScrollPane();
        this.jTableMatchEvents = new JTable();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonExclude = new JButton();
        this.jButtonMatchAll = new JButton();
        this.jButtonAdd = new JButton();
        this.jButtonAddAll = new JButton();
        this.jButtonAddSelected = new JButton();
        this.jButtonSelectEvent = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonLoad = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(800, 500));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DialogMatchEvents.this.formWindowClosing(evt);
            }
        });
        this.jPanel1.setMinimumSize(new Dimension(400, 300));
        this.jTableMatchEvents.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jTableMatchEvents.setModel((TableModel)this.sorter);
        this.jTableMatchEvents.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogMatchEvents.this.jTableMatchEventsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableMatchEvents);
        this.jLabel1.setFont(new Font("Tahoma", 1, 13));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(new Font("Tahoma", 1, 13));
        this.jLabel2.setText("...Database");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchEvents.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchEvents.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.setToolTipText("Exclude selected events from workspace");
        this.jButtonExclude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchEvents.this.jButtonExcludeActionPerformed(evt);
            }
        });
        this.jButtonMatchAll.setText("Match all");
        this.jButtonMatchAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchEvents.this.jButtonMatchAllActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.setToolTipText("Add selected event to dictionary via dialog");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchEvents.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonAddAll.setText("Add all");
        this.jButtonAddAll.setToolTipText("Add all unmatched events to the event dictionary");
        this.jButtonAddAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchEvents.this.jButtonAddAllActionPerformed(evt);
            }
        });
        this.jButtonAddSelected.setText("Add selected");
        this.jButtonAddSelected.setToolTipText("Add selected unmatched events to the event dictionary");
        this.jButtonAddSelected.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonAddSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchEvents.this.jButtonAddSelectedActionPerformed(evt);
            }
        });
        this.jButtonSelectEvent.setText("Select...");
        this.jButtonSelectEvent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchEvents.this.jButtonSelectEventActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchEvents.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonLoad.setText("Load...");
        this.jButtonLoad.setToolTipText("<html>Select a location for a text file which will store matches,<br>\nor select a previous match file to load matches.</html>");
        this.jButtonLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchEvents.this.jButtonLoadActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 470, Short.MAX_VALUE).addComponent(this.jLabel2)).addComponent(this.jScrollPane1, -1, 628, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonMatchAll, -1, 83, Short.MAX_VALUE).addComponent(this.jButtonCancel, -1, 83, Short.MAX_VALUE).addComponent(this.jButtonAddSelected, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonAddAll, -1, 83, Short.MAX_VALUE).addComponent(this.jButtonAdd, -1, 83, Short.MAX_VALUE).addComponent(this.jButtonSelectEvent, -1, 83, Short.MAX_VALUE).addComponent(this.jButtonExclude, -1, 83, Short.MAX_VALUE).addComponent(this.jButtonOK, -1, 83, Short.MAX_VALUE).addComponent(this.jButtonHelp, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonLoad, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.linkSize(0, this.jButtonAdd, this.jButtonAddAll, this.jButtonAddSelected, this.jButtonCancel, this.jButtonExclude, this.jButtonMatchAll, this.jButtonOK, this.jButtonSelectEvent);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addGap(11, 11, 11).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonMatchAll).addGap(4, 4, 4).addComponent(this.jButtonExclude).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSelectEvent).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAddAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAddSelected).addGap(27, 27, 27).addComponent(this.jButtonLoad).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jScrollPane1, -1, 429, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        boolean autoExclude = false;
        LinkedList<SBEvent> toRemove = new LinkedList<SBEvent>();
        for (SBEvent event : this.model.data) {
            if (event.getLink() != null) continue;
            if (!autoExclude) {
                int opt = JOptionPane.showConfirmDialog(this, "Not all events matched - auto Exclude unmatched entries?", this.getTitle(), 0, 3);
                if (opt == 0) {
                    autoExclude = true;
                } else {
                    return;
                }
            }
            toRemove.add(event);
        }
        for (SBEvent event : toRemove) {
            this.model.data.remove(event);
        }
        this.sorter.reallocateIndexes();
        try {
            LinkedList excluded = new LinkedList(this.ws.getSBEvents(false));
            excluded.removeAll(this.model.data);
            for (SBEvent event : excluded) {
                System.out.println("Excluding event...." + event);
                this.ws.deleteSBEvent(event);
                this.db.commit();
            }
            for (SBEvent remaining : this.model.data) {
                this.ws.copyLinkedEvent(remaining.getEvID());
            }
            this.setOK();
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.jButtonCancelActionPerformed(null);
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        if (this.jTableMatchEvents.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No events selected", this.getTitle(), 2);
            return;
        }
        int[] selected = this.jTableMatchEvents.getSelectedRows();
        LinkedList<SBEvent> toRemove = new LinkedList<SBEvent>();
        for (int i : selected) {
            SBEvent event = this.model.data.get(this.sorter.getIndexOf(i));
            if (event == null) continue;
            toRemove.add(event);
        }
        for (SBEvent event : toRemove) {
            this.model.data.remove(event);
        }
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
    }

    private void jButtonMatchAllActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            boolean switchedType = false;
            for (SBEvent event : this.model.data) {
                if (event.getLink() != null) continue;
                event.findLink(this.db);
                if (event.getLink() != null || !event.findLinkAnyType(this.db)) continue;
                switchedType = true;
            }
            if (switchedType) {
                JOptionPane.showMessageDialog(this, "Note: Some event types in the workspace have been changed to match the database event types.");
            }
        }
        catch (SBException e) {
            FrameJsbugs.showStackError("Error", (Exception)((Object)e), this.db);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
        this.sorter.reallocateIndexes();
        this.sorter.sort(null);
        this.sorter.fireTableDataChanged();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        if (this.jTableMatchEvents.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one event in the table to add", this.getTitle(), 1);
            return;
        }
        SBEvent event = this.model.data.get(this.sorter.getIndexOf(this.jTableMatchEvents.getSelectedRow()));
        DialogEvent dialog = new DialogEvent(this, true, this.db, event);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.sbEvent != null) {
            event.setLink(dialog.sbEvent);
            this.sorter.reallocateIndexes();
            this.sorter.sort((Object)this);
            this.sorter.fireTableDataChanged();
            int index = this.model.data.indexOf(event);
            index = this.sorter.getRowOf(index);
            this.jTableMatchEvents.setRowSelectionInterval(index, index);
        }
    }

    private void jButtonAddAllActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            for (SBEvent event : this.model.data) {
                String taxonName;
                if (event.getLink() == null) {
                    event.findLink(this.db);
                }
                if (event.getLink() != null) continue;
                SBEvent.Builder builder = new SBEvent.Builder().name(event.getName()).isSingle(event.isSingle()).desc(event.getEvDesc());
                boolean generate = event.isGenerate();
                if (event.getTaxon() != null) {
                    builder.taxon(event.getTaxon().getLink());
                    taxonName = event.getTaxon().toString(false, false, false);
                } else {
                    taxonName = event.getName();
                    if (taxonName.indexOf(42) > 0 && taxonName.lastIndexOf(42) > taxonName.indexOf(42)) {
                        taxonName = taxonName.substring(0, taxonName.indexOf(42));
                        generate = false;
                    }
                }
                builder.isGenerate(generate);
                event.setLink(this.db.addSBEvent(builder, taxonName));
                this.db.commit();
            }
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
        this.sorter.reallocateIndexes();
        this.sorter.sort((Object)this);
        this.sorter.fireTableDataChanged();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jButtonAddSelectedActionPerformed(ActionEvent evt) {
        int[] selection = this.jTableMatchEvents.getSelectedRows();
        if (selection.length == 0) {
            JOptionPane.showMessageDialog(this, "No rows selected", this.getTitle(), 1);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            for (int i = 0; i < selection.length; ++i) {
                String taxonName;
                SBEvent event = this.model.data.get(this.sorter.getIndexOf(selection[i]));
                if (event.getLink() == null) {
                    event.findLink(this.db);
                }
                if (event.getLink() != null) continue;
                SBEvent.Builder builder = new SBEvent.Builder().name(event.getName()).isSingle(event.isSingle()).desc(event.getEvDesc());
                boolean generate = event.isGenerate();
                if (event.getTaxon() != null) {
                    builder.taxon(event.getTaxon().getLink());
                    taxonName = event.getTaxon().toString(false, false, false);
                } else {
                    taxonName = event.getName();
                    if (taxonName.indexOf(42) > 0 && taxonName.lastIndexOf(42) > taxonName.indexOf(42)) {
                        taxonName = taxonName.substring(0, taxonName.indexOf(42));
                        generate = false;
                    }
                }
                builder.isGenerate(generate);
                event.setLink(this.db.addSBEvent(builder, taxonName));
                this.db.commit();
            }
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
        this.sorter.reallocateIndexes();
        this.sorter.sort((Object)this);
        this.sorter.fireTableDataChanged();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jButtonSelectEventActionPerformed(ActionEvent evt) {
        if (this.jTableMatchEvents.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one event in the table to add", this.getTitle(), 1);
        }
        SBEvent event = this.model.data.get(this.sorter.getIndexOf(this.jTableMatchEvents.getSelectedRow()));
        try {
            DialogSelectEvent dialog = new DialogSelectEvent(this, true, this.db, event.getLink(), event.getDictionaryName());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                event.setLink(dialog.selection);
                this.sorter.reallocateIndexes();
                this.sorter.sort((Object)this);
                this.sorter.fireTableDataChanged();
                int index = this.model.data.indexOf(event);
                index = this.sorter.getRowOf(index);
                this.jTableMatchEvents.setRowSelectionInterval(index, index);
                if (this.matchFile != null) {
                    BufferedWriter out = new BufferedWriter(new FileWriter(this.matchFile, true));
                    out.write(event.getLink().getEvID() + "\t" + event.toString());
                    out.newLine();
                    out.close();
                }
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error: ", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (IOException ioe) {
            SB.showStackError((String)"Error", (Exception)ioe);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jTableMatchEventsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonSelectEventActionPerformed(null);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogmatchevents.html");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonLoadActionPerformed(ActionEvent evt) {
        try {
            JFileChooser chooser = new JFileChooser();
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Text files", "txt");
            chooser.setFileFilter(filter);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                this.matchFile = chooser.getSelectedFile();
                if (!this.matchFile.getPath().endsWith(".txt")) {
                    this.matchFile = new File(this.matchFile.getPath() + ".txt");
                }
                if (this.matchFile.exists()) {
                    int evID;
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    BufferedReader in = new BufferedReader(new FileReader(this.matchFile));
                    String buff = in.readLine();
                    HashMap<Integer, String> matches = new HashMap<Integer, String>();
                    while (buff != null) {
                        String[] f = buff.split("\t");
                        if (f.length > 1) {
                            evID = Integer.parseInt(f[0]);
                            String evName = f[1];
                            matches.put(evID, evName);
                        }
                        buff = in.readLine();
                    }
                    in.close();
                    Iterator i$ = matches.keySet().iterator();
                    while (i$.hasNext()) {
                        evID = (Integer)i$.next();
                        for (SBEvent event : this.model.data) {
                            if (!event.toString().equals((String)matches.get(evID))) continue;
                            event.findLink(this.db, evID);
                        }
                    }
                    this.sorter.reallocateIndexes();
                    this.sorter.sort(null);
                    this.sorter.fireTableDataChanged();
                } else {
                    this.matchFile.createNewFile();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error opening/reading file: " + ex.toString(), this.getTitle(), 0);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }
}

