/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.DialogImageSetOverview;
import jsbugs.DialogList;
import jsbugs.DialogTaxonImages;
import jsbugs.FrameJsbugs;
import jsbugs.SBDialog;
import jsbugs.TableModelMatchGroup;
import model2.ImageSet;
import model2.SBdb;
import model2.Taxon;
import model2.TxGroup;
import util.MatchData;
import util.SB;
import util.SBException;

public class DialogMatchGroup
extends SBDialog {
    TxGroup wsGroup;
    TxGroup dbGroup;
    SBdb db;
    Image backgroundImage;
    TableModelMatchGroup model = new TableModelMatchGroup();
    LinkedList<TableModelMatchGroup.MatchGroupTaxon> wsList;
    static final String NOGROUPSTRING = "<No database group>";
    private JButton jButtonCancel;
    private JButton jButtonClearDBGroup;
    private JButton jButtonExclude;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonSelectDBGroup;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTableMatchGroup;
    private JTextField jTextFieldDBGroup;

    public DialogMatchGroup(JDialog parent, boolean modal, TxGroup wsGroup, TxGroup dbGroup, SBdb db) throws SQLException, SBException {
        super((Dialog)parent, modal);
        this.wsGroup = wsGroup;
        this.dbGroup = dbGroup;
        this.db = db;
        this.initComponents();
        this.init();
    }

    public DialogMatchGroup(JFrame parent, boolean modal, TxGroup wsGroup, TxGroup dbGroup, SBdb db) throws SQLException, SBException {
        super((Frame)parent, modal);
        this.wsGroup = wsGroup;
        this.dbGroup = dbGroup;
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle(this.wsGroup != null ? "Match incoming group : " + this.wsGroup.getName() : "Database Group : " + this.dbGroup.getName());
        this.backgroundImage = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/MatchBG.png"));
        this.model.setUpTable(this.jTableMatchGroup);
        if (this.wsGroup != null) {
            LinkedList tempList = new LinkedList(this.wsGroup.getDatabase().getTxGroupTaxa(this.wsGroup));
            this.wsList = new LinkedList();
            for (Taxon t : tempList) {
                if (t.getLink() == null) {
                    throw new SBException("Unmatched taxon found in group match");
                }
                this.wsList.add(new TableModelMatchGroup.MatchGroupTaxon(t));
            }
        }
        this.model.data.init(this.wsList, this.getDBList());
        if (this.wsGroup == null) {
            this.jButtonExclude.setEnabled(false);
        }
        if (this.dbGroup != null) {
            this.jTextFieldDBGroup.setText(this.dbGroup.getName());
        } else {
            this.jTextFieldDBGroup.setText(NOGROUPSTRING);
        }
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    List<TableModelMatchGroup.MatchGroupTaxon> getDBList() throws SQLException, SBException {
        LinkedList dbList = this.dbGroup != null ? new LinkedList(this.db.getTxGroupTaxa(this.dbGroup)) : new LinkedList();
        LinkedList<TableModelMatchGroup.MatchGroupTaxon> retList = new LinkedList<TableModelMatchGroup.MatchGroupTaxon>();
        for (Taxon taxon : dbList) {
            retList.add(new TableModelMatchGroup.MatchGroupTaxon(taxon));
        }
        return retList;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(DialogMatchGroup.this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane1 = new JScrollPane();
        this.jTableMatchGroup = new JTable();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonExclude = new JButton();
        this.jTextFieldDBGroup = new JTextField();
        this.jLabel3 = new JLabel();
        this.jButtonOK = new JButton();
        this.jButtonSelectDBGroup = new JButton();
        this.jButtonClearDBGroup = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(550, 300));
        this.jTableMatchGroup.setModel(this.model);
        this.jTableMatchGroup.setToolTipText("Double-click image column to display images");
        this.jTableMatchGroup.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogMatchGroup.this.jTableMatchGroupMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableMatchGroup);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchGroup.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchGroup.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jLabel1.setFont(new Font("Tahoma", 1, 13));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(new Font("Tahoma", 1, 13));
        this.jLabel2.setText("...Database");
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.setToolTipText("Exclude selected taxa from workspace group");
        this.jButtonExclude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchGroup.this.jButtonExcludeActionPerformed(evt);
            }
        });
        this.jTextFieldDBGroup.setEditable(false);
        this.jLabel3.setText("Group:");
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchGroup.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonSelectDBGroup.setText("...");
        this.jButtonSelectDBGroup.setToolTipText("Select database group (leave blank to create new group)");
        this.jButtonSelectDBGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchGroup.this.jButtonSelectDBGroupActionPerformed(evt);
            }
        });
        this.jButtonClearDBGroup.setText("Clear");
        this.jButtonClearDBGroup.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonClearDBGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchGroup.this.jButtonClearDBGroupActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldDBGroup, -2, 157, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSelectDBGroup, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClearDBGroup)).addComponent(this.jLabel2))).addComponent(this.jScrollPane1, -1, 455, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonExclude, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonOK, -2, 83, -2).addComponent(this.jButtonHelp, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonCancel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.linkSize(0, this.jButtonCancel, this.jButtonExclude, this.jButtonHelp, this.jButtonOK);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldDBGroup, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.jButtonSelectDBGroup).addComponent(this.jButtonClearDBGroup)).addGap(7, 7, 7).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonExclude).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jScrollPane1, -1, 318, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        int[] selected = this.jTableMatchGroup.getSelectedRows();
        LinkedList<TableModelMatchGroup.MatchGroupTaxon> toRemove = new LinkedList<TableModelMatchGroup.MatchGroupTaxon>();
        for (int i : selected) {
            TableModelMatchGroup.MatchGroupTaxon taxon = (TableModelMatchGroup.MatchGroupTaxon)this.model.data.get(i).getWs();
            if (taxon == null) continue;
            toRemove.add(taxon);
        }
        LinkedList<Taxon> wsRemovals = new LinkedList<Taxon>();
        for (TableModelMatchGroup.MatchGroupTaxon taxon : toRemove) {
            this.wsList.remove(taxon);
            wsRemovals.add(taxon.taxon);
        }
        try {
            this.wsGroup.deleteTaxa(wsRemovals);
            this.model.data.init(this.wsList, this.getDBList());
            this.model.fireTableDataChanged();
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
        }
    }

    private void jTableMatchGroupMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            if (this.jTableMatchGroup.getSelectedRow() < 0) {
                JOptionPane.showMessageDialog(this, "No taxon selected", this.getTitle(), 2);
                return;
            }
            MatchData.MatchPair pair = this.model.data.get(this.jTableMatchGroup.getSelectedRow());
            TableModelMatchGroup.MatchGroupTaxon mgWsTaxon = (TableModelMatchGroup.MatchGroupTaxon)pair.getWs();
            Taxon wsTaxon = mgWsTaxon == null ? null : mgWsTaxon.taxon;
            TableModelMatchGroup.MatchGroupTaxon mgDbTaxon = (TableModelMatchGroup.MatchGroupTaxon)pair.getDb();
            Taxon dbTaxon = mgDbTaxon == null ? null : mgDbTaxon.taxon;
            try {
                if (this.jTableMatchGroup.getSelectedColumn() == 6) {
                    if (dbTaxon == null) {
                        JOptionPane.showMessageDialog(this, "No database taxon selected", this.getTitle(), 1);
                        return;
                    }
                    DialogTaxonImages dialog = new DialogTaxonImages(this, true, this.db, dbTaxon);
                    SB.centreDialog((Dialog)dialog);
                    dialog.setVisible(true);
                } else if (this.jTableMatchGroup.getSelectedColumn() == 2) {
                    if (wsTaxon == null) {
                        JOptionPane.showMessageDialog(this, "No workspace taxon selected", this.getTitle(), 1);
                        return;
                    }
                    if (wsTaxon.getWsImageSets() == null || wsTaxon.getWsImageSets().isEmpty()) {
                        JOptionPane.showMessageDialog(this, "There are no images in the workspace for selected taxon.", this.getTitle(), 1);
                        return;
                    }
                    System.out.println("Workspace taxon database is: " + wsTaxon.getDatabase());
                    DialogImageSetOverview dialog = new DialogImageSetOverview((Dialog)this, true, (ImageSet)wsTaxon.getWsImageSets().get(0), wsTaxon.getDatabase());
                    dialog.setLocationRelativeTo(this);
                    dialog.setVisible(true);
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
                ex.printStackTrace();
            }
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogmatchgroup.html");
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            Iterator it1 = this.wsGroup.getDatabase().getTxGroupTaxa(this.wsGroup).iterator();
            HashSet<Taxon> duplicates = null;
            while (it1.hasNext()) {
                Taxon wsTaxon1 = (Taxon)it1.next();
                for (Taxon wsTaxon2 : this.wsGroup.getDatabase().getTxGroupTaxa(this.wsGroup)) {
                    if (wsTaxon1 == wsTaxon2 || wsTaxon1.getLink() != wsTaxon2.getLink()) continue;
                    if (duplicates == null) {
                        duplicates = new HashSet<Taxon>();
                    }
                    if (duplicates.contains(wsTaxon1.getLink())) continue;
                    duplicates.add(wsTaxon1.getLink());
                }
            }
            if (duplicates != null) {
                String strg = "You must exclude one of the pairs of the following duplicate taxa, before proceeding: ";
                for (Taxon taxon : duplicates) {
                    strg = strg + "\n" + taxon.toString();
                }
                JOptionPane.showMessageDialog(this, strg, this.getTitle(), 1);
                return;
            }
            boolean deleteUnlinkedDB = false;
            boolean deleteAsk = false;
            if (this.dbGroup == null) {
                if (this.db.getTxGroup(this.wsGroup.getName()) != null) {
                    String newName = JOptionPane.showInputDialog(this, "Database already contains a group called " + this.wsGroup.getName() + ".\nEnter name for new group:", "New group", 2);
                    if (newName == null || newName.isEmpty()) {
                        return;
                    }
                    this.wsGroup.setName(newName);
                }
                this.dbGroup = this.db.copyToDatabase(this.wsGroup.getDatabase(), this.wsGroup);
                JOptionPane.showMessageDialog(this, "Group: " + this.dbGroup.getName() + " added", this.getTitle(), 1);
            } else {
                Taxon wsTaxon;
                TableModelMatchGroup.MatchGroupTaxon mgWsTaxon;
                MatchData.MatchPair pair;
                int i;
                LinkedList<Taxon> groupTaxa = new LinkedList<Taxon>();
                LinkedList<Taxon> dbExtras = new LinkedList<Taxon>();
                for (i = 0; i < this.model.data.size(); ++i) {
                    pair = this.model.data.get(i);
                    mgWsTaxon = (TableModelMatchGroup.MatchGroupTaxon)pair.getWs();
                    if (mgWsTaxon == null || (wsTaxon = mgWsTaxon.taxon) == null) continue;
                    groupTaxa.add(wsTaxon.getLink());
                }
                for (i = 0; i < this.model.data.size(); ++i) {
                    pair = this.model.data.get(i);
                    mgWsTaxon = (TableModelMatchGroup.MatchGroupTaxon)pair.getWs();
                    Taxon taxon = mgWsTaxon != null ? (mgWsTaxon.taxon == null ? null : mgWsTaxon.taxon.getLink()) : (wsTaxon = null);
                    if (wsTaxon != null) continue;
                    if (!deleteAsk) {
                        deleteAsk = true;
                        int opt = JOptionPane.showConfirmDialog(this, "Do you want to delete group membership of taxa that are NOT in the workspace group?", this.getTitle(), 0, 3);
                        if (opt == 0) {
                            deleteUnlinkedDB = true;
                        }
                    }
                    dbExtras.add(((TableModelMatchGroup.MatchGroupTaxon)pair.getDb()).taxon);
                }
                if (!dbExtras.isEmpty()) {
                    if (deleteUnlinkedDB) {
                        this.dbGroup.deleteTaxa(dbExtras);
                    } else {
                        LinkedList<Taxon> newWsTaxa = new LinkedList<Taxon>();
                        SBdb workspace = this.wsGroup.getDatabase();
                        for (Taxon taxon : dbExtras) {
                            newWsTaxa.add(workspace.fillTaxon(workspace, taxon));
                        }
                        this.wsGroup.addTaxa(newWsTaxa);
                    }
                }
                this.dbGroup.addTaxa(groupTaxa);
                JOptionPane.showMessageDialog(this, "Group: " + this.dbGroup.getName() + " updated", this.getTitle(), 1);
            }
            this.wsGroup.updateStatus(this.dbGroup);
            this.db.commit();
            this.setOK();
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error", (Exception)ex);
            this.db.doRollback();
        }
    }

    private void jButtonSelectDBGroupActionPerformed(ActionEvent evt) {
        try {
            DialogList dialog = new DialogList(this, true, "Select database group", this.db, this.db.getTxGroupsSorted(), true, false);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                this.dbGroup = (TxGroup)dialog.selection;
                this.jTextFieldDBGroup.setText(this.dbGroup.getName());
                this.model.data.init(this.wsList, this.getDBList());
                this.model.fireTableDataChanged();
            }
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
    }

    private void jButtonClearDBGroupActionPerformed(ActionEvent evt) {
        this.dbGroup = null;
        this.jTextFieldDBGroup.setText(NOGROUPSTRING);
        try {
            this.model.data.init(this.wsList, this.getDBList());
            this.model.fireTableDataChanged();
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
    }
}

