/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.TableModel;
import jsbugs.DialogIGDScheme;
import jsbugs.DialogList;
import jsbugs.DialogMatchIGDScheme;
import jsbugs.DialogMatchIGDSuggestions;
import jsbugs.DialogSelectScheme;
import jsbugs.FrameJsbugs;
import jsbugs.FrameOrganiser;
import jsbugs.TableModelMatchIGD;
import jsbugs.TableModelMatchIGDSurfaces;
import jsbugs.TableModelMatchIGDUnits;
import model2.IGDInterval;
import model2.IGDIntervalZone;
import model2.IGDScheme;
import model2.IGDUnit;
import model2.SBdb;
import model2.SQPick;
import model2.Surface;
import model2.Well;
import model2.WellInterp;
import model2.WsWell;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SbugsStatus;
import util.TableSorter;

public class DialogMatchIGD
extends JDialog
implements Observer {
    SBdb ws;
    SBdb db;
    TableModelMatchIGD model = new TableModelMatchIGD();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    TableModelMatchIGDUnits modelUnits = new TableModelMatchIGDUnits();
    TableSorter sorterUnits = new TableSorter((TableModel)this.modelUnits);
    JTable tableUnits = new JTable((TableModel)this.sorterUnits);
    JComboBox unitsComboBox = new JComboBox();
    TableModelMatchIGDSurfaces modelSurfaces = new TableModelMatchIGDSurfaces();
    JTable tableSurfaces = new JTable(this.modelSurfaces);
    JComboBox surfaceComboBox = new JComboBox();
    Image backgroundImage;
    boolean isOK = false;
    boolean inSetup = true;
    boolean[] hasIGD = new boolean[]{false, false, false, false};
    int[] igdTypes = new int[]{3, 2, 4, 10};
    FrameOrganiser frameOrganiser;
    private JButton jButtonAddScheme;
    private JButton jButtonCancel;
    private JButton jButtonCreatePicks;
    private JButton jButtonExclude;
    private JButton jButtonFindScheme;
    private JButton jButtonHelp;
    private JButton jButtonMatchAll;
    private JButton jButtonMatchScheme;
    private JButton jButtonOK;
    private JButton jButtonSelectScheme;
    private JButton jButtonShowInformal;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTable jTableMatchIGD;

    public DialogMatchIGD(Frame parent, boolean modal, SBdb ws, SBdb db) throws SQLException, SBException {
        super(parent, modal);
        this.frameOrganiser = (FrameOrganiser)parent;
        this.ws = ws;
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SQLException, SBException {
        this.setTitle("Match Stratigraphic Interval Units and Picked Surfaces");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        Iterator it = this.ws.getProject(0).getWellIterator();
        while (it.hasNext()) {
            Well well = (Well)it.next();
            Iterator iit = well.getInterpIterator();
            while (iit.hasNext()) {
                WellInterp interp = (WellInterp)iit.next();
                for (int i = 0; i < this.hasIGD.length - 1; ++i) {
                    if (interp.getIGDList(this.igdTypes[i], 0).size() <= 0) continue;
                    this.hasIGD[i] = true;
                }
                if (interp.getSQPicks().size() <= 0) continue;
                this.hasIGD[3] = true;
            }
        }
        this.model.setUpTable(this.jTableMatchIGD);
        this.unitsComboBox.setMaximumRowCount(25);
        this.modelUnits.setUpTable(this.tableUnits, false, this.unitsComboBox);
        this.sorterUnits.addMouseListenerToHeaderInTable(this.tableUnits);
        this.surfaceComboBox.setMaximumRowCount(25);
        this.modelSurfaces.setUpTable(this.tableSurfaces, this.surfaceComboBox);
        this.jScrollPane1.add(this.tableUnits);
        this.jScrollPane1.setViewportView(this.tableUnits);
        for (int i = 0; i < this.igdTypes.length; ++i) {
            if (!this.hasIGD[i]) continue;
            int igdType = this.igdTypes[i];
            for (IGDScheme scheme : this.ws.getIGDSchemes(igdType)) {
                this.model.list.add(scheme);
                scheme.addObserver((Observer)this);
                scheme.updateStatus();
            }
        }
        this.sorterUnits.reallocateIndexes();
        this.sorter.reallocateIndexes();
        this.backgroundImage = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/MatchBG.png"));
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(DialogMatchIGD.this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonSelectScheme = new JButton();
        this.jButtonMatchScheme = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jScrollPane2 = new JScrollPane();
        this.jTableMatchIGD = new JTable();
        this.jButtonAddScheme = new JButton();
        this.jButtonMatchAll = new JButton();
        this.jButtonCreatePicks = new JButton();
        this.jButtonFindScheme = new JButton();
        this.jButtonShowInformal = new JButton();
        this.jButtonExclude = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(600, 300));
        this.setModal(true);
        this.jButtonOK.setText("OK");
        this.jButtonOK.setToolTipText("Commit matches to well data");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchIGD.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchIGD.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setToolTipText("Schemes and units will not be unmatched");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchIGD.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonSelectScheme.setText("Select Scheme...");
        this.jButtonSelectScheme.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonSelectScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchIGD.this.jButtonSelectSchemeActionPerformed(evt);
            }
        });
        this.jButtonMatchScheme.setText("Match Scheme...");
        this.jButtonMatchScheme.setToolTipText("Match full scheme (not necessary for import of well data)");
        this.jButtonMatchScheme.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonMatchScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchIGD.this.jButtonMatchSchemeActionPerformed(evt);
            }
        });
        this.jLabel1.setFont(new Font("Tahoma", 1, 13));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(new Font("Tahoma", 1, 13));
        this.jLabel2.setText("...Database");
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.4);
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jSplitPane1.setBottomComponent(this.jScrollPane1);
        this.jScrollPane2.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jTableMatchIGD.setModel((TableModel)this.sorter);
        this.jTableMatchIGD.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogMatchIGD.this.jTableMatchIGDMouseClicked(evt);
            }
        });
        this.jTableMatchIGD.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DialogMatchIGD.this.jTableMatchIGDKeyReleased(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTableMatchIGD);
        this.jSplitPane1.setLeftComponent(this.jScrollPane2);
        this.jButtonAddScheme.setText("Add Scheme...");
        this.jButtonAddScheme.setToolTipText("Add selected workspace scheme to database");
        this.jButtonAddScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchIGD.this.jButtonAddSchemeActionPerformed(evt);
            }
        });
        this.jButtonMatchAll.setText("Match all");
        this.jButtonMatchAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchIGD.this.jButtonMatchAllActionPerformed(evt);
            }
        });
        this.jButtonCreatePicks.setText("Create picks");
        this.jButtonCreatePicks.setToolTipText("Create surfaces and picks from selected interval data");
        this.jButtonCreatePicks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchIGD.this.jButtonCreatePicksActionPerformed(evt);
            }
        });
        this.jButtonFindScheme.setText("Suggest scheme...");
        this.jButtonFindScheme.setToolTipText("Find schemes which contains the most likely unit matches ");
        this.jButtonFindScheme.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonFindScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchIGD.this.jButtonFindSchemeActionPerformed(evt);
            }
        });
        this.jButtonShowInformal.setText("Show informal...");
        this.jButtonShowInformal.setToolTipText("Show all the informal terms linked to scheme");
        this.jButtonShowInformal.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonShowInformal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchIGD.this.jButtonShowInformalActionPerformed(evt);
            }
        });
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.setToolTipText("Exclude scheme and associated intervals from the workspace");
        this.jButtonExclude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchIGD.this.jButtonExcludeActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 499, Short.MAX_VALUE).addComponent(this.jLabel2)).addComponent(this.jSplitPane1, -1, 657, Short.MAX_VALUE)).addGap(12, 12, 12).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonMatchAll, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonSelectScheme, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonFindScheme, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonShowInformal, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonMatchScheme, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonAddScheme, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonCreatePicks, GroupLayout.Alignment.TRAILING, 0, 0, Short.MAX_VALUE).addComponent(this.jButtonExclude, GroupLayout.Alignment.TRAILING, -2, 113, -2).addComponent(this.jButtonOK, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonHelp, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonCancel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.linkSize(0, this.jButtonAddScheme, this.jButtonCancel, this.jButtonCreatePicks, this.jButtonExclude, this.jButtonFindScheme, this.jButtonHelp, this.jButtonMatchAll, this.jButtonMatchScheme, this.jButtonOK, this.jButtonSelectScheme, this.jButtonShowInformal);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addGap(12, 12, 12).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonMatchAll).addGap(4, 4, 4).addComponent(this.jButtonSelectScheme).addGap(4, 4, 4).addComponent(this.jButtonFindScheme).addGap(4, 4, 4).addComponent(this.jButtonShowInformal).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonMatchScheme).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAddScheme).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCreatePicks).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonExclude).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 157, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jSplitPane1, GroupLayout.Alignment.LEADING, -1, 463, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogmatchigd.html");
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String msg;
        boolean hasSchemeConflicts = false;
        boolean hasUnmatched = false;
        boolean hasUnmatchedPicks = false;
        block8: for (IGDScheme scheme : this.model.list) {
            if (scheme.getLink() == null) {
                JOptionPane.showMessageDialog(this, "Not all workspace schemes are linked to database schemes.\nYou need to select a scheme from the database to be assigned to the workspace intervals, or Exclude the scheme.", this.getTitle(), 2);
                return;
            }
            if (scheme.getStatus() == IGDScheme.CONFLICT) {
                hasSchemeConflicts = true;
            }
            try {
                Iterator it = this.ws.getProject(0).getWellIterator();
                while (it.hasNext()) {
                    Well well = (Well)it.next();
                    Iterator iit = well.getInterpIterator();
                    while (iit.hasNext()) {
                        WellInterp interp = (WellInterp)iit.next();
                        if (scheme.getIGDType() == 10) {
                            List picks = interp.getSQPicks();
                            for (SQPick pick : picks) {
                                Surface s = pick.getSurface();
                                if (s.getLink() != null) continue;
                                hasUnmatchedPicks = true;
                                continue block8;
                            }
                            continue;
                        }
                        List zones = interp.getIGDList(scheme.getIGDType(), scheme.getID());
                        for (IGDIntervalZone zone : zones) {
                            if (zone.getUppZone() > 0 && scheme.findUnit(zone.getUppZone()).getLink() == null) {
                                hasUnmatched = true;
                                continue block8;
                            }
                            if (zone.getLowZone() <= 0 || scheme.findUnit(zone.getLowZone()) == null || scheme.findUnit(zone.getLowZone()).getLink() != null) continue;
                            hasUnmatched = true;
                        }
                    }
                }
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error checking matches", sql, this.db);
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error checking matches", (Exception)((Object)sbe));
            }
            catch (RuntimeException re) {
                SB.showStackError((String)"", (Exception)re);
            }
        }
        if (hasSchemeConflicts) {
            msg = "Warning: some matched schemes have conflicting attributes.\nThe workspace units/surfaces will be replaced by the database units/surfaces.\nInterpreted interval and sequence pick names will be updated as appropriate.";
            System.out.println(msg);
        }
        if (hasUnmatched || hasUnmatchedPicks) {
            int opt;
            msg = "";
            if (hasUnmatched) {
                msg = msg + "Warning: There are unmatched units in the workspace.\nIntervals linked to unmatched units will be imported with an informal name only.";
            }
            if (hasUnmatchedPicks) {
                if (!msg.isEmpty()) {
                    msg = msg + "\n";
                }
                msg = msg + "Warning: There are unmatched sequence picks in the workspace.\nAll picks linked to unmatched surfaces will be EXCLUDED from the well data imported.";
            }
            if ((opt = JOptionPane.showConfirmDialog(this, msg = msg + "\nContinue?", this.getTitle(), 0, 3)) != 0) {
                return;
            }
        }
        try {
            int potential;
            String msg2;
            int opt;
            int nHierReassign = this.assignDbHier(false);
            if (nHierReassign > 0 && (opt = JOptionPane.showConfirmDialog(this, msg2 = "There are " + nHierReassign + " linked intervals whose hierarchy level does not match the level of the linked unit." + "\nReassign interval hierarchy levels to match scheme hierarchy? (Recommended, but may cause conflicts with overlapping intervals)", this.getTitle(), 0, 3)) == 0) {
                this.assignDbHier(true);
            }
            int killedPicks = this.saveSurfaces();
            int informalResult = 0;
            boolean hasInformal = false;
            for (IGDScheme scheme : this.model.list) {
                if (this.getInformals(scheme).isEmpty()) continue;
                hasInformal = true;
                break;
            }
            if (hasInformal && (potential = this.linkInformals(false)) > 0) {
                informalResult = this.linkInformals(true);
            }
            int zonesResult = this.saveUnits();
            String msg3 = "";
            if (killedPicks > 0) {
                msg3 = msg3 + "Picks deleted: " + killedPicks;
            }
            if (zonesResult > 0) {
                if (!msg3.isEmpty()) {
                    msg3 = msg3 + "\n";
                }
                msg3 = msg3 + "Intervals updated: " + zonesResult;
            }
            if (informalResult > 0) {
                if (!msg3.isEmpty()) {
                    msg3 = msg3 + "\n";
                }
                msg3 = msg3 + "(Scheme updated in workspace with: " + informalResult + "units)";
            }
            if (!msg3.isEmpty()) {
                JOptionPane.showMessageDialog(this, msg3, this.getTitle(), 1);
            }
            this.isOK = true;
            this.dispose();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private int saveSurfaces() throws SQLException, SBException {
        Iterator it = this.ws.getProject(0).getWellIterator();
        LinkedList<SQPick> toKill = new LinkedList<SQPick>();
        int nDeleted = 0;
        while (it.hasNext()) {
            Well well = (Well)it.next();
            Iterator iit = well.getInterpIterator();
            while (iit.hasNext()) {
                WellInterp interp = (WellInterp)iit.next();
                toKill.clear();
                for (SQPick pick : interp.getSQPicks()) {
                    if (pick.getSurface().getLink() == null) {
                        toKill.add(pick);
                        continue;
                    }
                    if (pick.getInfName() == null || pick.getInfName().isEmpty() || !pick.getInfName().equals(pick.getSurface().getName())) continue;
                    pick.setInfName(pick.getSurface().getLink().getName());
                }
                nDeleted += toKill.size();
                for (SQPick kill : toKill) {
                    interp.deleteSQPick(kill, 0);
                }
            }
        }
        for (IGDScheme scheme : this.model.list) {
            if (scheme.getIGDType() == 10) {
                for (Surface surface : scheme.getSurfaces()) {
                    if (surface.getLink() == null || surface.getStatus() != SbugsStatus.CONFLICT) continue;
                    surface.copyLink();
                }
            }
            scheme.updateStatus();
        }
        return nDeleted;
    }

    @Override
    public void update(Observable o, Object arg) {
        int row = this.jTableMatchIGD.getSelectedRow();
        this.sorter.fireTableDataChanged();
        this.sorter.reallocateIndexes();
        if (row > -1) {
            this.jTableMatchIGD.setRowSelectionInterval(this.sorter.getIndexOf(row), this.sorter.getIndexOf(row));
        }
    }

    private int saveUnits() throws SQLException, SBException {
        int nUpdated = 0;
        for (IGDScheme scheme : this.model.list) {
            if (scheme.getIGDType() == 10) continue;
            for (IGDUnit unit : scheme.getUnits()) {
                if (unit.getLink() == null || unit.getStatus() != SbugsStatus.CONFLICT) continue;
                if (!unit.getName().equalsIgnoreCase(unit.getLink().getName())) {
                    Iterator pit = this.ws.getProject(0).getWellIterator();
                    while (pit.hasNext()) {
                        Well well = (Well)pit.next();
                        Iterator wit = well.getInterpIterator();
                        while (wit.hasNext()) {
                            WellInterp interp = (WellInterp)wit.next();
                            for (IGDIntervalZone zone : interp.getIGDList(scheme.getIGDType(), scheme.getID())) {
                                boolean updated = false;
                                if (zone.getUppZone() == unit.getUnitID() && zone.getUppInf().equals(unit.getName())) {
                                    zone.setUppInf(unit.getLink().getName());
                                    updated = true;
                                }
                                if (zone.getLowZone() == unit.getUnitID() && zone.getLowInf().equals(unit.getName())) {
                                    zone.setLowInf(unit.getLink().getName());
                                    updated = true;
                                }
                                if (!updated) continue;
                                ++nUpdated;
                            }
                        }
                    }
                }
                unit.copyLink();
            }
            scheme.updateStatus();
        }
        return nUpdated;
    }

    private int assignDbHier(boolean assign) throws SQLException, SBException {
        int nToBeUpdated = 0;
        for (int igdType : this.igdTypes) {
            if (igdType == 10) continue;
            Iterator it = this.ws.getProject(0).getWellIterator();
            while (it.hasNext()) {
                Well well = (Well)it.next();
                Iterator iit = well.getInterpIterator();
                while (iit.hasNext()) {
                    WellInterp interp = (WellInterp)iit.next();
                    List igdList = interp.getIGDList(igdType);
                    for (IGDIntervalZone zone : igdList) {
                        IGDUnit unit;
                        int uppUnit;
                        IGDUnit unit2;
                        if (zone.getSchID() <= 0) continue;
                        IGDScheme scheme = this.ws.getIGDScheme(zone.getSchID());
                        int lowUnit = zone.getLowZone();
                        if (lowUnit > 0 && lowUnit != zone.getUppZone() && (unit2 = scheme.findUnit(lowUnit)) != null && unit2.getLink() != null && unit2.getLink().getHier() != zone.getHier()) {
                            if (assign) {
                                zone.setHier(unit2.getLink().getHier());
                            } else {
                                ++nToBeUpdated;
                            }
                        }
                        if ((uppUnit = zone.getUppZone()) <= 0 || (unit = scheme.findUnit(uppUnit)) == null || unit.getLink() == null || unit.getLink().getHier() == zone.getHier()) continue;
                        if (assign) {
                            zone.setHier(unit.getLink().getHier());
                            continue;
                        }
                        ++nToBeUpdated;
                    }
                }
            }
        }
        return nToBeUpdated;
    }

    private int linkInformals(boolean doIt) throws SQLException, SBException {
        int added = 0;
        for (IGDScheme scheme : this.model.list) {
            if (scheme.getIGDType() == 10) continue;
            for (IGDIntervalZone informal : this.getInformals(scheme)) {
                IGDUnit linkUnit = null;
                if (informal.getUppZone() == 0) {
                    linkUnit = scheme.getLink().findUnit(informal.getUppInf());
                    if (linkUnit == null && informal.getUppInf().split(" ").length > 1) {
                        for (String split : informal.getUppInf().split(" ")) {
                            linkUnit = scheme.getLink().findUnit(split);
                            if (linkUnit != null) break;
                        }
                    }
                    if (linkUnit != null) {
                        if (doIt) {
                            IGDUnit wsUnit = scheme.findUnit(linkUnit.getName());
                            if (wsUnit == null) {
                                try {
                                    wsUnit = scheme.addUnit(IGDUnit.Builder.copyOf((IGDUnit)linkUnit, (SBdb)this.ws));
                                }
                                catch (InvalidFieldException ife) {
                                    ife.printStackTrace();
                                }
                            }
                            wsUnit.setLink(linkUnit);
                            informal.setUppZone(wsUnit.getUnitID());
                            if (informal.getLowZone() == 0 || scheme.findUnit(informal.getLowZone()).getHier() < wsUnit.getHier()) {
                                informal.setHier(wsUnit.getHier());
                            }
                        }
                        ++added;
                    }
                }
                if (informal.getLowZone() != 0 || informal.getLowInf() == null || informal.getLowInf().isEmpty()) continue;
                boolean addedUpper = linkUnit != null;
                linkUnit = scheme.getLink().findUnit(informal.getLowInf());
                if (linkUnit == null && informal.getLowInf().split(" ").length > 1) {
                    for (String split : informal.getLowInf().split(" ")) {
                        linkUnit = scheme.getLink().findUnit(split);
                        if (linkUnit != null) break;
                    }
                }
                if (linkUnit == null) continue;
                if (doIt) {
                    IGDUnit wsUnit = scheme.findUnit(linkUnit.getName());
                    if (wsUnit == null) {
                        try {
                            wsUnit = scheme.addUnit(IGDUnit.Builder.copyOf((IGDUnit)linkUnit, (SBdb)this.ws));
                        }
                        catch (InvalidFieldException ife) {
                            ife.printStackTrace();
                        }
                    }
                    wsUnit.setLink(linkUnit);
                    informal.setLowZone(wsUnit.getUnitID());
                    if (informal.getUppZone() == 0 || scheme.findUnit(informal.getUppZone()).getHier() < wsUnit.getHier()) {
                        informal.setHier(wsUnit.getHier());
                    }
                }
                if (addedUpper) continue;
                ++added;
            }
        }
        return added;
    }

    private void jTableMatchIGDMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonSelectSchemeActionPerformed(null);
        }
        this.setTable();
    }

    private void setTable() {
        IGDScheme scheme = this.model.list.get(this.sorter.getIndexOf(this.jTableMatchIGD.getSelectedRow()));
        try {
            if (scheme.getIGDType() == 10) {
                if (this.jScrollPane1.getViewport().getView() == this.tableUnits) {
                    this.jScrollPane1.remove(this.tableUnits);
                    this.jScrollPane1.add(this.tableSurfaces);
                    this.jScrollPane1.setViewportView(this.tableSurfaces);
                }
                this.modelSurfaces.setSurfaces(scheme, this.ws);
                this.fillSurfaceCombo(scheme);
                this.modelSurfaces.fireTableDataChanged();
            } else {
                if (this.jScrollPane1.getViewport().getView() == this.tableSurfaces) {
                    this.jScrollPane1.remove(this.tableSurfaces);
                    this.jScrollPane1.add(this.tableUnits);
                    this.jScrollPane1.setViewportView(this.tableUnits);
                }
                this.modelUnits.setUnits(this, scheme, this.ws);
                this.fillUnitsCombo(scheme);
                this.sorterUnits.reallocateIndexes();
                this.sorterUnits.fireTableDataChanged();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error: " + e.getMessage(), this.getTitle(), 0);
        }
    }

    private void fillSurfaceCombo(IGDScheme scheme) throws SQLException, SBException {
        this.surfaceComboBox.removeAllItems();
        if (scheme.getLink() != null) {
            this.surfaceComboBox.addItem(null);
            for (Surface surface : scheme.getLink().getSurfaces()) {
                this.surfaceComboBox.addItem(surface);
            }
        }
    }

    private void fillUnitsCombo(IGDScheme scheme) throws SQLException, SBException {
        this.unitsComboBox.removeAllItems();
        if (scheme.getLink() != null) {
            this.unitsComboBox.addItem(null);
            for (IGDUnit unit : scheme.getLink().getUnits()) {
                this.unitsComboBox.addItem(unit);
            }
        }
    }

    private void jButtonMatchSchemeActionPerformed(ActionEvent evt) {
        if (this.jTableMatchIGD.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "No scheme selected", this.getTitle(), 2);
            return;
        }
        IGDScheme scheme = this.model.list.get(this.sorter.getIndexOf(this.jTableMatchIGD.getSelectedRow()));
        int n = 0;
        if (scheme.getIGDType() == 10) {
            for (Surface surface : this.modelSurfaces.surfaces) {
                if (surface.getLink() == null || surface.getLink().getName().equalsIgnoreCase(surface.getName())) continue;
                ++n;
            }
        } else {
            for (IGDUnit u : this.modelUnits.list) {
                if (u.getLink() == null || u.getLink().getName().equalsIgnoreCase(u.getName())) continue;
                ++n;
            }
        }
        if (n > 0) {
            String msg = "There are " + n + " workspace " + (scheme.getIGDType() == 10 ? "surfaces" : "units") + " which have been manually linked.";
            if (JOptionPane.showConfirmDialog(this, msg = msg + "\nThese links will be reset. Continue?", "Match Schemes", 0) != 0) {
                return;
            }
        }
        try {
            scheme.updateStatus();
            DialogMatchIGDScheme dialog = new DialogMatchIGDScheme((Dialog)this, true, scheme, this.db);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (scheme.getIGDType() == 10) {
                this.fillSurfaceCombo(scheme);
                this.modelSurfaces.fireTableDataChanged();
            } else {
                this.fillUnitsCombo(scheme);
                this.sorterUnits.fireTableDataChanged();
            }
            this.sorter.fireTableDataChanged();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonSelectSchemeActionPerformed(ActionEvent evt) {
        if (this.jTableMatchIGD.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Choose a scheme from the workspace list", this.getTitle(), 2);
            return;
        }
        try {
            int row = this.jTableMatchIGD.getSelectedRow();
            IGDScheme scheme = this.model.list.get(this.sorter.getIndexOf(row));
            DialogSelectScheme dialog = new DialogSelectScheme(this, true, this.db, scheme.getIGDType(), null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                IGDScheme origLink = scheme.getLink();
                if (dialog.selection != origLink) {
                    scheme.setLink(dialog.selection);
                    this.setTable();
                    if (scheme.getIGDType() == 10) {
                        this.modelSurfaces.linkSurfaces(scheme);
                        this.fillSurfaceCombo(scheme);
                    } else {
                        this.modelUnits.linkUnits(scheme);
                        this.fillUnitsCombo(scheme);
                    }
                    this.sorter.fireTableDataChanged();
                    this.sorter.reallocateIndexes();
                }
                this.jTableMatchIGD.setRowSelectionInterval(row, row);
            }
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error selecting scheme", (Exception)((Object)sbe));
            sbe.printStackTrace();
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
            sql.printStackTrace();
        }
    }

    private void jTableMatchIGDKeyReleased(KeyEvent evt) {
        if (this.jTableMatchIGD.getSelectedRowCount() != 1) {
            return;
        }
        this.setTable();
    }

    private void jButtonAddSchemeActionPerformed(ActionEvent evt) {
        if (this.jTableMatchIGD.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "No scheme selected", this.getTitle(), 2);
            return;
        }
        IGDScheme scheme = this.model.list.get(this.sorter.getIndexOf(this.jTableMatchIGD.getSelectedRow()));
        try {
            DialogIGDScheme dialog = new DialogIGDScheme(this, true, this.db, scheme, scheme.getIGDType());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                scheme.setLink(dialog.schemeAdded);
                this.setTable();
                if (scheme.getIGDType() == 10) {
                    this.modelSurfaces.linkSurfaces(scheme);
                    this.fillSurfaceCombo(scheme);
                } else {
                    this.modelUnits.linkUnits(scheme);
                    this.fillUnitsCombo(scheme);
                }
                this.sorter.fireTableDataChanged();
                this.sorter.reallocateIndexes();
            }
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonMatchAllActionPerformed(ActionEvent evt) {
        try {
            for (int igdType : this.igdTypes) {
                for (IGDScheme scheme : this.ws.getIGDSchemes(igdType)) {
                    if (scheme.getLink() != null) continue;
                    for (IGDScheme dbScheme : this.db.getIGDSchemes(igdType)) {
                        if (!dbScheme.toString().equals(scheme.toString())) continue;
                        scheme.setLink(dbScheme);
                        scheme.updateStatus();
                        if (igdType == 10) {
                            this.modelSurfaces.setSurfaces(scheme, this.ws);
                            this.modelSurfaces.linkSurfaces(scheme);
                            continue;
                        }
                        this.modelUnits.setUnits(this, scheme, this.ws);
                        this.modelUnits.linkUnits(scheme);
                    }
                }
            }
            this.modelSurfaces.fireTableDataChanged();
            this.sorterUnits.reallocateIndexes();
            this.sorterUnits.fireTableDataChanged();
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
        }
        catch (Exception ex) {
            SB.showStackError(null, (Exception)ex);
            ex.printStackTrace();
        }
    }

    private void jButtonCreatePicksActionPerformed(ActionEvent evt) {
        if (this.jTableMatchIGD.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "No scheme selected", this.getTitle(), 2);
            return;
        }
        int row = this.jTableMatchIGD.getSelectedRow();
        IGDScheme oldScheme = this.model.list.get(this.sorter.getIndexOf(this.jTableMatchIGD.getSelectedRow()));
        String msg = "This option will change the selected scheme to a sequence scheme, and a series of surfaces and picks will replace the intervals in the workspace.\nWhere the interval has a sample range, the top sample will be used as the picked sample.\nContinue?";
        if (JOptionPane.showConfirmDialog(this, msg, this.getTitle(), 0, 3) != 0) {
            return;
        }
        try {
            oldScheme.setLink(null);
            oldScheme.updateStatus();
            this.ws.getIGDSchemes(oldScheme.getIGDType()).remove(oldScheme);
            IGDScheme scheme = IGDScheme.copyToSequence((SBdb)this.ws, (IGDScheme)oldScheme);
            this.ws.addIGDScheme(scheme);
            int nPicks = 0;
            int nonInserts = 0;
            Iterator it = this.ws.getProject(0).getWellIterator();
            while (it.hasNext()) {
                WsWell well = (WsWell)it.next();
                Iterator iit = well.getInterpIterator();
                while (iit.hasNext()) {
                    WellInterp interp = (WellInterp)iit.next();
                    List igdList = interp.getIGDList(oldScheme.getIGDType());
                    Iterator it2 = igdList.iterator();
                    while (it2.hasNext()) {
                        int uppUnit;
                        IGDIntervalZone zone = (IGDIntervalZone)it2.next();
                        if (zone.getSchID() != scheme.getID()) continue;
                        int lowUnit = zone.getLowZone();
                        if (lowUnit > 0 && lowUnit != zone.getUppZone()) {
                            System.out.println("Need to create lower pick for: " + zone.getLowInf());
                            IGDUnit unit = scheme.findUnit(lowUnit);
                            Surface surface = scheme.getSurface(zone.getLowInf());
                            try {
                                if (surface == null) {
                                    surface = scheme.addSurface(new Surface.Builder(scheme.getDatabase()).name(zone.getLowInf()).age(unit != null ? unit.getLage() : 0.0).type(Surface.SurfaceType.parseType((String)zone.getLowInf(), (Surface.SurfaceType)Surface.SurfaceType.MFS)));
                                }
                                interp.addSQPick((Well)well, zone.getBaseSample(), surface, zone.getLowInf(), zone.getQLzone(), zone.getBaseBnd());
                                ++nPicks;
                            }
                            catch (InvalidFieldException se) {
                                System.out.println("Non-insertion of: " + zone.getUppInf() + ": " + se.getMessage());
                                ++nonInserts;
                            }
                        }
                        if ((uppUnit = zone.getUppZone()) > 0) {
                            IGDUnit unit = scheme.findUnit(uppUnit);
                            Surface surface = scheme.getSurface(zone.getUppInf());
                            try {
                                if (surface == null) {
                                    surface = scheme.addSurface(new Surface.Builder(scheme.getDatabase()).name(zone.getUppInf()).age(unit != null ? unit.getUage() : 0.0).type(Surface.SurfaceType.parseType((String)zone.getUppInf(), (Surface.SurfaceType)Surface.SurfaceType.MFS)));
                                }
                                interp.addSQPick((Well)well, zone.getTopSample(), surface, zone.getUppInf(), zone.getQUzone(), zone.getTopBnd());
                                ++nPicks;
                            }
                            catch (InvalidFieldException se) {
                                System.out.println("Non-insertion of: " + zone.getUppInf() + ": " + se.getMessage());
                                ++nonInserts;
                            }
                        }
                        it2.remove();
                    }
                    interp.updateSQPickStatus(well.getMonitor(interp.getHeader().getInterpID(), 14), (Well)well, well.getWellUnits());
                }
            }
            msg = "Number of picks created: " + nPicks;
            if (nonInserts > 0) {
                msg = msg + "\nNumber of non-inserts (due to overlaps or other errors: " + nonInserts;
            }
            JOptionPane.showMessageDialog(this, msg, this.getTitle(), 1);
            if (nPicks > 0 || nonInserts > 0) {
                this.model.list.remove(oldScheme);
                this.model.list.add(scheme);
                this.sorter.reallocateIndexes();
                this.sorter.fireTableDataChanged();
                this.jTableMatchIGD.setRowSelectionInterval(row, row);
                this.setTable();
                if (!this.frameOrganiser.dataTypes.contains(14)) {
                    this.frameOrganiser.dataTypes.add(14);
                }
                if (this.model.list.isEmpty()) {
                    this.dispose();
                }
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonFindSchemeActionPerformed(ActionEvent evt) {
        if (this.jTableMatchIGD.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "No scheme selected", this.getTitle(), 2);
            return;
        }
        int row = this.jTableMatchIGD.getSelectedRow();
        IGDScheme scheme = this.model.list.get(this.sorter.getIndexOf(row));
        try {
            if (scheme.getIGDType() == 10) {
                List matches = scheme.findMatches(this.db);
                if (matches == null || matches.isEmpty()) {
                    JOptionPane.showMessageDialog(this, "There are no schemes of the type which contain any units with matching names", this.getTitle(), 1);
                    return;
                }
                DialogMatchIGDSuggestions dialog = new DialogMatchIGDSuggestions(this, true, matches, 0);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.selection != null) {
                    IGDScheme origLink = scheme.getLink();
                    if (dialog.selection != origLink) {
                        scheme.setLink(dialog.selection);
                        this.setTable();
                        this.modelSurfaces.linkSurfaces(scheme);
                        this.fillSurfaceCombo(scheme);
                        this.sorter.fireTableDataChanged();
                        this.sorter.reallocateIndexes();
                    }
                    this.jTableMatchIGD.setRowSelectionInterval(row, row);
                }
            } else {
                List<IGDIntervalZone> informals = this.getInformals(scheme);
                List matches = scheme.findMatches(this.db, informals);
                if (matches == null || matches.isEmpty()) {
                    JOptionPane.showMessageDialog(this, "There are no schemes of the type which contain any units with matching names", this.getTitle(), 1);
                    return;
                }
                DialogMatchIGDSuggestions dialog = new DialogMatchIGDSuggestions(this, true, matches, informals.size());
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.selection != null) {
                    IGDScheme origLink = scheme.getLink();
                    if (dialog.selection != origLink) {
                        scheme.setLink(dialog.selection);
                        this.setTable();
                        this.modelUnits.linkUnits(scheme);
                        this.fillUnitsCombo(scheme);
                        this.sorter.fireTableDataChanged();
                        this.sorter.reallocateIndexes();
                    }
                    this.jTableMatchIGD.setRowSelectionInterval(row, row);
                }
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonShowInformalActionPerformed(ActionEvent evt) {
        if (this.jTableMatchIGD.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "No scheme selected", this.getTitle(), 2);
            return;
        }
        IGDScheme scheme = this.model.list.get(this.sorter.getIndexOf(this.jTableMatchIGD.getSelectedRow()));
        try {
            if (scheme.getIGDType() == 10) {
                JOptionPane.showMessageDialog(this, "You can't have informal picks in sequence schemes.", this.getTitle(), 1);
            } else {
                List<IGDIntervalZone> informals = this.getInformals(scheme);
                if (!informals.isEmpty()) {
                    DialogList dialog = new DialogList(this.frameOrganiser, true, "Informal units of: " + scheme.toString(), this.db, informals, false, false);
                    dialog.setLocation(this.getLocation().x + this.getBounds().width, this.getLocation().y);
                    dialog.setVisible(true);
                } else {
                    JOptionPane.showMessageDialog(this, "There are no informal terms of scheme: " + scheme.toString(), this.getTitle(), 1);
                }
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        if (this.jTableMatchIGD.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "No scheme selected", this.getTitle(), 2);
            return;
        }
        IGDScheme scheme = this.model.list.get(this.sorter.getIndexOf(this.jTableMatchIGD.getSelectedRow()));
        int opt = JOptionPane.showConfirmDialog(this, "Exclude '" + scheme.toString() + "' and all associated intervals/picks (formal and informal) from the workspace?", this.getTitle(), 0, 3);
        if (opt != 0) {
            return;
        }
        try {
            Iterator it = this.ws.getProject(0).getWellIterator();
            while (it.hasNext()) {
                WsWell well = (WsWell)it.next();
                Iterator iit = well.getInterpIterator();
                while (iit.hasNext()) {
                    Iterator list;
                    WellInterp wellInterp = (WellInterp)iit.next();
                    if (scheme.getIGDType() == 10) {
                        list = wellInterp.getSQPicks().iterator();
                        while (list.hasNext()) {
                            SQPick pick = (SQPick)list.next();
                            if (pick.getSurface().getSchID() != scheme.getID()) continue;
                            list.remove();
                        }
                    } else {
                        list = wellInterp.getIGDList(scheme.getIGDType()).iterator();
                        while (list.hasNext()) {
                            IGDIntervalZone zone = (IGDIntervalZone)list.next();
                            if (zone.getSchID() != scheme.getID()) continue;
                            list.remove();
                        }
                    }
                    LinkedList<Integer> dType = new LinkedList<Integer>();
                    dType.add(new Integer(IGDInterval.igdType2dType((int)scheme.getIGDType())));
                    if (scheme.getIGDType() == 10) {
                        dType.add(14);
                    }
                    well.resetInterpDataMonitors(dType, wellInterp.getHeader().getInterpID());
                }
            }
            this.ws.deleteIGDScheme(scheme);
            this.model.list.remove(scheme);
            this.modelUnits.list.clear();
            this.sorterUnits.reallocateIndexes();
            this.sorterUnits.fireTableDataChanged();
            this.modelSurfaces.surfaces.clear();
            this.modelSurfaces.fireTableDataChanged();
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private List<IGDIntervalZone> getInformals(IGDScheme scheme) throws SQLException, SBException {
        LinkedList<IGDIntervalZone> informals = new LinkedList<IGDIntervalZone>();
        Iterator wells = this.ws.getProject(0).getWellIterator();
        while (wells.hasNext()) {
            Well well = (Well)wells.next();
            Iterator it = well.getInterpIterator();
            while (it.hasNext()) {
                WellInterp wellInterp = (WellInterp)it.next();
                List zones = wellInterp.getIGDList(scheme.getIGDType(), scheme.getID());
                if (zones == null) continue;
                for (IGDIntervalZone zone : zones) {
                    if ((zone.getUppInf() == null || zone.getUppInf().length() <= 0 || zone.getUppZone() != 0) && (zone.getLowInf() == null || zone.getLowInf().length() <= 0 || zone.getLowZone() != 0)) continue;
                    informals.add(zone);
                }
            }
        }
        return informals;
    }
}

