/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import jsbugs.DialogFilePreviewSelect;
import jsbugs.DialogSelectScheme;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelMatchIGDInterval;
import model2.IGDInterval;
import model2.IGDIntervalZone;
import model2.IGDScheme;
import model2.IGDUnit;
import model2.InterpHdr;
import model2.Lastval;
import model2.SBdb;
import model2.Sample;
import model2.Userdef;
import model2.Well;
import model2.WellInterp;
import model2.WsWell;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.MatchData;
import util.SB;
import util.SBException;
import util.SbugsFileFilter;
import util.TableSorter;

public class DialogMatchIGDIntervals
extends JDialog {
    TableModelMatchIGDInterval model = new TableModelMatchIGDInterval();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    Image backgroundImage;
    InterpHdr hdr;
    SBdb wsDB;
    SBdb dbDB;
    private JButton jButton1;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonExclude;
    private JButton jButtonRead;
    private JButton jButtonSave;
    private JButton jButtonSaveSelected;
    private JInternalFrame jInternalFrame1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JTable jTableMatchIGDIntervals;

    public DialogMatchIGDIntervals(Frame parent, boolean modal, SBdb ws, SBdb db, WsWell well, char units, InterpHdr hdr, int igdType) throws SQLException, SBException {
        super(parent, modal);
        this.model.wsWell = well;
        this.hdr = hdr;
        this.model.igdType = igdType;
        this.model.units = units;
        this.wsDB = ws;
        this.dbDB = db;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Match Stratigraphic Intervals for : " + this.model.wsWell);
        this.getRootPane().setDefaultButton(this.jButtonCancel);
        if (this.model.wsWell.hasInterpLoaded(this.hdr.getInterpID())) {
            this.model.wsInterp = this.model.wsWell.getInterp(this.hdr.getInterpID());
        }
        if (this.model.wsWell.getLink() != null && this.hdr.getLink() != null && this.model.wsWell.getLink().hasInterpLoaded(this.hdr.getLink().getInterpID())) {
            this.model.dbInterp = this.model.wsWell.getLink().getInterp(this.hdr.getLink().getInterpID());
            this.model.wsWell.getLink().loadInterp(this.model.dbInterp);
        }
        this.checkLinks();
        this.model.data.init(this.model.wsInterp != null ? this.model.wsInterp.getIGDList(this.model.igdType, 0) : null, this.model.dbInterp != null ? this.model.dbInterp.getIGDList(this.model.igdType, 0) : null);
        this.model.setUpTable(this.jTableMatchIGDIntervals);
        this.sorter.addMouseListenerToHeaderInTable(this.jTableMatchIGDIntervals);
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
        this.backgroundImage = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/MatchBG.png"));
    }

    private void checkLinks() throws SQLException, SBException {
        if (this.model.wsWell.getLink() != null) {
            for (InterpHdr interpHdr : this.wsDB.getInterps()) {
                if (interpHdr.getLink() != null) continue;
                throw new SBException("Cannot open dialog, Versions not Matched");
            }
            for (IGDIntervalZone zone : this.model.wsInterp.getIGDList(this.model.igdType, 0)) {
                if (zone.getSchID() <= 0) continue;
                if (this.wsDB.getIGDScheme(zone.getSchID()) == null) {
                    throw new SBException("Cannot open dialog, Stratigraphic Scheme(s) missing from workspace in workspace interval(s).\nScheme ID=" + zone.getSchID() + ", interval=" + zone.toString());
                }
                if (this.wsDB.getIGDScheme(zone.getSchID()).getLink() != null) continue;
                throw new SBException("Cannot open dialog, Stratigraphic Schemes not Matched");
            }
        }
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jInternalFrame1 = new JInternalFrame();
        this.jPanel1 = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(DialogMatchIGDIntervals.this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane2 = new JScrollPane();
        this.jTableMatchIGDIntervals = new JTable();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonCancel = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonExclude = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonRead = new JButton();
        this.jButtonSaveSelected = new JButton();
        this.jButton1.setText("jButton1");
        this.jInternalFrame1.setVisible(true);
        GroupLayout jInternalFrame1Layout = new GroupLayout(this.jInternalFrame1.getContentPane());
        this.jInternalFrame1.getContentPane().setLayout((LayoutManager)jInternalFrame1Layout);
        jInternalFrame1Layout.setHorizontalGroup((GroupLayout.Group)jInternalFrame1Layout.createParallelGroup(1).add(0, 0, Short.MAX_VALUE));
        jInternalFrame1Layout.setVerticalGroup((GroupLayout.Group)jInternalFrame1Layout.createParallelGroup(1).add(0, 0, Short.MAX_VALUE));
        this.setDefaultCloseOperation(2);
        this.setBackground(Color.lightGray);
        this.setMinimumSize(new Dimension(600, 300));
        this.setModal(true);
        this.jScrollPane2.setViewportBorder(BorderFactory.createLineBorder(new Color(255, 255, 255)));
        this.jTableMatchIGDIntervals.setModel((TableModel)this.sorter);
        this.jScrollPane2.setViewportView(this.jTableMatchIGDIntervals);
        this.jLabel1.setFont(new Font("Tahoma", 1, 13));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(new Font("Tahoma", 1, 13));
        this.jLabel2.setText("...Database");
        this.jButtonCancel.setText("Close");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchIGDIntervals.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.setToolTipText("Save ALL unsaved intervals from workspace into database");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchIGDIntervals.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setToolTipText("Delete selected intervals from database");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchIGDIntervals.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.setToolTipText("Exclude selected intervals from workspace");
        this.jButtonExclude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchIGDIntervals.this.jButtonExcludeActionPerformed(evt);
            }
        });
        this.jButtonRead.setText("Read...");
        this.jButtonRead.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchIGDIntervals.this.jButtonReadActionPerformed(evt);
            }
        });
        this.jButtonSaveSelected.setText("Save selected");
        this.jButtonSaveSelected.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonSaveSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchIGDIntervals.this.jButtonSaveSelectedActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jLabel2)).add((Component)this.jScrollPane2, -1, 645, Short.MAX_VALUE)).add(10, 10, 10).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jButtonRead, -2, 87, -2).add((Component)this.jSeparator1, -2, 87, -2).add((Component)this.jButtonSaveSelected).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1, false).add((Component)this.jButtonCancel, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonSave, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDelete, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonExclude, -2, 87, -2))).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jButtonExclude).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0).add((Component)this.jButtonSave).addPreferredGap(0).add((Component)this.jButtonSaveSelected).addPreferredGap(1).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonRead).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane2, -1, 419, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        this.deleteIntervals(false);
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.deleteIntervals(true);
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        LinkedList<MatchData.MatchPair> selection = new LinkedList<MatchData.MatchPair>();
        for (int row = 0; row < this.model.data.size(); ++row) {
            selection.add(this.model.data.get(row));
        }
        this.saveSelection(selection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void saveSelection(List<MatchData.MatchPair> selection) {
        block49: {
            if (this.model.wsWell.getLink() == null) {
                JOptionPane.showMessageDialog(this, "No linked well - use Match | Wells from main menu.", this.getTitle(), 2);
                return;
            }
            if (this.model.dbInterp == null) {
                JOptionPane.showMessageDialog(this, "Version not linked - use Match | Versions from main menu.", this.getTitle(), 2);
                return;
            }
            if (selection.isEmpty()) {
                return;
            }
            boolean samplesCreated = false;
            Statement stmt = null;
            IGDIntervalZone added = null;
            Well dbWell = this.model.wsWell.getLink();
            boolean doStore = false;
            LinkedList<IGDIntervalZone> wsZones = new LinkedList<IGDIntervalZone>();
            for (MatchData.MatchPair pair : selection) {
                doStore = true;
                IGDIntervalZone ws = (IGDIntervalZone)pair.getWs();
                IGDIntervalZone db = (IGDIntervalZone)pair.getDb();
                if (ws == null) continue;
                if (db == null) {
                    IGDUnit wsUnit;
                    IGDUnit wsUnit2;
                    Sample baseSample;
                    if (ws.getSchID() == 0) {
                        JOptionPane.showMessageDialog(this, "Interval: " + ws.toString() + " not linked to a scheme. Use Match | Stratigraphic intervals from menu.");
                        doStore = false;
                        break;
                    }
                    IGDScheme wsScheme = this.wsDB.getIGDScheme(ws.getSchID());
                    if (wsScheme == null) {
                        JOptionPane.showMessageDialog(this, "Scheme for Interval: " + ws.toString() + " not found in workspace. Use Match | Stratigraphic intervals from menu.");
                        doStore = false;
                        break;
                    }
                    IGDScheme dbScheme = wsScheme.getLink();
                    if (dbScheme == null) {
                        JOptionPane.showMessageDialog(this, "Interval: " + ws.toString() + " scheme not found in workspace. Use Match | Stratigraphic intervals from menu.");
                        doStore = false;
                        break;
                    }
                    Sample topSample = dbWell.getSample(ws.getTopSample().getTopDepth(), ws.getTopSample().getBaseDepth(), ws.getTopSample().getType());
                    if (topSample == null) {
                        int opt = JOptionPane.showConfirmDialog(this, "Sample: " + ws.getTopSample() + " does not exist: create it?", this.getTitle(), 0, 3);
                        if (opt != 0) {
                            doStore = false;
                            break;
                        }
                        if (stmt == null) {
                            stmt = dbWell.getDataModel().getDatabase().createStatement();
                        }
                        topSample = dbWell.addWsSample(stmt, ws.getTopSample());
                        samplesCreated = true;
                    }
                    if ((baseSample = dbWell.getSample(ws.getBaseSample().getTopDepth(), ws.getBaseSample().getBaseDepth(), ws.getBaseSample().getType())) == null) {
                        int opt = JOptionPane.showConfirmDialog(this, "Sample: " + ws.getTopSample() + " does not exist: create it?", this.getTitle(), 0, 3);
                        if (opt != 0) {
                            doStore = false;
                            break;
                        }
                        if (stmt == null) {
                            stmt = dbWell.getDataModel().getDatabase().createStatement();
                        }
                        baseSample = dbWell.addWsSample(stmt, ws.getBaseSample());
                        samplesCreated = true;
                    }
                    String topAnalyAbr = null;
                    if (ws.getTopAnalyst() > 0) {
                        Userdef wsUser = this.wsDB.getUser(ws.getTopAnalyst());
                        if (wsUser == null) {
                            JOptionPane.showMessageDialog(this, "Cannot save: analyst used as interval boundary does not exist in workspace.");
                            doStore = false;
                            break;
                        }
                        if (wsUser.getLink() == null) {
                            JOptionPane.showMessageDialog(this, "Cannot save: analyst used as interval boundary is not matched: " + wsUser.getAbr());
                            doStore = false;
                            break;
                        }
                        topAnalyAbr = wsUser.getLink().getAbr();
                    }
                    String baseAnalyAbr = null;
                    if (ws.getBaseAnalyst() > 0) {
                        Userdef wsUser = this.wsDB.getUser(ws.getBaseAnalyst());
                        if (wsUser == null) {
                            JOptionPane.showMessageDialog(this, "Cannot save: analyst used as interval boundary does not exist in workspace.");
                            doStore = false;
                            break;
                        }
                        if (wsUser.getLink() == null) {
                            JOptionPane.showMessageDialog(this, "Cannot save: analyst used as interval boundary is not matched: " + wsUser.getAbr());
                            doStore = false;
                            break;
                        }
                        baseAnalyAbr = wsUser.getLink().getAbr();
                    }
                    int uppUnitID = 0;
                    int hier = ws.getHier();
                    if (ws.getUppZone() > 0 && (wsUnit2 = wsScheme.findUnit(ws.getUppZone())) != null && wsUnit2.getLink() != null) {
                        uppUnitID = wsUnit2.getLink().getUnitID();
                        hier = wsUnit2.getLink().getHier();
                    }
                    int lowUnitID = 0;
                    if (ws.getLowZone() > 0 && (wsUnit = wsScheme.findUnit(ws.getLowZone())) != null && wsUnit.getLink() != null) {
                        lowUnitID = wsUnit.getLink().getUnitID();
                    }
                }
                wsZones.add(ws);
            }
            if (doStore) {
                this.model.dbInterp.storeZones(wsZones, dbWell.getWellID(), IGDInterval.igdType2dType((int)this.model.igdType));
                added = (IGDIntervalZone)this.model.dbInterp.getIGDList(this.model.igdType).get(0);
            }
            this.model.wsWell.getLink().getDataModel().commit();
            try {
                if (stmt != null) {
                    stmt.close();
                }
                this.model.data.init(this.model.wsInterp != null ? this.model.wsInterp.getIGDList(this.model.igdType, 0) : null, this.model.dbInterp != null ? this.model.dbInterp.getIGDList(this.model.igdType, 0) : null);
                this.sorter.reallocateIndexes();
                this.sorter.fireTableDataChanged();
                if (added != null) {
                    this.model.dbInterp.notifyObservers((Object)added);
                }
                if (samplesCreated) {
                    this.model.wsWell.getLink().notifyObservers(Sample.class);
                }
                break block49;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            break block49;
            catch (SBException sbe) {
                this.model.wsWell.getLink().getDataModel().doRollback();
                SB.showStackError((String)"Error", (Exception)((Object)sbe));
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    this.model.data.init(this.model.wsInterp != null ? this.model.wsInterp.getIGDList(this.model.igdType, 0) : null, this.model.dbInterp != null ? this.model.dbInterp.getIGDList(this.model.igdType, 0) : null);
                    this.sorter.reallocateIndexes();
                    this.sorter.fireTableDataChanged();
                    if (added != null) {
                        this.model.dbInterp.notifyObservers((Object)added);
                    }
                    if (samplesCreated) {
                        this.model.wsWell.getLink().notifyObservers(Sample.class);
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            catch (SQLException sql) {
                this.model.wsWell.getLink().getDataModel().doRollback();
                FrameJsbugs.showStackError("SQL Error", sql, this.model.wsWell.getLink().getDataModel());
                {
                    catch (Throwable throwable) {
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                            this.model.data.init(this.model.wsInterp != null ? this.model.wsInterp.getIGDList(this.model.igdType, 0) : null, this.model.dbInterp != null ? this.model.dbInterp.getIGDList(this.model.igdType, 0) : null);
                            this.sorter.reallocateIndexes();
                            this.sorter.fireTableDataChanged();
                            if (added != null) {
                                this.model.dbInterp.notifyObservers(added);
                            }
                            if (samplesCreated) {
                                this.model.wsWell.getLink().notifyObservers(Sample.class);
                            }
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        throw throwable;
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    this.model.data.init(this.model.wsInterp != null ? this.model.wsInterp.getIGDList(this.model.igdType, 0) : null, this.model.dbInterp != null ? this.model.dbInterp.getIGDList(this.model.igdType, 0) : null);
                    this.sorter.reallocateIndexes();
                    this.sorter.fireTableDataChanged();
                    if (added != null) {
                        this.model.dbInterp.notifyObservers((Object)added);
                    }
                    if (samplesCreated) {
                        this.model.wsWell.getLink().notifyObservers(Sample.class);
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    private void jButtonReadActionPerformed(ActionEvent evt) {
        SbugsFileFilter filterAll = new SbugsFileFilter();
        JFileChooser jFileChooser = new JFileChooser();
        File setDir = null;
        try {
            setDir = new File(Lastval.getString((SBdb)this.dbDB, (String)"JIGDFILE"));
        }
        catch (SQLException ex) {
            // empty catch block
        }
        if (setDir == null || !setDir.exists()) {
            setDir = new File(".");
        }
        jFileChooser.setCurrentDirectory(setDir);
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("txt");
        filter.addExtension("csv");
        filter.addExtension("lst");
        jFileChooser.setFileFilter((FileFilter)filter);
        if (jFileChooser.showOpenDialog(this) == 0) {
            String fileName = jFileChooser.getSelectedFile().getPath();
            String[] types = new String[]{"CSV 2 lines: well | interval | depth (1 header lines)", "CSV (semi colon delimeter) 2 lines: pick top/base | depth | label (no header lines)", "CSV 2 lines: pick top/base | depth | label (no header lines)", "TABBED: well | top depth | base depth | * | label"};
            try {
                Lastval.putString((SBdb)this.dbDB, (String)"JIGDFILE", (String)fileName);
                this.dbDB.getDatabase().commit();
                DialogFilePreviewSelect selector = new DialogFilePreviewSelect((Dialog)this, true, fileName, types);
                selector.setLocationRelativeTo(this);
                selector.setVisible(true);
                if (!selector.isOK()) {
                    return;
                }
                String selectedFileType = types[selector.selectedItem];
                BufferedReader in = new BufferedReader(new FileReader(fileName));
                String schemeName = jFileChooser.getSelectedFile().getName();
                schemeName = schemeName.substring(0, schemeName.indexOf(46));
                DialogSelectScheme dialog = new DialogSelectScheme(this, true, this.dbDB, this.model.igdType, null);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.selection != null) {
                    IGDScheme scheme = IGDScheme.copyToWorkspace((SBdb)this.wsDB, (IGDScheme)dialog.selection);
                    this.wsDB.addIGDScheme(scheme);
                    LinkedList<Integer> dummy = new LinkedList<Integer>();
                    dummy.add(1);
                    this.model.wsWell.fillData(dummy);
                    if (selectedFileType.equals(types[0])) {
                        this.importTextFile(in, scheme, ',', 1, 3, 2, 0, 2, 2, 1);
                    } else if (selectedFileType.equals(types[1])) {
                        this.importTextFile(in, scheme, ';', 0, 3, 2, -1, 1, 1, 0);
                    } else if (selectedFileType.equals(types[2])) {
                        this.importTextFile(in, scheme, ',', 0, 3, 2, -1, 1, 1, 0);
                    } else if (selectedFileType.equals(types[3])) {
                        this.importTextFile(in, scheme, '\t', 1, 5, 1, 0, 1, 2, 4);
                    } else {
                        JOptionPane.showMessageDialog(this, "Cannot recognise file type. Please select a file type from the list of types at the base of the dialog", this.getTitle(), 2);
                    }
                    in.close();
                    if (this.model.wsInterp != null) {
                        // empty if block
                    }
                    this.model.data.init(this.model.wsInterp != null ? this.model.wsInterp.getIGDList(this.model.igdType, 0) : null, this.model.dbInterp != null ? this.model.dbInterp.getIGDList(this.model.igdType, 0) : null);
                    this.sorter.reallocateIndexes();
                    this.sorter.fireTableDataChanged();
                }
            }
            catch (Exception eio) {
                JOptionPane.showMessageDialog(null, "Problem reading file: " + eio.getMessage());
                eio.printStackTrace();
            }
        }
    }

    private void jButtonSaveSelectedActionPerformed(ActionEvent evt) {
        int[] selectedRows = this.jTableMatchIGDIntervals.getSelectedRows();
        if (selectedRows.length == 0) {
            JOptionPane.showMessageDialog(this, "Make a selection of rows to save", this.getTitle(), 2);
            return;
        }
        LinkedList<MatchData.MatchPair> selection = new LinkedList<MatchData.MatchPair>();
        for (int i = 0; i < selectedRows.length; ++i) {
            selection.add(this.model.data.get(this.sorter.getIndexOf(selectedRows[i])));
        }
        this.saveSelection(selection);
    }

    void importTextFile(BufferedReader in, IGDScheme scheme, char delim, int nHeaders, int nColumns, int nRowsPerInterval, int wellColumn, int topColumn, int baseColumn, int nameColumn) throws IOException, SBException, SQLException {
        String buff;
        for (int i = 0; i < nHeaders; ++i) {
            buff = in.readLine();
        }
        buff = in.readLine();
        String wellUWI = null;
        while (buff != null) {
            if (buff.indexOf(delim) > 0) {
                Sample topSample = null;
                Sample baseSample = null;
                String intervalName = null;
                Object zone = null;
                double depth = 0.0;
                for (int row = 1; row <= nRowsPerInterval; ++row) {
                    depth = 0.0;
                    for (int column = 0; column < nColumns && buff != null && buff.length() > 0; buff = buff.substring(buff.indexOf(delim) + 1), ++column) {
                        String strg = buff.indexOf(delim) > 0 ? buff.substring(0, buff.indexOf(delim)).trim() : buff.trim();
                        if (column == wellColumn) {
                            if (wellUWI == null) {
                                wellUWI = strg;
                            }
                            if (wellUWI.equals(strg)) continue;
                            throw new SBException("Well identifier changes in file - edit file to separate");
                        }
                        if (column == topColumn && (nRowsPerInterval == 1 || nRowsPerInterval == 2 && row == 1)) {
                            if (SB.hasDepthUnitsInString((String)strg)) {
                                depth = SB.parseDepthString((String)strg);
                            }
                            if (depth < (double)0.0029f) {
                                depth = SB.convToM((double)Double.parseDouble(strg), (char)this.model.units);
                            }
                            if ((topSample = this.model.wsWell.getSample(depth, null, true)) != null) continue;
                            topSample = this.model.wsWell.addSample(this.dbDB.useSampleTops() ? Double.valueOf(depth) : null, this.dbDB.useSampleTops() ? null : Double.valueOf(depth), "LOG", null);
                            continue;
                        }
                        if (column == baseColumn && (nRowsPerInterval == 1 || nRowsPerInterval == 2 && row == 2)) {
                            depth = SB.parseDepthString((String)strg);
                            if (depth < (double)0.0029f) {
                                depth = SB.convToM((double)Double.parseDouble(strg), (char)this.model.units);
                            }
                            if ((baseSample = this.model.wsWell.getSample(depth, null, true)) != null) continue;
                            baseSample = this.model.wsWell.addSample(this.dbDB.useSampleTops() ? Double.valueOf(depth) : null, this.dbDB.useSampleTops() ? null : Double.valueOf(depth), "LOG", null);
                            continue;
                        }
                        if (column != nameColumn || nRowsPerInterval != 1 && (nRowsPerInterval != 2 || row != 1)) continue;
                        intervalName = buff.substring(0).trim();
                        if (intervalName.indexOf(delim) >= 0) {
                            intervalName = intervalName.substring(0, intervalName.indexOf(delim)).trim();
                        }
                        if (!intervalName.toUpperCase().endsWith(" TOP")) continue;
                        intervalName = intervalName.substring(0, intervalName.length() - 4);
                    }
                    buff = in.readLine();
                }
                if (topSample != null && baseSample != null && intervalName != null) {
                    try {
                        int hier = IGDIntervalZone.getDefaultHier((int)this.model.igdType);
                        IGDUnit unit = scheme.findUnit(intervalName);
                        if (unit != null) {
                            hier = unit.getHier();
                        }
                        IGDIntervalZone.Builder builder = new IGDIntervalZone.Builder(this.wsDB, this.model.igdType, topSample, baseSample, hier, scheme.getID()).uppInf(intervalName);
                        if (unit != null) {
                            builder.uppZone(unit.getUnitID());
                        }
                        this.model.wsInterp.addZone(builder, (Well)this.model.wsWell);
                        continue;
                    }
                    catch (SBException ex) {
                        ex.printStackTrace();
                        if (this.handleException((Exception)((Object)ex))) continue;
                        break;
                    }
                    catch (IllegalStateException ex) {
                        if (this.handleException(ex)) continue;
                        break;
                    }
                    catch (InvalidFieldException ex) {
                        if (this.handleException((Exception)((Object)ex))) continue;
                        break;
                    }
                }
                System.out.println("Can't add interval for depth: " + depth + ": " + intervalName);
                continue;
            }
            buff = in.readLine();
        }
    }

    private boolean handleException(Exception ex) {
        int opt = JOptionPane.showConfirmDialog(this, "Error reading file: " + ex.getMessage() + "\nContinue reading?", this.getTitle(), 0, 3);
        return opt == 0;
    }

    private void deleteIntervals(boolean fromDatabase) {
        block10: {
            if (fromDatabase && this.model.wsWell.getLink() == null) {
                JOptionPane.showMessageDialog(this, "No well data - use Exclude to remove from workspace", this.getTitle(), 2);
                return;
            }
            if (this.jTableMatchIGDIntervals.getSelectedRowCount() == 0) {
                JOptionPane.showMessageDialog(this, "No intervals selected", this.getTitle(), 2);
                return;
            }
            int[] selected = this.jTableMatchIGDIntervals.getSelectedRows();
            LinkedList<IGDIntervalZone> toRemove = new LinkedList<IGDIntervalZone>();
            for (int i : selected) {
                IGDIntervalZone zone = fromDatabase ? (IGDIntervalZone)this.model.data.get(this.sorter.getIndexOf(i)).getDb() : (IGDIntervalZone)this.model.data.get(this.sorter.getIndexOf(i)).getWs();
                if (zone == null) continue;
                toRemove.add(zone);
            }
            if (fromDatabase && toRemove.size() > 0) {
                String msg = "Really delete ";
                msg = msg + (toRemove.size() == 1 ? "this interval" : "these " + toRemove.size() + " interval");
                if (JOptionPane.showConfirmDialog(this, msg = msg + (toRemove.size() == 1 ? "?" : "s?"), this.getTitle(), 0, 3) != 0) {
                    return;
                }
            }
            try {
                int nSamples = 0;
                WsWell deleteWell = fromDatabase ? this.model.wsWell.getLink() : this.model.wsWell;
                WellInterp deleteInterp = fromDatabase ? this.model.dbInterp : this.model.wsInterp;
                IGDIntervalZone deletedZone = null;
                for (IGDIntervalZone zone : toRemove) {
                    deleteInterp.deleteZone((Well)deleteWell, zone);
                    deletedZone = zone;
                    ++nSamples;
                }
                String text = fromDatabase ? "deleted" : "excluded";
                JOptionPane.showMessageDialog(this, "Intervals " + text + ": " + nSamples, this.getTitle(), 1);
                if (fromDatabase) {
                    deleteWell.getDataModel().commit();
                    deleteInterp.notifyObservers((Object)deletedZone);
                } else {
                    this.model.wsWell.updateZoneStatus(this.model.wsInterp, this.model.dbInterp != null ? this.model.dbInterp.getHeader() : null, this.model.igdType, this.model.units, true);
                }
                this.model.data.init(this.model.wsInterp != null ? this.model.wsInterp.getIGDList(this.model.igdType, 0) : null, this.model.dbInterp != null ? this.model.dbInterp.getIGDList(this.model.igdType, 0) : null);
                this.sorter.reallocateIndexes();
                this.sorter.fireTableDataChanged();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Error " + (fromDatabase ? "deleting" : "excluding") + " : " + e.getMessage(), this.getTitle(), 0);
                e.printStackTrace();
                if (!fromDatabase) break block10;
                this.model.wsWell.getLink().getDataModel().doRollback();
            }
        }
    }
}

