/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableModel;
import jsbugs.DialogDrawIGDScheme;
import jsbugs.DialogIGDScheme;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelMatchIGDSchemeSurfaces;
import jsbugs.TableModelMatchIGDSchemeUnits;
import model2.IGDScheme;
import model2.IGDUnit;
import model2.SBdb;
import model2.Surface;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SbugsStatus;
import util.SortEntry;
import util.TableSorter;

public class DialogMatchIGDScheme
extends JDialog {
    TableModelMatchIGDSchemeUnits model = new TableModelMatchIGDSchemeUnits();
    TableModelMatchIGDSchemeSurfaces surfaceModel = new TableModelMatchIGDSchemeSurfaces();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    TableSorter surfaceSorter = new TableSorter((TableModel)this.surfaceModel);
    Image backgroundImage;
    SBdb db;
    IGDScheme origLink;
    private String UNIT_ADD = "Add units";
    private String UNIT_UPDATE = "Update units";
    private String SURFACE_ADD = "Add surfaces";
    private String SURFACE_UPDATE = "Update surfaces";
    private JButton jButtonAddScheme;
    private JButton jButtonAddUnits;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonDraw;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonUpdate;
    private JComboBox jComboBoxDb;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPaneSurfaces;
    private JTabbedPane jTabbedPane1;
    private JTable jTableMatchSurfaces;
    private JTable jTableMatchUnits;
    private JTextField jTextFieldScheme;

    public DialogMatchIGDScheme(Frame parent, boolean modal, IGDScheme scheme, SBdb db) throws SQLException, SBException {
        super(parent, modal);
        this.model.scheme = scheme;
        this.surfaceModel.scheme = scheme;
        this.db = db;
        this.initComponents();
        this.init();
    }

    public DialogMatchIGDScheme(Dialog parent, boolean modal, IGDScheme scheme, SBdb db) throws SQLException, SBException {
        super(parent, modal);
        this.model.scheme = scheme;
        this.surfaceModel.scheme = scheme;
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Match Stratigraphic Scheme : " + this.model.scheme.toString());
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.backgroundImage = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/MatchBG.png"));
        this.jTextFieldScheme.setText(this.model.scheme.toString());
        this.jComboBoxDb.removeAllItems();
        this.jComboBoxDb.insertItemAt("<Select>", 0);
        this.origLink = this.model.scheme.getLink();
        LinkedList list = new LinkedList(this.db.getIGDSchemes(this.model.scheme.getIGDType()));
        Collections.sort(list);
        for (IGDScheme igd : list) {
            this.jComboBoxDb.addItem(igd);
        }
        this.sorter.addMouseListenerToHeaderInTable(this.jTableMatchUnits);
        if (this.model.scheme.getLink() != null) {
            this.jComboBoxDb.setSelectedItem(this.model.scheme.getLink());
            for (IGDUnit unit : this.model.scheme.getLink().getUnits()) {
                unit.getNoccs(true);
            }
            if (this.model.scheme.getIGDType() == 10) {
                for (Surface surface : this.model.scheme.getLink().getSurfaces()) {
                    surface.getNoccs(true);
                }
            }
        }
        this.model.setUpTable(this.jTableMatchUnits);
        this.model.data.init(this.model.scheme.getUnits(), this.model.scheme.getLink() != null ? this.model.scheme.getLink().getUnits() : null);
        this.sorter.fireTableDataChanged();
        this.sorter.reallocateIndexes();
        if (this.model.scheme.getIGDType() != 10) {
            this.jScrollPaneSurfaces.setEnabled(false);
            this.jTabbedPane1.remove(this.jScrollPaneSurfaces);
            this.jButtonAddUnits.setText(this.UNIT_ADD);
            this.jButtonUpdate.setText(this.UNIT_UPDATE);
        } else {
            this.jTabbedPane1.setSelectedComponent(this.jScrollPaneSurfaces);
            this.surfaceModel.setUpTable(this.jTableMatchSurfaces);
            this.surfaceModel.data.init(this.model.scheme.getSurfaces(), this.model.scheme.getLink() != null ? this.model.scheme.getLink().getSurfaces() : null);
            this.surfaceSorter.fireTableDataChanged();
            this.surfaceSorter.reallocateIndexes();
            this.surfaceSorter.addMouseListenerToHeaderInTable(this.jTableMatchSurfaces);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(DialogMatchIGDScheme.this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonDraw = new JButton();
        this.jButtonDelete = new JButton();
        this.jComboBoxDb = new JComboBox();
        this.jTextFieldScheme = new JTextField();
        this.jButtonAddUnits = new JButton();
        this.jButtonUpdate = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonAddScheme = new JButton();
        this.jButtonHelp = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jScrollPane1 = new JScrollPane();
        this.jTableMatchUnits = new JTable();
        this.jScrollPaneSurfaces = new JScrollPane();
        this.jTableMatchSurfaces = new JTable();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(800, 400));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DialogMatchIGDScheme.this.formWindowClosing(evt);
            }
        });
        this.jPanel1.setMinimumSize(new Dimension(600, 300));
        this.jLabel1.setFont(new Font("Tahoma", 1, 13));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace:");
        this.jLabel2.setFont(new Font("Tahoma", 1, 13));
        this.jLabel2.setText("Database:");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchIGDScheme.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchIGDScheme.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonDraw.setText("Draw...");
        this.jButtonDraw.setToolTipText("Plot both schemes for comparison");
        this.jButtonDraw.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchIGDScheme.this.jButtonDrawActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setToolTipText("Delete selected units/surfaces from database scheme");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchIGDScheme.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jComboBoxDb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchIGDScheme.this.jComboBoxDbActionPerformed(evt);
            }
        });
        this.jTextFieldScheme.setEditable(false);
        this.jButtonAddUnits.setText("Add surfaces");
        this.jButtonAddUnits.setToolTipText("Add selected units/surfaces from workspace to database scheme");
        this.jButtonAddUnits.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchIGDScheme.this.jButtonAddUnitsActionPerformed(evt);
            }
        });
        this.jButtonUpdate.setText("Update surfaces");
        this.jButtonUpdate.setToolTipText("Update units/surfaces in database from matching selected units/surfaces in workspace");
        this.jButtonUpdate.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchIGDScheme.this.jButtonUpdateActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit scheme...");
        this.jButtonEdit.setToolTipText("Edit database scheme");
        this.jButtonEdit.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchIGDScheme.this.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonAddScheme.setText("Add scheme...");
        this.jButtonAddScheme.setToolTipText("Add workspace scheme to database");
        this.jButtonAddScheme.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonAddScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchIGDScheme.this.jButtonAddSchemeActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchIGDScheme.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DialogMatchIGDScheme.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.jTableMatchUnits.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jTableMatchUnits.setModel((TableModel)this.sorter);
        this.jScrollPane1.setViewportView(this.jTableMatchUnits);
        this.jTabbedPane1.addTab("Units", this.jScrollPane1);
        this.jTableMatchSurfaces.setModel((TableModel)this.surfaceSorter);
        this.jScrollPaneSurfaces.setViewportView(this.jTableMatchSurfaces);
        this.jTabbedPane1.addTab("Surfaces", this.jScrollPaneSurfaces);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldScheme, -1, 252, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxDb, 0, 248, Short.MAX_VALUE)).addComponent(this.jTabbedPane1, -1, 670, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonHelp, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonOK, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonCancel, GroupLayout.Alignment.LEADING, -1, 99, Short.MAX_VALUE)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonAddScheme).addComponent(this.jButtonDelete, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonUpdate, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonAddUnits, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDraw, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonEdit))).addContainerGap()));
        jPanel1Layout.linkSize(0, this.jButtonAddScheme, this.jButtonAddUnits, this.jButtonCancel, this.jButtonDelete, this.jButtonDraw, this.jButtonEdit, this.jButtonHelp, this.jButtonOK, this.jButtonUpdate);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldScheme, -2, -1, -2).addComponent(this.jComboBoxDb, -2, -1, -2).addComponent(this.jLabel2)).addGap(30, 30, 30).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jButtonAddScheme).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonEdit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDraw).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAddUnits).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonUpdate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 220, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jTabbedPane1, -1, 490, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        try {
            this.model.scheme.setLink(this.origLink);
            this.model.linkUnits();
            if (this.model.scheme.getIGDType() == 10) {
                this.surfaceModel.linkSurfaces();
            }
            this.model.scheme.updateStatus();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.dispose();
    }

    private void jComboBoxDbActionPerformed(ActionEvent evt) {
        try {
            IGDScheme dbScheme;
            Object obj = this.jComboBoxDb.getSelectedItem();
            if (obj instanceof IGDScheme) {
                dbScheme = (IGDScheme)obj;
                dbScheme.loadUnits();
            } else {
                dbScheme = null;
            }
            this.model.scheme.setLink(dbScheme);
            this.model.linkUnits();
            this.model.data.init(this.model.scheme.getUnits(), dbScheme != null ? dbScheme.getUnits() : null);
            if (dbScheme != null) {
                for (IGDUnit unit : dbScheme.getUnits()) {
                    unit.getNoccs(true);
                }
            }
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
            if (this.model.scheme.getIGDType() == 10) {
                this.surfaceModel.linkSurfaces();
                this.surfaceModel.data.init(this.model.scheme.getSurfaces(), dbScheme != null ? dbScheme.getSurfaces() : null);
                if (dbScheme != null) {
                    for (Surface surface : dbScheme.getSurfaces()) {
                        surface.getNoccs(true);
                    }
                }
                this.surfaceSorter.reallocateIndexes();
                this.surfaceSorter.fireTableDataChanged();
            }
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
            sbe.printStackTrace();
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
            sql.printStackTrace();
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.jButtonCancelActionPerformed(null);
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        boolean units = this.jTabbedPane1.getSelectedComponent() == this.jScrollPane1;
        String unitsString = units ? "units" : "surfaces";
        if ((units ? this.jTableMatchUnits : this.jTableMatchSurfaces).getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No " + unitsString + " selected", this.getTitle(), 2);
            return;
        }
        int[] selected = (units ? this.jTableMatchUnits : this.jTableMatchSurfaces).getSelectedRows();
        LinkedList<SortEntry> toRemove = new LinkedList<SortEntry>();
        int nOccs = 0;
        for (int n : selected) {
            SortEntry unit = units ? this.model.data.get(this.sorter.getIndexOf(n)).getDb() : this.surfaceModel.data.get(this.surfaceSorter.getIndexOf(n)).getDb();
            int thisOccs = 0;
            try {
                if (unit instanceof IGDUnit) {
                    thisOccs += ((IGDUnit)unit).getNoccs(false);
                } else if (unit instanceof Surface) {
                    thisOccs += ((Surface)unit).getNoccs(false);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (thisOccs > 0) {
                nOccs += thisOccs;
                unit = null;
            }
            if (unit == null) continue;
            toRemove.add(unit);
        }
        if (nOccs > 0) {
            JOptionPane.showMessageDialog(this, "Some " + unitsString + " cannot be deleted because they occur in " + (units ? "interpreted intervals." : "picks."), this.getTitle(), 2);
        }
        if (toRemove.size() > 0) {
            String msg = "Really delete " + (toRemove.size() == 1 ? "this " + (units ? "unit" : "surface") : "these " + unitsString) + "? (no occurrence in database)";
            if (JOptionPane.showConfirmDialog(this, msg, this.getTitle(), 0, 3) != 0) {
                return;
            }
            int nUnits = 0;
            try {
                for (Object e : toRemove) {
                    if (e instanceof IGDUnit) {
                        this.model.scheme.getLink().deleteUnit((IGDUnit)e);
                        ++nUnits;
                    } else if (e instanceof Surface) {
                        this.model.scheme.getLink().deleteSurface((Surface)e);
                        ++nUnits;
                    }
                    this.model.scheme.getDatabase().commit();
                }
            }
            catch (SQLException sql) {
                this.model.scheme.getDatabase().doRollback();
                FrameJsbugs.showStackError("SQL Error deleting units", sql, this.db);
            }
            JOptionPane.showMessageDialog(this, (units ? "Units" : "Surfaces") + " deleted: " + nUnits, this.getTitle(), 1);
            try {
                this.model.linkUnits();
                this.model.scheme.updateStatus();
                this.model.data.init(this.model.scheme.getUnits(), this.model.scheme.getLink().getUnits());
                this.sorter.reallocateIndexes();
                this.sorter.fireTableDataChanged();
                if (!units) {
                    this.surfaceModel.linkSurfaces();
                    this.surfaceModel.data.init(this.model.scheme.getSurfaces(), this.model.scheme.getLink().getSurfaces());
                    this.surfaceSorter.reallocateIndexes();
                    this.surfaceSorter.fireTableDataChanged();
                }
                this.model.scheme.getLink().notifyObservers();
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.db);
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error", (Exception)((Object)sbe));
            }
            catch (RuntimeException re) {
                SB.showStackError((String)"", (Exception)re);
            }
        }
    }

    private void jButtonAddUnitsActionPerformed(ActionEvent evt) {
        if (this.model.scheme.getLink() == null) {
            JOptionPane.showMessageDialog(this, "Select a database scheme", this.getTitle(), 1);
            return;
        }
        boolean units = this.jTabbedPane1.getSelectedComponent() == this.jScrollPane1;
        if ((units ? this.jTableMatchUnits : this.jTableMatchSurfaces).getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No " + (units ? "units" : "surfaces") + " selected", this.getTitle(), 2);
            return;
        }
        int[] selected = (units ? this.jTableMatchUnits : this.jTableMatchSurfaces).getSelectedRows();
        LinkedList<IGDUnit> toAdd = new LinkedList<IGDUnit>();
        for (int i : selected) {
            Object unit = units ? (IGDUnit)this.model.data.get(this.sorter.getIndexOf(i)).getWs() : (Surface)this.surfaceModel.data.get(this.surfaceSorter.getIndexOf(i)).getWs();
            if (unit == null) continue;
            toAdd.add((IGDUnit)unit);
        }
        for (SbugsStatus sbugsStatus : toAdd) {
            if (sbugsStatus.getStatus() == IGDUnit.NOTSTORED) continue;
            JOptionPane.showMessageDialog(this, "You can only add " + (units ? "units" : "surfaces") + " which are new and do not conflict with the database scheme units", this.getTitle(), 2);
            return;
        }
        try {
            for (SbugsStatus sbugsStatus : toAdd) {
                try {
                    if (sbugsStatus instanceof IGDUnit) {
                        IGDUnit wsUnit = (IGDUnit)sbugsStatus;
                        this.model.scheme.getLink().addUnit(IGDUnit.Builder.copyOf((IGDUnit)wsUnit, (SBdb)this.model.scheme.getLink().getDatabase()));
                    } else {
                        Surface surface = (Surface)sbugsStatus;
                        this.surfaceModel.scheme.getLink().addSurface(Surface.Builder.copyOf((SBdb)this.db, (Surface)surface));
                    }
                }
                catch (InvalidFieldException e) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
                    continue;
                }
                catch (SQLException sql) {
                    this.db.doRollback();
                    FrameJsbugs.showStackError("SQL Error", sql, this.db);
                    continue;
                }
                catch (SBException sbe) {
                    this.db.doRollback();
                    SB.showStackError((String)"Error", (Exception)((Object)sbe));
                    continue;
                }
                this.db.commit();
            }
            this.model.linkUnits();
            this.model.scheme.updateStatus();
            this.model.data.init(this.model.scheme.getUnits(), this.model.scheme.getLink().getUnits());
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
            if (!units) {
                this.surfaceModel.linkSurfaces();
                this.surfaceModel.data.init(this.model.scheme.getSurfaces(), this.model.scheme.getLink().getSurfaces());
                this.surfaceSorter.reallocateIndexes();
                this.surfaceSorter.fireTableDataChanged();
            }
            this.model.scheme.getLink().notifyObservers();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.model.scheme.getLink() == null) {
            JOptionPane.showMessageDialog(this, "No scheme selected", this.getTitle(), 2);
            return;
        }
        try {
            DialogIGDScheme dialog = new DialogIGDScheme(this, true, this.db, this.model.scheme.getLink(), this.model.scheme.getLink().getIGDType());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.model.data.init(this.model.scheme.getUnits(), this.model.scheme.getLink().getUnits());
                this.model.scheme.updateStatus();
                this.sorter.reallocateIndexes();
                this.sorter.fireTableDataChanged();
            }
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonUpdateActionPerformed(ActionEvent evt) {
        boolean units = this.jTabbedPane1.getSelectedComponent() == this.jScrollPane1;
        if ((units ? this.jTableMatchUnits : this.jTableMatchSurfaces).getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No " + (units ? "units" : "surfaces") + " selected", this.getTitle(), 2);
            return;
        }
        int[] selected = (units ? this.jTableMatchUnits : this.jTableMatchSurfaces).getSelectedRows();
        LinkedList<IGDUnit> toUpdate = new LinkedList<IGDUnit>();
        for (int i : selected) {
            if (units) {
                IGDUnit unit = (IGDUnit)this.model.data.get(this.sorter.getIndexOf(i)).getWs();
                if (unit == null) continue;
                toUpdate.add(unit);
                continue;
            }
            Surface surface = (Surface)this.surfaceModel.data.get(this.surfaceSorter.getIndexOf(i)).getWs();
            if (surface == null) continue;
            toUpdate.add((IGDUnit)surface);
        }
        try {
            DialogIGDScheme dialog = new DialogIGDScheme(this, true, this.db, this.model.scheme.getLink(), this.model.scheme.getLink().getIGDType());
            dialog.setLocationRelativeTo(this);
            if (units) {
                dialog.setUpdateUnits(toUpdate);
            } else {
                dialog.setUpdateSurfaces(toUpdate);
            }
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.model.data.init(this.model.scheme.getUnits(), this.model.scheme.getLink().getUnits());
                this.model.scheme.updateStatus();
                this.sorter.reallocateIndexes();
                this.sorter.fireTableDataChanged();
                if (!units) {
                    this.surfaceModel.linkSurfaces();
                    this.surfaceModel.data.init(this.model.scheme.getSurfaces(), this.model.scheme.getLink().getSurfaces());
                    this.surfaceSorter.reallocateIndexes();
                    this.surfaceSorter.fireTableDataChanged();
                }
            }
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonDrawActionPerformed(ActionEvent evt) {
        if (this.model.scheme.getLink() == null) {
            JOptionPane.showMessageDialog(this, "Select a database scheme", this.getTitle(), 1);
            return;
        }
        try {
            DialogDrawIGDScheme dialog = new DialogDrawIGDScheme(this, false, this.model.scheme, this.model.scheme.getLink());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonAddSchemeActionPerformed(ActionEvent evt) {
        try {
            DialogIGDScheme dialog = new DialogIGDScheme(this, true, this.db, this.model.scheme, this.model.scheme.getIGDType());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.model.scheme.setLink(dialog.schemeAdded);
                this.jComboBoxDb.addItem(this.model.scheme.getLink());
                this.jComboBoxDb.setSelectedItem(this.model.scheme.getLink());
            }
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error adding scheme", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error adding scheme", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogmatchigdscheme.html");
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        System.out.println("Component state changed");
        if (this.jTabbedPane1.getSelectedComponent() == this.jScrollPaneSurfaces) {
            this.jButtonAddUnits.setText(this.SURFACE_ADD);
            this.jButtonUpdate.setText(this.SURFACE_UPDATE);
        } else {
            this.jButtonAddUnits.setText(this.UNIT_ADD);
            this.jButtonUpdate.setText(this.UNIT_UPDATE);
        }
    }
}

