/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.TableModel;
import jsbugs.DialogVersionHeader;
import jsbugs.FrameJsbugs;
import jsbugs.FrameOrganiser;
import jsbugs.TableModelMatchInterp;
import model2.InterpHdr;
import model2.SBdb;
import model2.WsWell;
import util.TableSorter;

public class DialogMatchInterp
extends JDialog {
    TableModelMatchInterp model = new TableModelMatchInterp();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    boolean isOK = false;
    Image backgroundImage;
    FrameOrganiser parent;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonMatchAll;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTableInterps;

    public DialogMatchInterp(FrameOrganiser parent, boolean modal, SBdb ws, SBdb db) throws SQLException {
        super((Frame)parent, modal);
        this.parent = parent;
        this.setTitle("Match Versions");
        this.initComponents();
        this.init(ws, db);
    }

    private void init(SBdb ws, SBdb db) throws SQLException {
        this.model.setupTable(this.jTableInterps, ws, db);
        this.sorter.addMouseListenerToHeaderInTable(this.jTableInterps);
        this.sorter.reallocateIndexes();
        this.sorter.sortByColumn(0);
        this.sorter.sort((Object)this);
        this.sorter.fireTableDataChanged();
        this.jTableInterps.getTableHeader().setReorderingAllowed(false);
        this.backgroundImage = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/MatchBG.png"));
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(DialogMatchInterp.this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableInterps = new JTable();
        this.jButtonMatchAll = new JButton();
        this.jButtonAdd = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 250));
        this.jLabel1.setFont(new Font("Tahoma", 1, 13));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(new Font("Tahoma", 1, 13));
        this.jLabel2.setText("...Database");
        this.jScrollPane1.setToolTipText("Select the database abbreviation to match");
        this.jScrollPane1.setViewportBorder(BorderFactory.createLineBorder(new Color(255, 255, 255)));
        this.jTableInterps.setModel((TableModel)this.sorter);
        this.jScrollPane1.setViewportView(this.jTableInterps);
        this.jButtonMatchAll.setText("Match all");
        this.jButtonMatchAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchInterp.this.jButtonMatchAllActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchInterp.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchInterp.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchInterp.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchInterp.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 410, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 252, Short.MAX_VALUE).addComponent(this.jLabel2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonCancel, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonMatchAll, -1, 75, Short.MAX_VALUE).addComponent(this.jButtonAdd, -1, -1, Short.MAX_VALUE)).addComponent(this.jButtonOK, -1, 77, Short.MAX_VALUE).addComponent(this.jButtonHelp)).addContainerGap()));
        jPanel1Layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1, -2, 21, -2).addComponent(this.jLabel2, -2, 27, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonMatchAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 116, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 249, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonMatchAllActionPerformed(ActionEvent evt) {
        try {
            for (InterpHdr hdr : this.model.ws.getInterps()) {
                InterpHdr dbHdr;
                if (hdr.getLink() != null || (dbHdr = this.model.db.getInterp(hdr.getDescription())) == null) continue;
                hdr.setLink(dbHdr);
            }
            this.sorter.fireTableDataChanged();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error: " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        if (this.jTableInterps.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one row from the table to add.", this.getTitle(), 1);
            return;
        }
        try {
            InterpHdr hdr = (InterpHdr)this.model.ws.getInterps().get(this.sorter.getIndexOf(this.jTableInterps.getSelectedRow()));
            if (hdr.getLink() != null) {
                JOptionPane.showMessageDialog(this, "Item to be added is already linked.", this.getTitle(), 1);
                return;
            }
            DialogVersionHeader dialog = new DialogVersionHeader((JDialog)this, true, this.model.db, hdr.getDescription());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK) {
                this.model.interpComboBox.insertItemAt(dialog.interpHdr.getDescription(), 1);
                hdr.setLink(dialog.interpHdr);
                this.sorter.fireTableDataChanged();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error: " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            HashSet<InterpHdr> set = new HashSet<InterpHdr>();
            for (InterpHdr hdr : this.model.ws.getInterps()) {
                if (hdr.getLink() == null) {
                    JOptionPane.showMessageDialog(this, "Not all versions matched. Press Cancel to close without matching.", this.getTitle(), 2);
                    return;
                }
                if (set.add(hdr.getLink())) continue;
                JOptionPane.showMessageDialog(this, "You cannot match more than one version to the same database version.", this.getTitle(), 2);
                return;
            }
            Iterator it = this.model.ws.getProject(0).getWellIterator();
            while (it.hasNext()) {
                WsWell well = (WsWell)it.next();
                for (InterpHdr hdr : this.model.ws.getInterps()) {
                    well.resetInterpDataMonitors(this.parent.dataTypes, hdr.getLink().getInterpID());
                    well.updateInterpStatus(well.getInterp(hdr.getInterpID()), well.getWellUnits());
                }
            }
            this.isOK = true;
            this.dispose();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error getting personnel: " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogmatchinterp.html");
    }
}

