/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jsbugs.ComboCellRenderer;
import jsbugs.DialogLithTrnSchManager;
import jsbugs.DialogLithTrnScheme;
import jsbugs.FrameJsbugs;
import model2.LithTrnEntry;
import model2.LithTrnScheme;
import model2.Lithdesc;
import model2.Lithology;
import model2.SBdb;
import model2.WsLithology;
import util.ArrowCellRenderer;
import util.SB;
import util.SBException;
import util.TableSorter;

public class DialogMatchLithology
extends JDialog {
    TableModelLithTrn model = new TableModelLithTrn();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    Image backgroundImage;
    public boolean isOK;
    SBdb db;
    boolean inStartup = true;
    private JButton jButtonCancel;
    private JButton jButtonClear;
    private JButton jButtonHelp;
    private JButton jButtonMatchAll;
    private JButton jButtonOK;
    private JButton jButtonSave;
    private JButton jButtonScheme;
    private JComboBox jComboBoxSchemes;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTable jTable1;

    public DialogMatchLithology(Dialog parent, boolean modal, LinkedList<WsLithology> liths, SBdb db) {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.init(liths);
    }

    private void init(LinkedList<WsLithology> liths) {
        this.setTitle("Match Lithology Terms");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.model.liths = liths;
        this.backgroundImage = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/MatchBG.png"));
        try {
            this.model.lithdesc = this.db.getLithdesc();
            JComboBox combo = this.db.getLithologyCombo(true);
            this.model.setupTable(this.jTable1, combo);
            this.fillSchemeCombo();
        }
        catch (SQLException sql) {
            SB.showStackError((String)"Error loading lithology: ", (SQLException)sql);
            sql.printStackTrace();
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error loading lithology: ", (Exception)((Object)sbe));
            sbe.printStackTrace();
        }
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
        this.inStartup = false;
    }

    private void fillSchemeCombo() throws SBException, SQLException {
        this.jComboBoxSchemes.removeAllItems();
        LinkedList schemes = this.db.getLithTrnSchemes();
        for (LithTrnScheme scheme : schemes) {
            this.jComboBoxSchemes.addItem(scheme);
        }
        this.jComboBoxSchemes.insertItemAt("<Select>", 0);
        this.jComboBoxSchemes.setSelectedIndex(0);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(DialogMatchLithology.this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jLabel1 = new JLabel();
        this.jComboBoxSchemes = new JComboBox();
        this.jButtonScheme = new JButton();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jButtonMatchAll = new JButton();
        this.jButtonClear = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(500, 400));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchLithology.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchLithology.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jTable1.setModel((TableModel)this.sorter);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Match Scheme:");
        this.jComboBoxSchemes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchLithology.this.jComboBoxSchemesActionPerformed(evt);
            }
        });
        this.jButtonScheme.setText("...");
        this.jButtonScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchLithology.this.jButtonSchemeActionPerformed(evt);
            }
        });
        this.jLabel2.setFont(new Font("Tahoma", 1, 13));
        this.jLabel2.setForeground(new Color(255, 255, 255));
        this.jLabel2.setText("Workspace...");
        this.jLabel3.setFont(new Font("Tahoma", 1, 13));
        this.jLabel3.setText("...Database");
        this.jButtonMatchAll.setText("Match all");
        this.jButtonMatchAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchLithology.this.jButtonMatchAllActionPerformed(evt);
            }
        });
        this.jButtonClear.setText("Clear matches");
        this.jButtonClear.setToolTipText("Unlink selected items");
        this.jButtonClear.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchLithology.this.jButtonClearActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save matches");
        this.jButtonSave.setToolTipText("Create new scheme from matches");
        this.jButtonSave.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchLithology.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchLithology.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxSchemes, -2, 217, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonScheme, -2, 30, -2)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSeparator1, GroupLayout.Alignment.LEADING, -1, 431, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 273, Short.MAX_VALUE).addComponent(this.jLabel3)).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 431, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonCancel, -1, 89, Short.MAX_VALUE).addComponent(this.jButtonMatchAll, -1, 89, Short.MAX_VALUE).addComponent(this.jButtonClear, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonSave, GroupLayout.Alignment.LEADING, -2, 89, -2).addComponent(this.jButtonOK, -1, 89, Short.MAX_VALUE).addComponent(this.jButtonHelp, -2, 89, -2)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBoxSchemes, -2, -1, -2).addComponent(this.jButtonScheme)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonMatchAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClear).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 177, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jScrollPane1, -1, 339, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        for (WsLithology wslith : this.model.liths) {
            if (wslith.getLink() != null) continue;
            if (JOptionPane.showConfirmDialog(this, "Some entries are unmatched. Continue and lose intervals using these lithologies?", this.getTitle(), 0) == 0) break;
            return;
        }
        this.isOK = true;
        this.dispose();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonMatchAllActionPerformed(ActionEvent evt) {
        for (WsLithology wslith : this.model.liths) {
            Lithology lith;
            if (wslith.getLink() != null || wslith.getDescription().isEmpty() || (lith = this.model.lithdesc.getLithologyFromDescription(wslith.getDescription())) == null) continue;
            wslith.setLink(lith);
        }
        this.sorter.fireTableDataChanged();
    }

    private void jButtonSchemeActionPerformed(ActionEvent evt) {
        DialogLithTrnSchManager dialog = new DialogLithTrnSchManager((Dialog)this, true, this.db);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        try {
            this.fillSchemeCombo();
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error: ", (Exception)((Object)sbe));
            sbe.printStackTrace();
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error: ", (SQLException)sql);
            sql.printStackTrace();
        }
        if (dialog.selected != null) {
            this.jComboBoxSchemes.setSelectedItem(dialog.selected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jComboBoxSchemesActionPerformed(ActionEvent evt) {
        if (this.inStartup) {
            return;
        }
        if (this.jComboBoxSchemes.getSelectedIndex() == 0) {
            return;
        }
        LithTrnScheme scheme = (LithTrnScheme)this.jComboBoxSchemes.getSelectedItem();
        if (scheme == null) {
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            scheme.loadEntries();
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.model.currentScheme = scheme;
        for (WsLithology lith : this.model.liths) {
            lith.setLink(null);
        }
        this.model.tryLink();
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
    }

    private void jButtonClearActionPerformed(ActionEvent evt) {
        int[] selection;
        if (this.jTable1.getSelectedRowCount() < 1) {
            JOptionPane.showMessageDialog(this, "Select one or more rows", this.getTitle(), 2);
            return;
        }
        for (int i : selection = this.jTable1.getSelectedRows()) {
            WsLithology lith = this.model.liths.get(this.sorter.getIndexOf(i));
            lith.setLink(null);
        }
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        LithTrnScheme scheme;
        if (this.jComboBoxSchemes.getSelectedIndex() == 0) {
            scheme = new LithTrnScheme(this.db, new LinkedList());
        } else {
            scheme = (LithTrnScheme)this.jComboBoxSchemes.getSelectedItem();
            if (JOptionPane.showConfirmDialog(this, "Add matches to scheme " + scheme + "?", this.getTitle(), 2) != 0) {
                return;
            }
        }
        for (WsLithology wsLith : this.model.liths) {
            if (wsLith.getLink() == null) continue;
            scheme.addEntry(new LithTrnEntry(wsLith.getCode(), wsLith.getDescription(), wsLith.getLink().getLithID()), true);
        }
        DialogLithTrnScheme dialog = new DialogLithTrnScheme((Dialog)this, true, this.db, scheme);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK) {
            try {
                this.db.addLithTrnScheme(scheme);
                Collections.sort(this.db.getLithTrnSchemes());
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error: ", (Exception)((Object)sbe));
                sbe.printStackTrace();
            }
            catch (SQLException sql) {
                SB.showStackError((String)"SQL Error: ", (SQLException)sql);
                sql.printStackTrace();
            }
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("organiser_lithimport.html");
    }

    class TableModelLithTrn
    extends AbstractTableModel {
        static final int COL_DONOR_ID = 0;
        static final int COL_DONOR_DESC = 1;
        static final int COL_ARROW = 2;
        static final int COL_HOST_ID = 3;
        static final int COL_HOST_DESC = 4;
        final int[] colWidths = new int[]{20, 80, 16, 20, 80};
        final String[] colTitles = new String[]{"Code", "Description", "", "ID", "Description"};
        LinkedList<WsLithology> liths = new LinkedList();
        boolean modelDirty = false;
        LithTrnScheme currentScheme = null;
        Lithdesc lithdesc;

        TableModelLithTrn() {
        }

        @Override
        public int getColumnCount() {
            return this.colTitles.length;
        }

        @Override
        public int getRowCount() {
            return this.liths.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            WsLithology lith = this.liths.get(row);
            switch (col) {
                case 0: {
                    if (lith.getCode() > 0) {
                        return new Integer(lith.getCode());
                    }
                    return null;
                }
                case 1: {
                    return lith.getDescription();
                }
                case 2: {
                    return lith.getLink() != null;
                }
                case 3: {
                    if (lith.getLink() != null) {
                        return new Integer(lith.getLink().getLithID());
                    }
                    return "";
                }
                case 4: {
                    if (lith.getLink() == null) break;
                    return lith.getLink().getDescr();
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            WsLithology lith = this.liths.get(row);
            switch (col) {
                case 4: {
                    lith.setLink(this.lithdesc.getLithologyFromDescription(obj.toString()));
                    break;
                }
            }
        }

        public Class getColumnClass(int col) {
            switch (col) {
                case 0: 
                case 3: {
                    return Integer.class;
                }
                case 1: 
                case 4: {
                    return String.class;
                }
                case 2: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                default: {
                    return false;
                }
                case 4: 
            }
            return true;
        }

        public void setupTable(JTable table, JComboBox combo) {
            SB.setTableHeaderBold((JTable)table);
            TableColumnModel columnModel = table.getTableHeader().getColumnModel();
            for (int i = 0; i < this.getColumnCount(); ++i) {
                columnModel.getColumn(i).setHeaderValue(this.colTitles[i]);
                columnModel.getColumn(i).setPreferredWidth(this.colWidths[i]);
            }
            columnModel.getColumn(2).setMaxWidth(this.colWidths[3]);
            columnModel.getColumn(4).setCellEditor(new DefaultCellEditor(combo));
            columnModel.getColumn(4).setCellRenderer(new ComboCellRenderer());
            table.setDefaultRenderer(Boolean.class, (TableCellRenderer)new ArrowCellRenderer());
        }

        void tryLink() {
            if (this.currentScheme == null || this.liths == null || this.liths.isEmpty()) {
                return;
            }
            boolean codes = this.currentScheme.isUseCodes();
            block0: for (WsLithology lith : this.liths) {
                if (codes && lith.getCode() < 0 || !codes && lith.getDescription().isEmpty()) continue;
                for (LithTrnEntry entry : this.currentScheme.getEntries()) {
                    if ((!codes || lith.getCode() != entry.getCode()) && (codes || !lith.getDescription().equalsIgnoreCase(entry.getDescr()))) continue;
                    Lithology lithology = this.lithdesc.getLithology(entry.getSbugsCode());
                    if (lithology == null) continue block0;
                    lith.setLink(lithology);
                    continue block0;
                }
            }
        }
    }
}

