/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelMatchMarkers;
import model2.SeismicMarker;
import model2.WellInterp;
import model2.WsWell;
import org.jdesktop.layout.GroupLayout;
import util.ArrowCellRenderer;
import util.ColorRenderer;
import util.SB;
import util.SBException;
import util.SbugsStatusRenderer;
import util.StringStatus;
import util.TableSorter;

public class DialogMatchMarkers
extends JDialog {
    WsWell well = null;
    TableModelMatchMarkers model = new TableModelMatchMarkers();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    Image backgroundImage;
    WellInterp interp = null;
    WellInterp dbInterp = null;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonExclude;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTableMarkers;

    public DialogMatchMarkers(Frame parent, boolean modal, WsWell well, char units) throws SQLException, SBException {
        super(parent, modal);
        this.well = well;
        this.model.units = units;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Match Markers");
        this.getRootPane().setDefaultButton(this.jButtonClose);
        SB.setTableHeaderBold((JTable)this.jTableMarkers);
        TableColumnModel columnModel = this.jTableMarkers.getTableHeader().getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelMatchMarkers.colTitles[i]);
            columnModel.getColumn(i).setWidth(TableModelMatchMarkers.colWidths[i]);
        }
        columnModel.getColumn(3).setMaxWidth(TableModelMatchMarkers.colWidths[3]);
        this.model.init(this.well.getMarkers(), this.well.getLink() != null ? this.well.getLink().getMarkers() : null);
        this.jTableMarkers.setDefaultRenderer(SeismicMarker.class, (TableCellRenderer)new SbugsStatusRenderer());
        this.jTableMarkers.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        this.jTableMarkers.setDefaultRenderer(Color.class, (TableCellRenderer)new ColorRenderer(true));
        this.jTableMarkers.setDefaultRenderer(Boolean.class, (TableCellRenderer)new ArrowCellRenderer());
        this.sorter.addMouseListenerToHeaderInTable(this.jTableMarkers);
        this.sorter.reallocateIndexes();
        this.backgroundImage = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/MatchBG.png"));
        this.jTableMarkers.getTableHeader().setReorderingAllowed(false);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(DialogMatchMarkers.this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane1 = new JScrollPane();
        this.jTableMarkers = new JTable();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonExclude = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonClose = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(480, 320));
        this.setModal(true);
        this.jScrollPane1.setViewportBorder(BorderFactory.createLineBorder(new Color(255, 255, 255)));
        this.jTableMarkers.setModel((TableModel)this.sorter);
        this.jScrollPane1.setViewportView(this.jTableMarkers);
        this.jLabel1.setFont(new Font("Tahoma", 1, 13));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(new Font("Tahoma", 1, 13));
        this.jLabel2.setText("...Database");
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.setToolTipText("Exclude selected data from workspace");
        this.jButtonExclude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchMarkers.this.jButtonExcludeActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setToolTipText("Delete selected data from database");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchMarkers.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchMarkers.this.jButtonCloseActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0, 229, Short.MAX_VALUE).add((Component)this.jLabel2)).add(2, (Component)this.jScrollPane1, -1, 387, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2, false).add((Component)this.jButtonClose, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonExclude, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jButtonDelete, -1, 69, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jButtonExclude).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0, 196, Short.MAX_VALUE).add((Component)this.jButtonClose)).add((Component)this.jScrollPane1, -1, 271, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.deleteMarkers(true);
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        this.deleteMarkers(false);
    }

    private void deleteMarkers(boolean fromDatabase) {
        block9: {
            if (fromDatabase && this.well.getLink() == null) {
                JOptionPane.showMessageDialog(this, "No well data - use Exclude to remove from workspace", this.getTitle(), 2);
                return;
            }
            if (this.jTableMarkers.getSelectedRowCount() == 0) {
                JOptionPane.showMessageDialog(this, "No rows selected", this.getTitle(), 2);
                return;
            }
            int[] selected = this.jTableMarkers.getSelectedRows();
            LinkedList<SeismicMarker> toRemove = new LinkedList<SeismicMarker>();
            for (int i : selected) {
                SeismicMarker marker = fromDatabase ? (SeismicMarker)this.model.data.get(this.sorter.getIndexOf(i)).getDb() : (SeismicMarker)this.model.data.get(this.sorter.getIndexOf(i)).getWs();
                if (marker == null) continue;
                toRemove.add(marker);
            }
            if (fromDatabase && toRemove.size() > 0) {
                String msg = "Really delete ";
                msg = msg + (toRemove.size() == 1 ? "this marker" : "these " + toRemove.size() + " marker");
                if (JOptionPane.showConfirmDialog(this, msg = msg + (toRemove.size() == 1 ? "?" : "s?"), this.getTitle(), 0, 3) == 1) {
                    return;
                }
            }
            try {
                int nItems = 0;
                WsWell deleteFromWell = fromDatabase ? this.well.getLink() : this.well;
                for (SeismicMarker marker : toRemove) {
                    deleteFromWell.getMarkers().delete(deleteFromWell.getWellID(), marker);
                    ++nItems;
                }
                String text = fromDatabase ? "deleted" : "excluded";
                JOptionPane.showMessageDialog(this, "Markers " + text + ": " + nItems, this.getTitle(), 1);
                this.well.updateMarkersStatus(true);
                this.model.init(this.well.getMarkers(), this.well.getLink() != null ? this.well.getLink().getMarkers() : null);
                this.sorter.reallocateIndexes();
                this.sorter.fireTableDataChanged();
                if (fromDatabase) {
                    deleteFromWell.getDataModel().commit();
                    deleteFromWell.notifyObservers();
                    deleteFromWell.getMarkers().notifyObservers();
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Error " + (fromDatabase ? "deleting" : "excluding") + " : " + e.getMessage(), this.getTitle(), 0);
                e.printStackTrace();
                if (!fromDatabase) break block9;
                this.well.getLink().getDataModel().doRollback();
            }
        }
    }
}

