/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jsbugs.FrameJsbugs;
import model2.EnvScheme;
import model2.IGDIntervalEnv;
import model2.InterpHdr;
import model2.SBdb;
import model2.Sample;
import model2.Well;
import model2.WellInterp;
import model2.WsWell;
import util.ArrowCellRenderer;
import util.MatchData;
import util.SB;
import util.SBException;
import util.SbugsStatusRenderer;
import util.StringStatus;
import util.TableSorter;

public class DialogMatchPalaeoenvs
extends JDialog {
    TableModelMatchPalaeoenvs model = new TableModelMatchPalaeoenvs();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    WsWell well = null;
    Image backgroundImage;
    InterpHdr hdr;
    WellInterp wsInterp;
    WellInterp dbInterp;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonExclude;
    private JButton jButtonSave;
    private JButton jButtonSaveSelected;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTableMatchPalaeoenvs;

    public DialogMatchPalaeoenvs(Frame parent, boolean modal, WsWell well, char units, InterpHdr hdr) throws SBException, SQLException {
        super(parent, modal);
        this.well = well;
        this.hdr = hdr;
        this.model.units = units;
        this.initComponents();
        this.init();
    }

    private void init() throws SBException, SQLException {
        this.setTitle("Match Palaeoenvironments");
        this.getRootPane().setDefaultButton(this.jButtonClose);
        if (this.well.hasInterpLoaded(this.hdr.getInterpID())) {
            this.wsInterp = this.well.getInterp(this.hdr.getInterpID());
        }
        this.checkLinks();
        if (this.well.getLink() != null && this.hdr.getLink() != null && this.well.getLink().hasInterpLoaded(this.hdr.getInterpID())) {
            this.dbInterp = this.well.getLink().getInterp(this.hdr.getLink().getInterpID());
        }
        this.model.data.init(this.wsInterp != null ? this.wsInterp.getEnvs() : null, this.dbInterp != null ? this.dbInterp.getEnvs() : null);
        this.model.setUpTable(this.jTableMatchPalaeoenvs);
        this.sorter.addMouseListenerToHeaderInTable(this.jTableMatchPalaeoenvs);
        this.sorter.reallocateIndexes();
        this.backgroundImage = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/MatchBG.png"));
    }

    private void checkLinks() throws SBException, SQLException {
        if (this.well != null && this.well.getLink() != null) {
            for (IGDIntervalEnv env : this.wsInterp.getEnvs()) {
                if (this.well.getDataModel().getEnvScheme(env.getSchID()).getLink() != null) continue;
                throw new SBException("Cannot open dialog - Palaeoenvironment Schemes not Matched");
            }
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(DialogMatchPalaeoenvs.this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane1 = new JScrollPane();
        this.jTableMatchPalaeoenvs = new JTable();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonExclude = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonSaveSelected = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(500, 250));
        this.setModal(true);
        this.jTableMatchPalaeoenvs.setModel((TableModel)this.sorter);
        this.jScrollPane1.setViewportView(this.jTableMatchPalaeoenvs);
        this.jLabel1.setFont(new Font("Tahoma", 1, 13));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(new Font("Tahoma", 1, 13));
        this.jLabel2.setText("...Database");
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.setToolTipText("Exclude selected sample from workspace");
        this.jButtonExclude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchPalaeoenvs.this.jButtonExcludeActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setToolTipText("Delete selected data from database");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchPalaeoenvs.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchPalaeoenvs.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.setToolTipText("Save new intervals from workspace into database");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchPalaeoenvs.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonSaveSelected.setText("Save selected");
        this.jButtonSaveSelected.setToolTipText("Save new intervals from workspace into database");
        this.jButtonSaveSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchPalaeoenvs.this.jButtonSaveSelectedActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 348, Short.MAX_VALUE).addComponent(this.jLabel2)).addComponent(this.jScrollPane1, -1, 506, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonClose, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonExclude, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDelete, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonSave, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonSaveSelected, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonExclude).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSaveSelected).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 118, Short.MAX_VALUE).addComponent(this.jButtonClose)).addComponent(this.jScrollPane1, -1, 251, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        this.deleteIntervals(false);
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.deleteIntervals(true);
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        LinkedList<MatchData.MatchPair> selection = new LinkedList<MatchData.MatchPair>();
        for (int row = 0; row < this.model.data.size(); ++row) {
            selection.add(this.model.data.get(row));
        }
        this.saveSelection(selection);
    }

    private void jButtonSaveSelectedActionPerformed(ActionEvent evt) {
        int[] selectedRows = this.jTableMatchPalaeoenvs.getSelectedRows();
        if (selectedRows.length == 0) {
            JOptionPane.showMessageDialog(this, "Make a selection of rows to save", this.getTitle(), 2);
            return;
        }
        LinkedList<MatchData.MatchPair> selection = new LinkedList<MatchData.MatchPair>();
        for (int i = 0; i < selectedRows.length; ++i) {
            selection.add(this.model.data.get(this.sorter.getIndexOf(selectedRows[i])));
        }
        this.saveSelection(selection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void saveSelection(List<MatchData.MatchPair> selection) {
        block39: {
            if (this.well.getLink() == null) {
                JOptionPane.showMessageDialog(this, "No linked well - use Match | Wells from main menu.", this.getTitle(), 2);
                return;
            }
            if (this.dbInterp == null) {
                JOptionPane.showMessageDialog(this, "Version not linked - use Match | Versions from main menu.", this.getTitle(), 2);
                return;
            }
            if (selection.isEmpty()) {
                return;
            }
            boolean samplesCreated = false;
            Statement stmt = null;
            IGDIntervalEnv added = null;
            Well dbWell = this.well.getLink();
            SBdb wsDB = this.well.getDataModel();
            boolean doStore = false;
            LinkedList<IGDIntervalEnv> wsZones = new LinkedList<IGDIntervalEnv>();
            for (MatchData.MatchPair pair : selection) {
                Sample baseSample;
                doStore = true;
                IGDIntervalEnv ws = (IGDIntervalEnv)pair.getWs();
                IGDIntervalEnv db = (IGDIntervalEnv)pair.getDb();
                if (ws == null || db != null) continue;
                EnvScheme wsScheme = wsDB.getEnvScheme(ws.getSchID());
                if (wsScheme == null) {
                    JOptionPane.showMessageDialog(this, "Scheme for Interval: " + ws.toString() + " not found in workspace. Use Match | Paleovironments from menu.");
                    doStore = false;
                    break;
                }
                EnvScheme dbScheme = wsScheme.getLink();
                if (dbScheme == null) {
                    JOptionPane.showMessageDialog(this, "Interval: " + ws.toString() + " scheme not found in database. Use Match | Paleovironments from menu.");
                    doStore = false;
                    break;
                }
                Sample topSample = dbWell.getSample(ws.getTopSample().getTopDepth(), ws.getTopSample().getBaseDepth(), ws.getTopSample().getType());
                if (topSample == null) {
                    int opt = JOptionPane.showConfirmDialog(this, "Sample: " + ws.getTopSample() + " does not exist: create it?", this.getTitle(), 0, 3);
                    if (opt != 0) {
                        doStore = false;
                        break;
                    }
                    if (stmt == null) {
                        stmt = dbWell.getDataModel().getDatabase().createStatement();
                    }
                    topSample = dbWell.addWsSample(stmt, ws.getTopSample());
                    samplesCreated = true;
                }
                if ((baseSample = dbWell.getSample(ws.getBaseSample().getTopDepth(), ws.getBaseSample().getBaseDepth(), ws.getBaseSample().getType())) == null) {
                    int opt = JOptionPane.showConfirmDialog(this, "Sample: " + ws.getTopSample() + " does not exist: create it?", this.getTitle(), 0, 3);
                    if (opt != 0) {
                        doStore = false;
                        break;
                    }
                    if (stmt == null) {
                        stmt = dbWell.getDataModel().getDatabase().createStatement();
                    }
                    baseSample = dbWell.addWsSample(stmt, ws.getBaseSample());
                    samplesCreated = true;
                }
                wsZones.add(ws);
            }
            if (doStore) {
                this.dbInterp.storeEnvs(wsZones, dbWell.getWellID());
                added = (IGDIntervalEnv)this.dbInterp.getEnvs().get(0);
            }
            this.well.getLink().getDataModel().commit();
            try {
                if (stmt != null) {
                    stmt.close();
                }
                this.model.data.init(this.wsInterp != null ? this.wsInterp.getEnvs() : null, this.dbInterp != null ? this.dbInterp.getEnvs() : null);
                this.sorter.reallocateIndexes();
                this.sorter.fireTableDataChanged();
                if (added != null) {
                    this.dbInterp.notifyObservers((Object)added);
                }
                if (samplesCreated) {
                    this.well.getLink().notifyObservers(Sample.class);
                }
                break block39;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            break block39;
            catch (SBException sbe) {
                this.well.getLink().getDataModel().doRollback();
                SB.showStackError((String)"Error", (Exception)((Object)sbe));
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    this.model.data.init(this.wsInterp != null ? this.wsInterp.getEnvs() : null, this.dbInterp != null ? this.dbInterp.getEnvs() : null);
                    this.sorter.reallocateIndexes();
                    this.sorter.fireTableDataChanged();
                    if (added != null) {
                        this.dbInterp.notifyObservers((Object)added);
                    }
                    if (samplesCreated) {
                        this.well.getLink().notifyObservers(Sample.class);
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            catch (SQLException sql) {
                this.well.getLink().getDataModel().doRollback();
                FrameJsbugs.showStackError("SQL Error", sql, this.well.getLink().getDataModel());
                {
                    catch (Throwable throwable) {
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                            this.model.data.init(this.wsInterp != null ? this.wsInterp.getEnvs() : null, this.dbInterp != null ? this.dbInterp.getEnvs() : null);
                            this.sorter.reallocateIndexes();
                            this.sorter.fireTableDataChanged();
                            if (added != null) {
                                this.dbInterp.notifyObservers(added);
                            }
                            if (samplesCreated) {
                                this.well.getLink().notifyObservers(Sample.class);
                            }
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        throw throwable;
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    this.model.data.init(this.wsInterp != null ? this.wsInterp.getEnvs() : null, this.dbInterp != null ? this.dbInterp.getEnvs() : null);
                    this.sorter.reallocateIndexes();
                    this.sorter.fireTableDataChanged();
                    if (added != null) {
                        this.dbInterp.notifyObservers((Object)added);
                    }
                    if (samplesCreated) {
                        this.well.getLink().notifyObservers(Sample.class);
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    private void deleteIntervals(boolean fromDatabase) {
        block10: {
            if (fromDatabase && this.well.getLink() == null) {
                JOptionPane.showMessageDialog(this, "No well data - use Exclude to remove from workspace", this.getTitle(), 2);
                return;
            }
            if (this.jTableMatchPalaeoenvs.getSelectedRowCount() == 0) {
                JOptionPane.showMessageDialog(this, "No intervals selected", this.getTitle(), 2);
                return;
            }
            int[] selected = this.jTableMatchPalaeoenvs.getSelectedRows();
            LinkedList<IGDIntervalEnv> toRemove = new LinkedList<IGDIntervalEnv>();
            for (int i : selected) {
                IGDIntervalEnv envInterval = fromDatabase ? (IGDIntervalEnv)this.model.data.get(this.sorter.getIndexOf(i)).getDb() : (IGDIntervalEnv)this.model.data.get(this.sorter.getIndexOf(i)).getWs();
                if (envInterval == null) continue;
                toRemove.add(envInterval);
            }
            if (fromDatabase && toRemove.size() > 0) {
                String msg = "Really delete ";
                msg = msg + (toRemove.size() == 1 ? "this interval" : "these " + toRemove.size() + " interval");
                if (JOptionPane.showConfirmDialog(this, msg = msg + (toRemove.size() == 1 ? "?" : "s?"), this.getTitle(), 0, 3) != 0) {
                    return;
                }
            }
            try {
                int nSamples = 0;
                WsWell deleteWell = fromDatabase ? this.well.getLink() : this.well;
                WellInterp deleteInterp = fromDatabase ? this.dbInterp : this.wsInterp;
                for (IGDIntervalEnv envInterval : toRemove) {
                    deleteInterp.deleteEnv(envInterval, deleteWell.getWellID());
                    ++nSamples;
                }
                String text = fromDatabase ? "deleted" : "excluded";
                JOptionPane.showMessageDialog(this, "Intervals " + text + ": " + nSamples, this.getTitle(), 1);
                if (fromDatabase) {
                    deleteWell.getDataModel().commit();
                    deleteInterp.notifyObservers((Object)5);
                } else {
                    this.well.updateEnvStatus(this.wsInterp, this.dbInterp != null ? this.dbInterp.getHeader() : null, this.model.units, true);
                }
                this.model.data.init(this.wsInterp != null ? this.wsInterp.getEnvs() : null, this.dbInterp != null ? this.dbInterp.getEnvs() : null);
                this.sorter.reallocateIndexes();
                this.sorter.fireTableDataChanged();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Error " + (fromDatabase ? "deleting" : "excluding") + " : " + e.getMessage(), this.getTitle(), 0);
                e.printStackTrace();
                if (!fromDatabase) break block10;
                this.well.getLink().getDataModel().doRollback();
            }
        }
    }

    class TableModelMatchPalaeoenvs
    extends AbstractTableModel {
        static final int COL_DONOR_TOP = 0;
        static final int COL_DONOR_BASE = 1;
        static final int COL_DONOR_ENV = 2;
        static final int COL_CONFLICT = 3;
        static final int COL_ARROW = 4;
        static final int COL_HOST_TOP = 5;
        static final int COL_HOST_BASE = 6;
        static final int COL_HOST_ENV = 7;
        String[] colTitles = new String[]{"Top", "Base", "Environment", "Conflict", "", "Top", "Base", "Environment"};
        int[] colWidths = new int[]{30, 30, 100, 100, 16, 30, 30, 100};
        char units = (char)77;
        MatchData data = new MatchData();

        TableModelMatchPalaeoenvs() {
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return this.colTitles.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            MatchData.MatchPair pair = this.data.get(rowIndex);
            if (pair == null) {
                return "";
            }
            IGDIntervalEnv ws = (IGDIntervalEnv)pair.getWs();
            IGDIntervalEnv db = (IGDIntervalEnv)pair.getDb();
            try {
                switch (columnIndex) {
                    case 0: {
                        return ws != null ? new StringStatus(ws.getTopSample().toString(this.units), ws.getStatus()) : null;
                    }
                    case 1: {
                        return ws != null ? new StringStatus(ws.getBaseSample().toString(this.units), ws.getStatus()) : null;
                    }
                    case 2: {
                        return ws != null ? new StringStatus(ws.toString(), ws.getStatus()) : null;
                    }
                    case 3: {
                        return ws != null ? new StringStatus(ws.getConflictReason(), ws.getStatus()) : null;
                    }
                    case 4: {
                        return new Boolean(ws != null && db != null && ws.getStatus() == Sample.STORED);
                    }
                    case 5: {
                        return db != null ? db.getTopSample().toString(this.units) : null;
                    }
                    case 6: {
                        return db != null ? db.getBaseSample().toString(this.units) : null;
                    }
                    case 7: {
                        return db != null ? db.toString() : null;
                    }
                }
                return "";
            }
            catch (Exception e) {
                e.printStackTrace();
                return e.getMessage();
            }
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: 
                case 1: 
                case 2: {
                    return StringStatus.class;
                }
                case 4: {
                    return Boolean.class;
                }
            }
            return String.class;
        }

        void setUpTable(JTable table) {
            SB.setTableHeaderBold((JTable)table);
            TableColumnModel columnModel = table.getTableHeader().getColumnModel();
            for (int i = 0; i < columnModel.getColumnCount(); ++i) {
                columnModel.getColumn(i).setHeaderValue(this.colTitles[i]);
                columnModel.getColumn(i).setPreferredWidth(this.colWidths[i]);
            }
            columnModel.getColumn(4).setMaxWidth(this.colWidths[4]);
            table.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
            table.setDefaultRenderer(Boolean.class, (TableCellRenderer)new ArrowCellRenderer());
            table.getTableHeader().setReorderingAllowed(false);
        }
    }
}

